/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.tree;

import java.io.IOException;
import java.util.Map;
import org.apache.spark.Logging;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.tree.DecisionTree$;
import org.apache.spark.mllib.tree.RandomForest$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impl.BaggedPoint;
import org.apache.spark.mllib.tree.impl.BaggedPoint$;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata;
import org.apache.spark.mllib.tree.impl.DecisionTreeMetadata$;
import org.apache.spark.mllib.tree.impl.NodeIdCache;
import org.apache.spark.mllib.tree.impl.NodeIdCache$;
import org.apache.spark.mllib.tree.impl.TimeTracker;
import org.apache.spark.mllib.tree.impl.TreePoint;
import org.apache.spark.mllib.tree.impl.TreePoint$;
import org.apache.spark.mllib.tree.model.Bin;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.Node;
import org.apache.spark.mllib.tree.model.Node$;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.mllib.tree.model.Split;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\tmc\u0001B\u0001\u0003\t5\u0011ABU1oI>lgi\u001c:fgRT!a\u0001\u0003\u0002\tQ\u0014X-\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001$G\u0007\u0002\r%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!b\u0001\n\u0013i\u0012\u0001C:ue\u0006$XmZ=\u0016\u0003y\u0001\"a\b\u0012\u000e\u0003\u0001R!!\t\u0002\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\t\u0019\u0003E\u0001\u0005TiJ\fG/Z4z\u0011!)\u0003A!A!\u0002\u0013q\u0012!C:ue\u0006$XmZ=!\u0011!9\u0003A!b\u0001\n\u0013A\u0013\u0001\u00038v[R\u0013X-Z:\u0016\u0003%\u0002\"a\u0004\u0016\n\u0005-\u0002\"aA%oi\"AQ\u0006\u0001B\u0001B\u0003%\u0011&A\u0005ok6$&/Z3tA!Aq\u0006\u0001B\u0001B\u0003%\u0001'A\u000bgK\u0006$XO]3Tk\n\u001cX\r^*ue\u0006$XmZ=\u0011\u0005E\"dBA\b3\u0013\t\u0019\u0004#\u0001\u0004Qe\u0016$WMZ\u0005\u0003kY\u0012aa\u0015;sS:<'BA\u001a\u0011\u0011!A\u0004A!b\u0001\n\u0013A\u0013\u0001B:fK\u0012D\u0001B\u000f\u0001\u0003\u0002\u0003\u0006I!K\u0001\u0006g\u0016,G\r\t\u0005\u0006y\u0001!\t!P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000by\u0002\u0015IQ\"\u0011\u0005}\u0002Q\"\u0001\u0002\t\u000bqY\u0004\u0019\u0001\u0010\t\u000b\u001dZ\u0004\u0019A\u0015\t\u000b=Z\u0004\u0019\u0001\u0019\t\u000baZ\u0004\u0019A\u0015\t\u000b\u0015\u0003A\u0011\u0001$\u0002\u0007I,h\u000e\u0006\u0002H\u001bB\u0011\u0001jS\u0007\u0002\u0013*\u0011!JA\u0001\u0006[>$W\r\\\u0005\u0003\u0019&\u0013\u0011CU1oI>lgi\u001c:fgRlu\u000eZ3m\u0011\u0015qE\t1\u0001P\u0003\u0015Ig\u000e];u!\r\u00016+V\u0007\u0002#*\u0011!KB\u0001\u0004e\u0012$\u0017B\u0001+R\u0005\r\u0011F\t\u0012\t\u0003-fk\u0011a\u0016\u0006\u00031\u0012\t!B]3he\u0016\u001c8/[8o\u0013\tQvK\u0001\u0007MC\n,G.\u001a3Q_&tGoB\u0003]\u0005!\u0005Q,\u0001\u0007SC:$w.\u001c$pe\u0016\u001cH\u000f\u0005\u0002@=\u001a)\u0011A\u0001E\u0001?N!aL\u0004\u000b\u0018\u0011\u0015ad\f\"\u0001b)\u0005i\u0006\"B2_\t\u0003!\u0017a\u0004;sC&t7\t\\1tg&4\u0017.\u001a:\u0015\r\u001d+gm\u001a5j\u0011\u0015q%\r1\u0001P\u0011\u0015a\"\r1\u0001\u001f\u0011\u00159#\r1\u0001*\u0011\u0015y#\r1\u00011\u0011\u0015A$\r1\u0001*Q\r\u00117.\u001d\t\u0003Y>l\u0011!\u001c\u0006\u0003]\u001a\t!\"\u00198o_R\fG/[8o\u0013\t\u0001XNA\u0003TS:\u001cW-I\u0001s\u0003\u0015\tdF\r\u00181\u0011\u0015\u0019g\f\"\u0001u)59UO\u001e=~}~\f\u0019!a\u0002\u0002\f!)aj\u001da\u0001\u001f\")qo\u001da\u0001S\u0005Qa.^7DY\u0006\u001c8/Z:\t\u000be\u001c\b\u0019\u0001>\u0002/\r\fG/Z4pe&\u001c\u0017\r\u001c$fCR,(/Z:J]\u001a|\u0007\u0003B\u0019|S%J!\u0001 \u001c\u0003\u00075\u000b\u0007\u000fC\u0003(g\u0002\u0007\u0011\u0006C\u00030g\u0002\u0007\u0001\u0007\u0003\u0004\u0002\u0002M\u0004\r\u0001M\u0001\tS6\u0004XO]5us\"1\u0011QA:A\u0002%\n\u0001\"\\1y\t\u0016\u0004H\u000f\u001b\u0005\u0007\u0003\u0013\u0019\b\u0019A\u0015\u0002\u000f5\f\u0007PQ5og\"9\u0001h\u001dI\u0001\u0002\u0004I\u0003fA:lc\"11M\u0018C\u0001\u0003#!2cRA\n\u0003K\t9#!\u0011\u0002D\u0005\u0015\u0013qIA%\u0003\u0017BqATA\b\u0001\u0004\t)\u0002E\u0003\u0002\u0018\u0005\u0005R+\u0004\u0002\u0002\u001a)!\u00111DA\u000f\u0003\u0011Q\u0017M^1\u000b\u0007\u0005}a!A\u0002ba&LA!a\t\u0002\u001a\t9!*\u0019<b%\u0012#\u0005BB<\u0002\u0010\u0001\u0007\u0011\u0006C\u0004z\u0003\u001f\u0001\r!!\u000b\u0011\u0011\u0005-\u00121GA\u001b\u0003ki!!!\f\u000b\t\u0005=\u0012\u0011G\u0001\u0005kRLGN\u0003\u0002\u0002\u001c%\u0019A0!\f\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQA!a\u000f\u00022\u0005!A.\u00198h\u0013\u0011\ty$!\u000f\u0003\u000f%sG/Z4fe\"1q%a\u0004A\u0002%BaaLA\b\u0001\u0004\u0001\u0004bBA\u0001\u0003\u001f\u0001\r\u0001\r\u0005\b\u0003\u000b\ty\u00011\u0001*\u0011\u001d\tI!a\u0004A\u0002%Ba\u0001OA\b\u0001\u0004I\u0003\u0006BA\bWFDq!!\u0015_\t\u0003\t\u0019&\u0001\bue\u0006LgNU3he\u0016\u001c8o\u001c:\u0015\u0017\u001d\u000b)&a\u0016\u0002Z\u0005m\u0013Q\f\u0005\u0007\u001d\u0006=\u0003\u0019A(\t\rq\ty\u00051\u0001\u001f\u0011\u00199\u0013q\na\u0001S!1q&a\u0014A\u0002ABa\u0001OA(\u0001\u0004I\u0003\u0006BA(WFDq!!\u0015_\t\u0003\t\u0019\u0007F\tH\u0003K\n9'!\u001b\u0002l\u00055\u0014qNA9\u0003gBaATA1\u0001\u0004y\u0005BB=\u0002b\u0001\u0007!\u0010\u0003\u0004(\u0003C\u0002\r!\u000b\u0005\u0007_\u0005\u0005\u0004\u0019\u0001\u0019\t\u000f\u0005\u0005\u0011\u0011\ra\u0001a!9\u0011QAA1\u0001\u0004I\u0003bBA\u0005\u0003C\u0002\r!\u000b\u0005\tq\u0005\u0005\u0004\u0013!a\u0001S!\"\u0011\u0011M6r\u0011\u001d\t\tF\u0018C\u0001\u0003s\"\u0012cRA>\u0003{\ny(!!\u0002\u0004\u0006\u0015\u0015qQAE\u0011\u001dq\u0015q\u000fa\u0001\u0003+Aq!_A<\u0001\u0004\tI\u0003\u0003\u0004(\u0003o\u0002\r!\u000b\u0005\u0007_\u0005]\u0004\u0019\u0001\u0019\t\u000f\u0005\u0005\u0011q\u000fa\u0001a!9\u0011QAA<\u0001\u0004I\u0003bBA\u0005\u0003o\u0002\r!\u000b\u0005\u0007q\u0005]\u0004\u0019A\u0015)\t\u0005]4.\u001d\u0005\n\u0003\u001fs&\u0019!C\u0001\u0003#\u000b\u0001e];qa>\u0014H/\u001a3GK\u0006$XO]3Tk\n\u001cX\r^*ue\u0006$XmZ5fgV\u0011\u00111\u0013\t\u0005\u001f\u0005U\u0005'C\u0002\u0002\u0018B\u0011Q!\u0011:sCfDC!!$lc\"A\u0011Q\u00140!\u0002\u0013\t\u0019*A\u0011tkB\u0004xN\u001d;fI\u001a+\u0017\r^;sKN+(m]3u'R\u0014\u0018\r^3hS\u0016\u001c\b\u0005\u000b\u0003\u0002\u001c.\fhaBAR=\u0002\u0011\u0011Q\u0015\u0002\u000e\u001d>$W-\u00138eKbLeNZ8\u0014\t\u0005\u0005f\u0002\u0006\u0005\u000b\u0003S\u000b\tK!b\u0001\n\u0003A\u0013\u0001\u00058pI\u0016Le\u000eZ3y\u0013:<%o\\;q\u0011)\ti+!)\u0003\u0002\u0003\u0006I!K\u0001\u0012]>$W-\u00138eKbLen\u0012:pkB\u0004\u0003bCAY\u0003C\u0013)\u0019!C\u0001\u0003g\u000bQBZ3biV\u0014XmU;cg\u0016$XCAA[!\u0015y\u0011qWA^\u0013\r\tI\f\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t=\t)*\u000b\u0005\f\u0003\u007f\u000b\tK!A!\u0002\u0013\t),\u0001\bgK\u0006$XO]3Tk\n\u001cX\r\u001e\u0011\t\u000fq\n\t\u000b\"\u0001\u0002DR1\u0011QYAe\u0003\u0017\u0004B!a2\u0002\"6\ta\fC\u0004\u0002*\u0006\u0005\u0007\u0019A\u0015\t\u0011\u0005E\u0016\u0011\u0019a\u0001\u0003kC\u0001\"a4_\t\u0003\u0011\u0011\u0011[\u0001\u0013g\u0016dWm\u0019;O_\u0012,7\u000fV8Ta2LG\u000f\u0006\u0006\u0002T\u0006\u001d\u0018Q B\u0004\u0005/\u0001raDAk\u00033\f\u0019/C\u0002\u0002XB\u0011a\u0001V;qY\u0016\u0014\u0004#B\u0019|S\u0005m\u0007#B\b\u0002\u0016\u0006u\u0007c\u0001%\u0002`&\u0019\u0011\u0011]%\u0003\t9{G-\u001a\t\u0006cmL\u0013Q\u001d\t\u0006cmL\u0013Q\u0019\u0005\t\u0003S\fi\r1\u0001\u0002l\u0006Ian\u001c3f#V,W/\u001a\t\u0007\u0003[\f90a?\u000e\u0005\u0005=(\u0002BAy\u0003g\fq!\\;uC\ndWMC\u0002\u0002vB\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI0a<\u0003\u000bE+X-^3\u0011\r=\t).KAo\u0011!\ty0!4A\u0002\t\u0005\u0011AD7bq6+Wn\u001c:z+N\fw-\u001a\t\u0004\u001f\t\r\u0011b\u0001B\u0003!\t!Aj\u001c8h\u0011!\u0011I!!4A\u0002\t-\u0011\u0001C7fi\u0006$\u0017\r^1\u0011\t\t5!1C\u0007\u0003\u0005\u001fQ1A!\u0005\u0003\u0003\u0011IW\u000e\u001d7\n\t\tU!q\u0002\u0002\u0015\t\u0016\u001c\u0017n]5p]R\u0013X-Z'fi\u0006$\u0017\r^1\t\u0011\te\u0011Q\u001aa\u0001\u00057\t1A\u001d8h!\u0011\u0011iB!\t\u000e\u0005\t}!bAA\u0018!%!!1\u0005B\u0010\u0005\u0019\u0011\u0016M\u001c3p[\"A!q\u00050\u0005\u0002\t\u0011I#\u0001\u000bbO\u001e\u0014XmZ1uKNK'0\u001a$pe:{G-\u001a\u000b\u0007\u0005\u0003\u0011YC!\f\t\u0011\t%!Q\u0005a\u0001\u0005\u0017A\u0001\"!-\u0003&\u0001\u0007\u0011Q\u0017\u0005\n\u0005cq\u0016\u0013!C\u0001\u0005g\t\u0011\u0004\u001e:bS:\u001cE.Y:tS\u001aLWM\u001d\u0013eK\u001a\fW\u000f\u001c;%sU\u0011!Q\u0007\u0016\u0004S\t]2F\u0001B\u001d!\u0011\u0011YDa\u0011\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u00059\u0004\u0012\u0002\u0002B#\u0005{\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011IEXI\u0001\n\u0003\u0011\u0019$\u0001\rue\u0006LgNU3he\u0016\u001c8o\u001c:%I\u00164\u0017-\u001e7uIaB\u0011B!\u0014_\u0003\u0003%IAa\u0014\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005#\u0002B!a\u000e\u0003T%!!QKA\u001d\u0005\u0019y%M[3di\"\u001aal[9)\u0007m[\u0017\u000f")
public class RandomForest
implements Serializable,
Logging {
    private final Strategy org$apache$spark$mllib$tree$RandomForest$$strategy;
    private final int org$apache$spark$mllib$tree$RandomForest$$numTrees;
    public final String org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy;
    private final int org$apache$spark$mllib$tree$RandomForest$$seed;
    private transient Logger org$apache$spark$Logging$$log_;

    public static int trainRegressor$default$8() {
        return RandomForest$.MODULE$.trainRegressor$default$8();
    }

    public static int trainClassifier$default$9() {
        return RandomForest$.MODULE$.trainClassifier$default$9();
    }

    public static String[] supportedFeatureSubsetStrategies() {
        return RandomForest$.MODULE$.supportedFeatureSubsetStrategies();
    }

    public static RandomForestModel trainRegressor(JavaRDD<LabeledPoint> javaRDD, Map<Integer, Integer> map, int n, String string, String string2, int n2, int n3, int n4) {
        return RandomForest$.MODULE$.trainRegressor(javaRDD, map, n, string, string2, n2, n3, n4);
    }

    public static RandomForestModel trainRegressor(RDD<LabeledPoint> rDD, scala.collection.immutable.Map<Object, Object> map, int n, String string, String string2, int n2, int n3, int n4) {
        return RandomForest$.MODULE$.trainRegressor(rDD, map, n, string, string2, n2, n3, n4);
    }

    public static RandomForestModel trainRegressor(RDD<LabeledPoint> rDD, Strategy strategy, int n, String string, int n2) {
        return RandomForest$.MODULE$.trainRegressor(rDD, strategy, n, string, n2);
    }

    public static RandomForestModel trainClassifier(JavaRDD<LabeledPoint> javaRDD, int n, Map<Integer, Integer> map, int n2, String string, String string2, int n3, int n4, int n5) {
        return RandomForest$.MODULE$.trainClassifier(javaRDD, n, map, n2, string, string2, n3, n4, n5);
    }

    public static RandomForestModel trainClassifier(RDD<LabeledPoint> rDD, int n, scala.collection.immutable.Map<Object, Object> map, int n2, String string, String string2, int n3, int n4, int n5) {
        return RandomForest$.MODULE$.trainClassifier(rDD, n, map, n2, string, string2, n3, n4, n5);
    }

    public static RandomForestModel trainClassifier(RDD<LabeledPoint> rDD, Strategy strategy, int n, String string, int n2) {
        return RandomForest$.MODULE$.trainClassifier(rDD, strategy, n, string, n2);
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Strategy org$apache$spark$mllib$tree$RandomForest$$strategy() {
        return this.org$apache$spark$mllib$tree$RandomForest$$strategy;
    }

    public int org$apache$spark$mllib$tree$RandomForest$$numTrees() {
        return this.org$apache$spark$mllib$tree$RandomForest$$numTrees;
    }

    public int org$apache$spark$mllib$tree$RandomForest$$seed() {
        return this.org$apache$spark$mllib$tree$RandomForest$$seed;
    }

    public RandomForestModel run(RDD<LabeledPoint> input) {
        Node[] topNodes;
        block5: {
            Tuple2<Split[][], Bin[][]> tuple2;
            block4: {
                Tuple2 tuple22;
                TimeTracker timer = new TimeTracker();
                timer.start("total");
                timer.start("init");
                RDD retaggedInput = input.retag(LabeledPoint.class);
                DecisionTreeMetadata metadata = DecisionTreeMetadata$.MODULE$.buildMetadata((RDD<LabeledPoint>)retaggedInput, this.org$apache$spark$mllib$tree$RandomForest$$strategy(), this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), this.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy);
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"algo = ").append((Object)this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().algo()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"numTrees = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$numTrees())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"seed = ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$seed())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this, metadata){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTreeMetadata metadata$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"maxBins = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.maxBins())).toString();
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"featureSubsetStrategy = ").append((Object)this.$outer.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this, metadata){
                    public static final long serialVersionUID = 0L;
                    private final DecisionTreeMetadata metadata$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"numFeaturesPerNode = ").append((Object)BoxesRunTime.boxToInteger((int)this.metadata$1.numFeaturesPerNode())).toString();
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;

                    public final String apply() {
                        return new StringBuilder().append((Object)"subsamplingRate = ").append((Object)BoxesRunTime.boxToDouble((double)this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().subsamplingRate())).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
                timer.start("findSplitsBins");
                tuple2 = DecisionTree$.MODULE$.findSplitsBins((RDD<LabeledPoint>)retaggedInput, metadata);
                if (tuple2 == null) break block4;
                Split[][] splits = (Split[][])tuple2._1();
                Bin[][] bins = (Bin[][])tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)splits, (Object)bins);
                Split[][] splits2 = (Split[][])tuple23._1();
                Bin[][] bins2 = (Bin[][])tuple23._2();
                timer.stop("findSplitsBins");
                this.logDebug((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "numBins: feature: number of bins";
                    }
                });
                this.logDebug((Function0<String>)new Serializable(this, metadata){
                    public static final long serialVersionUID = 0L;
                    public final DecisionTreeMetadata metadata$1;

                    public final String apply() {
                        return ((TraversableOnce)package$.MODULE$.Range().apply(0, this.metadata$1.numFeatures()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$run$10 $outer;

                            public final String apply(int featureIndex) {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\t", "\\t", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)featureIndex), BoxesRunTime.boxToInteger((int)this.$outer.metadata$1.numBins()[featureIndex])}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom())).mkString("\n");
                    }
                    {
                        this.metadata$1 = metadata$1;
                    }
                });
                RDD<TreePoint> treeInput = TreePoint$.MODULE$.convertToTreeRDD((RDD<LabeledPoint>)retaggedInput, bins2, metadata);
                boolean withReplacement = this.org$apache$spark$mllib$tree$RandomForest$$numTrees() > 1;
                RDD baggedInput = BaggedPoint$.MODULE$.convertToBaggedRDD(treeInput, this.org$apache$spark$mllib$tree$RandomForest$$strategy().subsamplingRate(), this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), withReplacement, this.org$apache$spark$mllib$tree$RandomForest$$seed()).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
                int maxDepth = this.org$apache$spark$mllib$tree$RandomForest$$strategy().maxDepth();
                Predef$.MODULE$.require(maxDepth <= 30, (Function0)new Serializable(this, maxDepth){
                    public static final long serialVersionUID = 0L;
                    private final int maxDepth$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DecisionTree currently only supports maxDepth <= 30, but was given maxDepth = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxDepth$1)}));
                    }
                    {
                        this.maxDepth$1 = maxDepth$1;
                    }
                });
                long maxMemoryUsage = (long)this.org$apache$spark$mllib$tree$RandomForest$$strategy().maxMemoryInMB() * 1024L * 1024L;
                this.logDebug((Function0<String>)new Serializable(this, maxMemoryUsage){
                    public static final long serialVersionUID = 0L;
                    private final long maxMemoryUsage$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"max memory usage for aggregates = ").append((Object)BoxesRunTime.boxToLong((long)this.maxMemoryUsage$1)).append((Object)" bytes.").toString();
                    }
                    {
                        this.maxMemoryUsage$1 = maxMemoryUsage$1;
                    }
                });
                None$ featureSubset = metadata.subsamplingFeatures() ? new Some(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(metadata.numBins()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).sortBy((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x$2) {
                        return -x$2._1$mcI$sp();
                    }
                }, (Ordering)Ordering.Int$.MODULE$)).take(metadata.numFeaturesPerNode())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Tuple2<Object, Object> x$3) {
                        return x$3._2$mcI$sp();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))) : None$.MODULE$;
                long maxMemoryPerNode = RandomForest$.MODULE$.aggregateSizeForNode(metadata, (Option<int[]>)featureSubset) * 8L;
                Predef$.MODULE$.require(maxMemoryPerNode <= maxMemoryUsage, (Function0)new Serializable(this, maxMemoryPerNode){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RandomForest $outer;
                    private final long maxMemoryPerNode$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest/DecisionTree given maxMemoryInMB = ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().maxMemoryInMB())}))).append((Object)" which is too small for the given features.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"  Minimum value = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.maxMemoryPerNode$1 / 0x100000L))}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.maxMemoryPerNode$1 = maxMemoryPerNode$1;
                    }
                });
                timer.stop("init");
                None$ nodeIdCache = this.org$apache$spark$mllib$tree$RandomForest$$strategy().useNodeIdCache() ? new Some((Object)NodeIdCache$.MODULE$.init((RDD<BaggedPoint<TreePoint>>)baggedInput, this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), this.org$apache$spark$mllib$tree$RandomForest$$strategy().checkpointInterval(), 1)) : None$.MODULE$;
                Queue nodeQueue = new Queue();
                Random rng = new Random();
                rng.setSeed((long)this.org$apache$spark$mllib$tree$RandomForest$$seed());
                topNodes = (Node[])Array$.MODULE$.fill(this.org$apache$spark$mllib$tree$RandomForest$$numTrees(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Node apply() {
                        return Node$.MODULE$.emptyNode(1);
                    }
                }, ClassTag$.MODULE$.apply(Node.class));
                package$.MODULE$.Range().apply(0, this.org$apache$spark$mllib$tree$RandomForest$$numTrees()).foreach$mVc$sp((Function1)new Serializable(this, nodeQueue, topNodes){
                    public static final long serialVersionUID = 0L;
                    private final Queue nodeQueue$1;
                    private final Node[] topNodes$1;

                    public final void apply(int treeIndex) {
                        this.apply$mcVI$sp(treeIndex);
                    }

                    public void apply$mcVI$sp(int treeIndex) {
                        this.nodeQueue$1.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)treeIndex), (Object)this.topNodes$1[treeIndex])}));
                    }
                    {
                        this.nodeQueue$1 = nodeQueue$1;
                        this.topNodes$1 = topNodes$1;
                    }
                });
                while (nodeQueue.nonEmpty()) {
                    Tuple2<scala.collection.immutable.Map<Object, Node[]>, scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, NodeIndexInfo>>> tuple24 = RandomForest$.MODULE$.selectNodesToSplit((Queue<Tuple2<Object, Node>>)nodeQueue, maxMemoryUsage, metadata, rng);
                    if (tuple24 != null) {
                        Tuple2 tuple25;
                        scala.collection.immutable.Map nodesForGroup = (scala.collection.immutable.Map)tuple24._1();
                        scala.collection.immutable.Map treeToNodeToIndexInfo = (scala.collection.immutable.Map)tuple24._2();
                        Tuple2 tuple26 = tuple25 = new Tuple2((Object)nodesForGroup, (Object)treeToNodeToIndexInfo);
                        scala.collection.immutable.Map nodesForGroup2 = (scala.collection.immutable.Map)tuple26._1();
                        scala.collection.immutable.Map treeToNodeToIndexInfo2 = (scala.collection.immutable.Map)tuple26._2();
                        Predef$.MODULE$.assert(nodesForGroup2.size() > 0, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest selected empty nodesForGroup.  Error for unknown reason."})).s((Seq)Nil$.MODULE$);
                            }
                        });
                        timer.start("findBestSplits");
                        DecisionTree$.MODULE$.findBestSplits((RDD<BaggedPoint<TreePoint>>)baggedInput, metadata, topNodes, (scala.collection.immutable.Map<Object, Node[]>)nodesForGroup2, (scala.collection.immutable.Map<Object, scala.collection.immutable.Map<Object, NodeIndexInfo>>)treeToNodeToIndexInfo2, splits2, bins2, (Queue<Tuple2<Object, Node>>)nodeQueue, timer, (Option<NodeIdCache>)nodeIdCache);
                        timer.stop("findBestSplits");
                        continue;
                    }
                    throw new MatchError(tuple24);
                }
                baggedInput.unpersist(baggedInput.unpersist$default$1());
                timer.stop("total");
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Internal timing for DecisionTree:";
                    }
                });
                this.logInfo((Function0<String>)new Serializable(this, timer){
                    public static final long serialVersionUID = 0L;
                    private final TimeTracker timer$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.timer$1}));
                    }
                    {
                        this.timer$1 = timer$1;
                    }
                });
                if (!nodeIdCache.nonEmpty()) break block5;
                try {
                    ((NodeIdCache)nodeIdCache.get()).deleteAllCheckpoints();
                }
                catch (IOException iOException) {
                    this.logWarning((Function0<String>)new Serializable(this, iOException){
                        public static final long serialVersionUID = 0L;
                        private final IOException e$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete all checkpoints failed. Error reason: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.e$1.getMessage()}));
                        }
                        {
                            this.e$1 = e$1;
                        }
                    });
                }
            }
            throw new MatchError(tuple2);
        }
        DecisionTreeModel[] trees = (DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])topNodes).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final DecisionTreeModel apply(Node topNode) {
                return new DecisionTreeModel(topNode, this.$outer.org$apache$spark$mllib$tree$RandomForest$$strategy().algo());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DecisionTreeModel.class)));
        return new RandomForestModel(this.org$apache$spark$mllib$tree$RandomForest$$strategy().algo(), trees);
    }

    public RandomForest(Strategy strategy, int numTrees, String featureSubsetStrategy, int seed) {
        this.org$apache$spark$mllib$tree$RandomForest$$strategy = strategy;
        this.org$apache$spark$mllib$tree$RandomForest$$numTrees = numTrees;
        this.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy = featureSubsetStrategy;
        this.org$apache$spark$mllib$tree$RandomForest$$seed = seed;
        Logging.class.$init$((Logging)this);
        strategy.assertValid();
        Predef$.MODULE$.require(numTrees > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest requires numTrees > 0, but was given numTrees = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$tree$RandomForest$$numTrees())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        Predef$.MODULE$.require(Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.supportedFeatureSubsetStrategies()).contains((Object)featureSubsetStrategy), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForest $outer;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForest given invalid featureSubsetStrategy: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$tree$RandomForest$$featureSubsetStrategy}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Supported values: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])RandomForest$.MODULE$.supportedFeatureSubsetStrategies()).mkString(", ")}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public static class NodeIndexInfo
    implements Serializable {
        private final int nodeIndexInGroup;
        private final Option<int[]> featureSubset;

        public int nodeIndexInGroup() {
            return this.nodeIndexInGroup;
        }

        public Option<int[]> featureSubset() {
            return this.featureSubset;
        }

        public NodeIndexInfo(int nodeIndexInGroup, Option<int[]> featureSubset) {
            this.nodeIndexInGroup = nodeIndexInGroup;
            this.featureSubset = featureSubset;
        }
    }
}

