/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.clustering;

import java.io.IOException;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.clustering.LDA$;
import org.apache.spark.ml.clustering.LDAModel$;
import org.apache.spark.ml.clustering.LDAParams;
import org.apache.spark.ml.clustering.LDAParams$class;
import org.apache.spark.ml.linalg.Matrix;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasCheckpointInterval$class;
import org.apache.spark.ml.param.shared.HasFeaturesCol$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasSeed$class;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWritable$class;
import org.apache.spark.mllib.clustering.LDAOptimizer;
import org.apache.spark.mllib.clustering.LocalLDAModel;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorImplicits$;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=h!B\u0001\u0003\u0003\u0003i!\u0001\u0003'E\u00036{G-\u001a7\u000b\u0005\r!\u0011AC2mkN$XM]5oO*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0015\u0001a\u0002F\f\u001e!\ry\u0001CE\u0007\u0002\t%\u0011\u0011\u0003\u0002\u0002\u0006\u001b>$W\r\u001c\t\u0003'\u0001i\u0011A\u0001\t\u0003'UI!A\u0006\u0002\u0003\u00131#\u0015\tU1sC6\u001c\bC\u0001\r\u001c\u001b\u0005I\"B\u0001\u000e\u0007\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u000f\u001a\u0005\u001daunZ4j]\u001e\u0004\"AH\u0011\u000e\u0003}Q!\u0001\t\u0003\u0002\tU$\u0018\u000e\\\u0005\u0003E}\u0011!\"\u0014'Xe&$\u0018M\u00197f\u0011!!\u0003A!b\u0001\n\u0003*\u0013aA;jIV\ta\u0005\u0005\u0002([9\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\u00051\u0001K]3eK\u001aL!AL\u0018\u0003\rM#(/\u001b8h\u0015\ta\u0013\u0006K\u0002$c]\u0002\"AM\u001b\u000e\u0003MR!\u0001\u000e\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u00027g\t)1+\u001b8dK\u0006\n\u0001(A\u00032]Yr\u0003\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003'\u0003\u0011)\u0018\u000e\u001a\u0011)\u0007e\nt\u0007\u0003\u0005>\u0001\t\u0015\r\u0011\"\u0001?\u0003%1xnY1c'&TX-F\u0001@!\tA\u0003)\u0003\u0002BS\t\u0019\u0011J\u001c;)\u0007q\nt\u0007\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003@\u0003)1xnY1c'&TX\r\t\u0015\u0004\u0007F:\u0004\"C$\u0001\u0005\u000b\u0007I\u0011\u0001\u0003I\u00031\u0019\b/\u0019:l'\u0016\u001c8/[8o+\u0005I\u0005C\u0001&N\u001b\u0005Y%B\u0001'\u0007\u0003\r\u0019\u0018\u000f\\\u0005\u0003\u001d.\u0013Ab\u00159be.\u001cVm]:j_:D3AR\u00198\u0011!\t\u0006A!A!\u0002\u0013I\u0015!D:qCJ\\7+Z:tS>t\u0007\u0005\u000b\u0002Q'B\u0011\u0001\u0006V\u0005\u0003+&\u0012\u0011\u0002\u001e:b]NLWM\u001c;)\u0007A\u000bt\u0007\u0003\u0004Y\u0001\u0011\u0005A!W\u0001\u0007y%t\u0017\u000e\u001e \u0015\tIQFL\u0018\u0005\u0006I]\u0003\rA\n\u0015\u00045F:\u0004\"B\u001fX\u0001\u0004y\u0004f\u0001/2o!)qi\u0016a\u0001\u0013\"\u001aa,M\u001c\t\u000b\u0005\u0004a\u0011\u00032\u0002\u001b=dG\rT8dC2lu\u000eZ3m+\u0005\u0019\u0007C\u00013i\u001b\u0005)'BA\u0002g\u0015\t9g!A\u0003nY2L'-\u0003\u0002jK\niAj\\2bY2#\u0015)T8eK2D3\u0001Y\u00198\u0011\u0015a\u0007A\"\u0005n\u0003!9W\r^'pI\u0016dW#\u00018\u0011\u0005\u0011|\u0017BA\u0001fQ\rY\u0017g\u000e\u0005\u0007e\u0002!\t\u0001B:\u00029\u001d,G/\u00124gK\u000e$\u0018N^3E_\u000e\u001cuN\\2f]R\u0014\u0018\r^5p]V\tA\u000fE\u0002)k^L!A^\u0015\u0003\u000b\u0005\u0013(/Y=\u0011\u0005!B\u0018BA=*\u0005\u0019!u.\u001e2mK\"11\u0010\u0001C\u0001\tq\fadZ3u\u000b\u001a4Wm\u0019;jm\u0016$v\u000e]5d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\u0016\u0003]DQA \u0001\u0005\u0002}\fab]3u\r\u0016\fG/\u001e:fg\u000e{G\u000e\u0006\u0003\u0002\u0002\u0005\rQ\"\u0001\u0001\t\r\u0005\u0015Q\u00101\u0001'\u0003\u00151\u0018\r\\;fQ\ri\u0018g\u000e\u0005\b\u0003\u0017\u0001A\u0011AA\u0007\u0003\u001d\u0019X\r^*fK\u0012$B!!\u0001\u0002\u0010!A\u0011QAA\u0005\u0001\u0004\t\t\u0002E\u0002)\u0003'I1!!\u0006*\u0005\u0011auN\\4)\t\u0005%\u0011g\u000e\u0005\b\u00037\u0001A\u0011IA\u000f\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002 \u0005\r\u0003\u0003BA\u0011\u0003{qA!a\t\u0002:9!\u0011QEA\u001c\u001d\u0011\t9#!\u000e\u000f\t\u0005%\u00121\u0007\b\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011q\u0006\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0011BA\u0005\u000b\u0013\t9\u0001\"\u0003\u0002M\r%\u0019\u00111H&\u0002\u000fA\f7m[1hK&!\u0011qHA!\u0005%!\u0015\r^1Ge\u0006lWMC\u0002\u0002<-C\u0001\"!\u0012\u0002\u001a\u0001\u0007\u0011qI\u0001\bI\u0006$\u0018m]3ua\u0011\tI%a\u0015\u0011\u000b)\u000bY%a\u0014\n\u0007\u000553JA\u0004ECR\f7/\u001a;\u0011\t\u0005E\u00131\u000b\u0007\u0001\t1\t)&a\u0011\u0002\u0002\u0003\u0005)\u0011AA,\u0005\ryF%M\t\u0005\u00033\ny\u0006E\u0002)\u00037J1!!\u0018*\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001KA1\u0013\r\t\u0019'\u000b\u0002\u0004\u0003:L\b&BA\rc\u0005\u001d\u0014EAA5\u0003\u0015\u0011d\u0006\r\u00181\u0011\u001d\ti\u0007\u0001C!\u0003_\nq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0003c\ni\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9hS\u0001\u0006if\u0004Xm]\u0005\u0005\u0003w\n)H\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001\"a \u0002l\u0001\u0007\u0011\u0011O\u0001\u0007g\u000eDW-\\1)\t\u0005-\u0014g\u000e\u0005\b\u0003\u000b\u0003A\u0011AAD\u0003e)7\u000f^5nCR,G\rR8d\u0007>t7-\u001a8ue\u0006$\u0018n\u001c8\u0016\u0005\u0005%\u0005\u0003BAF\u0003#k!!!$\u000b\u0007\u0005=E!\u0001\u0004mS:\fGnZ\u0005\u0005\u0003'\u000biI\u0001\u0004WK\u000e$xN\u001d\u0015\u0006\u0003\u0007\u000b\u0014q\r\u0005\b\u00033\u0003A\u0011AAN\u00031!x\u000e]5dg6\u000bGO]5y+\t\ti\n\u0005\u0003\u0002\f\u0006}\u0015\u0002BAQ\u0003\u001b\u0013a!T1ue&D\b&BALc\u0005\u001d\u0004bBAT\u0001\u0019\u0005\u0011\u0011V\u0001\u000eSN$\u0015n\u001d;sS\n,H/\u001a3\u0016\u0005\u0005-\u0006c\u0001\u0015\u0002.&\u0019\u0011qV\u0015\u0003\u000f\t{w\u000e\\3b]\"\"\u0011QU\u00198\u0011\u001d\t)\f\u0001C\u0001\u0003o\u000bQ\u0002\\8h\u0019&\\W\r\\5i_>$GcA<\u0002:\"A\u0011QIAZ\u0001\u0004\tY\f\r\u0003\u0002>\u0006\u0005\u0007#\u0002&\u0002L\u0005}\u0006\u0003BA)\u0003\u0003$A\"a1\u0002:\u0006\u0005\t\u0011!B\u0001\u0003/\u00121a\u0018\u00133Q\u0015\t\u0019,MA4\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017\fQ\u0002\\8h!\u0016\u0014\b\u000f\\3ySRLHcA<\u0002N\"A\u0011QIAd\u0001\u0004\ty\r\r\u0003\u0002R\u0006U\u0007#\u0002&\u0002L\u0005M\u0007\u0003BA)\u0003+$A\"a6\u0002N\u0006\u0005\t\u0011!B\u0001\u0003/\u00121a\u0018\u00134Q\u0015\t9-MA4\u0011\u001d\ti\u000e\u0001C\u0001\u0003?\fa\u0002Z3tGJL'-\u001a+pa&\u001c7\u000f\u0006\u0003\u0002 \u0005\u0005\bbBAr\u00037\u0004\raP\u0001\u0011[\u0006DH+\u001a:ngB+'\u000fV8qS\u000eDC!a72o!9\u0011Q\u001c\u0001\u0005\u0002\u0005%HCAA\u0010Q\u0011\t9/M\u001c)\u0007\u0001\tt\u0007")
public abstract class LDAModel
extends Model<LDAModel>
implements LDAParams,
MLWritable {
    private final String uid;
    private final int vocabSize;
    private final transient SparkSession sparkSession;
    private final IntParam k;
    private final DoubleArrayParam docConcentration;
    private final DoubleParam topicConcentration;
    private final String[] supportedOptimizers;
    private final Param<String> optimizer;
    private final Param<String> topicDistributionCol;
    private final DoubleParam learningOffset;
    private final DoubleParam learningDecay;
    private final DoubleParam subsamplingRate;
    private final BooleanParam optimizeDocConcentration;
    private final BooleanParam keepLastCheckpoint;
    private final IntParam checkpointInterval;
    private final LongParam seed;
    private final IntParam maxIter;
    private final Param<String> featuresCol;

    @Override
    public void save(String path) throws IOException {
        MLWritable$class.save(this, path);
    }

    @Override
    public final IntParam k() {
        return this.k;
    }

    @Override
    public final DoubleArrayParam docConcentration() {
        return this.docConcentration;
    }

    @Override
    public final DoubleParam topicConcentration() {
        return this.topicConcentration;
    }

    @Override
    public final String[] supportedOptimizers() {
        return this.supportedOptimizers;
    }

    @Override
    public final Param<String> optimizer() {
        return this.optimizer;
    }

    @Override
    public final Param<String> topicDistributionCol() {
        return this.topicDistributionCol;
    }

    @Override
    public final DoubleParam learningOffset() {
        return this.learningOffset;
    }

    @Override
    public final DoubleParam learningDecay() {
        return this.learningDecay;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final BooleanParam optimizeDocConcentration() {
        return this.optimizeDocConcentration;
    }

    @Override
    public final BooleanParam keepLastCheckpoint() {
        return this.keepLastCheckpoint;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$k_$eq(IntParam x$1) {
        this.k = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$docConcentration_$eq(DoubleArrayParam x$1) {
        this.docConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicConcentration_$eq(DoubleParam x$1) {
        this.topicConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$supportedOptimizers_$eq(String[] x$1) {
        this.supportedOptimizers = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizer_$eq(Param x$1) {
        this.optimizer = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$topicDistributionCol_$eq(Param x$1) {
        this.topicDistributionCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningOffset_$eq(DoubleParam x$1) {
        this.learningOffset = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$learningDecay_$eq(DoubleParam x$1) {
        this.learningDecay = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$optimizeDocConcentration_$eq(BooleanParam x$1) {
        this.optimizeDocConcentration = x$1;
    }

    @Override
    public final void org$apache$spark$ml$clustering$LDAParams$_setter_$keepLastCheckpoint_$eq(BooleanParam x$1) {
        this.keepLastCheckpoint = x$1;
    }

    @Override
    public int getK() {
        return LDAParams$class.getK(this);
    }

    @Override
    public double[] getDocConcentration() {
        return LDAParams$class.getDocConcentration(this);
    }

    @Override
    public org.apache.spark.ml.linalg.Vector getOldDocConcentration() {
        return LDAParams$class.getOldDocConcentration(this);
    }

    @Override
    public double getTopicConcentration() {
        return LDAParams$class.getTopicConcentration(this);
    }

    @Override
    public double getOldTopicConcentration() {
        return LDAParams$class.getOldTopicConcentration(this);
    }

    @Override
    public String getOptimizer() {
        return LDAParams$class.getOptimizer(this);
    }

    @Override
    public String getTopicDistributionCol() {
        return LDAParams$class.getTopicDistributionCol(this);
    }

    @Override
    public double getLearningOffset() {
        return LDAParams$class.getLearningOffset(this);
    }

    @Override
    public double getLearningDecay() {
        return LDAParams$class.getLearningDecay(this);
    }

    @Override
    public double getSubsamplingRate() {
        return LDAParams$class.getSubsamplingRate(this);
    }

    @Override
    public boolean getOptimizeDocConcentration() {
        return LDAParams$class.getOptimizeDocConcentration(this);
    }

    @Override
    public boolean getKeepLastCheckpoint() {
        return LDAParams$class.getKeepLastCheckpoint(this);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema) {
        return LDAParams$class.validateAndTransformSchema(this, schema);
    }

    @Override
    public LDAOptimizer getOldOptimizer() {
        return LDAParams$class.getOldOptimizer(this);
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval$class.getCheckpointInterval(this);
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final long getSeed() {
        return HasSeed$class.getSeed(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final Param<String> featuresCol() {
        return this.featuresCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFeaturesCol$_setter_$featuresCol_$eq(Param x$1) {
        this.featuresCol = x$1;
    }

    @Override
    public final String getFeaturesCol() {
        return HasFeaturesCol$class.getFeaturesCol(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public int vocabSize() {
        return this.vocabSize;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public abstract LocalLDAModel oldLocalModel();

    public abstract org.apache.spark.mllib.clustering.LDAModel getModel();

    public double[] getEffectiveDocConcentration() {
        return this.getModel().docConcentration().toArray();
    }

    public double getEffectiveTopicConcentration() {
        return this.getModel().topicConcentration();
    }

    public LDAModel setFeaturesCol(String value) {
        return (LDAModel)this.set(this.featuresCol(), value);
    }

    public LDAModel setSeed(long value) {
        return (LDAModel)this.set(this.seed(), BoxesRunTime.boxToLong((long)value));
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.topicDistributionCol()))).nonEmpty()) {
            Function1<Vector, Vector> transformer = this.oldLocalModel().getTopicDistributionMethod(this.sparkSession().sparkContext());
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(LDAModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(LDAModel $outer) {
                }
            }
            UserDefinedFunction t = functions$.MODULE$.udf((Function1)new Serializable(this, transformer){
                public static final long serialVersionUID = 0L;
                private final Function1 transformer$1;

                public final org.apache.spark.ml.linalg.Vector apply(org.apache.spark.ml.linalg.Vector v) {
                    return ((Vector)this.transformer$1.apply((Object)Vectors$.MODULE$.fromML(v))).asML();
                }
                {
                    this.transformer$1 = transformer$1;
                }
            }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator1$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator2$1(this)));
            dataset2 = dataset.withColumn(this.$(this.topicDistributionCol()), t.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}))).toDF();
        } else {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "LDAModel.transform was called without any output columns. Set an output column such as topicDistributionCol to produce results.";
                }
            });
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public StructType transformSchema(StructType schema) {
        return this.validateAndTransformSchema(schema);
    }

    public org.apache.spark.ml.linalg.Vector estimatedDocConcentration() {
        return VectorImplicits$.MODULE$.mllibVectorToMLVector(this.getModel().docConcentration());
    }

    public Matrix topicsMatrix() {
        return this.oldLocalModel().topicsMatrix().asML();
    }

    public abstract boolean isDistributed();

    public double logLikelihood(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logLikelihood(oldDataset);
    }

    public double logPerplexity(Dataset<?> dataset) {
        RDD<Tuple2<Object, Vector>> oldDataset = LDA$.MODULE$.getOldDataset(dataset, this.$(this.featuresCol()));
        return this.oldLocalModel().logPerplexity(oldDataset);
    }

    public Dataset<Row> describeTopics(int maxTermsPerTopic) {
        Tuple3[] topics = (Tuple3[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.getModel().describeTopics(maxTermsPerTopic)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Seq<Object>, Seq<Object>> apply(Tuple2<Tuple2<int[], double[]>, Object> x0$2) {
                Tuple2<Tuple2<int[], double[]>, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    int topic = tuple2._2$mcI$sp();
                    if (tuple22 != null) {
                        int[] termIndices = (int[])tuple22._1();
                        double[] termWeights = (double[])tuple22._2();
                        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)topic), (Object)Predef$.MODULE$.intArrayOps(termIndices).toSeq(), (Object)Predef$.MODULE$.doubleArrayOps(termWeights).toSeq());
                        return tuple3;
                    }
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(LDAModel.class.getClassLoader());
        public final class Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple3"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor(), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Int").asType().toTypeConstructor()}))), $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala.collection").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.collection.Seq"), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Types.TypeApi[]{$m.staticClass("scala.Double").asType().toTypeConstructor()})))})));
            }

            public Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(LDAModel $outer) {
            }
        }
        return this.sparkSession().createDataFrame((Seq)Predef$.MODULE$.wrapRefArray((Object[])topics), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_clustering_LDAModel$$typecreator3$1(this))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic", "termIndices", "termWeights"}));
    }

    public Dataset<Row> describeTopics() {
        return this.describeTopics(10);
    }

    public LDAModel(String uid, int vocabSize, SparkSession sparkSession) {
        this.uid = uid;
        this.vocabSize = vocabSize;
        this.sparkSession = sparkSession;
        HasFeaturesCol$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasSeed$class.$init$(this);
        HasCheckpointInterval$class.$init$(this);
        LDAParams$class.$init$(this);
        MLWritable$class.$init$(this);
    }
}

