/*
 * Decompiled with CFR 0.152.
 */
package org.spark_project.dmg.pmml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.spark_project.dmg.pmml.Extension;
import org.spark_project.dmg.pmml.FieldName;
import org.spark_project.dmg.pmml.HasExtensions;
import org.spark_project.dmg.pmml.Indexable;
import org.spark_project.dmg.pmml.OpType;
import org.spark_project.dmg.pmml.PMMLObject;
import org.spark_project.dmg.pmml.TargetValue;
import org.spark_project.dmg.pmml.Visitor;
import org.spark_project.dmg.pmml.VisitorAction;
import org.spark_project.dmg.pmml.adapters.FieldNameAdapter;
import org.spark_project.jpmml.schema.Added;
import org.spark_project.jpmml.schema.Optional;
import org.spark_project.jpmml.schema.Version;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"extensions", "targetValues"})
@XmlRootElement(name="Target", namespace="http://www.dmg.org/PMML-4_2")
public class Target
extends PMMLObject
implements HasExtensions,
Indexable<FieldName> {
    @XmlAttribute(name="field", required=true)
    @XmlJavaTypeAdapter(value=FieldNameAdapter.class)
    private FieldName field;
    @XmlAttribute(name="optype")
    private OpType opType;
    @XmlAttribute(name="castInteger")
    private CastInteger castInteger;
    @XmlAttribute(name="min")
    @Added(value=Version.PMML_3_1)
    private Double min;
    @XmlAttribute(name="max")
    @Added(value=Version.PMML_3_1)
    private Double max;
    @XmlAttribute(name="rescaleConstant")
    @Added(value=Version.PMML_3_1)
    private Double rescaleConstant;
    @XmlAttribute(name="rescaleFactor")
    @Added(value=Version.PMML_3_1)
    private Double rescaleFactor;
    @XmlElement(name="Extension", namespace="http://www.dmg.org/PMML-4_2")
    private List<Extension> extensions;
    @XmlElement(name="TargetValue", namespace="http://www.dmg.org/PMML-4_2")
    @Optional(value=Version.PMML_3_1)
    private List<TargetValue> targetValues;
    private static final Double DEFAULT_RESCALE_CONSTANT = 0.0;
    private static final Double DEFAULT_RESCALE_FACTOR = 1.0;

    public Target() {
    }

    public Target(FieldName field) {
        this.field = field;
    }

    public FieldName getField() {
        return this.field;
    }

    public Target setField(FieldName field) {
        this.field = field;
        return this;
    }

    public OpType getOpType() {
        return this.opType;
    }

    public Target setOpType(OpType opType) {
        this.opType = opType;
        return this;
    }

    public CastInteger getCastInteger() {
        return this.castInteger;
    }

    public Target setCastInteger(CastInteger castInteger) {
        this.castInteger = castInteger;
        return this;
    }

    public Double getMin() {
        return this.min;
    }

    public Target setMin(Double min2) {
        this.min = min2;
        return this;
    }

    public Double getMax() {
        return this.max;
    }

    public Target setMax(Double max2) {
        this.max = max2;
        return this;
    }

    public Double getRescaleConstant() {
        if (this.rescaleConstant == null) {
            return DEFAULT_RESCALE_CONSTANT;
        }
        return this.rescaleConstant;
    }

    public Target setRescaleConstant(Double rescaleConstant) {
        this.rescaleConstant = rescaleConstant;
        return this;
    }

    public Double getRescaleFactor() {
        if (this.rescaleFactor == null) {
            return DEFAULT_RESCALE_FACTOR;
        }
        return this.rescaleFactor;
    }

    public Target setRescaleFactor(Double rescaleFactor) {
        this.rescaleFactor = rescaleFactor;
        return this;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = new ArrayList<Extension>();
        }
        return this.extensions;
    }

    public List<TargetValue> getTargetValues() {
        if (this.targetValues == null) {
            this.targetValues = new ArrayList<TargetValue>();
        }
        return this.targetValues;
    }

    @Override
    public FieldName getKey() {
        return this.getField();
    }

    @Override
    public boolean hasExtensions() {
        return this.extensions != null && this.extensions.size() > 0;
    }

    public Target addExtensions(Extension ... extensions) {
        this.getExtensions().addAll(Arrays.asList(extensions));
        return this;
    }

    public boolean hasTargetValues() {
        return this.targetValues != null && this.targetValues.size() > 0;
    }

    public Target addTargetValues(TargetValue ... targetValues) {
        this.getTargetValues().addAll(Arrays.asList(targetValues));
        return this;
    }

    @Override
    public VisitorAction accept(Visitor visitor) {
        VisitorAction status = visitor.visit(this);
        if (status == VisitorAction.CONTINUE) {
            visitor.pushParent(this);
            if (status == VisitorAction.CONTINUE && this.hasExtensions()) {
                status = PMMLObject.traverse(visitor, this.getExtensions());
            }
            if (status == VisitorAction.CONTINUE && this.hasTargetValues()) {
                status = PMMLObject.traverse(visitor, this.getTargetValues());
            }
            visitor.popParent();
        }
        if (status == VisitorAction.TERMINATE) {
            return VisitorAction.TERMINATE;
        }
        return VisitorAction.CONTINUE;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum CastInteger {
        ROUND("round"),
        CEILING("ceiling"),
        FLOOR("floor");

        private final String value;

        private CastInteger(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static CastInteger fromValue(String v) {
            for (CastInteger c : CastInteger.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

