/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.ml.Predictor;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.LabeledPoint;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasRawPredictionCol;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.SeqOps;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005ea!\u0002\u0005\n\u0003\u0003!\u0002\"\u0002\u001d\u0001\t\u0003I\u0004\"\u0002\u001e\u0001\t\u0003Y\u0004\"B%\u0001\t#Q\u0005\"\u00025\u0001\t#I\u0007\"\u00028\u0001\t#y\u0007\"\u0002<\u0001\t#9\b\"CA\u0001\u0001E\u0005I\u0011CA\u0002\u0005)\u0019E.Y:tS\u001aLWM\u001d\u0006\u0003\u0015-\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\r\u001b\u0005\u0011Q\u000e\u001c\u0006\u0003\u001d=\tQa\u001d9be.T!\u0001E\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0011\u0012aA8sO\u000e\u0001Q\u0003B\u000b\u001dS=\u001a2\u0001\u0001\f6!\u00159\u0002D\u0007\u0015/\u001b\u0005Y\u0011BA\r\f\u0005%\u0001&/\u001a3jGR|'\u000f\u0005\u0002\u001c91\u0001A!B\u000f\u0001\u0005\u0004q\"\u0001\u0004$fCR,(/Z:UsB,\u0017CA\u0010&!\t\u00013%D\u0001\"\u0015\u0005\u0011\u0013!B:dC2\f\u0017B\u0001\u0013\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\t\u0014\n\u0005\u001d\n#aA!osB\u00111$\u000b\u0003\u0006U\u0001\u0011\ra\u000b\u0002\u0002\u000bF\u0011q\u0004\f\t\u0006[\u0001Q\u0002FL\u0007\u0002\u0013A\u00111d\f\u0003\u0006a\u0001\u0011\r!\r\u0002\u0002\u001bF\u0011qD\r\t\u0005[MRb&\u0003\u00025\u0013\t\u00192\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u0011QFN\u0005\u0003o%\u0011\u0001c\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\u0002\rqJg.\u001b;?)\u0005a\u0013aE:fiJ\u000bw\u000f\u0015:fI&\u001cG/[8o\u0007>dGC\u0001\u0015=\u0011\u0015i$\u00011\u0001?\u0003\u00151\u0018\r\\;f!\tydI\u0004\u0002A\tB\u0011\u0011)I\u0007\u0002\u0005*\u00111iE\u0001\u0007yI|w\u000e\u001e \n\u0005\u0015\u000b\u0013A\u0002)sK\u0012,g-\u0003\u0002H\u0011\n11\u000b\u001e:j]\u001eT!!R\u0011\u0002)\u0015DHO]1di2\u000b'-\u001a7fIB{\u0017N\u001c;t)\rYuk\u0019\t\u0004\u0019>\u000bV\"A'\u000b\u00059k\u0011a\u0001:eI&\u0011\u0001+\u0014\u0002\u0004%\u0012#\u0005C\u0001*V\u001b\u0005\u0019&B\u0001+\f\u0003\u001d1W-\u0019;ve\u0016L!AV*\u0003\u00191\u000b'-\u001a7fIB{\u0017N\u001c;\t\u000ba\u001b\u0001\u0019A-\u0002\u000f\u0011\fG/Y:fiB\u0012!,\u0019\t\u00047z\u0003W\"\u0001/\u000b\u0005uk\u0011aA:rY&\u0011q\f\u0018\u0002\b\t\u0006$\u0018m]3u!\tY\u0012\rB\u0005c/\u0006\u0005\t\u0011!B\u0001=\t\u0019q\f\n\u001a\t\u000b\u0011\u001c\u0001\u0019A3\u0002\u00159,Xn\u00117bgN,7\u000f\u0005\u0002!M&\u0011q-\t\u0002\u0004\u0013:$\u0018A\u0005<bY&$\u0017\r^3Ok6\u001cE.Y:tKN$\"A[7\u0011\u0005\u0001Z\u0017B\u00017\"\u0005\u0011)f.\u001b;\t\u000b\u0011$\u0001\u0019A3\u0002\u001bY\fG.\u001b3bi\u0016d\u0015MY3m)\rQ\u0007/\u001e\u0005\u0006c\u0016\u0001\rA]\u0001\u0006Y\u0006\u0014W\r\u001c\t\u0003AML!\u0001^\u0011\u0003\r\u0011{WO\u00197f\u0011\u0015!W\u00011\u0001f\u000359W\r\u001e(v[\u000ec\u0017m]:fgR\u0019Q\r\u001f@\t\u000ba3\u0001\u0019A=1\u0005id\bcA._wB\u00111\u0004 \u0003\n{b\f\t\u0011!A\u0003\u0002y\u00111a\u0018\u00134\u0011\u001dyh\u0001%AA\u0002\u0015\fQ\"\\1y\u001dVl7\t\\1tg\u0016\u001c\u0018aF4fi:+Xn\u00117bgN,7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t)AK\u0002f\u0003\u000fY#!!\u0003\u0011\t\u0005-\u0011QC\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003'\t\u0013AC1o]>$\u0018\r^5p]&!\u0011qCA\u0007\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public abstract class Classifier<FeaturesType, E extends Classifier<FeaturesType, E, M>, M extends ClassificationModel<FeaturesType, M>>
extends Predictor<FeaturesType, E, M>
implements ClassifierParams {
    private Param<String> rawPredictionCol;

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$ClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public RDD<Instance> extractInstances(Dataset<?> dataset, int numClasses) {
        return ClassifierParams.extractInstances$(this, dataset, numClasses);
    }

    @Override
    public final String getRawPredictionCol() {
        return HasRawPredictionCol.getRawPredictionCol$(this);
    }

    @Override
    public final Param<String> rawPredictionCol() {
        return this.rawPredictionCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRawPredictionCol$_setter_$rawPredictionCol_$eq(Param<String> x$1) {
        this.rawPredictionCol = x$1;
    }

    public E setRawPredictionCol(String value) {
        return (E)((Classifier)this.set(this.rawPredictionCol(), value));
    }

    public RDD<LabeledPoint> extractLabeledPoints(Dataset<?> dataset, int numClasses) {
        this.validateNumClasses(numClasses);
        return dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.labelCol())), functions$.MODULE$.col(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
            double d;
            Object features;
            block3: {
                Row row;
                block2: {
                    Some some;
                    row = x0$1;
                    if (row == null || (some = Row$.MODULE$.unapplySeq(row)).isEmpty() || some.get() == null || ((SeqOps)some.get()).lengthCompare(2) != 0) break block2;
                    Object label = ((SeqOps)some.get()).apply(0);
                    features = ((SeqOps)some.get()).apply(1);
                    if (!(label instanceof Double)) break block2;
                    d = BoxesRunTime.unboxToDouble((Object)label);
                    if (features instanceof Vector) break block3;
                }
                throw new MatchError((Object)row);
            }
            Vector vector = (Vector)features;
            this.validateLabel(d, numClasses);
            LabeledPoint labeledPoint = new LabeledPoint(d, vector);
            return labeledPoint;
        }, ClassTag$.MODULE$.apply(LabeledPoint.class));
    }

    public void validateNumClasses(int numClasses) {
        Predef$.MODULE$.require(numClasses > 0, (Function0 & Serializable)() -> new StringBuilder(0).append("Classifier (in extractLabeledPoints) found numClasses =").append(new StringBuilder(31).append(" ").append(numClasses).append(", but requires numClasses > 0.").toString()).toString());
    }

    public void validateLabel(double label, int numClasses) {
        Predef$.MODULE$.require((double)((long)label) == label && label >= 0.0 && label < (double)numClasses, (Function0 & Serializable)() -> new StringBuilder(0).append("Classifier was given").append(new StringBuilder(63).append(" dataset with invalid label ").append(label).append(".  Labels must be integers in range").toString()).append(new StringBuilder(7).append(" [0, ").append(numClasses).append(").").toString()).toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getNumClasses(Dataset<?> dataset, int maxNumClasses) {
        Option<Object> option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())));
        if (option instanceof Some) {
            Some some = (Some)option;
            int n = BoxesRunTime.unboxToInt((Object)some.value());
            if (true) {
                int n2 = n;
                return n2;
            }
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        Row[] maxLabelRow = (Row[])dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max(this.$(this.labelCol()))})).take(1);
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow))) throw new SparkException("ML algorithm was given empty dataset.");
        if (maxLabelRow[0].get(0) == null) {
            throw new SparkException("ML algorithm was given empty dataset.");
        }
        double maxDoubleLabel = ((Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])maxLabelRow))).getDouble(0);
        Predef$.MODULE$.require(RichDouble$.MODULE$.isValidInt$extension(Predef$.MODULE$.doubleWrapper(maxDoubleLabel + 1.0)), (Function0 & Serializable)() -> new StringBuilder(0).append("Classifier found max label value =").append(new StringBuilder(62).append(" ").append(maxDoubleLabel).append(" but requires integers in range [0, ... ").append(Integer.MAX_VALUE).append(")").toString()).toString());
        int numClasses = (int)maxDoubleLabel + 1;
        Predef$.MODULE$.require(numClasses <= maxNumClasses, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(38).append("Classifier inferred ").append(numClasses).append(" from label values").toString()).append(new StringBuilder(60).append(" in column ").append(this.labelCol()).append(", but this exceeded the max numClasses (").append(maxNumClasses).append(") allowed").toString()).append(new StringBuilder(68).append(" to be inferred from values.  To avoid this error for labels with > ").append(maxNumClasses).toString()).append(" classes, specify numClasses explicitly in the metadata; this can be done by applying").append(" StringIndexer to the label column.").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(this.getClass().getCanonicalName()).append(new StringBuilder(22).append(" inferred ").append(numClasses).append(" classes for").toString()).append(new StringBuilder(69).append(" labelCol=").append(this.labelCol()).append(" since numClasses was not specified in the column metadata.").toString()).toString());
        return numClasses;
    }

    public int getNumClasses$default$2() {
        return 100;
    }

    public Classifier() {
        HasRawPredictionCol.$init$(this);
        ClassifierParams.$init$(this);
        Statics.releaseFence();
    }
}

