/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasStepSize;
import org.apache.spark.ml.param.shared.HasValidationIndicatorCol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.GBTRegressionModel$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.GBTParams;
import org.apache.spark.ml.tree.GBTRegressorParams;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleRegressorParams;
import org.apache.spark.ml.tree.impl.GradientBoostedTrees$;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.BoostingStrategy;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.loss.Loss;
import org.apache.spark.mllib.tree.model.DecisionTreeModel;
import org.apache.spark.mllib.tree.model.GradientBoostedTreesModel;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.JsonDSL$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\tef\u0001B\u0016-\u0001]B\u0001b\u0019\u0001\u0003\u0006\u0004%\t\u0005\u001a\u0005\t[\u0002\u0011\t\u0011)A\u0005K\"Aa\u000e\u0001BC\u0002\u0013%q\u000e\u0003\u0005u\u0001\t\u0005\t\u0015!\u0003q\u0011!)\bA!b\u0001\n\u00131\b\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011B<\t\u0011q\u0004!Q1A\u0005BuD\u0011\"a\u0001\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\t\u0011\u0005\u0015\u0001\u0001\"\u0001/\u0003\u000fAq!!\u0002\u0001\t\u0003\t\t\u0002\u0003\u0004\u0002,\u0001!\te\u001c\u0005\t\u0003_\u0001!\u0019!C\u0001{\"9\u0011q\u0007\u0001!\u0002\u0013q\bBBA\u001e\u0001\u0011\u0005c\u000fC\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\!9\u0011Q\u0014\u0001\u0005B\u0005}\u0005bBAS\u0001\u0011\u0005\u0013q\u0015\u0005\b\u0003w\u0003A\u0011IA_\u0011)\t\t\r\u0001EC\u0002\u0013\u0005\u00111\u0019\u0005\t\u0003\u000f\u0004A\u0011\u0001\u0018\u0002J\"9\u0011Q\u001c\u0001\u0005\u0002\u0005}\u0007bBA|\u0001\u0011\u0005\u0013\u0011`\u0004\b\u0005\u000ba\u0003\u0012\u0001B\u0004\r\u0019YC\u0006#\u0001\u0003\n!9\u0011QA\r\u0005\u0002\t\u0015\u0002b\u0002B\u00143\u0011\u0005#\u0011\u0006\u0005\b\u0005gIB\u0011\tB\u001b\r\u001d\u0011i$\u0007\u0001\u001a\u0005\u007fA\u0011B!\u0011\u001e\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000f\u0005\u0015Q\u0004\"\u0001\u0003D!9!1J\u000f\u0005R\t5cA\u0002B,3\u0011\u0011I\u0006C\u0004\u0002\u0006\u0005\"\tAa\u0017\t\u0013\t}\u0013E1A\u0005\n\t\u0005\u0004\u0002\u0003B7C\u0001\u0006IAa\u0019\t\u0013\t=\u0014E1A\u0005\n\t\u0005\u0004\u0002\u0003B9C\u0001\u0006IAa\u0019\t\u000f\tM\u0012\u0005\"\u0011\u0003t!A!qO\r\u0005\u00029\u0012I\b\u0003\u0006\u0003\u0016f\t\n\u0011\"\u0001/\u0005/C\u0011Ba+\u001a\u0003\u0003%IA!,\u0003%\u001d\u0013EKU3he\u0016\u001c8/[8o\u001b>$W\r\u001c\u0006\u0003[9\n!B]3he\u0016\u001c8/[8o\u0015\ty\u0003'\u0001\u0002nY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001A4)S(V!\u0011I$\b\u0010\"\u000e\u00031J!a\u000f\u0017\u0003\u001fI+wM]3tg&|g.T8eK2\u0004\"!\u0010!\u000e\u0003yR!a\u0010\u0018\u0002\r1Lg.\u00197h\u0013\t\teH\u0001\u0004WK\u000e$xN\u001d\t\u0003s\u0001\u0001\"\u0001R$\u000e\u0003\u0015S!A\u0012\u0018\u0002\tQ\u0014X-Z\u0005\u0003\u0011\u0016\u0013!c\u0012\"U%\u0016<'/Z:t_J\u0004\u0016M]1ngB\u0019AI\u0013'\n\u0005-+%!\u0005+sK\u0016,en]3nE2,Wj\u001c3fYB\u0011\u0011(T\u0005\u0003\u001d2\u00121\u0004R3dSNLwN\u001c+sK\u0016\u0014Vm\u001a:fgNLwN\\'pI\u0016d\u0007C\u0001)T\u001b\u0005\t&B\u0001*/\u0003\u0011)H/\u001b7\n\u0005Q\u000b&AC'M/JLG/\u00192mKB\u0011a\u000b\u0019\b\u0003/vs!\u0001W.\u000e\u0003eS!A\u0017\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0016!B:dC2\f\u0017B\u00010`\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001X\u0005\u0003C\n\u0014AbU3sS\u0006d\u0017N_1cY\u0016T!AX0\u0002\u0007ULG-F\u0001f!\t1'N\u0004\u0002hQB\u0011\u0001lX\u0005\u0003S~\u000ba\u0001\u0015:fI\u00164\u0017BA6m\u0005\u0019\u0019FO]5oO*\u0011\u0011nX\u0001\u0005k&$\u0007%\u0001\u0004`iJ,Wm]\u000b\u0002aB\u0019\u0011O\u001d'\u000e\u0003}K!a]0\u0003\u000b\u0005\u0013(/Y=\u0002\u000f}#(/Z3tA\u0005aq\f\u001e:fK^+\u0017n\u001a5ugV\tq\u000fE\u0002reb\u0004\"!]=\n\u0005i|&A\u0002#pk\ndW-A\u0007`iJ,WmV3jO\"$8\u000fI\u0001\f]Vlg)Z1ukJ,7/F\u0001\u007f!\t\tx0C\u0002\u0002\u0002}\u00131!\u00138u\u00031qW/\u001c$fCR,(/Z:!\u0003\u0019a\u0014N\\5u}QI!)!\u0003\u0002\f\u00055\u0011q\u0002\u0005\u0006G&\u0001\r!\u001a\u0005\u0006]&\u0001\r\u0001\u001d\u0005\u0006k&\u0001\ra\u001e\u0005\u0006y&\u0001\rA \u000b\b\u0005\u0006M\u0011QCA\f\u0011\u0015\u0019'\u00021\u0001f\u0011\u0015q'\u00021\u0001q\u0011\u0015)(\u00021\u0001xQ\u0015Q\u00111DA\u0014!\u0011\ti\"a\t\u000e\u0005\u0005}!bAA\u0011a\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u0012q\u0004\u0002\u0006'&t7-Z\u0011\u0003\u0003S\tQ!\r\u00185]A\nQ\u0001\u001e:fKNDSaCA\u000e\u0003O\t1bZ3u\u001dVlGK]3fg\"*A\"a\u0007\u00024\u0005\u0012\u0011QG\u0001\u0006e9\u0002d\u0006M\u0001\rO\u0016$h*^7Ue\u0016,7\u000f\t\u0015\u0006\u001b\u0005m\u00111G\u0001\fiJ,WmV3jO\"$8\u000fK\u0003\u000f\u00037\t9#A\bue\u0006t7OZ8s[N\u001b\u0007.Z7b)\u0011\t\u0019%a\u0015\u0011\t\u0005\u0015\u0013qJ\u0007\u0003\u0003\u000fRA!!\u0013\u0002L\u0005)A/\u001f9fg*\u0019\u0011Q\n\u0019\u0002\u0007M\fH.\u0003\u0003\u0002R\u0005\u001d#AC*ueV\u001cG\u000fV=qK\"9\u0011QK\bA\u0002\u0005\r\u0013AB:dQ\u0016l\u0017\rK\u0003\u0010\u00037\t9#A\u0005ue\u0006t7OZ8s[R!\u0011QLA=!\u0011\ty&a\u001d\u000f\t\u0005\u0005\u0014\u0011\u000f\b\u0005\u0003G\nyG\u0004\u0003\u0002f\u00055d\u0002BA4\u0003Wr1\u0001WA5\u0013\u0005)\u0014BA\u001a5\u0013\t\t$'C\u0002\u0002NAJ1AXA&\u0013\u0011\t)(a\u001e\u0003\u0013\u0011\u000bG/\u0019$sC6,'b\u00010\u0002L!9\u00111\u0010\tA\u0002\u0005u\u0014a\u00023bi\u0006\u001cX\r\u001e\u0019\u0005\u0003\u007f\nY\t\u0005\u0004\u0002\u0002\u0006\r\u0015qQ\u0007\u0003\u0003\u0017JA!!\"\u0002L\t9A)\u0019;bg\u0016$\b\u0003BAE\u0003\u0017c\u0001\u0001\u0002\u0007\u0002\u000e\u0006e\u0014\u0011!A\u0001\u0006\u0003\tyIA\u0002`II\nB!!%\u0002\u0018B\u0019\u0011/a%\n\u0007\u0005UuLA\u0004O_RD\u0017N\\4\u0011\u0007E\fI*C\u0002\u0002\u001c~\u00131!\u00118z\u0003\u001d\u0001(/\u001a3jGR$2\u0001_AQ\u0011\u0019\t\u0019+\u0005a\u0001y\u0005Aa-Z1ukJ,7/\u0001\u0003d_BLHc\u0001\"\u0002*\"9\u00111\u0016\nA\u0002\u00055\u0016!B3yiJ\f\u0007\u0003BAX\u0003kk!!!-\u000b\u0007\u0005Mf&A\u0003qCJ\fW.\u0003\u0003\u00028\u0006E&\u0001\u0003)be\u0006lW*\u00199)\u000bI\tY\"a\n\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u001a\u0015\u0006'\u0005m\u0011qE\u0001\u0013M\u0016\fG/\u001e:f\u00136\u0004xN\u001d;b]\u000e,7/F\u0001=Q\u0015!\u00121DA\u001a\u0003\u0015!xn\u00147e+\t\tY\r\u0005\u0003\u0002N\u0006eWBAAh\u0015\u0011\t\t.a5\u0002\u000b5|G-\u001a7\u000b\u0007\u0019\u000b)NC\u0002\u0002XB\nQ!\u001c7mS\nLA!a7\u0002P\nIrI]1eS\u0016tGOQ8pgR,G\r\u0016:fKNlu\u000eZ3m\u0003U)g/\u00197vCR,W)Y2i\u0013R,'/\u0019;j_:$Ra^Aq\u0003[Dq!a\u001f\u0017\u0001\u0004\t\u0019\u000f\r\u0003\u0002f\u0006%\bCBAA\u0003\u0007\u000b9\u000f\u0005\u0003\u0002\n\u0006%H\u0001DAv\u0003C\f\t\u0011!A\u0003\u0002\u0005=%aA0%g!1\u0011q\u001e\fA\u0002\u0015\fA\u0001\\8tg\"*a#a\u0007\u0002t\u0006\u0012\u0011Q_\u0001\u0006e9\"d\u0006M\u0001\u0006oJLG/Z\u000b\u0003\u0003w\u00042\u0001UA\u007f\u0013\r\ty0\u0015\u0002\t\u001b2;&/\u001b;fe\"*q#a\u0007\u00024!*\u0001!a\u0007\u0002(\u0005\u0011rI\u0011+SK\u001e\u0014Xm]:j_:lu\u000eZ3m!\tI\u0014dE\u0004\u001a\u0005\u0017\u0011\tBa\u0006\u0011\u0007E\u0014i!C\u0002\u0003\u0010}\u0013a!\u00118z%\u00164\u0007\u0003\u0002)\u0003\u0014\tK1A!\u0006R\u0005)iEJU3bI\u0006\u0014G.\u001a\t\u0005\u00053\u0011\u0019#\u0004\u0002\u0003\u001c)!!Q\u0004B\u0010\u0003\tIwN\u0003\u0002\u0003\"\u0005!!.\u0019<b\u0013\r\t'1\u0004\u000b\u0003\u0005\u000f\tAA]3bIV\u0011!1\u0006\t\u0005!\n5\")C\u0002\u00030E\u0013\u0001\"\u0014'SK\u0006$WM\u001d\u0015\u00067\u0005m\u00111G\u0001\u0005Y>\fG\rF\u0002C\u0005oAaA!\u000f\u001d\u0001\u0004)\u0017\u0001\u00029bi\"DS\u0001HA\u000e\u0003g\u0011\u0001d\u0012\"U%\u0016<'/Z:tS>tWj\u001c3fY^\u0013\u0018\u000e^3s'\ri\u00121`\u0001\tS:\u001cH/\u00198dKR!!Q\tB%!\r\u00119%H\u0007\u00023!1!\u0011I\u0010A\u0002\t\u000b\u0001b]1wK&k\u0007\u000f\u001c\u000b\u0005\u0005\u001f\u0012)\u0006E\u0002r\u0005#J1Aa\u0015`\u0005\u0011)f.\u001b;\t\r\te\u0002\u00051\u0001f\u0005a9%\t\u0016*fOJ,7o]5p]6{G-\u001a7SK\u0006$WM]\n\u0004C\t-BC\u0001B/!\r\u00119%I\u0001\nG2\f7o\u001d(b[\u0016,\"Aa\u0019\u0011\t\t\u0015$1N\u0007\u0003\u0005ORAA!\u001b\u0003 \u0005!A.\u00198h\u0013\rY'qM\u0001\u000bG2\f7o\u001d(b[\u0016\u0004\u0013!\u0004;sK\u0016\u001cE.Y:t\u001d\u0006lW-\u0001\bue\u0016,7\t\\1tg:\u000bW.\u001a\u0011\u0015\u0007\t\u0013)\b\u0003\u0004\u0003:\u001d\u0002\r!Z\u0001\bMJ|Wn\u00147e)%\u0011%1\u0010B@\u0005\u0013\u0013\u0019\nC\u0004\u0003~!\u0002\r!a3\u0002\u0011=dG-T8eK2DqA!!)\u0001\u0004\u0011\u0019)\u0001\u0004qCJ,g\u000e\u001e\t\u0004s\t\u0015\u0015b\u0001BDY\taqI\u0011+SK\u001e\u0014Xm]:pe\"9!1\u0012\u0015A\u0002\t5\u0015aE2bi\u0016<wN]5dC24U-\u0019;ve\u0016\u001c\b#\u00024\u0003\u0010zt\u0018b\u0001BIY\n\u0019Q*\u00199\t\u000fqD\u0003\u0013!a\u0001}\u0006\tbM]8n\u001f2$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\te%f\u0001@\u0003\u001c.\u0012!Q\u0014\t\u0005\u0005?\u00139+\u0004\u0002\u0003\"*!!1\u0015BS\u0003%)hn\u00195fG.,GMC\u0002\u0002\"}KAA!+\u0003\"\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\t=\u0006\u0003\u0002B3\u0005cKAAa-\u0003h\t1qJ\u00196fGRDS!GA\u000e\u0003gAS\u0001GA\u000e\u0003g\u0001")
public class GBTRegressionModel
extends RegressionModel<Vector, GBTRegressionModel>
implements GBTRegressorParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final double[] _treeWeights;
    private final int numFeatures;
    private final int getNumTrees;
    private int totalNumNodes;
    private Param<String> lossType;
    private Param<String> impurity;
    private DoubleParam validationTol;
    private DoubleParam stepSize;
    private Param<String> validationIndicatorCol;
    private IntParam maxIter;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static GBTRegressionModel load(String path) {
        return GBTRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<GBTRegressionModel> read() {
        return GBTRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public String getLossType() {
        return GBTRegressorParams.getLossType$(this);
    }

    @Override
    public Loss getOldLossType() {
        return GBTRegressorParams.getOldLossType$(this);
    }

    @Override
    public Loss convertToOldLossType(String loss) {
        return GBTRegressorParams.convertToOldLossType$(this, loss);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$GBTParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final double getValidationTol() {
        return GBTParams.getValidationTol$(this);
    }

    @Override
    public BoostingStrategy getOldBoostingStrategy(Map<Object, Object> categoricalFeatures, Enumeration.Value oldAlgo) {
        return GBTParams.getOldBoostingStrategy$(this, categoricalFeatures, oldAlgo);
    }

    @Override
    public final String getValidationIndicatorCol() {
        return HasValidationIndicatorCol.getValidationIndicatorCol$(this);
    }

    @Override
    public final double getStepSize() {
        return HasStepSize.getStepSize$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public Param<String> lossType() {
        return this.lossType;
    }

    @Override
    public void org$apache$spark$ml$tree$GBTRegressorParams$_setter_$lossType_$eq(Param<String> x$1) {
        this.lossType = x$1;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final DoubleParam validationTol() {
        return this.validationTol;
    }

    @Override
    public final DoubleParam stepSize() {
        return this.stepSize;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$validationTol_$eq(DoubleParam x$1) {
        this.validationTol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$GBTParams$_setter_$stepSize_$eq(DoubleParam x$1) {
        this.stepSize = x$1;
    }

    @Override
    public final Param<String> validationIndicatorCol() {
        return this.validationIndicatorCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasValidationIndicatorCol$_setter_$validationIndicatorCol_$eq(Param<String> x$1) {
        this.validationIndicatorCol = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasStepSize$_setter_$stepSize_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    private double[] _treeWeights() {
        return this._treeWeights;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    public int getNumTrees() {
        return this.getNumTrees;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StructType transformSchema(StructType schema) {
        void var2_2;
        block0: {
            StructType outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return var2_2;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        Dataset dataset2;
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)scala.package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)scala.package$.MODULE$.Seq().empty();
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(GBTRegressionModel.class));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1(GBTRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$transform$1(bcastModel, features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.featuresCol()), outputSchema.apply(this.$(this.featuresCol())).metadata()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(GBTRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1(GBTRegressionModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1(GBTRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> ((TreeEnsembleModel)bcastModel.value()).predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_GBTRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            dataset2 = dataset.withColumns(predictionColNames, predictionColumns);
        } else {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(36).append(new StringBuilder(45).append(this.uid()).append(": GBTRegressionModel.transform() does nothing").toString()).append(" because no output columns were set.").toString());
            dataset2 = dataset.toDF();
        }
        return dataset2;
    }

    @Override
    public double predict(Vector features) {
        double[] treePredictions = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)GBTRegressionModel.$anonfun$predict$1(features, x$4)), (ClassTag)ClassTag$.MODULE$.Double());
        return BLAS$.MODULE$.nativeBLAS().ddot(this.getNumTrees(), treePredictions, 1, this._treeWeights(), 1);
    }

    @Override
    public GBTRegressionModel copy(ParamMap extra) {
        return (GBTRegressionModel)((Model)this.copyValues(new GBTRegressionModel(this.uid(), this._trees(), this._treeWeights(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringBuilder(49).append("GBTRegressionModel: uid=").append(this.uid()).append(", numTrees=").append(this.getNumTrees()).append(", numFeatures=").append(this.numFeatures()).toString();
    }

    private Vector featureImportances$lzycompute() {
        GBTRegressionModel gBTRegressionModel = this;
        synchronized (gBTRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), false);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public GradientBoostedTreesModel toOld() {
        return new GradientBoostedTreesModel(Algo$.MODULE$.Regression(), (DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$5 -> x$5.toOld(), ClassTag$.MODULE$.apply(DecisionTreeModel.class)), this._treeWeights());
    }

    public double[] evaluateEachIteration(Dataset<?> dataset, String loss) {
        RDD<Instance> data = this.extractInstances(dataset);
        return GradientBoostedTrees$.MODULE$.evaluateEachIteration(data, this.trees(), this.treeWeights(), this.convertToOldLossType(loss), Algo$.MODULE$.Regression());
    }

    @Override
    public MLWriter write() {
        return new GBTRegressionModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transform$1(Broadcast bcastModel$1, Vector features) {
        return ((GBTRegressionModel)bcastModel$1.value()).predict(features);
    }

    public static final /* synthetic */ double $anonfun$predict$1(Vector features$1, DecisionTreeRegressionModel x$4) {
        return x$4.rootNode().predictImpl(features$1).prediction();
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights, int numFeatures) {
        this.uid = uid;
        this._trees = _trees;
        this._treeWeights = _treeWeights;
        this.numFeatures = numFeatures;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        HasMaxIter.$init$(this);
        HasStepSize.$init$(this);
        HasValidationIndicatorCol.$init$(this);
        GBTParams.$init$(this);
        TreeEnsembleRegressorParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        GBTRegressorParams.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "GBTRegressionModel requires at least 1 tree.");
        Predef$.MODULE$.require(_trees.length == _treeWeights.length, (Function0 & Serializable)() -> new StringBuilder(46).append("GBTRegressionModel given trees, treeWeights of").append(new StringBuilder(41).append(" non-matching lengths (").append(this._trees().length).append(", ").append(this._treeWeights().length).append(", respectively).").toString()).toString());
        this.getNumTrees = this.trees().length;
        Statics.releaseFence();
    }

    public GBTRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, double[] _treeWeights) {
        this(uid, _trees, _treeWeights, -1);
    }

    private static class GBTRegressionModelReader
    extends MLReader<GBTRegressionModel> {
        private final String className = GBTRegressionModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public GBTRegressionModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            Tuple3 tuple32 = tuple3;
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple32._1();
            Tuple2[] treesData = (Tuple2[])tuple32._2();
            double[] treeWeights2 = (double[])tuple32._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numFeatures")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)org.json4s.package$.MODULE$.jvalue2extractable(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()).$bslash("numTrees")).extract((Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                Node root = (Node)tuple2._2();
                DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                DecisionTreeRegressionModel decisionTreeRegressionModel = tree;
                return decisionTreeRegressionModel;
            }, ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(33).append("GBTRegressionModel.load expected ").append(numTrees).toString()).append(new StringBuilder(42).append(" trees based on metadata but found ").append(trees.length).append(" trees.").toString()).toString());
            GBTRegressionModel model = new GBTRegressionModel(metadata3.uid(), trees, treeWeights2, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class GBTRegressionModelWriter
    extends MLWriter {
        private final GBTRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            JsonAST.JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public GBTRegressionModelWriter(GBTRegressionModel instance) {
            this.instance = instance;
        }
    }
}

