/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Date;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateTimeFormatterHelper;
import org.apache.spark.sql.catalyst.util.Iso8601TimestampFormatter$;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.TimestampFormatter;
import org.apache.spark.sql.catalyst.util.TimestampFormatter$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.TimestampNTZType$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005g\u0001B\r\u001b\u0001\u001dB\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005\u0005\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003R\u0011!!\u0007A!A!\u0002\u0013)\u0007\"\u00025\u0001\t\u0003I\u0007\u0002\u00039\u0001\u0011\u000b\u0007I\u0011C9\t\u0011q\u0004\u0001R1A\u0005\u0012uDaa \u0001\u0005B\u0005\u0005\u0001bBA\n\u0001\u0011%\u0011Q\u0003\u0005\b\u0003O\u0001A\u0011IA\u0015\u0011\u001d\ti\u0003\u0001C!\u0003_Aq!a\u000e\u0001\t\u0013\tI\u0004C\u0004\u0002B\u0001!\t%a\u0011\t\rU\u0004A\u0011IA%\u0011\u0019)\b\u0001\"\u0011\u0002V!1Q\u000f\u0001C!\u00037Ba!\u001e\u0001\u0005B\u0005-\u0004bBA<\u0001\u0011\u0005\u0013\u0011P\u0004\n\u0003\u000bS\u0012\u0011!E\u0001\u0003\u000f3\u0001\"\u0007\u000e\u0002\u0002#\u0005\u0011\u0011\u0012\u0005\u0007QV!\t!a&\t\u0013\u0005eU#%A\u0005\u0002\u0005m\u0005\"CAY+\u0005\u0005I\u0011BAZ\u0005eI5o\u001c\u001d7aE\"\u0016.\\3ti\u0006l\u0007OR8s[\u0006$H/\u001a:\u000b\u0005ma\u0012\u0001B;uS2T!!\b\u0010\u0002\u0011\r\fG/\u00197zgRT!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0015/eA\u0011\u0011\u0006L\u0007\u0002U)\t1&A\u0003tG\u0006d\u0017-\u0003\u0002.U\t1\u0011I\\=SK\u001a\u0004\"a\f\u0019\u000e\u0003iI!!\r\u000e\u0003%QKW.Z:uC6\u0004hi\u001c:nCR$XM\u001d\t\u0003_MJ!\u0001\u000e\u000e\u0003/\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000fS3ma\u0016\u0014\u0018a\u00029biR,'O\u001c\t\u0003oyr!\u0001\u000f\u001f\u0011\u0005eRS\"\u0001\u001e\u000b\u0005m2\u0013A\u0002\u001fs_>$h(\u0003\u0002>U\u00051\u0001K]3eK\u001aL!a\u0010!\u0003\rM#(/\u001b8h\u0015\ti$&\u0001\u0004{_:,\u0017\n\u001a\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bA\u0001^5nK*\tq)\u0001\u0003kCZ\f\u0017BA%E\u0005\u0019QvN\\3JI\u00061An\\2bY\u0016\u0004\"\u0001\u0014(\u000e\u00035S!a\u0007$\n\u0005=k%A\u0002'pG\u0006dW-\u0001\u0007mK\u001e\f7-\u001f$pe6\fG\u000f\u0005\u0002SC:\u00111k\u0018\b\u0003)zs!!V/\u000f\u0005YcfBA,\\\u001d\tA&L\u0004\u0002:3&\tQ%\u0003\u0002$I%\u0011\u0011EI\u0005\u0003?\u0001J!!\b\u0010\n\u0005ma\u0012B\u00011\u001b\u0003EaUmZ1ds\u0012\u000bG/\u001a$pe6\fGo]\u0005\u0003E\u000e\u0014\u0001\u0003T3hC\u000eLH)\u0019;f\r>\u0014X.\u0019;\u000b\u0005\u0001T\u0012!C5t!\u0006\u00148/\u001b8h!\tIc-\u0003\u0002hU\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0004kW2lgn\u001c\t\u0003_\u0001AQ!\u000e\u0004A\u0002YBQ!\u0011\u0004A\u0002\tCQA\u0013\u0004A\u0002-Cq\u0001\u0015\u0004\u0011\u0002\u0003\u0007\u0011\u000bC\u0003e\r\u0001\u0007Q-A\u0005g_Jl\u0017\r\u001e;feV\t!\u000f\u0005\u0002tm6\tAO\u0003\u0002v\t\u00061am\u001c:nCRL!a\u001e;\u0003#\u0011\u000bG/\u001a+j[\u00164uN]7biR,'\u000f\u000b\u0002\bsB\u0011\u0011F_\u0005\u0003w*\u0012\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001f1,w-Y2z\r>\u0014X.\u0019;uKJ,\u0012A\f\u0015\u0003\u0011e\fQ\u0002]1sg\u0016|\u0005\u000f^5p]\u0006dG\u0003BA\u0002\u0003\u001f\u0001R!KA\u0003\u0003\u0013I1!a\u0002+\u0005\u0019y\u0005\u000f^5p]B\u0019\u0011&a\u0003\n\u0007\u00055!F\u0001\u0003M_:<\u0007BBA\t\u0013\u0001\u0007a'A\u0001t\u00035)\u0007\u0010\u001e:bGRl\u0015n\u0019:pgR!\u0011\u0011BA\f\u0011\u001d\tIB\u0003a\u0001\u00037\ta\u0001]1sg\u0016$\u0007\u0003BA\u000f\u0003Gi!!a\b\u000b\u0007\u0005\u0005B)\u0001\u0005uK6\u0004xN]1m\u0013\u0011\t)#a\b\u0003!Q+W\u000e]8sC2\f5mY3tg>\u0014\u0018!\u00029beN,G\u0003BA\u0005\u0003WAa!!\u0005\f\u0001\u00041\u0014\u0001\b9beN,w+\u001b;i_V$H+[7f5>tWm\u00149uS>t\u0017\r\u001c\u000b\u0007\u0003\u0007\t\t$a\r\t\r\u0005EA\u00021\u00017\u0011\u0019\t)\u0004\u0004a\u0001K\u0006i\u0011\r\u001c7poRKW.\u001a.p]\u0016\f\u0001#\u001a=ue\u0006\u001cG/T5de>\u001ch\n\u0016.\u0015\u0011\u0005%\u00111HA\u001f\u0003\u007fAa!!\u0005\u000e\u0001\u00041\u0004bBA\r\u001b\u0001\u0007\u00111\u0004\u0005\u0007\u0003ki\u0001\u0019A3\u0002)A\f'o]3XSRDw.\u001e;US6,'l\u001c8f)\u0019\tI!!\u0012\u0002H!1\u0011\u0011\u0003\bA\u0002YBa!!\u000e\u000f\u0001\u0004)Gc\u0001\u001c\u0002L!9\u0011QJ\bA\u0002\u0005=\u0013aB5ogR\fg\u000e\u001e\t\u0004\u0007\u0006E\u0013bAA*\t\n9\u0011J\\:uC:$Hc\u0001\u001c\u0002X!9\u0011\u0011\f\tA\u0002\u0005%\u0011AA;t)\r1\u0014Q\f\u0005\b\u0003?\n\u0002\u0019AA1\u0003\t!8\u000f\u0005\u0003\u0002d\u0005\u001dTBAA3\u0015\tyb)\u0003\u0003\u0002j\u0005\u0015$!\u0003+j[\u0016\u001cH/Y7q)\r1\u0014Q\u000e\u0005\b\u0003_\u0012\u0002\u0019AA9\u00035awnY1m\t\u0006$X\rV5nKB\u00191)a\u001d\n\u0007\u0005UDIA\u0007M_\u000e\fG\u000eR1uKRKW.Z\u0001\u0016m\u0006d\u0017\u000eZ1uKB\u000bG\u000f^3s]N#(/\u001b8h)\u0011\tY(!!\u0011\u0007%\ni(C\u0002\u0002\u0000)\u0012A!\u00168ji\"1\u00111Q\nA\u0002\u0015\f1b\u00195fG.dUmZ1ds\u0006I\u0012j]89mA\nD+[7fgR\fW\u000e\u001d$pe6\fG\u000f^3s!\tySc\u0005\u0003\u0016Q\u0005-\u0005\u0003BAG\u0003'k!!a$\u000b\u0007\u0005Ee)\u0001\u0002j_&!\u0011QSAH\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\t9)A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003;S3!UAPW\t\t\t\u000b\u0005\u0003\u0002$\u00065VBAAS\u0015\u0011\t9+!+\u0002\u0013Ut7\r[3dW\u0016$'bAAVU\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0016Q\u0015\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001D<sSR,'+\u001a9mC\u000e,GCAA[!\u0011\t9,!0\u000e\u0005\u0005e&bAA^\r\u0006!A.\u00198h\u0013\u0011\ty,!/\u0003\r=\u0013'.Z2u\u0001")
public class Iso8601TimestampFormatter
implements TimestampFormatter,
DateTimeFormatterHelper {
    private transient DateTimeFormatter formatter;
    private transient TimestampFormatter legacyFormatter;
    private final String pattern;
    private final ZoneId zoneId;
    private final Locale locale;
    private final Enumeration.Value legacyFormat;
    private final boolean isParsing;
    private volatile transient byte bitmap$trans$0;

    public static Enumeration.Value $lessinit$greater$default$4() {
        return Iso8601TimestampFormatter$.MODULE$.$lessinit$greater$default$4();
    }

    @Override
    public LocalDate toLocalDate(TemporalAccessor accessor) {
        return DateTimeFormatterHelper.toLocalDate$(this, accessor);
    }

    @Override
    public LocalTime toLocalTime(TemporalAccessor accessor) {
        return DateTimeFormatterHelper.toLocalTime$(this, accessor);
    }

    @Override
    public ZonedDateTime toZonedDateTime(TemporalAccessor accessor, ZoneId zoneId) {
        return DateTimeFormatterHelper.toZonedDateTime$(this, accessor, zoneId);
    }

    @Override
    public DateTimeFormatter getOrCreateFormatter(String pattern, Locale locale, boolean isParsing) {
        return DateTimeFormatterHelper.getOrCreateFormatter$(this, pattern, locale, isParsing);
    }

    @Override
    public <T> PartialFunction<Throwable, T> checkParsedDiff(String s, Function1<String, T> legacyParseFunc) {
        return DateTimeFormatterHelper.checkParsedDiff$(this, s, legacyParseFunc);
    }

    @Override
    public <T extends Date> PartialFunction<Throwable, String> checkFormattedDiff(T d, Function1<T, String> legacyFormatFunc) {
        return DateTimeFormatterHelper.checkFormattedDiff$(this, d, legacyFormatFunc);
    }

    @Override
    public PartialFunction<Throwable, DateTimeFormatter> checkLegacyFormatter(String pattern, Function0<BoxedUnit> tryLegacyFormatter) {
        return DateTimeFormatterHelper.checkLegacyFormatter$(this, pattern, tryLegacyFormatter);
    }

    @Override
    public PartialFunction<Throwable, Nothing$> checkInvalidPattern(String pattern) {
        return DateTimeFormatterHelper.checkInvalidPattern$(this, pattern);
    }

    @Override
    public final long parseWithoutTimeZone(String s) throws ParseException, DateTimeParseException, DateTimeException, IllegalStateException {
        return TimestampFormatter.parseWithoutTimeZone$(this, s);
    }

    private DateTimeFormatter formatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.formatter = this.getOrCreateFormatter(this.pattern, this.locale, this.isParsing);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.formatter;
    }

    public DateTimeFormatter formatter() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.formatter$lzycompute() : this.formatter;
    }

    private TimestampFormatter legacyFormatter$lzycompute() {
        Iso8601TimestampFormatter iso8601TimestampFormatter = this;
        synchronized (iso8601TimestampFormatter) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.legacyFormatter = TimestampFormatter$.MODULE$.getLegacyFormatter(this.pattern, this.zoneId, this.locale, this.legacyFormat);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.legacyFormatter;
    }

    public TimestampFormatter legacyFormatter() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.legacyFormatter$lzycompute() : this.legacyFormatter;
    }

    @Override
    public Option<Object> parseOptional(String s) {
        None$ none$;
        block4: {
            try {
                TemporalAccessor parsed = this.formatter().parseUnresolved(s, new ParsePosition(0));
                if (parsed != null) {
                    none$ = new Some((Object)BoxesRunTime.boxToLong((long)this.extractMicros(parsed)));
                    break block4;
                }
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                None$ none$2 = None$.MODULE$;
                none$ = none$2;
            }
        }
        return none$;
    }

    private long extractMicros(TemporalAccessor parsed) {
        ZoneId parsedZoneId = parsed.query(TemporalQueries.zone());
        ZoneId timeZoneId = parsedZoneId == null ? this.zoneId : parsedZoneId;
        ZonedDateTime zonedDateTime = this.toZonedDateTime(parsed, timeZoneId);
        long epochSeconds = zonedDateTime.toEpochSecond();
        int microsOfSecond = zonedDateTime.get(ChronoField.MICRO_OF_SECOND);
        return Math.addExact(Math.multiplyExact(epochSeconds, 1000000L), (long)microsOfSecond);
    }

    @Override
    public long parse(String s2) {
        long l;
        try {
            TemporalAccessor parsed = this.formatter().parse(s2);
            l = this.extractMicros(parsed);
        }
        catch (Throwable x$3) {
            PartialFunction catchExpr$1 = this.checkParsedDiff(s2, (Function1 & Serializable)s -> BoxesRunTime.boxToLong((long)Iso8601TimestampFormatter.$anonfun$parse$1(this, s)));
            if (catchExpr$1.isDefinedAt((Object)x$3)) {
                l = BoxesRunTime.unboxToLong((Object)catchExpr$1.apply((Object)x$3));
            }
            throw x$3;
        }
        return l;
    }

    @Override
    public Option<Object> parseWithoutTimeZoneOptional(String s, boolean allowTimeZone) {
        None$ none$;
        block4: {
            try {
                TemporalAccessor parsed = this.formatter().parseUnresolved(s, new ParsePosition(0));
                if (parsed != null) {
                    none$ = new Some((Object)BoxesRunTime.boxToLong((long)this.extractMicrosNTZ(s, parsed, allowTimeZone)));
                    break block4;
                }
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                None$ none$2 = None$.MODULE$;
                none$ = none$2;
            }
        }
        return none$;
    }

    private long extractMicrosNTZ(String s, TemporalAccessor parsed, boolean allowTimeZone) {
        if (!allowTimeZone && parsed.query(TemporalQueries.zone()) != null) {
            throw ExecutionErrors$.MODULE$.cannotParseStringAsDataTypeError(this.pattern, s, TimestampNTZType$.MODULE$);
        }
        LocalDate localDate = this.toLocalDate(parsed);
        LocalTime localTime = this.toLocalTime(parsed);
        return SparkDateTimeUtils$.MODULE$.localDateTimeToMicros(LocalDateTime.of(localDate, localTime));
    }

    @Override
    public long parseWithoutTimeZone(String s2, boolean allowTimeZone) {
        long l;
        try {
            TemporalAccessor parsed = this.formatter().parse(s2);
            l = this.extractMicrosNTZ(s2, parsed, allowTimeZone);
        }
        catch (Throwable x$4) {
            PartialFunction catchExpr$2 = this.checkParsedDiff(s2, (Function1 & Serializable)s -> BoxesRunTime.boxToLong((long)Iso8601TimestampFormatter.$anonfun$parseWithoutTimeZone$1(this, s)));
            if (catchExpr$2.isDefinedAt((Object)x$4)) {
                l = BoxesRunTime.unboxToLong((Object)catchExpr$2.apply((Object)x$4));
            }
            throw x$4;
        }
        return l;
    }

    @Override
    public String format(Instant instant) {
        String string;
        try {
            string = this.formatter().withZone(this.zoneId).format(instant);
        }
        catch (Throwable x$5) {
            PartialFunction<Throwable, String> catchExpr$3 = this.checkFormattedDiff(SparkDateTimeUtils$.MODULE$.toJavaTimestamp(SparkDateTimeUtils$.MODULE$.instantToMicros(instant)), (Function1 & Serializable)t -> this.format((Timestamp)t));
            if (catchExpr$3.isDefinedAt((Object)x$5)) {
                string = (String)catchExpr$3.apply((Object)x$5);
            }
            throw x$5;
        }
        return string;
    }

    @Override
    public String format(long us) {
        Instant instant = SparkDateTimeUtils$.MODULE$.microsToInstant(us);
        return this.format(instant);
    }

    @Override
    public String format(Timestamp ts) {
        return this.legacyFormatter().format(ts);
    }

    @Override
    public String format(LocalDateTime localDateTime) {
        return localDateTime.format(this.formatter());
    }

    @Override
    public void validatePatternString(boolean checkLegacy) {
        if (checkLegacy) {
            Object object;
            try {
                object = this.formatter();
            }
            catch (Throwable x$6) {
                PartialFunction<Throwable, DateTimeFormatter> catchExpr$4 = this.checkLegacyFormatter(this.pattern, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.legacyFormatter().validatePatternString(true));
                if (catchExpr$4.isDefinedAt((Object)x$6)) {
                    object = catchExpr$4.apply((Object)x$6);
                }
                throw x$6;
            }
        } else {
            try {
                this.formatter();
            }
            catch (Throwable x$7) {
                PartialFunction<Throwable, Nothing$> catchExpr$5 = this.checkInvalidPattern(this.pattern);
                if (catchExpr$5.isDefinedAt((Object)x$7)) {
                    catchExpr$5.apply((Object)x$7);
                }
                throw x$7;
            }
        }
    }

    public static final /* synthetic */ long $anonfun$parse$1(Iso8601TimestampFormatter $this, String s) {
        return $this.legacyFormatter().parse(s);
    }

    public static final /* synthetic */ long $anonfun$parseWithoutTimeZone$1(Iso8601TimestampFormatter $this, String s) {
        return $this.legacyFormatter().parse(s);
    }

    public Iso8601TimestampFormatter(String pattern, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        this.pattern = pattern;
        this.zoneId = zoneId;
        this.locale = locale;
        this.legacyFormat = legacyFormat;
        this.isParsing = isParsing;
        TimestampFormatter.$init$(this);
        DateTimeFormatterHelper.$init$(this);
    }
}

