/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.window;

import java.util.ArrayDeque;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.ExternalAppendOnlyUnsafeRowArray;
import org.apache.spark.sql.execution.window.AggregateProcessor;
import org.apache.spark.sql.execution.window.BoundOrdering;
import org.apache.spark.sql.execution.window.WindowFunctionFrame;
import org.apache.spark.sql.execution.window.WindowFunctionFrame$;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4QAD\b\u0003\u001fmA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015\t\u0004\u0001\"\u00013\u0011\u0019A\u0004\u0001)Q\u0005s!IQ\b\u0001a\u0001\u0002\u0003\u0006KA\u0010\u0005\u0007%\u0002\u0001\u000b\u0015\u0002\u0012\t\rM\u0003\u0001\u0015!\u0003U\u0011\u0019a\u0006\u0001)Q\u0005;\"1\u0011\r\u0001Q!\nuCQA\u0019\u0001\u0005B\rDQ!\u001b\u0001\u0005B)\u0014!d\u00157jI&twmV5oI><h)\u001e8di&|gN\u0012:b[\u0016T!\u0001E\t\u0002\r]Lg\u000eZ8x\u0015\t\u00112#A\u0005fq\u0016\u001cW\u000f^5p]*\u0011A#F\u0001\u0004gFd'B\u0001\f\u0018\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0012$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u00025\u0005\u0019qN]4\u0014\u0005\u0001a\u0002CA\u000f\u001f\u001b\u0005y\u0011BA\u0010\u0010\u0005M9\u0016N\u001c3po\u001a+hn\u0019;j_:4%/Y7f\u0003\u0019!\u0018M]4fi\u000e\u0001\u0001CA\u0012'\u001b\u0005!#BA\u0013\u0014\u0003!\u0019\u0017\r^1msN$\u0018BA\u0014%\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u0013A\u0014xnY3tg>\u0014\bCA\u000f+\u0013\tYsB\u0001\nBO\u001e\u0014XmZ1uKB\u0013xnY3tg>\u0014\u0018A\u00027c_VtG\r\u0005\u0002\u001e]%\u0011qf\u0004\u0002\u000e\u0005>,h\u000eZ(sI\u0016\u0014\u0018N\\4\u0002\rU\u0014w.\u001e8e\u0003\u0019a\u0014N\\5u}Q)1\u0007N\u001b7oA\u0011Q\u0004\u0001\u0005\u0006A\u0015\u0001\rA\t\u0005\u0006Q\u0015\u0001\r!\u000b\u0005\u0006Y\u0015\u0001\r!\f\u0005\u0006a\u0015\u0001\r!L\u0001\u0006S:\u0004X\u000f\u001e\t\u0003umj\u0011!E\u0005\u0003yE\u0011\u0001%\u0012=uKJt\u0017\r\\!qa\u0016tGm\u00148msVs7/\u00194f%><\u0018I\u001d:bs\u0006i\u0011N\u001c9vi&#XM]1u_J\u00042aP%M\u001d\t\u0001eI\u0004\u0002B\t6\t!I\u0003\u0002DC\u00051AH]8pizJ\u0011!R\u0001\u0006g\u000e\fG.Y\u0005\u0003\u000f\"\u000bq\u0001]1dW\u0006<WMC\u0001F\u0013\tQ5J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t9\u0005\n\u0005\u0002N!6\taJ\u0003\u0002PI\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\t\tfJA\u0005V]N\fg-\u001a*po\u00069a.\u001a=u%><\u0018A\u00022vM\u001a,'\u000fE\u0002V5\nj\u0011A\u0016\u0006\u0003/b\u000bA!\u001e;jY*\t\u0011,\u0001\u0003kCZ\f\u0017BA.W\u0005)\t%O]1z\t\u0016\fX/Z\u0001\u000fS:\u0004X\u000f\u001e%jO\"Le\u000eZ3y!\tqv,D\u0001I\u0013\t\u0001\u0007JA\u0002J]R\fQ\"\u001b8qkRdun^%oI\u0016D\u0018a\u00029sKB\f'/\u001a\u000b\u0003I\u001e\u0004\"AX3\n\u0005\u0019D%\u0001B+oSRDQ\u0001\u001b\u0007A\u0002e\nAA]8xg\u0006)qO]5uKR\u0019Am[7\t\u000b1l\u0001\u0019A/\u0002\u000b%tG-\u001a=\t\u000b9l\u0001\u0019\u0001\u0012\u0002\u000f\r,(O]3oi\u0002")
public final class SlidingWindowFunctionFrame
extends WindowFunctionFrame {
    private final InternalRow target;
    private final AggregateProcessor processor;
    private final BoundOrdering lbound;
    private final BoundOrdering ubound;
    private ExternalAppendOnlyUnsafeRowArray input;
    private Iterator<UnsafeRow> inputIterator;
    private InternalRow nextRow;
    private final ArrayDeque<InternalRow> buffer;
    private int inputHighIndex;
    private int inputLowIndex;

    @Override
    public void prepare(ExternalAppendOnlyUnsafeRowArray rows) {
        this.input = rows;
        this.inputIterator = this.input.generateIterator();
        this.nextRow = WindowFunctionFrame$.MODULE$.getNextOrNull(this.inputIterator);
        this.inputHighIndex = 0;
        this.inputLowIndex = 0;
        this.buffer.clear();
    }

    @Override
    public void write(int index, InternalRow current) {
        block5: {
            boolean bufferUpdated;
            boolean bl = bufferUpdated = index == 0;
            while (!this.buffer.isEmpty() && this.lbound.compare(this.buffer.peek(), this.inputLowIndex, current, index) < 0) {
                this.buffer.remove();
                ++this.inputLowIndex;
                bufferUpdated = true;
            }
            while (this.nextRow != null && this.ubound.compare(this.nextRow, this.inputHighIndex, current, index) <= 0) {
                if (this.lbound.compare(this.nextRow, this.inputLowIndex, current, index) < 0) {
                    ++this.inputLowIndex;
                } else {
                    this.buffer.add(this.nextRow.copy());
                    bufferUpdated = true;
                }
                this.nextRow = WindowFunctionFrame$.MODULE$.getNextOrNull(this.inputIterator);
                ++this.inputHighIndex;
            }
            if (!bufferUpdated) break block5;
            this.processor.initialize(this.input.length());
            java.util.Iterator<InternalRow> iter = this.buffer.iterator();
            while (iter.hasNext()) {
                this.processor.update(iter.next());
            }
            this.processor.evaluate(this.target);
        }
    }

    public SlidingWindowFunctionFrame(InternalRow target, AggregateProcessor processor, BoundOrdering lbound, BoundOrdering ubound) {
        this.target = target;
        this.processor = processor;
        this.lbound = lbound;
        this.ubound = ubound;
        this.input = null;
        this.nextRow = null;
        this.buffer = new ArrayDeque();
        this.inputHighIndex = 0;
        this.inputLowIndex = 0;
    }
}

