/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.internal;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Catalog;
import org.apache.spark.sql.catalog.Column;
import org.apache.spark.sql.catalog.Database;
import org.apache.spark.sql.catalog.Function;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.DefinedByConstructorParams;
import org.apache.spark.sql.catalyst.FunctionIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogDatabase;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.ExpressionInfo;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.View;
import org.apache.spark.sql.catalyst.util.CharVarcharUtils$;
import org.apache.spark.sql.execution.CachedData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand;
import org.apache.spark.sql.execution.command.AlterTableRecoverPartitionsCommand$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.internal.CatalogImpl$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015b\u0001B\u001a5\u0001}B\u0001B\u0012\u0001\u0003\u0002\u0003\u0006Ia\u0012\u0005\u0006\u0017\u0002!\t\u0001\u0014\u0005\u0006!\u0002!I!\u0015\u0005\u00063\u0002!IA\u0017\u0005\u0006]\u0002!Ia\u001c\u0005\u0006g\u0002!\t\u0005\u001e\u0005\u0006k\u0002!\tE\u001e\u0005\b\u0003\u0007\u0001A\u0011IA\u0003\u0011\u001d\t\u0019\u0002\u0001C\u0005\u0003+Aq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002\u001a\u0001!\t%!\n\t\u000f\u0005-\u0002\u0001\"\u0003\u0002.!9\u00111\b\u0001\u0005B\u0005u\u0002bBA\u001e\u0001\u0011\u0005\u0013q\t\u0005\b\u0003\u001b\u0002A\u0011BA(\u0011\u001d\tY\u0006\u0001C!\u0003;Bq!a\u0017\u0001\t\u0003\ny\u0007C\u0004\u0002\\\u0001!I!a\u001f\t\u000f\u0005\u0005\u0005\u0001\"\u0011\u0002\u0004\"9\u0011q\u0011\u0001\u0005B\u0005%\u0005bBAD\u0001\u0011\u0005\u0013Q\u0012\u0005\b\u0003'\u0003A\u0011IAK\u0011\u001d\t\u0019\n\u0001C!\u00037Cq!!)\u0001\t\u0003\n\u0019\u000bC\u0004\u0002.\u0002!\t%a,\t\u000f\u00055\u0006\u0001\"\u0011\u00024\"9\u0011\u0011\u0018\u0001\u0005B\u0005m\u0006bBA]\u0001\u0011\u0005\u0013q\u0018\u0005\b\u0003\u000b\u0004A\u0011IAd\u0011\u001d\t)\r\u0001C!\u0003[Dq!!2\u0001\t\u0003\n9\u0010C\u0004\u0002F\u0002!\tEa\u0002\t\u000f\u0005\u0015\u0007\u0001\"\u0011\u0003\u0014!9\u0011Q\u0019\u0001\u0005B\t-\u0002b\u0002B\u001c\u0001\u0011\u0005#\u0011\b\u0005\b\u0005\u007f\u0001A\u0011\tB!\u0011\u001d\u0011)\u0005\u0001C\u0005\u0005\u000fBqA!\u0018\u0001\t\u0003\u0012y\u0006C\u0004\u0003d\u0001!\tE!\u001a\t\u000f\t%\u0004\u0001\"\u0011\u0003l!9!\u0011\u000e\u0001\u0005B\t=\u0004b\u0002BB\u0001\u0011\u0005#Q\u0011\u0005\b\u0005\u0013\u0003A\u0011\tBF\u0011!\u0011\u0019\u0007\u0001C\tm\t5\u0005b\u0002BW\u0001\u0011\u0005#q\u0016\u0005\b\u0005g\u0003A\u0011\tB[\u000f!\u0011Y\f\u000eE\u0001m\tufaB\u001a5\u0011\u00031$q\u0018\u0005\u0007\u0017B\"\tAa2\t\u000f\t%\u0007\u0007\"\u0001\u0003L\nY1)\u0019;bY><\u0017*\u001c9m\u0015\t)d'\u0001\u0005j]R,'O\\1m\u0015\t9\u0004(A\u0002tc2T!!\u000f\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005mb\u0014AB1qC\u000eDWMC\u0001>\u0003\ry'oZ\u0002\u0001'\t\u0001\u0001\t\u0005\u0002B\t6\t!I\u0003\u0002Dm\u000591-\u0019;bY><\u0017BA#C\u0005\u001d\u0019\u0015\r^1m_\u001e\fAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001S%\u000e\u0003YJ!A\u0013\u001c\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)\tiu\n\u0005\u0002O\u00015\tA\u0007C\u0003G\u0005\u0001\u0007q)\u0001\btKN\u001c\u0018n\u001c8DCR\fGn\\4\u0016\u0003I\u0003\"aU,\u000e\u0003QS!aQ+\u000b\u0005Y3\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\u0005a#&AD*fgNLwN\\\"bi\u0006dwnZ\u0001\u0016e\u0016\fX/\u001b:f\t\u0006$\u0018MY1tK\u0016C\u0018n\u001d;t)\tY\u0016\r\u0005\u0002]?6\tQLC\u0001_\u0003\u0015\u00198-\u00197b\u0013\t\u0001WL\u0001\u0003V]&$\b\"\u00022\u0005\u0001\u0004\u0019\u0017A\u00023c\u001d\u0006lW\r\u0005\u0002eW:\u0011Q-\u001b\t\u0003Mvk\u0011a\u001a\u0006\u0003Qz\na\u0001\u0010:p_Rt\u0014B\u00016^\u0003\u0019\u0001&/\u001a3fM&\u0011A.\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005)l\u0016A\u0005:fcVL'/\u001a+bE2,W\t_5tiN$2a\u00179r\u0011\u0015\u0011W\u00011\u0001d\u0011\u0015\u0011X\u00011\u0001d\u0003%!\u0018M\u00197f\u001d\u0006lW-A\bdkJ\u0014XM\u001c;ECR\f'-Y:f+\u0005\u0019\u0017AE:fi\u000e+(O]3oi\u0012\u000bG/\u00192bg\u0016$\"aW<\t\u000b\t<\u0001\u0019A2)\u0007\u001dIx\u0010E\u0002]urL!a_/\u0003\rQD'o\\<t!\tAU0\u0003\u0002\u007fm\t\t\u0012I\\1msNL7/\u0012=dKB$\u0018n\u001c8\"\u0005\u0005\u0005\u0011a\u00063bi\u0006\u0014\u0017m]3!I>,7\u000f\t8pi\u0002*\u00070[:u\u00035a\u0017n\u001d;ECR\f'-Y:fgR\u0011\u0011q\u0001\t\u0006\u0011\u0006%\u0011QB\u0005\u0004\u0003\u00171$a\u0002#bi\u0006\u001cX\r\u001e\t\u0004\u0003\u0006=\u0011bAA\t\u0005\nAA)\u0019;bE\u0006\u001cX-\u0001\u0007nC.,G)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002\u000e\u0005]\u0001\"\u00022\n\u0001\u0004\u0019\u0017A\u00037jgR$\u0016M\u00197fgR\u0011\u0011Q\u0004\t\u0006\u0011\u0006%\u0011q\u0004\t\u0004\u0003\u0006\u0005\u0012bAA\u0012\u0005\n)A+\u00192mKR!\u0011QDA\u0014\u0011\u0015\u00117\u00021\u0001dQ\rY\u0011p`\u0001\n[\u0006\\W\rV1cY\u0016$B!a\b\u00020!9\u0011\u0011\u0007\u0007A\u0002\u0005M\u0012A\u0003;bE2,\u0017\nZ3oiB!\u0011QGA\u001c\u001b\u0005)\u0016bAA\u001d+\nyA+\u00192mK&#WM\u001c;jM&,'/A\u0007mSN$h)\u001e8di&|gn\u001d\u000b\u0003\u0003\u007f\u0001R\u0001SA\u0005\u0003\u0003\u00022!QA\"\u0013\r\t)E\u0011\u0002\t\rVt7\r^5p]R!\u0011qHA%\u0011\u0015\u0011g\u00021\u0001dQ\rq\u0011p`\u0001\r[\u0006\\WMR;oGRLwN\u001c\u000b\u0005\u0003\u0003\n\t\u0006C\u0004\u0002T=\u0001\r!!\u0016\u0002\u0013\u0019,hnY%eK:$\b\u0003BA\u001b\u0003/J1!!\u0017V\u0005I1UO\\2uS>t\u0017\nZ3oi&4\u0017.\u001a:\u0002\u00171L7\u000f^\"pYVlgn\u001d\u000b\u0005\u0003?\n9\u0007E\u0003I\u0003\u0013\t\t\u0007E\u0002B\u0003GJ1!!\u001aC\u0005\u0019\u0019u\u000e\\;n]\")!\u000f\u0005a\u0001G\"\"\u0001#_A6C\t\ti'\u0001\u000buC\ndW\r\t3pKN\u0004cn\u001c;!KbL7\u000f\u001e\u000b\u0007\u0003?\n\t(a\u001d\t\u000b\t\f\u0002\u0019A2\t\u000bI\f\u0002\u0019A2)\tEI\u0018qO\u0011\u0003\u0003s\n\u0001\u0005Z1uC\n\f7/\u001a\u0011pe\u0002\"\u0018M\u00197fA\u0011|Wm\u001d\u0011o_R\u0004S\r_5tiR!\u0011qLA?\u0011\u001d\tyH\u0005a\u0001\u0003g\tq\u0002^1cY\u0016LE-\u001a8uS\u001aLWM]\u0001\fO\u0016$H)\u0019;bE\u0006\u001cX\r\u0006\u0003\u0002\u000e\u0005\u0015\u0005\"\u00022\u0014\u0001\u0004\u0019\u0017\u0001C4fiR\u000b'\r\\3\u0015\t\u0005}\u00111\u0012\u0005\u0006eR\u0001\ra\u0019\u000b\u0007\u0003?\ty)!%\t\u000b\t,\u0002\u0019A2\t\u000bI,\u0002\u0019A2\u0002\u0017\u001d,GOR;oGRLwN\u001c\u000b\u0005\u0003\u0003\n9\n\u0003\u0004\u0002\u001aZ\u0001\raY\u0001\rMVt7\r^5p]:\u000bW.\u001a\u000b\u0007\u0003\u0003\ni*a(\t\u000b\t<\u0002\u0019A2\t\r\u0005eu\u00031\u0001d\u00039!\u0017\r^1cCN,W\t_5tiN$B!!*\u0002,B\u0019A,a*\n\u0007\u0005%VLA\u0004C_>dW-\u00198\t\u000b\tD\u0002\u0019A2\u0002\u0017Q\f'\r\\3Fq&\u001cHo\u001d\u000b\u0005\u0003K\u000b\t\fC\u0003s3\u0001\u00071\r\u0006\u0004\u0002&\u0006U\u0016q\u0017\u0005\u0006Ej\u0001\ra\u0019\u0005\u0006ej\u0001\raY\u0001\u000fMVt7\r^5p]\u0016C\u0018n\u001d;t)\u0011\t)+!0\t\r\u0005e5\u00041\u0001d)\u0019\t)+!1\u0002D\")!\r\ba\u0001G\"1\u0011\u0011\u0014\u000fA\u0002\r\f1b\u0019:fCR,G+\u00192mKR1\u0011\u0011ZAt\u0003S\u0004B!a3\u0002b:!\u0011QZAo\u001d\u0011\ty-a7\u000f\t\u0005E\u0017\u0011\u001c\b\u0005\u0003'\f9ND\u0002g\u0003+L\u0011!P\u0005\u0003wqJ!!\u000f\u001e\n\u0005]B\u0014bAApm\u00059\u0001/Y2lC\u001e,\u0017\u0002BAr\u0003K\u0014\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005}g\u0007C\u0003s;\u0001\u00071\r\u0003\u0004\u0002lv\u0001\raY\u0001\u0005a\u0006$\b\u000e\u0006\u0005\u0002J\u0006=\u0018\u0011_Az\u0011\u0015\u0011h\u00041\u0001d\u0011\u0019\tYO\ba\u0001G\"1\u0011Q\u001f\u0010A\u0002\r\faa]8ve\u000e,G\u0003CAe\u0003s\fY0!@\t\u000bI|\u0002\u0019A2\t\r\u0005Ux\u00041\u0001d\u0011\u001d\typ\ba\u0001\u0005\u0003\tqa\u001c9uS>t7\u000fE\u0003e\u0005\u0007\u00197-C\u0002\u0003\u00065\u00141!T1q))\tIM!\u0003\u0003\f\t5!\u0011\u0003\u0005\u0006e\u0002\u0002\ra\u0019\u0005\u0007\u0003k\u0004\u0003\u0019A2\t\r\t=\u0001\u00051\u0001d\u0003-!Wm]2sSB$\u0018n\u001c8\t\u000f\u0005}\b\u00051\u0001\u0003\u0002QQ\u0011\u0011\u001aB\u000b\u0005/\u0011IB!\u000b\t\u000bI\f\u0003\u0019A2\t\r\u0005U\u0018\u00051\u0001d\u0011\u001d\u0011Y\"\ta\u0001\u0005;\taa]2iK6\f\u0007\u0003\u0002B\u0010\u0005Ki!A!\t\u000b\u0007\t\rb'A\u0003usB,7/\u0003\u0003\u0003(\t\u0005\"AC*ueV\u001cG\u000fV=qK\"9\u0011q`\u0011A\u0002\t\u0005A\u0003DAe\u0005[\u0011yC!\r\u00034\tU\u0002\"\u0002:#\u0001\u0004\u0019\u0007BBA{E\u0001\u00071\rC\u0004\u0003\u001c\t\u0002\rA!\b\t\r\t=!\u00051\u0001d\u0011\u001d\tyP\ta\u0001\u0005\u0003\tA\u0002\u001a:paR+W\u000e\u001d,jK^$B!!*\u0003<!1!QH\u0012A\u0002\r\f\u0001B^5fo:\u000bW.Z\u0001\u0013IJ|\u0007o\u00127pE\u0006dG+Z7q-&,w\u000f\u0006\u0003\u0002&\n\r\u0003B\u0002B\u001fI\u0001\u00071-A\u0006v]\u000e\f7\r[3WS\u0016<HcA.\u0003J!9!1J\u0013A\u0002\t5\u0013a\u0002<jK^$UM\u001a\t\u0005\u0005\u001f\u0012I&\u0004\u0002\u0003R)!!1\u000bB+\u0003\u001dawnZ5dC2T1Aa\u0016V\u0003\u0015\u0001H.\u00198t\u0013\u0011\u0011YF!\u0015\u0003\u00171{w-[2bYBc\u0017M\\\u0001\u0012e\u0016\u001cwN^3s!\u0006\u0014H/\u001b;j_:\u001cHcA.\u0003b!)!O\na\u0001G\u0006A\u0011n]\"bG\",G\r\u0006\u0003\u0002&\n\u001d\u0004\"\u0002:(\u0001\u0004\u0019\u0017AC2bG\",G+\u00192mKR\u00191L!\u001c\t\u000bID\u0003\u0019A2\u0015\u000bm\u0013\tHa\u001d\t\u000bIL\u0003\u0019A2\t\u000f\tU\u0014\u00061\u0001\u0003x\u0005a1\u000f^8sC\u001e,G*\u001a<fYB!!\u0011\u0010B@\u001b\t\u0011YHC\u0002\u0003~a\nqa\u001d;pe\u0006<W-\u0003\u0003\u0003\u0002\nm$\u0001D*u_J\fw-\u001a'fm\u0016d\u0017\u0001D;oG\u0006\u001c\u0007.\u001a+bE2,GcA.\u0003\b\")!O\u000ba\u0001G\u0006Q1\r\\3be\u000e\u000b7\r[3\u0015\u0003m#B!!*\u0003\u0010\"9!\u0011\u0013\u0017A\u0002\tM\u0015!B9OC6,\u0007\u0007\u0002BK\u00057\u0003R\u0001SA\u0005\u0005/\u0003BA!'\u0003\u001c2\u0001A\u0001\u0004BO\u0005\u001f\u000b\t\u0011!A\u0003\u0002\t}%aA0%cE!!\u0011\u0015BT!\ra&1U\u0005\u0004\u0005Kk&a\u0002(pi\"Lgn\u001a\t\u00049\n%\u0016b\u0001BV;\n\u0019\u0011I\\=\u0002\u0019I,gM]3tQR\u000b'\r\\3\u0015\u0007m\u0013\t\fC\u0003s[\u0001\u00071-A\u0007sK\u001a\u0014Xm\u001d5CsB\u000bG\u000f\u001b\u000b\u00047\n]\u0006B\u0002B]]\u0001\u00071-\u0001\u0007sKN|WO]2f!\u0006$\b.A\u0006DCR\fGn\\4J[Bd\u0007C\u0001(1'\r\u0001$\u0011\u0019\t\u00049\n\r\u0017b\u0001Bc;\n1\u0011I\\=SK\u001a$\"A!0\u0002\u00175\f7.\u001a#bi\u0006\u001cX\r^\u000b\u0005\u0005\u001b\u0014)\u000e\u0006\u0004\u0003P\u000eM11\u0005\u000b\u0005\u0005#\u0014\t\u000fE\u0003I\u0003\u0013\u0011\u0019\u000e\u0005\u0003\u0003\u001a\nUGa\u0002Ble\t\u0007!\u0011\u001c\u0002\u0002)F!!\u0011\u0015Bn!\u0011\t)D!8\n\u0007\t}WK\u0001\u000eEK\u001aLg.\u001a3Cs\u000e{gn\u001d;sk\u000e$xN\u001d)be\u0006l7\u000fC\u0005\u0003dJ\n\t\u0011q\u0001\u0003f\u0006QQM^5eK:\u001cW\rJ\u0019\u0011\r\t\u001d8q\u0001Bj\u001d\u0011\u0011Io!\u0001\u000f\t\t-(Q \b\u0005\u0005[\u00149P\u0004\u0003\u0003p\nMhb\u00014\u0003r&\ta,C\u0002\u0003vv\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u0003z\nm\u0018a\u0002:v]RLW.\u001a\u0006\u0004\u0005kl\u0016\u0002BAp\u0005\u007fTAA!?\u0003|&!11AB\u0003\u0003!)h.\u001b<feN,'\u0002BAp\u0005\u007fLAa!\u0003\u0004\f\t9A+\u001f9f)\u0006<\u0017\u0002BB\u0007\u0007\u001f\u0011\u0001\u0002V=qKR\u000bwm\u001d\u0006\u0005\u0007#\u0011Y0A\u0002ba&Dqa!\u00063\u0001\u0004\u00199\"\u0001\u0003eCR\f\u0007CBB\r\u0007;\u0011\u0019N\u0004\u0003\u0003p\u000em\u0011bAAp;&!1qDB\u0011\u0005\r\u0019V-\u001d\u0006\u0004\u0003?l\u0006\"\u0002$3\u0001\u00049\u0005")
public class CatalogImpl
extends Catalog {
    private final SparkSession sparkSession;

    public static <T extends DefinedByConstructorParams> Dataset<T> makeDataset(Seq<T> seq, SparkSession sparkSession, TypeTags.TypeTag<T> typeTag) {
        return CatalogImpl$.MODULE$.makeDataset(seq, sparkSession, typeTag);
    }

    private SessionCatalog sessionCatalog() {
        return this.sparkSession.sessionState().catalog();
    }

    private void requireDatabaseExists(String dbName) {
        if (!this.sessionCatalog().databaseExists(dbName)) {
            throw new AnalysisException(new StringBuilder(27).append("Database '").append(dbName).append("' does not exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void requireTableExists(String dbName, String tableName) {
        if (!this.sessionCatalog().tableExists(new TableIdentifier(tableName, (Option)new Some((Object)dbName)))) {
            throw new AnalysisException(new StringBuilder(39).append("Table '").append(tableName).append("' does not exist in database '").append(dbName).append("'.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    @Override
    public String currentDatabase() {
        return this.sessionCatalog().getCurrentDatabase();
    }

    @Override
    public void setCurrentDatabase(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        this.sessionCatalog().setCurrentDatabase(dbName);
    }

    @Override
    public Dataset<Database> listDatabases() {
        Seq databases = (Seq)this.sessionCatalog().listDatabases().map((Function1 & Serializable & scala.Serializable)dbName -> this.makeDatabase((String)dbName), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Database").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(databases, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$1(null)));
    }

    private Database makeDatabase(String dbName) {
        CatalogDatabase metadata = this.sessionCatalog().getDatabaseMetadata(dbName);
        return new Database(metadata.name(), metadata.description(), CatalogUtils$.MODULE$.URIToString(metadata.locationUri()));
    }

    @Override
    public Dataset<Table> listTables() {
        return this.listTables(this.currentDatabase());
    }

    @Override
    public Dataset<Table> listTables(String dbName) throws AnalysisException {
        Seq tables = (Seq)this.sessionCatalog().listTables(dbName).map((Function1 & Serializable & scala.Serializable)tableIdent -> this.makeTable((TableIdentifier)tableIdent), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Table").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(tables, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$2(null)));
    }

    private Table makeTable(TableIdentifier tableIdent) {
        Some some;
        try {
            some = new Some((Object)this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        Some metadata = some;
        boolean isTemp = this.sessionCatalog().isTemporaryTable(tableIdent);
        return new Table(tableIdent.table(), (String)((Option)metadata.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.identifier().database()).getOrElse((Function0 & Serializable & scala.Serializable)() -> tableIdent.database())).orNull(Predef$.MODULE$.$conforms()), (String)metadata.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.comment().orNull(Predef$.MODULE$.$conforms())).orNull(Predef$.MODULE$.$conforms()), isTemp ? "TEMPORARY" : (String)metadata.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.tableType().name()).orNull(Predef$.MODULE$.$conforms()), isTemp);
    }

    @Override
    public Dataset<Function> listFunctions() {
        return this.listFunctions(this.currentDatabase());
    }

    @Override
    public Dataset<Function> listFunctions(String dbName) throws AnalysisException {
        this.requireDatabaseExists(dbName);
        Seq functions2 = (Seq)this.sessionCatalog().listFunctions(dbName).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            FunctionIdentifier functIdent = (FunctionIdentifier)tuple2._1();
            Function function = this.makeFunction(functIdent);
            return function;
        }, Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Function").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(functions2, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$3(null)));
    }

    private Function makeFunction(FunctionIdentifier funcIdent) {
        ExpressionInfo metadata = this.sessionCatalog().lookupFunctionInfo(funcIdent);
        return new Function(metadata.getName(), metadata.getDb(), null, metadata.getClassName(), metadata.getDb() == null);
    }

    @Override
    public Dataset<Column> listColumns(String tableName) throws AnalysisException {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.listColumns(tableIdent);
    }

    @Override
    public Dataset<Column> listColumns(String dbName, String tableName) throws AnalysisException {
        this.requireTableExists(dbName, tableName);
        return this.listColumns(new TableIdentifier(tableName, (Option)new Some((Object)dbName)));
    }

    private Dataset<Column> listColumns(TableIdentifier tableIdentifier) {
        CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdentifier);
        Set partitionColumnNames = tableMetadata.partitionColumnNames().toSet();
        Set bucketColumnNames = ((TraversableOnce)tableMetadata.bucketSpec().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.bucketColumnNames()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$)).toSet();
        Seq columns = (Seq)tableMetadata.schema().map((Function1 & Serializable & scala.Serializable)c -> new Column(c.name(), (String)c.getComment().orNull(Predef$.MODULE$.$conforms()), ((DataType)CharVarcharUtils$.MODULE$.getRawType(c.metadata()).getOrElse((Function0 & Serializable & scala.Serializable)() -> c.dataType())).catalogString(), c.nullable(), partitionColumnNames.contains((Object)c.name()), bucketColumnNames.contains((Object)c.name())), Seq$.MODULE$.canBuildFrom());
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(CatalogImpl.class.getClassLoader());
        public final class Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("org.apache.spark.sql.catalog.Column").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4(CatalogImpl $outer) {
            }
        }
        return CatalogImpl$.MODULE$.makeDataset(columns, this.sparkSession, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_internal_CatalogImpl$$typecreator1$4(null)));
    }

    @Override
    public Database getDatabase(String dbName) {
        return this.makeDatabase(dbName);
    }

    @Override
    public Table getTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.getTable((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public Table getTable(String dbName, String tableName) {
        if (!this.tableExists(dbName, tableName)) {
            throw new AnalysisException(new StringBuilder(41).append("Table or view '").append(tableName).append("' not found in database '").append(dbName).append("'").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.makeTable(new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public Function getFunction(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.getFunction((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public Function getFunction(String dbName, String functionName) {
        return this.makeFunction(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public boolean databaseExists(String dbName) {
        return this.sessionCatalog().databaseExists(dbName);
    }

    @Override
    public boolean tableExists(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        return this.tableExists((String)tableIdent.database().orNull(Predef$.MODULE$.$conforms()), tableIdent.table());
    }

    @Override
    public boolean tableExists(String dbName, String tableName) {
        TableIdentifier tableIdent = new TableIdentifier(tableName, Option$.MODULE$.apply((Object)dbName));
        return this.sessionCatalog().isTemporaryTable(tableIdent) || this.sessionCatalog().tableExists(tableIdent);
    }

    @Override
    public boolean functionExists(String functionName) {
        FunctionIdentifier functionIdent = this.sparkSession.sessionState().sqlParser().parseFunctionIdentifier(functionName);
        return this.functionExists((String)functionIdent.database().orNull(Predef$.MODULE$.$conforms()), functionIdent.funcName());
    }

    @Override
    public boolean functionExists(String dbName, String functionName) {
        return this.sessionCatalog().functionExists(new FunctionIdentifier(functionName, Option$.MODULE$.apply((Object)dbName)));
    }

    @Override
    public Dataset<Row> createTable(String tableName, String path) {
        String dataSourceName = this.sparkSession.sessionState().conf().defaultDataSourceName();
        return this.createTable(tableName, path, dataSourceName);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String path, String source) {
        return this.createTable(tableName, source, (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path)}))));
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, Map<String, String> options) {
        return this.createTable(tableName, source, new StructType(), options);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, String description, Map<String, String> options) {
        return this.createTable(tableName, source, new StructType(), description, options);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, StructType schema, Map<String, String> options) {
        return this.createTable(tableName, source, schema, "", options);
    }

    @Override
    public Dataset<Row> createTable(String tableName, String source, StructType schema, String description, Map<String, String> options) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions(options);
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        TableIdentifier x$1 = tableIdent;
        CatalogTableType x$2 = tableType;
        CatalogStorageFormat x$3 = storage;
        StructType x$4 = schema;
        Some x$5 = new Some((Object)source);
        None$ x$6 = description.isEmpty() ? None$.MODULE$ : new Some((Object)description);
        Seq x$7 = CatalogTable$.MODULE$.apply$default$6();
        Option x$8 = CatalogTable$.MODULE$.apply$default$7();
        String x$9 = CatalogTable$.MODULE$.apply$default$8();
        long x$10 = CatalogTable$.MODULE$.apply$default$9();
        long x$11 = CatalogTable$.MODULE$.apply$default$10();
        String x$12 = CatalogTable$.MODULE$.apply$default$11();
        Map x$13 = CatalogTable$.MODULE$.apply$default$12();
        Option x$14 = CatalogTable$.MODULE$.apply$default$13();
        Option x$15 = CatalogTable$.MODULE$.apply$default$14();
        Seq x$16 = CatalogTable$.MODULE$.apply$default$16();
        boolean x$17 = CatalogTable$.MODULE$.apply$default$17();
        boolean x$18 = CatalogTable$.MODULE$.apply$default$18();
        Map x$19 = CatalogTable$.MODULE$.apply$default$19();
        Option x$20 = CatalogTable$.MODULE$.apply$default$20();
        CatalogTable tableDesc = new CatalogTable(x$1, x$2, x$3, x$4, (Option)x$5, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option)x$6, x$16, x$17, x$18, x$19, x$20);
        CreateTable plan = new CreateTable(tableDesc, SaveMode.ErrorIfExists, (Option<LogicalPlan>)None$.MODULE$);
        this.sparkSession.sessionState().executePlan(plan).toRdd();
        return this.sparkSession.table(tableIdent);
    }

    @Override
    public boolean dropTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropTempView$1(this, viewName, viewDef)));
    }

    @Override
    public boolean dropGlobalTempView(String viewName) {
        return this.sparkSession.sessionState().catalog().getGlobalTempView(viewName).exists((Function1 & Serializable & scala.Serializable)viewDef -> BoxesRunTime.boxToBoolean((boolean)CatalogImpl.$anonfun$dropGlobalTempView$1(this, viewName, viewDef)));
    }

    private void uncacheView(LogicalPlan viewDef) {
        try {
            None$ none$;
            LogicalPlan logicalPlan2 = viewDef;
            if (logicalPlan2 instanceof View) {
                View view = (View)logicalPlan2;
                none$ = view.desc().viewText();
            } else {
                none$ = None$.MODULE$;
            }
            None$ viewText = none$;
            QueryExecution plan = this.sparkSession.sessionState().executePlan(viewDef);
            this.sparkSession.sharedState().cacheManager().uncacheQuery(this.sparkSession, plan.analyzed(), viewText.isDefined(), this.sparkSession.sharedState().cacheManager().uncacheQuery$default$4());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    @Override
    public void recoverPartitions(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        this.sparkSession.sessionState().executePlan(new AlterTableRecoverPartitionsCommand(tableIdent, AlterTableRecoverPartitionsCommand$.MODULE$.apply$default$2())).toRdd();
    }

    @Override
    public boolean isCached(String tableName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(this.sparkSession.table(tableName)).nonEmpty();
    }

    @Override
    public void cacheTable(String tableName) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), this.sparkSession.sharedState().cacheManager().cacheQuery$default$3());
    }

    @Override
    public void cacheTable(String tableName, StorageLevel storageLevel) {
        this.sparkSession.sharedState().cacheManager().cacheQuery(this.sparkSession.table(tableName), (Option<String>)new Some((Object)tableName), storageLevel);
    }

    @Override
    public void uncacheTable(String tableName) {
        TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
        boolean cascade = !this.sessionCatalog().isTemporaryTable(tableIdent);
        this.sparkSession.sharedState().cacheManager().uncacheQuery(this.sparkSession.table(tableName), cascade);
    }

    @Override
    public void clearCache() {
        this.sparkSession.sharedState().cacheManager().clearCache();
    }

    public boolean isCached(Dataset<?> qName) {
        return this.sparkSession.sharedState().cacheManager().lookupCachedData(qName).nonEmpty();
    }

    @Override
    public void refreshTable(String tableName) {
        block2: {
            TableIdentifier tableIdent = this.sparkSession.sessionState().sqlParser().parseTableIdentifier(tableName);
            CatalogTable tableMetadata = this.sessionCatalog().getTempViewOrPermanentTableMetadata(tableIdent);
            Dataset<Row> table = this.sparkSession.table(tableIdent);
            CatalogTableType catalogTableType = tableMetadata.tableType();
            CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
            if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
                table.queryExecution().analyzed().refresh();
            } else {
                this.sessionCatalog().refreshTable(tableIdent);
            }
            Option<CachedData> cache = this.sparkSession.sharedState().cacheManager().lookupCachedData(table);
            this.sparkSession.sharedState().cacheManager().uncacheQuery(table, true);
            if (!cache.nonEmpty()) break block2;
            Option<String> cacheName = ((CachedData)cache.get()).cachedRepresentation().cacheBuilder().tableName();
            StorageLevel cacheLevel = ((CachedData)cache.get()).cachedRepresentation().cacheBuilder().storageLevel();
            Dataset<Row> newTable = this.sparkSession.table(tableIdent);
            this.sparkSession.sharedState().cacheManager().cacheQuery(newTable, cacheName, cacheLevel);
        }
    }

    @Override
    public void refreshByPath(String resourcePath) {
        this.sparkSession.sharedState().cacheManager().recacheByPath(this.sparkSession, resourcePath);
    }

    public static final /* synthetic */ boolean $anonfun$dropTempView$1(CatalogImpl $this, String viewName$1, LogicalPlan viewDef) {
        $this.uncacheView(viewDef);
        return $this.sessionCatalog().dropTempView(viewName$1);
    }

    public static final /* synthetic */ boolean $anonfun$dropGlobalTempView$1(CatalogImpl $this, String viewName$2, LogicalPlan viewDef) {
        $this.uncacheView(viewDef);
        return $this.sessionCatalog().dropGlobalTempView(viewName$2);
    }

    public CatalogImpl(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
    }
}

