/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.ExternalCatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Concat;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF;
import org.apache.spark.sql.catalyst.expressions.ScalaUDF$;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.execution.datasources.BucketingUtils$;
import org.apache.spark.sql.execution.datasources.FileFormatDataWriter;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-d!B\r\u001b\u0003\u00039\u0003\u0002\u0003\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011A\u0002!\u0011!Q\u0001\nEB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t\u0005\u0002\u0011\t\u0011)A\u0005\u0007\")\u0011\f\u0001C\u00015\"9\u0001\r\u0001b\u0001\n#\t\u0007B\u00024\u0001A\u0003%!\rC\u0004h\u0001\t\u0007I\u0011C1\t\r!\u0004\u0001\u0015!\u0003c\u0011%I\u0007\u00011AA\u0002\u0013E!\u000eC\u0005o\u0001\u0001\u0007\t\u0019!C\t_\"IQ\u000f\u0001a\u0001\u0002\u0003\u0006Ka\u001b\u0005\nm\u0002\u0001\r\u00111A\u0005\u0012]D\u0011b\u001f\u0001A\u0002\u0003\u0007I\u0011\u0003?\t\u0013y\u0004\u0001\u0019!A!B\u0013A\b\"C@\u0001\u0011\u000b\u0007I\u0011CA\u0001\u0011)\t\t\u0003\u0001EC\u0002\u0013%\u00111\u0005\u0005\u000b\u0003W\u0001\u0001R1A\u0005\n\u00055\u0002BCA\u0019\u0001!\u0015\r\u0011\"\u0005\u00024!I\u0011q\u0007\u0001C\u0002\u0013E\u0011\u0011\b\u0005\t\u0003\u0003\u0002\u0001\u0015!\u0003\u0002<!9\u00111\t\u0001\u0005\u0012\u0005\u0015\u0003bBA.\u0001\u0011E\u0011Q\f\u0005\b\u0003G\u0002A\u0011CA3\u0005y\u0011\u0015m]3Es:\fW.[2QCJ$\u0018\u000e^5p]\u0012\u000bG/Y,sSR,'O\u0003\u0002\u001c9\u0005YA-\u0019;bg>,(oY3t\u0015\tib$A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0004I\u0001\u0004gFd'BA\u0011#\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0019C%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002K\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u000b\t\u0003S)j\u0011AG\u0005\u0003Wi\u0011ACR5mK\u001a{'/\\1u\t\u0006$\u0018m\u0016:ji\u0016\u0014\u0018a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\"!\u000b\u0018\n\u0005=R\"aE,sSR,'j\u001c2EKN\u001c'/\u001b9uS>t\u0017A\u0005;bg.\fE\u000f^3naR\u001cuN\u001c;fqR\u0004\"AM\u001c\u000e\u0003MR!\u0001N\u001b\u0002\u00135\f\u0007O]3ek\u000e,'B\u0001\u001c#\u0003\u0019A\u0017\rZ8pa&\u0011\u0001h\r\u0002\u0013)\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH/A\u0005d_6l\u0017\u000e\u001e;feB\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\u0003S>T!a\u0010\u0011\u0002\u0011%tG/\u001a:oC2L!!\u0011\u001f\u0003%\u0019KG.Z\"p[6LG\u000f\u0015:pi>\u001cw\u000e\\\u0001\u000eGV\u001cHo\\7NKR\u0014\u0018nY:\u0011\t\u0011k\u0005k\u0015\b\u0003\u000b.\u0003\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0014\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0004\u001b\u0006\u0004(B\u0001'J!\t!\u0015+\u0003\u0002S\u001f\n11\u000b\u001e:j]\u001e\u0004\"\u0001V,\u000e\u0003US!A\u0016\u000f\u0002\r5,GO]5d\u0013\tAVKA\u0005T#2kU\r\u001e:jG\u00061A(\u001b8jiz\"Ra\u0017/^=~\u0003\"!\u000b\u0001\t\u000b1*\u0001\u0019A\u0017\t\u000bA*\u0001\u0019A\u0019\t\u000be*\u0001\u0019\u0001\u001e\t\u000b\t+\u0001\u0019A\"\u0002\u001b%\u001c\b+\u0019:uSRLwN\\3e+\u0005\u0011\u0007CA2e\u001b\u0005I\u0015BA3J\u0005\u001d\u0011un\u001c7fC:\fa\"[:QCJ$\u0018\u000e^5p]\u0016$\u0007%\u0001\u0006jg\n+8m[3uK\u0012\f1\"[:Ck\u000e\\W\r^3eA\u0005i!/Z2pe\u0012\u001c\u0018J\u001c$jY\u0016,\u0012a\u001b\t\u0003G2L!!\\%\u0003\t1{gnZ\u0001\u0012e\u0016\u001cwN\u001d3t\u0013:4\u0015\u000e\\3`I\u0015\fHC\u00019t!\t\u0019\u0017/\u0003\u0002s\u0013\n!QK\\5u\u0011\u001d!8\"!AA\u0002-\f1\u0001\u001f\u00132\u00039\u0011XmY8sINLeNR5mK\u0002\n1BZ5mK\u000e{WO\u001c;feV\t\u0001\u0010\u0005\u0002ds&\u0011!0\u0013\u0002\u0004\u0013:$\u0018a\u00044jY\u0016\u001cu.\u001e8uKJ|F%Z9\u0015\u0005Al\bb\u0002;\u000f\u0003\u0003\u0005\r\u0001_\u0001\rM&dWmQ8v]R,'\u000fI\u0001\u0013O\u0016$\b+\u0019:uSRLwN\u001c,bYV,7/\u0006\u0002\u0002\u0004A91-!\u0002\u0002\n\u0005U\u0011bAA\u0004\u0013\nIa)\u001e8di&|g.\r\t\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u0010\u0002\u0011\r\fG/\u00197zgRLA!a\u0005\u0002\u000e\tY\u0011J\u001c;fe:\fGNU8x!\u0011\t9\"!\b\u000e\u0005\u0005e!\u0002BA\u000e\u0003\u001b\t1\"\u001a=qe\u0016\u001c8/[8og&!\u0011qDA\r\u0005%)fn]1gKJ{w/A\fqCJ$\u0018\u000e^5p]B\u000bG\u000f[#yaJ,7o]5p]V\u0011\u0011Q\u0005\t\u0005\u0003/\t9#\u0003\u0003\u0002*\u0005e!AC#yaJ,7o]5p]\u0006\u0001r-\u001a;QCJ$\u0018\u000e^5p]B\u000bG\u000f[\u000b\u0003\u0003_\u0001baYA\u0003\u0003\u0013\u0001\u0016aC4fi\n+8m[3u\u0013\u0012,\"!!\u000e\u0011\r\r\f)!!\u0003y\u000319W\r^(viB,HOU8x+\t\tY\u0004\u0005\u0003\u0002\u0018\u0005u\u0012\u0002BA \u00033\u0011\u0001#\u00168tC\u001a,\u0007K]8kK\u000e$\u0018n\u001c8\u0002\u001b\u001d,GoT;uaV$(k\\<!\u0003I\u0011XM\\3x\u0007V\u0014(/\u001a8u/JLG/\u001a:\u0015\u000fA\f9%!\u0015\u0002X!9\u0011\u0011\n\fA\u0002\u0005-\u0013a\u00049beRLG/[8o-\u0006dW/Z:\u0011\u000b\r\fi%!\u0003\n\u0007\u0005=\u0013J\u0001\u0004PaRLwN\u001c\u0005\b\u0003'2\u0002\u0019AA+\u0003!\u0011WoY6fi&#\u0007\u0003B2\u0002NaDa!!\u0017\u0017\u0001\u0004\u0011\u0017AE2m_N,7)\u001e:sK:$xK]5uKJ\f!E]3oK^\u001cUO\u001d:f]R<&/\u001b;fe&3Gk\\8NC:L(+Z2pe\u0012\u001cH#\u00029\u0002`\u0005\u0005\u0004bBA%/\u0001\u0007\u00111\n\u0005\b\u0003':\u0002\u0019AA+\u0003-9(/\u001b;f%\u0016\u001cwN\u001d3\u0015\u0007A\f9\u0007C\u0004\u0002ja\u0001\r!!\u0003\u0002\rI,7m\u001c:e\u0001")
public abstract class BaseDynamicPartitionDataWriter
extends FileFormatDataWriter {
    private Function1<InternalRow, UnsafeRow> getPartitionValues;
    private Expression partitionPathExpression;
    private Function1<InternalRow, String> getPartitionPath;
    private Function1<InternalRow, Object> getBucketId;
    private final WriteJobDescription description;
    private final TaskAttemptContext taskAttemptContext;
    private final FileCommitProtocol committer;
    private final boolean isPartitioned;
    private final boolean isBucketed;
    private long recordsInFile;
    private int fileCounter;
    private final UnsafeProjection getOutputRow;
    private volatile byte bitmap$0;

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public boolean isBucketed() {
        return this.isBucketed;
    }

    public long recordsInFile() {
        return this.recordsInFile;
    }

    public void recordsInFile_$eq(long x$1) {
        this.recordsInFile = x$1;
    }

    public int fileCounter() {
        return this.fileCounter;
    }

    public void fileCounter_$eq(int x$1) {
        this.fileCounter = x$1;
    }

    private Function1<InternalRow, UnsafeRow> getPartitionValues$lzycompute() {
        BaseDynamicPartitionDataWriter baseDynamicPartitionDataWriter = this;
        synchronized (baseDynamicPartitionDataWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                UnsafeProjection proj = UnsafeProjection$.MODULE$.create(this.description.partitionColumns(), this.description.allColumns());
                this.getPartitionValues = (Function1 & Serializable & scala.Serializable)row -> proj.apply(row);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.getPartitionValues;
    }

    public Function1<InternalRow, UnsafeRow> getPartitionValues() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.getPartitionValues$lzycompute() : this.getPartitionValues;
    }

    private Expression partitionPathExpression$lzycompute() {
        BaseDynamicPartitionDataWriter baseDynamicPartitionDataWriter = this;
        synchronized (baseDynamicPartitionDataWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.partitionPathExpression = new Concat((Seq)((TraversableLike)this.description.partitionColumns().zipWithIndex(Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Attribute c = (Attribute)tuple2._1();
                    int i = tuple2._2$mcI$sp();
                    ScalaUDF partitionName = new ScalaUDF((Function2 & Serializable & scala.Serializable)(col, value) -> ExternalCatalogUtils$.MODULE$.getPartitionPathString(col, value), (DataType)StringType$.MODULE$, (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)c.name()), (List)new .colon.colon((Object)new Cast((Expression)c, (DataType)StringType$.MODULE$, Option$.MODULE$.apply((Object)$this.description.timeZoneId()), Cast$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)), ScalaUDF$.MODULE$.apply$default$4(), ScalaUDF$.MODULE$.apply$default$5(), ScalaUDF$.MODULE$.apply$default$6(), ScalaUDF$.MODULE$.apply$default$7(), ScalaUDF$.MODULE$.apply$default$8());
                    Seq seq = i == 0 ? (Seq)new .colon.colon((Object)partitionName, (List)Nil$.MODULE$) : (Seq)new .colon.colon((Object)Literal$.MODULE$.apply((Object)"/"), (List)new .colon.colon((Object)partitionName, (List)Nil$.MODULE$));
                    return seq;
                }, Seq$.MODULE$.canBuildFrom()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.partitionPathExpression;
    }

    private Expression partitionPathExpression() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.partitionPathExpression$lzycompute() : this.partitionPathExpression;
    }

    private Function1<InternalRow, String> getPartitionPath$lzycompute() {
        BaseDynamicPartitionDataWriter baseDynamicPartitionDataWriter = this;
        synchronized (baseDynamicPartitionDataWriter) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                UnsafeProjection proj = UnsafeProjection$.MODULE$.create((Seq)new .colon.colon((Object)this.partitionPathExpression(), (List)Nil$.MODULE$), this.description.partitionColumns());
                this.getPartitionPath = (Function1 & Serializable & scala.Serializable)row -> proj.apply(row).getString(0);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.getPartitionPath;
    }

    private Function1<InternalRow, String> getPartitionPath() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.getPartitionPath$lzycompute() : this.getPartitionPath;
    }

    private Function1<InternalRow, Object> getBucketId$lzycompute() {
        BaseDynamicPartitionDataWriter baseDynamicPartitionDataWriter = this;
        synchronized (baseDynamicPartitionDataWriter) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                UnsafeProjection proj = UnsafeProjection$.MODULE$.create(Option$.MODULE$.option2Iterable(this.description.bucketIdExpression()).toSeq(), this.description.allColumns());
                this.getBucketId = (Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToInteger((int)BaseDynamicPartitionDataWriter.$anonfun$getBucketId$1(proj, row));
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.getBucketId;
    }

    public Function1<InternalRow, Object> getBucketId() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.getBucketId$lzycompute() : this.getBucketId;
    }

    public UnsafeProjection getOutputRow() {
        return this.getOutputRow;
    }

    public void renewCurrentWriter(Option<InternalRow> partitionValues, Option<Object> bucketId, boolean closeCurrentWriter) {
        String bucketIdStr;
        this.recordsInFile_$eq(0L);
        if (closeCurrentWriter) {
            this.releaseCurrentWriter();
        }
        Option partDir = partitionValues.map((Function1 & Serializable & scala.Serializable)x$7 -> (String)this.getPartitionPath().apply(x$7));
        partDir.foreach((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)BaseDynamicPartitionDataWriter.$anonfun$renewCurrentWriter$2(this, elem)));
        String arg$macro$1 = bucketIdStr = (String)bucketId.map((Function1 & Serializable & scala.Serializable)id -> BucketingUtils$.MODULE$.bucketIdToString(BoxesRunTime.unboxToInt((Object)id))).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        int arg$macro$2 = this.fileCounter();
        String ext = new StringBuilder(0).append(new StringOps("%s.c%03d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, BoxesRunTime.boxToInteger((int)arg$macro$2)}))).append(this.description.outputWriterFactory().getFileExtension(this.taskAttemptContext)).toString();
        Option customPath = partDir.flatMap((Function1 & Serializable & scala.Serializable)dir -> $this.description.customPartitionLocations().get(PartitioningUtils$.MODULE$.parsePathFragment((String)dir)));
        String currentPath = customPath.isDefined() ? this.committer.newTaskTempFileAbsPath(this.taskAttemptContext, (String)customPath.get(), ext) : this.committer.newTaskTempFile(this.taskAttemptContext, partDir, ext);
        this.currentWriter_$eq(this.description.outputWriterFactory().newInstance(currentPath, package$.MODULE$.AttributeSeq(this.description.dataColumns()).toStructType(), this.taskAttemptContext));
        this.statsTrackers().foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            x$8.newFile(currentPath);
            return BoxedUnit.UNIT;
        });
    }

    public void renewCurrentWriterIfTooManyRecords(Option<InternalRow> partitionValues, Option<Object> bucketId) {
        this.fileCounter_$eq(this.fileCounter() + 1);
        Predef$.MODULE$.assert(this.fileCounter() < this.MAX_FILE_COUNTER(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("File counter ").append(this.fileCounter()).append(" is beyond max value ").append(this.MAX_FILE_COUNTER()).toString());
        this.renewCurrentWriter(partitionValues, bucketId, true);
    }

    public void writeRecord(InternalRow record) {
        UnsafeRow outputRow = this.getOutputRow().apply(record);
        this.currentWriter().write((InternalRow)outputRow);
        this.statsTrackers().foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            x$9.newRow(this.currentWriter().path(), (InternalRow)outputRow);
            return BoxedUnit.UNIT;
        });
        this.recordsInFile_$eq(this.recordsInFile() + 1L);
    }

    public static final /* synthetic */ int $anonfun$getBucketId$1(UnsafeProjection proj$3, InternalRow row) {
        return proj$3.apply(row).getInt(0);
    }

    public static final /* synthetic */ boolean $anonfun$renewCurrentWriter$2(BaseDynamicPartitionDataWriter $this, String elem) {
        return $this.updatedPartitions().add((Object)elem);
    }

    public BaseDynamicPartitionDataWriter(WriteJobDescription description, TaskAttemptContext taskAttemptContext, FileCommitProtocol committer, Map<String, SQLMetric> customMetrics) {
        this.description = description;
        this.taskAttemptContext = taskAttemptContext;
        this.committer = committer;
        super(description, taskAttemptContext, committer, customMetrics);
        this.isPartitioned = description.partitionColumns().nonEmpty();
        this.isBucketed = description.bucketIdExpression().isDefined();
        Predef$.MODULE$.assert(this.isPartitioned() || this.isBucketed(), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(176).append("DynamicPartitionWriteTask should be used for writing out data that's either\n       |partitioned or bucketed. In this case neither is true.\n       |WriteJobDescription: ").append($this.description).append("\n       ").toString())).stripMargin());
        this.getOutputRow = UnsafeProjection$.MODULE$.create(description.dataColumns(), description.allColumns());
    }
}

