/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ResolveDefaultColumns$;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.execution.command.AlterTableChangeColumnCommand$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001\u0002\u0010 \u00012B\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\r\"A1\n\u0001BK\u0002\u0013\u0005A\n\u0003\u0005Y\u0001\tE\t\u0015!\u0003N\u0011!I\u0006A!f\u0001\n\u0003Q\u0006\u0002C1\u0001\u0005#\u0005\u000b\u0011B.\t\u000b\t\u0004A\u0011A2\t\u000b!\u0004A\u0011I5\t\u000bq\u0004A\u0011B?\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u0011\u0011\n\u0001\u0005\n\u0005-\u0003bBA*\u0001\u0011%\u0011Q\u000b\u0005\n\u0003O\u0002\u0011\u0011!C\u0001\u0003SB\u0011\"!\u001d\u0001#\u0003%\t!a\u001d\t\u0013\u0005%\u0005!%A\u0005\u0002\u0005-\u0005\"CAH\u0001E\u0005I\u0011AAI\u0011%\t)\nAA\u0001\n\u0003\n9\nC\u0005\u0002(\u0002\t\t\u0011\"\u0001\u0002*\"I\u0011\u0011\u0017\u0001\u0002\u0002\u0013\u0005\u00111\u0017\u0005\n\u0003\u007f\u0003\u0011\u0011!C!\u0003\u0003D\u0011\"a4\u0001\u0003\u0003%\t!!5\t\u0013\u0005U\u0007!!A\u0005B\u0005]w!CAn?\u0005\u0005\t\u0012AAo\r!qr$!A\t\u0002\u0005}\u0007B\u00022\u0019\t\u0003\ti\u000fC\u0005\u0002pb\t\t\u0011\"\u0012\u0002r\"I\u00111\u001f\r\u0002\u0002\u0013\u0005\u0015Q\u001f\u0005\n\u0003{D\u0012\u0011!CA\u0003\u007fD\u0011B!\u0004\u0019\u0003\u0003%IAa\u0004\u0003;\u0005cG/\u001a:UC\ndWm\u00115b]\u001e,7i\u001c7v[:\u001cu.\\7b]\u0012T!\u0001I\u0011\u0002\u000f\r|W.\\1oI*\u0011!eI\u0001\nKb,7-\u001e;j_:T!\u0001J\u0013\u0002\u0007M\fHN\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u0019R\u0001A\u00178w\u0005\u0003\"AL\u001b\u000e\u0003=R!\u0001M\u0019\u0002\u000f1|w-[2bY*\u0011!gM\u0001\u0006a2\fgn\u001d\u0006\u0003i\r\n\u0001bY1uC2L8\u000f^\u0005\u0003m=\u00121\u0002T8hS\u000e\fG\u000e\u00157b]B\u0011\u0001(O\u0007\u0002?%\u0011!h\b\u0002\u0014\u0019\u0016\fgMU;o]\u0006\u0014G.Z\"p[6\fg\u000e\u001a\t\u0003y}j\u0011!\u0010\u0006\u0002}\u0005)1oY1mC&\u0011\u0001)\u0010\u0002\b!J|G-^2u!\ta$)\u0003\u0002D{\ta1+\u001a:jC2L'0\u00192mK\u0006IA/\u00192mK:\u000bW.Z\u000b\u0002\rB\u0011q\tS\u0007\u0002g%\u0011\u0011j\r\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\u0006QA/\u00192mK:\u000bW.\u001a\u0011\u0002\u0015\r|G.^7o\u001d\u0006lW-F\u0001N!\tqUK\u0004\u0002P'B\u0011\u0001+P\u0007\u0002#*\u0011!kK\u0001\u0007yI|w\u000e\u001e \n\u0005Qk\u0014A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001V\u001f\u0002\u0017\r|G.^7o\u001d\u0006lW\rI\u0001\n]\u0016<8i\u001c7v[:,\u0012a\u0017\t\u00039~k\u0011!\u0018\u0006\u0003=\u000e\nQ\u0001^=qKNL!\u0001Y/\u0003\u0017M#(/^2u\r&,G\u000eZ\u0001\u000b]\u0016<8i\u001c7v[:\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003eK\u001a<\u0007C\u0001\u001d\u0001\u0011\u0015!u\u00011\u0001G\u0011\u0015Yu\u00011\u0001N\u0011\u0015Iv\u00011\u0001\\\u0003\r\u0011XO\u001c\u000b\u0003U^\u00042a\u001b9t\u001d\tagN\u0004\u0002Q[&\ta(\u0003\u0002p{\u00059\u0001/Y2lC\u001e,\u0017BA9s\u0005\r\u0019V-\u001d\u0006\u0003_v\u0002\"\u0001^;\u000e\u0003\rJ!A^\u0012\u0003\u0007I{w\u000fC\u0003y\u0011\u0001\u0007\u00110\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002uu&\u00111p\t\u0002\r'B\f'o[*fgNLwN\\\u0001\u0011M&tGmQ8mk6t')\u001f(b[\u0016$ba\u0017@\u0002\b\u0005-\u0001BB@\n\u0001\u0004\t\t!\u0001\u0004tG\",W.\u0019\t\u00049\u0006\r\u0011bAA\u0003;\nQ1\u000b\u001e:vGR$\u0016\u0010]3\t\r\u0005%\u0011\u00021\u0001N\u0003\u0011q\u0017-\\3\t\u000f\u00055\u0011\u00021\u0001\u0002\u0010\u0005A!/Z:pYZ,'\u000f\u0005\u0003\u0002\u0012\u0005Eb\u0002BA\n\u0003[qA!!\u0006\u0002*9!\u0011qCA\u0014\u001d\u0011\tI\"!\n\u000f\t\u0005m\u00111\u0005\b\u0005\u0003;\t\tCD\u0002Q\u0003?I\u0011AK\u0005\u0003Q%J!AJ\u0014\n\u0005\u0011*\u0013B\u0001\u001b$\u0013\r\tYcM\u0001\tC:\fG._:jg&\u0019q.a\f\u000b\u0007\u0005-2'\u0003\u0003\u00024\u0005U\"\u0001\u0003*fg>dg/\u001a:\u000b\u0007=\fy#\u0001\u0006bI\u0012\u001cu.\\7f]R$RaWA\u001e\u0003\u007fAa!!\u0010\u000b\u0001\u0004Y\u0016AB2pYVlg\u000eC\u0004\u0002B)\u0001\r!a\u0011\u0002\u000f\r|W.\\3oiB!A(!\u0012N\u0013\r\t9%\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0002-\u0005$GmQ;se\u0016tG\u000fR3gCVdGOV1mk\u0016$RaWA'\u0003\u001fBa!!\u0010\f\u0001\u0004Y\u0006bBA)\u0017\u0001\u0007\u00111I\u0001\u0006m\u0006dW/Z\u0001\fG>dW/\u001c8FcV\fG\u000e\u0006\u0005\u0002X\u0005u\u0013\u0011MA3!\ra\u0014\u0011L\u0005\u0004\u00037j$a\u0002\"p_2,\u0017M\u001c\u0005\u0007\u0003?b\u0001\u0019A.\u0002\u000b\u0019LW\r\u001c3\t\r\u0005\rD\u00021\u0001\\\u0003\u0015yG\u000f[3s\u0011\u001d\ti\u0001\u0004a\u0001\u0003\u001f\tAaY8qsR9A-a\u001b\u0002n\u0005=\u0004b\u0002#\u000e!\u0003\u0005\rA\u0012\u0005\b\u00176\u0001\n\u00111\u0001N\u0011\u001dIV\u0002%AA\u0002m\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002v)\u001aa)a\u001e,\u0005\u0005e\u0004\u0003BA>\u0003\u000bk!!! \u000b\t\u0005}\u0014\u0011Q\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a!>\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u000f\u000biHA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002\u000e*\u001aQ*a\u001e\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0013\u0016\u00047\u0006]\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\u001aB!\u00111TAS\u001b\t\tiJ\u0003\u0003\u0002 \u0006\u0005\u0016\u0001\u00027b]\u001eT!!a)\u0002\t)\fg/Y\u0005\u0004-\u0006u\u0015\u0001\u00049s_\u0012,8\r^!sSRLXCAAV!\ra\u0014QV\u0005\u0004\u0003_k$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA[\u0003w\u00032\u0001PA\\\u0013\r\tI,\u0010\u0002\u0004\u0003:L\b\"CA_'\u0005\u0005\t\u0019AAV\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u00111\u0019\t\u0007\u0003\u000b\fY-!.\u000e\u0005\u0005\u001d'bAAe{\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u0017q\u0019\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002X\u0005M\u0007\"CA_+\u0005\u0005\t\u0019AA[\u0003\u0019)\u0017/^1mgR!\u0011qKAm\u0011%\tiLFA\u0001\u0002\u0004\t),A\u000fBYR,'\u000fV1cY\u0016\u001c\u0005.\u00198hK\u000e{G.^7o\u0007>lW.\u00198e!\tA\u0004d\u0005\u0003\u0019\u0003C\f\u0005\u0003CAr\u0003S4Uj\u00173\u000e\u0005\u0005\u0015(bAAt{\u00059!/\u001e8uS6,\u0017\u0002BAv\u0003K\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c84)\t\ti.\u0001\u0005u_N#(/\u001b8h)\t\tI*A\u0003baBd\u0017\u0010F\u0004e\u0003o\fI0a?\t\u000b\u0011[\u0002\u0019\u0001$\t\u000b-[\u0002\u0019A'\t\u000be[\u0002\u0019A.\u0002\u000fUt\u0017\r\u001d9msR!!\u0011\u0001B\u0005!\u0015a\u0014Q\tB\u0002!\u0019a$Q\u0001$N7&\u0019!qA\u001f\u0003\rQ+\b\u000f\\34\u0011!\u0011Y\u0001HA\u0001\u0002\u0004!\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\t\u0002\u0005\u0003\u0002\u001c\nM\u0011\u0002\u0002B\u000b\u0003;\u0013aa\u00142kK\u000e$\b")
public class AlterTableChangeColumnCommand
extends LogicalPlan
implements LeafRunnableCommand,
scala.Serializable {
    private final TableIdentifier tableName;
    private final String columnName;
    private final StructField newColumn;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple3<TableIdentifier, String, StructField>> unapply(AlterTableChangeColumnCommand alterTableChangeColumnCommand) {
        return AlterTableChangeColumnCommand$.MODULE$.unapply(alterTableChangeColumnCommand);
    }

    public static Function1<Tuple3<TableIdentifier, String, StructField>, AlterTableChangeColumnCommand> tupled() {
        return AlterTableChangeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<String, Function1<StructField, AlterTableChangeColumnCommand>>> curried() {
        return AlterTableChangeColumnCommand$.MODULE$.curried();
    }

    @Override
    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = this;
        synchronized (alterTableChangeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public TableIdentifier tableName() {
        return this.tableName;
    }

    public String columnName() {
        return this.columnName;
    }

    public StructField newColumn() {
        return this.newColumn;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionCatalog catalog = sparkSession.sessionState().catalog();
        CatalogTable table = catalog.getTableRawMetadata(this.tableName());
        Function2 resolver = sparkSession.sessionState().conf().resolver();
        DDLUtils$.MODULE$.verifyAlterTableType(catalog, table, false);
        StructField originColumn = this.findColumnByName(table.dataSchema(), this.columnName(), (Function2<String, String, Object>)resolver);
        if (!this.columnEqual(originColumn, this.newColumn(), (Function2<String, String, Object>)resolver)) {
            throw QueryCompilationErrors$.MODULE$.alterTableChangeColumnNotSupportedForColumnTypeError(originColumn, this.newColumn());
        }
        StructField[] newDataSchema = (StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])table.dataSchema().fields())).map((Function1 & Serializable & scala.Serializable)field -> {
            String string = field.name();
            String string2 = originColumn.name();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                StructField withNewComment = this.addComment((StructField)field, (Option<String>)this.newColumn().getComment());
                if (this.newColumn().getCurrentDefaultValue().isDefined()) {
                    if (new StringOps(Predef$.MODULE$.augmentString((String)this.newColumn().getCurrentDefaultValue().get())).nonEmpty()) {
                        StructField result = this.addCurrentDefaultValue(withNewComment, (Option<String>)this.newColumn().getCurrentDefaultValue());
                        ResolveDefaultColumns$.MODULE$.analyze(result, "ALTER TABLE ALTER COLUMN", ResolveDefaultColumns$.MODULE$.analyze$default$3());
                        return result;
                    }
                    return withNewComment.clearCurrentDefaultValue();
                }
                return withNewComment;
            }
            return field;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)));
        catalog.alterTableDataSchema(this.tableName(), new StructType(newDataSchema));
        return (Seq)Nil$.MODULE$;
    }

    private StructField findColumnByName(StructType schema, String name, Function2<String, String, Object> resolver) {
        return (StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).collectFirst((PartialFunction)new scala.Serializable(null, resolver, name){
            public static final long serialVersionUID = 0L;
            private final Function2 resolver$1;
            private final String name$1;

            public final <A1 extends StructField, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)A1.name(), (Object)this.name$1))) {
                    return (B1)A1;
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(StructField x1) {
                StructField structField = x1;
                return BoxesRunTime.unboxToBoolean((Object)this.resolver$1.apply((Object)structField.name(), (Object)this.name$1));
            }
            {
                this.resolver$1 = resolver$1;
                this.name$1 = name$1;
            }
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw QueryCompilationErrors$.MODULE$.cannotFindColumnError(name, schema.fieldNames());
        });
    }

    private StructField addComment(StructField column, Option<String> comment2) {
        return (StructField)comment2.map((Function1 & Serializable & scala.Serializable)comment -> column.withComment(comment)).getOrElse((Function0 & Serializable & scala.Serializable)() -> column);
    }

    private StructField addCurrentDefaultValue(StructField column, Option<String> value2) {
        return (StructField)value2.map((Function1 & Serializable & scala.Serializable)value -> column.withCurrentDefaultValue(value)).getOrElse((Function0 & Serializable & scala.Serializable)() -> column);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean columnEqual(StructField field, StructField other, Function2<String, String, Object> resolver) {
        if (!BoxesRunTime.unboxToBoolean((Object)resolver.apply((Object)field.name(), (Object)other.name()))) return false;
        DataType dataType = field.dataType();
        DataType dataType2 = other.dataType();
        if (dataType != null) {
            if (!dataType.equals(dataType2)) return false;
            return true;
        }
        if (dataType2 == null) return true;
        return false;
    }

    public AlterTableChangeColumnCommand copy(TableIdentifier tableName, String columnName, StructField newColumn) {
        return new AlterTableChangeColumnCommand(tableName, columnName, newColumn);
    }

    public TableIdentifier copy$default$1() {
        return this.tableName();
    }

    public String copy$default$2() {
        return this.columnName();
    }

    public StructField copy$default$3() {
        return this.newColumn();
    }

    public String productPrefix() {
        return "AlterTableChangeColumnCommand";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.tableName();
            }
            case 1: {
                return this.columnName();
            }
            case 2: {
                return this.newColumn();
            }
        }
        throw new IndexOutOfBoundsException(Integer.toString(x$1));
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterTableChangeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterTableChangeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterTableChangeColumnCommand alterTableChangeColumnCommand = (AlterTableChangeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableName();
        TableIdentifier tableIdentifier2 = alterTableChangeColumnCommand.tableName();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        String string = this.columnName();
        String string2 = alterTableChangeColumnCommand.columnName();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        StructField structField = this.newColumn();
        StructField structField2 = alterTableChangeColumnCommand.newColumn();
        if (structField == null) {
            if (structField2 != null) {
                return false;
            }
        } else if (!structField.equals(structField2)) return false;
        if (!alterTableChangeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public AlterTableChangeColumnCommand(TableIdentifier tableName, String columnName, StructField newColumn) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.newColumn = newColumn;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
        LeafLike.$init$((LeafLike)this);
    }
}

