/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.execution.streaming.AbstractFileContextBasedCheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001!4A\u0001C\u0005\u0001-!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003<\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u00151\u0005\u0001\"\u0011H\u0011\u0015a\u0005\u0001\"\u0011N\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015)\u0007\u0001\"\u0003g\u0005\u00152\u0015\u000e\\3D_:$X\r\u001f;CCN,Gm\u00115fG.\u0004x.\u001b8u\r&dW-T1oC\u001e,'O\u0003\u0002\u000b\u0017\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u00195\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u00059y\u0011aA:rY*\u0011\u0001#E\u0001\u0006gB\f'o\u001b\u0006\u0003%M\ta!\u00199bG\",'\"\u0001\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u000192\u0004\u0005\u0002\u001935\t\u0011\"\u0003\u0002\u001b\u0013\ti\u0013IY:ue\u0006\u001cGOR5mK\u000e{g\u000e^3yi\n\u000b7/\u001a3DQ\u0016\u001c7\u000e]8j]R4\u0015\u000e\\3NC:\fw-\u001a:\u0011\u0005qqcBA\u000f-\u001d\tq2F\u0004\u0002 U9\u0011\u0001%\u000b\b\u0003C!r!AI\u0014\u000f\u0005\r2S\"\u0001\u0013\u000b\u0005\u0015*\u0012A\u0002\u001fs_>$h(C\u0001\u0015\u0013\t\u00112#\u0003\u0002\u0011#%\u0011abD\u0005\u0003\u00195I!AC\u0006\n\u00055J\u0011!F\"iK\u000e\\\u0007o\\5oi\u001aKG.Z'b]\u0006<WM]\u0005\u0003_A\u00121CU3oC6,\u0007*\u001a7qKJlU\r\u001e5pINT!!L\u0005\u0002\tA\fG\u000f\u001b\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\n!AZ:\u000b\u0005]\n\u0012A\u00025bI>|\u0007/\u0003\u0002:i\t!\u0001+\u0019;i\u0003)A\u0017\rZ8pa\u000e{gN\u001a\t\u0003y}j\u0011!\u0010\u0006\u0003}Y\nAaY8oM&\u0011\u0001)\u0010\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\r\u0019E)\u0012\t\u00031\u0001AQ!M\u0002A\u0002IBQAO\u0002A\u0002m\nab\u0019:fCR,G+Z7q\r&dW\r\u0006\u0002I\u0017B\u00111'S\u0005\u0003\u0015R\u0012!CR*ECR\fw*\u001e;qkR\u001cFO]3b[\")\u0011\u0007\u0002a\u0001e\u0005a1M]3bi\u0016\fEo\\7jGR\u0019aJU*\u0011\u0005=\u0003fB\u0001\r-\u0013\t\t\u0006GA\u000fDC:\u001cW\r\u001c7bE2,gi\u0015#bi\u0006|U\u000f\u001e9viN#(/Z1n\u0011\u0015\tT\u00011\u00013\u0011\u0015!V\u00011\u0001V\u0003Myg/\u001a:xe&$X-\u00134Q_N\u001c\u0018N\u00197f!\t1\u0016,D\u0001X\u0015\u0005A\u0016!B:dC2\f\u0017B\u0001.X\u0005\u001d\u0011un\u001c7fC:\faB]3oC6,G+Z7q\r&dW\r\u0006\u0003^A\n$\u0007C\u0001,_\u0013\tyvK\u0001\u0003V]&$\b\"B1\u0007\u0001\u0004\u0011\u0014aB:sGB\u000bG\u000f\u001b\u0005\u0006G\u001a\u0001\rAM\u0001\bIN$\b+\u0019;i\u0011\u0015!f\u00011\u0001V\u0003Ai\u0017-\u001f*f[>4Xm\u0011:d\r&dW\r\u0006\u0002^O\")\u0011g\u0002a\u0001e\u0001")
public class FileContextBasedCheckpointFileManager
extends AbstractFileContextBasedCheckpointFileManager
implements CheckpointFileManager.RenameHelperMethods {
    @Override
    public FSDataOutputStream createTempFile(Path path) {
        return this.fc().create(path, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[]{Options.CreateOpts.checksumParam((Options.ChecksumOpt)Options.ChecksumOpt.createDisabled())});
    }

    @Override
    public CheckpointFileManager.CancellableFSDataOutputStream createAtomic(Path path, boolean overwriteIfPossible) {
        return new CheckpointFileManager.RenameBasedFSDataOutputStream(this, path, overwriteIfPossible);
    }

    @Override
    public void renameTempFile(Path srcPath, Path dstPath, boolean overwriteIfPossible) {
        this.fc().rename(srcPath, dstPath, new Options.Rename[]{overwriteIfPossible ? Options.Rename.OVERWRITE : Options.Rename.NONE});
        this.mayRemoveCrcFile(srcPath);
    }

    private void mayRemoveCrcFile(Path path) {
        try {
            Path checksumFile = new Path(path.getParent(), new StringBuilder(5).append(".").append(path.getName()).append(".crc").toString());
            if (this.exists(checksumFile)) {
                this.delete(checksumFile);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
            }
            throw throwable;
        }
    }

    public FileContextBasedCheckpointFileManager(Path path, Configuration hadoopConf) {
        super(path, hadoopConf);
        CheckpointFileManager.RenameHelperMethods.$init$(this);
    }
}

