/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.Serializable;
import java.sql.Date;
import java.util.concurrent.TimeUnit;
import org.apache.spark.api.java.Optional;
import org.apache.spark.sql.catalyst.plans.logical.EventTimeTimeout$;
import org.apache.spark.sql.catalyst.plans.logical.ProcessingTimeTimeout$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.streaming.GroupStateImpl$;
import org.apache.spark.sql.streaming.GroupStateTimeout;
import org.apache.spark.sql.streaming.TestGroupState;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015h!\u0002\u001a4\u0001]z\u0004\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011q\u0003!\u0011!Q\u0001\nuC\u0001\u0002\u0019\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"AQ\r\u0001BC\u0002\u0013\u0005c\r\u0003\u0005k\u0001\t\u0005\t\u0015!\u0003h\u0011!Y\u0007A!A!\u0002\u00139\u0007\"\u00027\u0001\t\u0013i\u0007b\u0002<\u0001\u0001\u0004%Ia\u001e\u0005\bq\u0002\u0001\r\u0011\"\u0003z\u0011\u0019y\b\u0001)Q\u0005\u0019\"A\u0011\u0011\u0001\u0001A\u0002\u0013%a\rC\u0005\u0002\u0004\u0001\u0001\r\u0011\"\u0003\u0002\u0006!9\u0011\u0011\u0002\u0001!B\u00139\u0007\u0002CA\u0006\u0001\u0001\u0007I\u0011\u00024\t\u0013\u00055\u0001\u00011A\u0005\n\u0005=\u0001bBA\n\u0001\u0001\u0006Ka\u001a\u0005\t\u0003+\u0001\u0001\u0019!C\u0005M\"I\u0011q\u0003\u0001A\u0002\u0013%\u0011\u0011\u0004\u0005\b\u0003;\u0001\u0001\u0015)\u0003h\u0011%\ty\u0002\u0001a\u0001\n\u0013\t\t\u0003C\u0005\u0002$\u0001\u0001\r\u0011\"\u0003\u0002&!9\u0011\u0011\u0006\u0001!B\u0013i\u0006BBA\u0016\u0001\u0011\u0005c\r\u0003\u0004\u0002.\u0001!\te\u001e\u0005\b\u0003_\u0001A\u0011IA\u0019\u0011\u001d\t\u0019\u0004\u0001C!\u0003kAq!a\u000f\u0001\t\u0003\ni\u0004C\u0004\u0002@\u0001!\t%!\u0011\t\u000f\u0005}\u0002\u0001\"\u0011\u0002H!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA2\u0001\u0011\u0005\u00131\u000e\u0005\b\u0003G\u0002A\u0011IA:\u0011\u001d\t\u0019\u0007\u0001C!\u0003\u000fCq!!$\u0001\t\u0003\ny\tC\u0004\u0002\u0012\u0002!\t%a$\t\u000f\u0005M\u0005\u0001\"\u0011\u0002\u0016\"1\u0011q\u0013\u0001\u0005B\u0019Da!!'\u0001\t\u00032\u0007bBAN\u0001\u0011\u0005\u0013Q\u0014\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\t\u0019\f\u0001C\u0005\u0003{9\u0001\"!.4\u0011\u00039\u0014q\u0017\u0004\beMB\taNA]\u0011\u0019aG\u0006\"\u0001\u0002<\"I\u0011Q\u0018\u0017C\u0002\u0013\u0005\u0011\u0011\u0005\u0005\b\u0003\u007fc\u0003\u0015!\u0003^\u0011\u001d\t\t\r\fC\u0001\u0003\u0007Dq!a7-\t\u0003\tiN\u0001\bHe>,\bo\u0015;bi\u0016LU\u000e\u001d7\u000b\u0005Q*\u0014!C:ue\u0016\fW.\u001b8h\u0015\t1t'A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0001(O\u0001\u0004gFd'B\u0001\u001e<\u0003\u0015\u0019\b/\u0019:l\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\u0016\u0005\u0001s5c\u0001\u0001B\u000fB\u0011!)R\u0007\u0002\u0007*\tA)A\u0003tG\u0006d\u0017-\u0003\u0002G\u0007\n1\u0011I\\=SK\u001a\u00042\u0001\u0013&M\u001b\u0005I%B\u0001\u001b8\u0013\tY\u0015J\u0001\bUKN$xI]8vaN#\u0018\r^3\u0011\u00055sE\u0002\u0001\u0003\u0006\u001f\u0002\u0011\r!\u0015\u0002\u0002'\u000e\u0001\u0011C\u0001*V!\t\u00115+\u0003\u0002U\u0007\n9aj\u001c;iS:<\u0007C\u0001\"W\u0013\t96IA\u0002B]f\fQb\u001c9uS>t\u0017\r\u001c,bYV,\u0007c\u0001\"[\u0019&\u00111l\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0002+\t\fGo\u00195Qe>\u001cWm]:j]\u001e$\u0016.\\3NgB\u0011!IX\u0005\u0003?\u000e\u0013A\u0001T8oO\u0006!RM^3oiRKW.Z,bi\u0016\u0014X.\u0019:l\u001bN\f1\u0002^5nK>,HoQ8oMB\u0011\u0001jY\u0005\u0003I&\u0013\u0011c\u0012:pkB\u001cF/\u0019;f)&lWm\\;u\u0003-A\u0017m\u001d+j[\u0016$w*\u001e;\u0016\u0003\u001d\u0004\"A\u00115\n\u0005%\u001c%a\u0002\"p_2,\u0017M\\\u0001\rQ\u0006\u001cH+[7fI>+H\u000fI\u0001\u0011o\u0006$XM]7be.\u0004&/Z:f]R\fa\u0001P5oSRtDc\u00028qcJ\u001cH/\u001e\t\u0004_\u0002aU\"A\u001a\t\u000baC\u0001\u0019A-\t\u000bqC\u0001\u0019A/\t\u000b\u0001D\u0001\u0019A/\t\u000b\u0005D\u0001\u0019\u00012\t\u000b\u0015D\u0001\u0019A4\t\u000b-D\u0001\u0019A4\u0002\u000bY\fG.^3\u0016\u00031\u000b\u0011B^1mk\u0016|F%Z9\u0015\u0005il\bC\u0001\"|\u0013\ta8I\u0001\u0003V]&$\bb\u0002@\u000b\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\n\u0014A\u0002<bYV,\u0007%A\u0004eK\u001aLg.\u001a3\u0002\u0017\u0011,g-\u001b8fI~#S-\u001d\u000b\u0004u\u0006\u001d\u0001b\u0002@\u000e\u0003\u0003\u0005\raZ\u0001\tI\u00164\u0017N\\3eA\u00059Q\u000f\u001d3bi\u0016$\u0017aC;qI\u0006$X\rZ0%KF$2A_A\t\u0011\u001dq\b#!AA\u0002\u001d\f\u0001\"\u001e9eCR,G\rI\u0001\be\u0016lwN^3e\u0003-\u0011X-\\8wK\u0012|F%Z9\u0015\u0007i\fY\u0002C\u0004\u007f'\u0005\u0005\t\u0019A4\u0002\u0011I,Wn\u001c<fI\u0002\n\u0001\u0003^5nK>,H\u000fV5nKN$\u0018-\u001c9\u0016\u0003u\u000bA\u0003^5nK>,H\u000fV5nKN$\u0018-\u001c9`I\u0015\fHc\u0001>\u0002(!9aPFA\u0001\u0002\u0004i\u0016!\u0005;j[\u0016|W\u000f\u001e+j[\u0016\u001cH/Y7qA\u00051Q\r_5tiN\f1aZ3u\u0003%9W\r^(qi&|g.F\u0001Z\u0003\u0019)\b\u000fZ1uKR\u0019!0a\u000e\t\r\u0005e2\u00041\u0001M\u0003!qWm\u001e,bYV,\u0017A\u0002:f[>4X\rF\u0001{\u0003I\u0019X\r\u001e+j[\u0016|W\u000f\u001e#ve\u0006$\u0018n\u001c8\u0015\u0007i\f\u0019\u0005\u0003\u0004\u0002Fu\u0001\r!X\u0001\u000bIV\u0014\u0018\r^5p]6\u001bHc\u0001>\u0002J!9\u00111\n\u0010A\u0002\u00055\u0013\u0001\u00033ve\u0006$\u0018n\u001c8\u0011\t\u0005=\u0013Q\f\b\u0005\u0003#\nI\u0006E\u0002\u0002T\rk!!!\u0016\u000b\u0007\u0005]\u0003+\u0001\u0004=e>|GOP\u0005\u0004\u00037\u001a\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002`\u0005\u0005$AB*ue&twMC\u0002\u0002\\\r\u000b1c]3u)&lWm\\;u)&lWm\u001d;b[B$2A_A4\u0011\u0019\tIg\ba\u0001;\u0006YA/[7fgR\fW\u000e]'t)\u0015Q\u0018QNA8\u0011\u0019\tI\u0007\ta\u0001;\"9\u0011\u0011\u000f\u0011A\u0002\u00055\u0013AE1eI&$\u0018n\u001c8bY\u0012+(/\u0019;j_:$2A_A;\u0011\u001d\t9(\ta\u0001\u0003s\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\t\u0005m\u00141Q\u0007\u0003\u0003{R1\u0001OA@\u0015\t\t\t)\u0001\u0003kCZ\f\u0017\u0002BAC\u0003{\u0012A\u0001R1uKR)!0!#\u0002\f\"9\u0011q\u000f\u0012A\u0002\u0005e\u0004bBA9E\u0001\u0007\u0011QJ\u0001\u0016O\u0016$8)\u001e:sK:$x+\u0019;fe6\f'o['t)\u0005i\u0016AG4fi\u000e+(O]3oiB\u0013xnY3tg&tw\rV5nK6\u001b\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u00055\u0013!C5t%\u0016lwN^3e\u0003%I7/\u00169eCR,G-A\u000bhKR$\u0016.\\3pkR$\u0016.\\3ti\u0006l\u0007/T:\u0016\u0005\u0005}\u0005#BAQ\u0003SkVBAAR\u0015\u0011\t\t)!*\u000b\u0007\u0005\u001d\u0016(A\u0002ba&LA!a+\u0002$\nAq\n\u001d;j_:\fG.A\u0007qCJ\u001cX\rR;sCRLwN\u001c\u000b\u0004;\u0006E\u0006bBA&S\u0001\u0007\u0011QJ\u0001\u001dG\",7m\u001b+j[\u0016|W\u000f\u001e+j[\u0016\u001cH/Y7q\u00032dwn^3e\u000399%o\\;q'R\fG/Z%na2\u0004\"a\u001c\u0017\u0014\u00051\nECAA\\\u00031quj\u0018+J\u001b\u0016\u001bF+Q'Q\u00035quj\u0018+J\u001b\u0016\u001bF+Q'QA\u0005\u00112M]3bi\u00164uN]*ue\u0016\fW.\u001b8h+\u0011\t)-a3\u0015\u001d\u0005\u001d\u0017QZAi\u0003'\f).a6\u0002ZB!q\u000eAAe!\ri\u00151\u001a\u0003\u0006\u001fB\u0012\r!\u0015\u0005\u00071B\u0002\r!a4\u0011\t\tS\u0016\u0011\u001a\u0005\u00069B\u0002\r!\u0018\u0005\u0006AB\u0002\r!\u0018\u0005\u0006CB\u0002\rA\u0019\u0005\u0006KB\u0002\ra\u001a\u0005\u0006WB\u0002\raZ\u0001\u000fGJ,\u0017\r^3G_J\u0014\u0015\r^2i)\u0019\ty.!9\u0002dB\u0019q\u000eA+\t\u000b\u0005\f\u0004\u0019\u00012\t\u000b-\f\u0004\u0019A4")
public class GroupStateImpl<S>
implements TestGroupState<S> {
    private final long batchProcessingTimeMs;
    private final long eventTimeWatermarkMs;
    private final GroupStateTimeout timeoutConf;
    private final boolean hasTimedOut;
    private final boolean watermarkPresent;
    private S value;
    private boolean defined;
    private boolean updated;
    private boolean removed;
    private long timeoutTimestamp;

    public static GroupStateImpl<Object> createForBatch(GroupStateTimeout timeoutConf, boolean watermarkPresent) {
        return GroupStateImpl$.MODULE$.createForBatch(timeoutConf, watermarkPresent);
    }

    public static <S> GroupStateImpl<S> createForStreaming(Option<S> optionalValue, long batchProcessingTimeMs, long eventTimeWatermarkMs, GroupStateTimeout timeoutConf, boolean hasTimedOut, boolean watermarkPresent) {
        return GroupStateImpl$.MODULE$.createForStreaming(optionalValue, batchProcessingTimeMs, eventTimeWatermarkMs, timeoutConf, hasTimedOut, watermarkPresent);
    }

    public static long NO_TIMESTAMP() {
        return GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }

    @Override
    public boolean hasTimedOut() {
        return this.hasTimedOut;
    }

    private S value() {
        return this.value;
    }

    private void value_$eq(S x$1) {
        this.value = x$1;
    }

    private boolean defined() {
        return this.defined;
    }

    private void defined_$eq(boolean x$1) {
        this.defined = x$1;
    }

    private boolean updated() {
        return this.updated;
    }

    private void updated_$eq(boolean x$1) {
        this.updated = x$1;
    }

    private boolean removed() {
        return this.removed;
    }

    private void removed_$eq(boolean x$1) {
        this.removed = x$1;
    }

    private long timeoutTimestamp() {
        return this.timeoutTimestamp;
    }

    private void timeoutTimestamp_$eq(long x$1) {
        this.timeoutTimestamp = x$1;
    }

    @Override
    public boolean exists() {
        return this.defined();
    }

    @Override
    public S get() {
        if (!this.defined()) {
            throw QueryExecutionErrors$.MODULE$.stateNotDefinedOrAlreadyRemovedError();
        }
        return this.value();
    }

    @Override
    public Option<S> getOption() {
        return this.defined() ? new Some(this.value()) : None$.MODULE$;
    }

    @Override
    public void update(S newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException("'null' is not a valid state value");
        }
        this.value_$eq(newValue);
        this.defined_$eq(true);
        this.updated_$eq(true);
        this.removed_$eq(false);
    }

    @Override
    public void remove() {
        this.defined_$eq(false);
        this.updated_$eq(false);
        this.removed_$eq(true);
    }

    @Override
    public void setTimeoutDuration(long durationMs) {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        ProcessingTimeTimeout$ processingTimeTimeout$ = ProcessingTimeTimeout$.MODULE$;
        if (groupStateTimeout == null ? processingTimeTimeout$ != null : !groupStateTimeout.equals(processingTimeTimeout$)) {
            throw QueryExecutionErrors$.MODULE$.cannotSetTimeoutDurationError();
        }
        if (durationMs <= 0L) {
            throw new IllegalArgumentException("Timeout duration must be positive");
        }
        this.timeoutTimestamp_$eq(durationMs + this.batchProcessingTimeMs);
    }

    @Override
    public void setTimeoutDuration(String duration) {
        this.setTimeoutDuration(this.parseDuration(duration));
    }

    @Override
    public void setTimeoutTimestamp(long timestampMs) {
        this.checkTimeoutTimestampAllowed();
        if (timestampMs <= 0L) {
            throw new IllegalArgumentException("Timeout timestamp must be positive");
        }
        if (this.eventTimeWatermarkMs != GroupStateImpl$.MODULE$.NO_TIMESTAMP() && timestampMs < this.eventTimeWatermarkMs) {
            throw new IllegalArgumentException(new StringBuilder(0).append(new StringBuilder(48).append("Timeout timestamp (").append(timestampMs).append(") cannot be earlier than the ").toString()).append(new StringBuilder(20).append("current watermark (").append(this.eventTimeWatermarkMs).append(")").toString()).toString());
        }
        this.timeoutTimestamp_$eq(timestampMs);
    }

    @Override
    public void setTimeoutTimestamp(long timestampMs, String additionalDuration) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(this.parseDuration(additionalDuration) + timestampMs);
    }

    @Override
    public void setTimeoutTimestamp(Date timestamp) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime());
    }

    @Override
    public void setTimeoutTimestamp(Date timestamp, String additionalDuration) {
        this.checkTimeoutTimestampAllowed();
        this.setTimeoutTimestamp(timestamp.getTime() + this.parseDuration(additionalDuration));
    }

    @Override
    public long getCurrentWatermarkMs() {
        if (!this.watermarkPresent) {
            throw QueryExecutionErrors$.MODULE$.cannotGetEventTimeWatermarkError();
        }
        return this.eventTimeWatermarkMs;
    }

    @Override
    public long getCurrentProcessingTimeMs() {
        return this.batchProcessingTimeMs;
    }

    public String toString() {
        return new StringBuilder(12).append("GroupState(").append(this.getOption().map((Function1 & Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable)() -> "<undefined>")).append(")").toString();
    }

    @Override
    public boolean isRemoved() {
        return this.removed();
    }

    @Override
    public boolean isUpdated() {
        return this.updated();
    }

    @Override
    public Optional<Object> getTimeoutTimestampMs() {
        return this.timeoutTimestamp() != GroupStateImpl$.MODULE$.NO_TIMESTAMP() ? Optional.of((Object)BoxesRunTime.boxToLong((long)this.timeoutTimestamp())) : Optional.empty();
    }

    private long parseDuration(String duration) {
        CalendarInterval cal = IntervalUtils$.MODULE$.stringToInterval(UTF8String.fromString((String)duration));
        if (IntervalUtils$.MODULE$.isNegative(cal, IntervalUtils$.MODULE$.isNegative$default$2())) {
            throw new IllegalArgumentException(new StringBuilder(32).append("Provided duration (").append(duration).append(") is negative").toString());
        }
        return IntervalUtils$.MODULE$.getDuration(cal, TimeUnit.MILLISECONDS, IntervalUtils$.MODULE$.getDuration$default$3());
    }

    private void checkTimeoutTimestampAllowed() {
        GroupStateTimeout groupStateTimeout = this.timeoutConf;
        EventTimeTimeout$ eventTimeTimeout$ = EventTimeTimeout$.MODULE$;
        if (groupStateTimeout == null ? eventTimeTimeout$ != null : !groupStateTimeout.equals(eventTimeTimeout$)) {
            throw QueryExecutionErrors$.MODULE$.cannotSetTimeoutTimestampError();
        }
    }

    public GroupStateImpl(Option<S> optionalValue, long batchProcessingTimeMs, long eventTimeWatermarkMs, GroupStateTimeout timeoutConf, boolean hasTimedOut, boolean watermarkPresent) {
        this.batchProcessingTimeMs = batchProcessingTimeMs;
        this.eventTimeWatermarkMs = eventTimeWatermarkMs;
        this.timeoutConf = timeoutConf;
        this.hasTimedOut = hasTimedOut;
        this.watermarkPresent = watermarkPresent;
        this.value = optionalValue.getOrElse((Function0 & Serializable)() -> null);
        this.defined = optionalValue.isDefined();
        this.updated = false;
        this.removed = false;
        this.timeoutTimestamp = GroupStateImpl$.MODULE$.NO_TIMESTAMP();
    }
}

