/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Locale;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.errors.QueryCompilationErrors$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.csv.CSVFileFormat;
import org.apache.spark.sql.execution.datasources.jdbc.JdbcRelationProvider;
import org.apache.spark.sql.execution.datasources.json.JsonFileFormat;
import org.apache.spark.sql.execution.datasources.orc.OrcFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.v2.orc.OrcDataSourceV2;
import org.apache.spark.sql.execution.streaming.sources.RateStreamProvider;
import org.apache.spark.sql.execution.streaming.sources.TextSocketSourceProvider;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.HadoopFSUtils$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.MapView;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class DataSource$
implements Logging,
Serializable {
    public static final DataSource$ MODULE$ = new DataSource$();
    private static final Map<String, String> backwardCompatibilityMap;
    private static final Set<String> spark2RemovedClasses;
    private static final String GLOB_PATHS_KEY;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        String jdbc = JdbcRelationProvider.class.getCanonicalName();
        String json = JsonFileFormat.class.getCanonicalName();
        String parquet = ParquetFileFormat.class.getCanonicalName();
        String csv = CSVFileFormat.class.getCanonicalName();
        String libsvm = "org.apache.spark.ml.source.libsvm.LibSVMFileFormat";
        String orc = "org.apache.spark.sql.hive.orc.OrcFileFormat";
        String nativeOrc = OrcFileFormat.class.getCanonicalName();
        String socket = TextSocketSourceProvider.class.getCanonicalName();
        String rate = RateStreamProvider.class.getCanonicalName();
        backwardCompatibilityMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.jdbc"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.jdbc.DefaultSource"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.jdbc.DefaultSource"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.jdbc"), (Object)jdbc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.json"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.json.DefaultSource"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.json"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.json.DefaultSource"), (Object)json), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.parquet"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.parquet.DefaultSource"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.parquet"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.parquet.DefaultSource"), (Object)parquet), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.hive.orc.DefaultSource"), (Object)orc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.hive.orc"), (Object)orc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.orc.DefaultSource"), (Object)nativeOrc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.datasources.orc"), (Object)nativeOrc), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.ml.source.libsvm.DefaultSource"), (Object)libsvm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.ml.source.libsvm"), (Object)libsvm), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"com.databricks.spark.csv"), (Object)csv), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.streaming.TextSocketSourceProvider"), (Object)socket), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.sql.execution.streaming.RateSourceProvider"), (Object)rate)}));
        spark2RemovedClasses = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"org.apache.spark.sql.DataFrame", "org.apache.spark.sql.sources.HadoopFsRelationProvider", "org.apache.spark.Logging"}));
        GLOB_PATHS_KEY = "__globPaths__";
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Seq<String> $lessinit$greater$default$3() {
        return package$.MODULE$.Nil();
    }

    public Option<StructType> $lessinit$greater$default$4() {
        return None$.MODULE$;
    }

    public Seq<String> $lessinit$greater$default$5() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<BucketSpec> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogTable> $lessinit$greater$default$8() {
        return None$.MODULE$;
    }

    private Map<String, String> backwardCompatibilityMap() {
        return backwardCompatibilityMap;
    }

    private Set<String> spark2RemovedClasses() {
        return spark2RemovedClasses;
    }

    /*
     * Unable to fully structure code
     */
    public Class<?> lookupDataSource(String provider, SQLConf conf) {
        block18: {
            block17: {
                var8_3 = (String)this.backwardCompatibilityMap().getOrElse((Object)provider, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$lookupDataSource$1(java.lang.String ), ()Ljava/lang/String;)((String)provider));
                if (!var8_3.equalsIgnoreCase("orc")) break block17;
                v0 = conf.getConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
                var9_4 = "native";
                if (v0 != null ? v0.equals(var9_4) == false : var9_4 != null) break block17;
                var6_5 = OrcDataSourceV2.class.getCanonicalName();
                break block18;
            }
            if (!var8_3.equalsIgnoreCase("orc")) ** GOTO lbl-1000
            v1 = conf.getConf(SQLConf$.MODULE$.ORC_IMPLEMENTATION());
            var10_6 = "hive";
            if (!(v1 != null ? v1.equals(var10_6) == false : var10_6 != null)) {
                var6_5 = "org.apache.spark.sql.hive.orc.OrcFileFormat";
            } else lbl-1000:
            // 2 sources

            {
                var6_5 = "com.databricks.spark.avro".equals(var8_3) != false && conf.replaceDatabricksSparkAvroEnabled() != false ? "org.apache.spark.sql.avro.AvroFileFormat" : var8_3;
            }
        }
        provider1 = var6_5;
        provider2 = new StringBuilder(14).append(provider1).append(".DefaultSource").toString();
        loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        serviceLoader = ServiceLoader.load(DataSourceRegister.class, loader);
        try {
            block24: {
                block19: {
                    var14_11 = ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(serviceLoader).asScala()).filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$lookupDataSource$2$adapted(java.lang.String org.apache.spark.sql.sources.DataSourceRegister ), (Lorg/apache/spark/sql/sources/DataSourceRegister;)Ljava/lang/Object;)((String)provider1))).toList();
                    v2 = package$.MODULE$.Nil();
                    var15_12 = var14_11;
                    if (v2 != null ? v2.equals(var15_12) == false : var15_12 != null) break block19;
                    try {
                        block20: {
                            block21: {
                                block23: {
                                    block22: {
                                        var16_13 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$lookupDataSource$3(java.lang.ClassLoader java.lang.String ), ()Ljava/lang/Class;)((ClassLoader)loader, (String)provider1)).orElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$lookupDataSource$4(java.lang.ClassLoader java.lang.String ), ()Lscala/util/Try;)((ClassLoader)loader, (String)provider2));
                                        if (var16_13 instanceof Success) break block20;
                                        if (!(var16_13 instanceof Failure)) break block21;
                                        var19_17 = (Failure)var16_13;
                                        error = var19_17.exception();
                                        if (provider1.startsWith("org.apache.spark.sql.hive.orc")) {
                                            throw QueryCompilationErrors$.MODULE$.orcNotUsedWithHiveEnabledError();
                                        }
                                        v3 = provider1.toLowerCase(Locale.ROOT);
                                        var21_19 = "avro";
                                        if (!(v3 == null ? var21_19 != null : v3.equals(var21_19) == false)) break block22;
                                        v4 = provider1;
                                        var22_20 = "com.databricks.spark.avro";
                                        if (!(v4 == null ? var22_20 != null : v4.equals(var22_20) == false)) break block22;
                                        v5 = provider1;
                                        var23_21 = "org.apache.spark.sql.avro";
                                        if (v5 != null ? v5.equals(var23_21) == false : var23_21 != null) break block23;
                                    }
                                    throw QueryCompilationErrors$.MODULE$.failedToFindAvroDataSourceError(provider1);
                                }
                                v6 = provider1.toLowerCase(Locale.ROOT);
                                var24_22 = "kafka";
                                if (!(v6 != null ? v6.equals(var24_22) == false : var24_22 != null)) {
                                    throw QueryCompilationErrors$.MODULE$.failedToFindKafkaDataSourceError(provider1);
                                }
                                throw QueryExecutionErrors$.MODULE$.dataSourceNotFoundError(provider1, error);
                            }
                            throw new MatchError((Object)var16_13);
                        }
                        var17_14 = (Success)var16_13;
                        var5_16 = dataSource = (Class<?>)var17_14.value();
                        v7 = var5_16;
                    }
                    catch (NoClassDefFoundError e) {
                        className = e.getMessage().replaceAll("/", ".");
                        if (this.spark2RemovedClasses().contains((Object)className)) {
                            throw QueryExecutionErrors$.MODULE$.removedClassInSpark2Error(className, (Throwable)e);
                        }
                        throw e;
                    }
                    var4_25 = v7;
                    break block24;
                }
                if (!(var14_11 instanceof .colon.colon)) ** GOTO lbl-1000
                var27_26 = (.colon.colon)var14_11;
                head = (DataSourceRegister)var27_26.head();
                var29_28 = var27_26.next$access$1();
                v8 = package$.MODULE$.Nil();
                var30_29 = var29_28;
                if (!(v8 != null ? v8.equals(var30_29) == false : var30_29 != null)) {
                    var4_25 = head.getClass();
                } else lbl-1000:
                // 2 sources

                {
                    sourceNames = var14_11.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$lookupDataSource$6(org.apache.spark.sql.sources.DataSourceRegister ), (Lorg/apache/spark/sql/sources/DataSourceRegister;)Ljava/lang/String;)());
                    internalSources = var14_11.filter((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$lookupDataSource$7$adapted(org.apache.spark.sql.sources.DataSourceRegister ), (Lorg/apache/spark/sql/sources/DataSourceRegister;)Ljava/lang/Object;)());
                    if (internalSources.size() != 1) {
                        throw QueryCompilationErrors$.MODULE$.findMultipleDataSourceError(provider1, (Seq)sourceNames);
                    }
                    this.logWarning((Function0<String>)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$lookupDataSource$8(java.lang.String scala.collection.immutable.List scala.collection.immutable.List ), ()Ljava/lang/String;)((String)provider1, (List)sourceNames, (List)internalSources));
                    var4_25 = internalSources.head().getClass();
                }
            }
            v9 = var4_25;
        }
        catch (Throwable var33_32) {
            var34_33 = var33_32;
            if (var34_33 instanceof ServiceConfigurationError && (var35_34 = (ServiceConfigurationError)var34_33).getCause() instanceof NoClassDefFoundError) {
                className = var35_34.getCause().getMessage().replaceAll("/", ".");
                if (this.spark2RemovedClasses().contains((Object)className)) {
                    throw QueryExecutionErrors$.MODULE$.incompatibleDataSourceRegisterError((Throwable)var35_34);
                }
                throw var35_34;
            }
            throw var33_32;
        }
        return v9;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<TableProvider> lookupDataSourceV2(String provider, SQLConf conf) {
        String[] useV1Sources = (String[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])((String)conf.getConf(SQLConf$.MODULE$.USE_V1_SOURCE_LIST())).toLowerCase(Locale.ROOT).split(",")), (Function1 & Serializable)x$19 -> x$19.trim(), ClassTag$.MODULE$.apply(String.class));
        Class<?> cls = this.lookupDataSource(provider, conf);
        Object obj = cls.newInstance();
        if (obj instanceof DataSourceRegister) {
            Object obj2 = obj;
            if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])useV1Sources), (Object)((DataSourceRegister)obj2).shortName())) {
                return None$.MODULE$;
            }
        }
        if (!(obj instanceof TableProvider)) return None$.MODULE$;
        Object obj3 = obj;
        if (ArrayOps$.MODULE$.contains$extension(Predef$.MODULE$.refArrayOps((Object[])useV1Sources), (Object)cls.getCanonicalName().toLowerCase(Locale.ROOT))) return None$.MODULE$;
        return new Some(obj3);
    }

    public String GLOB_PATHS_KEY() {
        return GLOB_PATHS_KEY;
    }

    public Seq<Path> checkAndGlobPathIfNecessary(Seq<String> pathStrings, Configuration hadoopConf, boolean checkEmptyGlobPath, boolean checkFilesExist, Integer numThreads, boolean enableGlobbing) {
        Seq allPaths;
        block10: {
            BoxedUnit boxedUnit;
            Seq seq;
            SparkHadoopUtil sparkHadoopUtil;
            Seq qualifiedPaths = (Seq)pathStrings.map((Function1 & Serializable)pathString -> {
                Path path = new Path(pathString);
                FileSystem fs = path.getFileSystem(hadoopConf);
                return path.makeQualified(fs.getUri(), fs.getWorkingDirectory());
            });
            Tuple2 tuple2 = qualifiedPaths.partition(arg_0 -> DataSource$.$anonfun$checkAndGlobPathIfNecessary$2$adapted(sparkHadoopUtil = SparkHadoopUtil$.MODULE$.get(), arg_0));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq globPaths = (Seq)tuple2._1();
            Seq nonGlobPaths = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)globPaths, (Object)nonGlobPaths);
            Tuple2 tuple23 = tuple22;
            Seq globPaths2 = (Seq)tuple23._1();
            Seq nonGlobPaths2 = (Seq)tuple23._2();
            try {
                seq = (Seq)ThreadUtils$.MODULE$.parmap(globPaths2, "globPath", Predef$.MODULE$.Integer2int(numThreads), (Function1 & Serializable)globPath -> {
                    Seq globResult;
                    FileSystem fs = globPath.getFileSystem(hadoopConf);
                    Seq seq = globResult = enableGlobbing ? SparkHadoopUtil$.MODULE$.get().globPath(fs, globPath) : qualifiedPaths;
                    if (checkEmptyGlobPath && globResult.isEmpty()) {
                        throw QueryCompilationErrors$.MODULE$.dataPathNotExistError(globPath.toString());
                    }
                    return globResult;
                }).flatten(Predef$.MODULE$.$conforms());
            }
            catch (SparkException e) {
                throw e.getCause();
            }
            Seq globbedPaths = seq;
            if (checkFilesExist) {
                try {
                    boxedUnit = ThreadUtils$.MODULE$.parmap(nonGlobPaths2, "checkPathsExist", Predef$.MODULE$.Integer2int(numThreads), (Function1 & Serializable)path -> {
                        DataSource$.$anonfun$checkAndGlobPathIfNecessary$4(hadoopConf, path);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (SparkException e) {
                    throw e.getCause();
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            allPaths = (Seq)globbedPaths.$plus$plus((IterableOnce)nonGlobPaths2);
            if (!checkFilesExist) break block10;
            Tuple2 tuple24 = allPaths.partition((Function1 & Serializable)path -> BoxesRunTime.boxToBoolean((boolean)HadoopFSUtils$.MODULE$.shouldFilterOutPathName(path.getName())));
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            Seq filteredOut = (Seq)tuple24._1();
            Seq filteredIn = (Seq)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)filteredOut, (Object)filteredIn);
            Tuple2 tuple26 = tuple25;
            Seq filteredOut2 = (Seq)tuple26._1();
            Seq filteredIn2 = (Seq)tuple26._2();
            if (filteredIn2.isEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(26).append("All paths were ignored:\n  ").append(filteredOut2.mkString("\n  ")).toString());
            } else {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Some paths were ignored:\n  ").append(filteredOut2.mkString("\n  ")).toString());
            }
        }
        return allPaths;
    }

    public Integer checkAndGlobPathIfNecessary$default$5() {
        return Predef$.MODULE$.int2Integer(40);
    }

    public CatalogStorageFormat buildStorageFormatFromOptions(Map<String, String> options) {
        Option path = CaseInsensitiveMap$.MODULE$.apply(options).get("path");
        MapView optionsWithoutPath = options.filterKeys((Function1 & Serializable)x$22 -> BoxesRunTime.boxToBoolean((boolean)DataSource$.$anonfun$buildStorageFormatFromOptions$1(x$22)));
        Option x$1 = path.map((Function1 & Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
        Map x$2 = optionsWithoutPath.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Option x$3 = CatalogStorageFormat$.MODULE$.empty().copy$default$2();
        Option x$4 = CatalogStorageFormat$.MODULE$.empty().copy$default$3();
        Option x$5 = CatalogStorageFormat$.MODULE$.empty().copy$default$4();
        boolean x$6 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
        return CatalogStorageFormat$.MODULE$.empty().copy(x$1, x$3, x$4, x$5, x$6, x$2);
    }

    public void validateSchema(StructType schema, SQLConf conf) {
        boolean shouldAllowEmptySchema = BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.ALLOW_EMPTY_SCHEMAS_FOR_WRITES()));
        if (!shouldAllowEmptySchema && DataSource$.hasEmptySchema$1(schema)) {
            throw QueryCompilationErrors$.MODULE$.writeEmptySchemasUnsupportedByDataSourceError();
        }
    }

    public Seq<Attribute> resolvePartitionColumns(Seq<Attribute> partitionColumns, Seq<Attribute> outputColumns, LogicalPlan plan, Function2<String, String, Object> resolver) {
        return (Seq)partitionColumns.map((Function1 & Serializable)col -> {
            Predef$.MODULE$.assert(col instanceof UnresolvedAttribute);
            UnresolvedAttribute unresolved = (UnresolvedAttribute)col;
            Predef$.MODULE$.assert(unresolved.nameParts().length() == 1);
            String name = (String)unresolved.nameParts().head();
            return (Attribute)outputColumns.find((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)DataSource$.$anonfun$resolvePartitionColumns$2(resolver, name, a))).getOrElse((Function0 & Serializable)() -> {
                throw QueryCompilationErrors$.MODULE$.cannotResolveAttributeError(name, ((IterableOnceOps)plan.output().map((Function1 & Serializable)x$23 -> x$23.name())).mkString(", "));
            });
        });
    }

    public DataSource apply(SparkSession sparkSession, String className, Seq<String> paths, Option<StructType> userSpecifiedSchema, Seq<String> partitionColumns, Option<BucketSpec> bucketSpec, Map<String, String> options, Option<CatalogTable> catalogTable) {
        return new DataSource(sparkSession, className, paths, userSpecifiedSchema, partitionColumns, bucketSpec, options, catalogTable);
    }

    public Seq<String> apply$default$3() {
        return package$.MODULE$.Nil();
    }

    public Option<StructType> apply$default$4() {
        return None$.MODULE$;
    }

    public Seq<String> apply$default$5() {
        return (Seq)package$.MODULE$.Seq().empty();
    }

    public Option<BucketSpec> apply$default$6() {
        return None$.MODULE$;
    }

    public Map<String, String> apply$default$7() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<CatalogTable> apply$default$8() {
        return None$.MODULE$;
    }

    public Option<Tuple8<SparkSession, String, Seq<String>, Option<StructType>, Seq<String>, Option<BucketSpec>, Map<String, String>, Option<CatalogTable>>> unapply(DataSource x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple8((Object)x$0.sparkSession(), (Object)x$0.className(), x$0.paths(), x$0.userSpecifiedSchema(), x$0.partitionColumns(), x$0.bucketSpec(), x$0.options(), x$0.catalogTable()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DataSource$.class);
    }

    public static final /* synthetic */ String $anonfun$lookupDataSource$1(String provider$1) {
        return provider$1;
    }

    public static final /* synthetic */ boolean $anonfun$lookupDataSource$2(String provider1$1, DataSourceRegister x$16) {
        return x$16.shortName().equalsIgnoreCase(provider1$1);
    }

    public static final /* synthetic */ Class $anonfun$lookupDataSource$3(ClassLoader loader$1, String provider1$1) {
        return loader$1.loadClass(provider1$1);
    }

    public static final /* synthetic */ Try $anonfun$lookupDataSource$4(ClassLoader loader$1, String provider2$1) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> loader$1.loadClass(provider2$1));
    }

    public static final /* synthetic */ String $anonfun$lookupDataSource$6(DataSourceRegister x$17) {
        return x$17.getClass().getName();
    }

    public static final /* synthetic */ boolean $anonfun$lookupDataSource$7(DataSourceRegister x$18) {
        return x$18.getClass().getName().startsWith("org.apache.spark");
    }

    public static final /* synthetic */ String $anonfun$lookupDataSource$8(String provider1$1, List sourceNames$1, List internalSources$1) {
        return new StringBuilder(0).append(new StringBuilder(32).append("Multiple sources found for ").append(provider1$1).append(" (").append(sourceNames$1.mkString(", ")).append("), ").toString()).append(new StringBuilder(41).append("defaulting to the internal datasource (").append(internalSources$1.head().getClass().getName()).append(").").toString()).toString();
    }

    public static final /* synthetic */ void $anonfun$checkAndGlobPathIfNecessary$4(Configuration hadoopConf$1, Path path) {
        FileSystem fs = path.getFileSystem(hadoopConf$1);
        if (!fs.exists(path)) {
            throw QueryCompilationErrors$.MODULE$.dataPathNotExistError(path.toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildStorageFormatFromOptions$1(String x$22) {
        String string = x$22.toLowerCase(Locale.ROOT);
        String string2 = "path";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$validateSchema$1(StructField x0$1) {
        boolean bl;
        DataType b;
        StructField structField = x0$1;
        if (structField != null && (b = structField.dataType()) instanceof StructType) {
            StructType structType = (StructType)b;
            bl = DataSource$.hasEmptySchema$1(structType);
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean hasEmptySchema$1(StructType schema) {
        return schema.size() == 0 || schema.exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DataSource$.$anonfun$validateSchema$1(x0$1)));
    }

    public static final /* synthetic */ boolean $anonfun$resolvePartitionColumns$2(Function2 resolver$1, String name$1, Attribute a) {
        return BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)a.name(), (Object)name$1));
    }

    private DataSource$() {
    }

    public static final /* synthetic */ Object $anonfun$lookupDataSource$2$adapted(String provider1$1, DataSourceRegister x$16) {
        return BoxesRunTime.boxToBoolean((boolean)DataSource$.$anonfun$lookupDataSource$2(provider1$1, x$16));
    }

    public static final /* synthetic */ Object $anonfun$lookupDataSource$7$adapted(DataSourceRegister x$18) {
        return BoxesRunTime.boxToBoolean((boolean)DataSource$.$anonfun$lookupDataSource$7(x$18));
    }

    public static final /* synthetic */ Object $anonfun$checkAndGlobPathIfNecessary$2$adapted(SparkHadoopUtil eta$0$1$1, Path pattern) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.isGlobPath(pattern));
    }
}

