/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.util.Locale;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StringType$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public final class TeradataDialect$
extends JdbcDialect
implements Product {
    public static final TeradataDialect$ MODULE$ = new TeradataDialect$();
    private static final Set<String> supportedAggregateFunctions;
    private static final Set<String> supportedFunctions;

    static {
        Product.$init$((Product)MODULE$);
        supportedAggregateFunctions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"MAX", "MIN", "SUM", "COUNT", "AVG", "VAR_POP", "VAR_SAMP", "STDDEV_POP", "STDDEV_SAMP", "COVAR_POP", "COVAR_SAMP", "CORR"}));
        supportedFunctions = MODULE$.supportedAggregateFunctions();
    }

    public String productElementName(int n) {
        return Product.productElementName$((Product)this, (int)n);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:teradata");
    }

    private Set<String> supportedAggregateFunctions() {
        return supportedAggregateFunctions;
    }

    private Set<String> supportedFunctions() {
        return supportedFunctions;
    }

    @Override
    public boolean isSupportedFunction(String funcName) {
        return this.supportedFunctions().contains((Object)funcName);
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        Object object = StringType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("VARCHAR(255)", 12)) : (BooleanType$.MODULE$.equals(dataType) ? Option$.MODULE$.apply((Object)new JdbcType("CHAR(1)", 1)) : None$.MODULE$);
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String getTruncateQuery(String table, Option<Object> cascade) {
        return new StringBuilder(16).append("DELETE FROM ").append(table).append(" ALL").toString();
    }

    @Override
    public Option<Object> getTruncateQuery$default$2() {
        return this.isCascadingTruncateTable();
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("RENAME TABLE ").append(oldTable).append(" TO ").append(newTable).toString();
    }

    @Override
    public String getLimitClause(Integer limit) {
        return "";
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        None$ none$;
        int n = sqlType;
        switch (n) {
            case 2: {
                if (md == null) {
                    none$ = new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                    break;
                }
                long scale = md.build().getLong("scale");
                if (size == 40) {
                    if (scale == 0L) {
                        none$ = new Some((Object)DecimalType$.MODULE$.SYSTEM_DEFAULT());
                        break;
                    }
                    none$ = new Some((Object)new DecimalType(DecimalType$.MODULE$.MAX_PRECISION(), (int)scale));
                    break;
                }
                none$ = new Some((Object)new DecimalType(size, (int)scale));
                break;
            }
            default: {
                none$ = None$.MODULE$;
                break;
            }
        }
        return none$;
    }

    public String productPrefix() {
        return "TeradataDialect";
    }

    public int productArity() {
        return 0;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        Object object = Statics.ioobe((int)x$1);
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TeradataDialect$;
    }

    public int hashCode() {
        return -1014754660;
    }

    public String toString() {
        return "TeradataDialect";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TeradataDialect$.class);
    }

    private TeradataDialect$() {
    }
}

