/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.receiver;

import java.nio.ByteBuffer;
import org.apache.spark.Logging;
import org.apache.spark.SparkException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StreamBlockId;
import org.apache.spark.streaming.receiver.ArrayBufferBlock;
import org.apache.spark.streaming.receiver.BlockManagerBasedStoreResult;
import org.apache.spark.streaming.receiver.ByteBufferBlock;
import org.apache.spark.streaming.receiver.CountingIterator;
import org.apache.spark.streaming.receiver.IteratorBlock;
import org.apache.spark.streaming.receiver.ReceivedBlock;
import org.apache.spark.streaming.receiver.ReceivedBlockHandler;
import org.apache.spark.streaming.receiver.ReceivedBlockStoreResult;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001)3Q!\u0001\u0002\u0001\t1\u0011QD\u00117pG.l\u0015M\\1hKJ\u0014\u0015m]3e\u00052|7m\u001b%b]\u0012dWM\u001d\u0006\u0003\u0007\u0011\t\u0001B]3dK&4XM\u001d\u0006\u0003\u000b\u0019\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001cB\u0001A\u0007\u0014/A\u0011a\"E\u0007\u0002\u001f)\t\u0001#A\u0003tG\u0006d\u0017-\u0003\u0002\u0013\u001f\t1\u0011I\\=SK\u001a\u0004\"\u0001F\u000b\u000e\u0003\tI!A\u0006\u0002\u0003)I+7-Z5wK\u0012\u0014En\\2l\u0011\u0006tG\r\\3s!\tA\u0012$D\u0001\u0007\u0013\tQbAA\u0004M_\u001e<\u0017N\\4\t\u0011q\u0001!\u0011!Q\u0001\ny\tAB\u00197pG.l\u0015M\\1hKJ\u001c\u0001\u0001\u0005\u0002 E5\t\u0001E\u0003\u0002\"\r\u000591\u000f^8sC\u001e,\u0017BA\u0012!\u00051\u0011En\\2l\u001b\u0006t\u0017mZ3s\u0011!)\u0003A!A!\u0002\u00131\u0013\u0001D:u_J\fw-\u001a'fm\u0016d\u0007CA\u0010(\u0013\tA\u0003E\u0001\u0007Ti>\u0014\u0018mZ3MKZ,G\u000eC\u0003+\u0001\u0011\u00051&\u0001\u0004=S:LGO\u0010\u000b\u0004Y5r\u0003C\u0001\u000b\u0001\u0011\u0015a\u0012\u00061\u0001\u001f\u0011\u0015)\u0013\u00061\u0001'\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003)\u0019Ho\u001c:f\u00052|7m\u001b\u000b\u0004eUR\u0004C\u0001\u000b4\u0013\t!$A\u0001\rSK\u000e,\u0017N^3e\u00052|7m[*u_J,'+Z:vYRDQAN\u0018A\u0002]\nqA\u00197pG.LE\r\u0005\u0002 q%\u0011\u0011\b\t\u0002\u000e'R\u0014X-Y7CY>\u001c7.\u00133\t\u000bmz\u0003\u0019\u0001\u001f\u0002\u000b\tdwnY6\u0011\u0005Qi\u0014B\u0001 \u0003\u00055\u0011VmY3jm\u0016$'\t\\8dW\")\u0001\t\u0001C\u0001\u0003\u0006\u00012\r\\3b]V\u0004x\n\u001c3CY>\u001c7n\u001d\u000b\u0003\u0005\u0016\u0003\"AD\"\n\u0005\u0011{!\u0001B+oSRDQAR A\u0002\u001d\u000b!\u0002\u001e5sKNDG+[7f!\tq\u0001*\u0003\u0002J\u001f\t!Aj\u001c8h\u0001")
public class BlockManagerBasedBlockHandler
implements ReceivedBlockHandler,
Logging {
    private final BlockManager blockManager;
    private final StorageLevel storageLevel;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    @Override
    public ReceivedBlockStoreResult storeBlock(StreamBlockId blockId, ReceivedBlock block) {
        ReceivedBlock receivedBlock;
        block7: {
            Seq seq;
            Option<Object> numRecords2;
            block5: {
                block6: {
                    block4: {
                        numRecords2 = None$.MODULE$;
                        receivedBlock = block;
                        if (!(receivedBlock instanceof ArrayBufferBlock)) break block4;
                        ArrayBufferBlock arrayBufferBlock = (ArrayBufferBlock)receivedBlock;
                        ArrayBuffer<?> arrayBuffer = arrayBufferBlock.arrayBuffer();
                        numRecords2 = new Some((Object)BoxesRunTime.boxToLong((long)arrayBuffer.size()));
                        seq = this.blockManager.putIterator((BlockId)blockId, arrayBuffer.iterator(), this.storageLevel, true, this.blockManager.putIterator$default$5());
                        break block5;
                    }
                    if (!(receivedBlock instanceof IteratorBlock)) break block6;
                    IteratorBlock iteratorBlock = (IteratorBlock)receivedBlock;
                    Iterator<Object> iterator = iteratorBlock.iterator();
                    CountingIterator<Object> countIterator = new CountingIterator<Object>(iterator);
                    Seq putResult = this.blockManager.putIterator((BlockId)blockId, countIterator, this.storageLevel, true, this.blockManager.putIterator$default$5());
                    numRecords2 = countIterator.count();
                    seq = putResult;
                    break block5;
                }
                if (!(receivedBlock instanceof ByteBufferBlock)) break block7;
                ByteBufferBlock byteBufferBlock = (ByteBufferBlock)receivedBlock;
                ByteBuffer byteBuffer = byteBufferBlock.byteBuffer();
                seq = this.blockManager.putBytes((BlockId)blockId, byteBuffer, this.storageLevel, true, this.blockManager.putBytes$default$5());
            }
            Seq putResult = seq;
            if (((SeqLike)putResult.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final BlockId apply(Tuple2<BlockId, BlockStatus> x$1) {
                    return (BlockId)x$1._1();
                }
            }, Seq$.MODULE$.canBuildFrom())).contains((Object)blockId)) {
                return new BlockManagerBasedStoreResult(blockId, numRecords2);
            }
            throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not store ", " to block manager with storage level ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blockId, this.storageLevel})));
        }
        throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not store ", " to block manager, unexpected block type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{blockId, receivedBlock.getClass().getName()})));
    }

    @Override
    public void cleanupOldBlocks(long threshTime) {
    }

    public BlockManagerBasedBlockHandler(BlockManager blockManager, StorageLevel storageLevel) {
        this.blockManager = blockManager;
        this.storageLevel = storageLevel;
        Logging.class.$init$((Logging)this);
    }
}

