/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.transport.socket.nio.NioSocketAcceptor;
import org.apache.sshd.common.AbstractFactoryManager;
import org.apache.sshd.common.Cipher;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.AES128CBC;
import org.apache.sshd.common.cipher.AES192CBC;
import org.apache.sshd.common.cipher.AES256CBC;
import org.apache.sshd.common.cipher.BlowfishCBC;
import org.apache.sshd.common.cipher.TripleDESCBC;
import org.apache.sshd.common.compression.CompressionNone;
import org.apache.sshd.common.keyprovider.FileKeyPairProvider;
import org.apache.sshd.common.mac.HMACMD5;
import org.apache.sshd.common.mac.HMACMD596;
import org.apache.sshd.common.mac.HMACSHA1;
import org.apache.sshd.common.mac.HMACSHA196;
import org.apache.sshd.common.random.BouncyCastleRandom;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.random.SingletonRandomFactory;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureRSA;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PasswordAuthenticator;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.ServerChannel;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.SessionFactory;
import org.apache.sshd.server.ShellFactory;
import org.apache.sshd.server.UserAuth;
import org.apache.sshd.server.auth.UserAuthPassword;
import org.apache.sshd.server.auth.UserAuthPublicKey;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.kex.DHG1;
import org.apache.sshd.server.kex.DHG14;
import org.apache.sshd.server.shell.ProcessShellFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshServer
extends AbstractFactoryManager
implements ServerFactoryManager {
    private IoAcceptor acceptor;
    private int port;
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private List<NamedFactory<ServerChannel>> channelFactories;
    private ShellFactory shellFactory;
    private SessionFactory sessionFactory;
    private CommandFactory commandFactory;
    private PasswordAuthenticator passwordAuthenticator;
    private PublickeyAuthenticator publickeyAuthenticator;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public List<NamedFactory<ServerChannel>> getChannelFactories() {
        return this.channelFactories;
    }

    public void setChannelFactories(List<NamedFactory<ServerChannel>> channelFactories) {
        this.channelFactories = channelFactories;
    }

    @Override
    public ShellFactory getShellFactory() {
        return this.shellFactory;
    }

    public void setShellFactory(ShellFactory shellFactory) {
        this.shellFactory = shellFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.passwordAuthenticator;
    }

    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }

    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    protected void checkConfig() {
        if (this.getPort() < 0) {
            throw new IllegalArgumentException("Bad port number: " + this.port);
        }
        if (this.getKeyExchangeFactories() == null) {
            throw new IllegalArgumentException("KeyExchangeFactories not set");
        }
        if (this.getUserAuthFactories() == null) {
            throw new IllegalArgumentException("UserAuthFactories not set");
        }
        if (this.getCipherFactories() == null) {
            throw new IllegalArgumentException("CipherFactories not set");
        }
        if (this.getCompressionFactories() == null) {
            throw new IllegalArgumentException("CompressionFactories not set");
        }
        if (this.getMacFactories() == null) {
            throw new IllegalArgumentException("MacFactories not set");
        }
        if (this.getChannelFactories() == null) {
            throw new IllegalArgumentException("ChannelFactories not set");
        }
        if (this.getRandomFactory() == null) {
            throw new IllegalArgumentException("RandomFactory not set");
        }
        if (this.getKeyPairProvider() == null) {
            throw new IllegalArgumentException("HostKeyProvider not set");
        }
    }

    public void start() throws IOException {
        this.checkConfig();
        this.acceptor = new NioSocketAcceptor();
        SessionFactory handler = this.sessionFactory;
        if (handler == null) {
            handler = new SessionFactory();
        }
        handler.setServer(this);
        this.acceptor.setHandler((IoHandler)handler);
        this.acceptor.bind((SocketAddress)new InetSocketAddress(this.port));
        if (this.port == 0) {
            this.port = ((InetSocketAddress)this.acceptor.getLocalAddress()).getPort();
        }
    }

    public void stop() {
        this.acceptor.dispose();
        this.acceptor = null;
    }

    public static SshServer setUpDefaultServer() {
        SshServer sshd = new SshServer();
        if (SecurityUtils.isBouncyCastleRegistered()) {
            sshd.setKeyExchangeFactories(Arrays.asList(new DHG14.Factory(), new DHG1.Factory()));
            sshd.setRandomFactory(new SingletonRandomFactory(new BouncyCastleRandom.Factory()));
        } else {
            sshd.setKeyExchangeFactories(Arrays.asList(new DHG1.Factory()));
            sshd.setRandomFactory(new SingletonRandomFactory(new JceRandom.Factory()));
        }
        sshd.setUserAuthFactories(Arrays.asList(new UserAuthPassword.Factory(), new UserAuthPublicKey.Factory()));
        SshServer.setUpDefaultCiphers(sshd);
        sshd.setCompressionFactories(Arrays.asList(new CompressionNone.Factory()));
        sshd.setMacFactories(Arrays.asList(new HMACMD5.Factory(), new HMACSHA1.Factory(), new HMACMD596.Factory(), new HMACSHA196.Factory()));
        sshd.setChannelFactories(Arrays.asList(new ChannelSession.Factory()));
        sshd.setSignatureFactories(Arrays.asList(new SignatureDSA.Factory(), new SignatureRSA.Factory()));
        return sshd;
    }

    private static void setUpDefaultCiphers(SshServer sshd) {
        LinkedList<NamedFactory<Cipher>> avail = new LinkedList<NamedFactory<Cipher>>();
        avail.add(new AES128CBC.Factory());
        avail.add(new TripleDESCBC.Factory());
        avail.add(new BlowfishCBC.Factory());
        avail.add(new AES192CBC.Factory());
        avail.add(new AES256CBC.Factory());
        Iterator i = avail.iterator();
        while (i.hasNext()) {
            NamedFactory f = (NamedFactory)i.next();
            try {
                Cipher c = (Cipher)f.create();
                byte[] key = new byte[c.getBlockSize()];
                byte[] iv = new byte[c.getIVSize()];
                c.init(Cipher.Mode.Encrypt, key, iv);
            }
            catch (InvalidKeyException e) {
                i.remove();
            }
            catch (Exception e) {
                i.remove();
            }
        }
        sshd.setCipherFactories(avail);
    }

    public static void main(String[] args) throws Exception {
        int port = 8000;
        boolean error = false;
        for (int i = 0; i < args.length; ++i) {
            if ("-p".equals(args[i])) {
                if (i + 1 >= args.length) {
                    System.err.println("option requires an argument: " + args[i]);
                    break;
                }
            } else {
                if (args[i].startsWith("-")) {
                    System.err.println("illegal option: " + args[i]);
                    error = true;
                    break;
                }
                System.err.println("extra argument: " + args[i]);
                error = true;
                break;
            }
            port = Integer.parseInt(args[++i]);
        }
        if (error) {
            System.err.println("usage: sshd [-p port]");
            System.exit(-1);
        }
        SshServer sshd = SshServer.setUpDefaultServer();
        sshd.setPort(port);
        sshd.setKeyPairProvider(new FileKeyPairProvider(new String[]{"/etc/ssh_host_rsa_key", "/etc/ssh_host_dsa_key"}));
        sshd.setShellFactory(new ProcessShellFactory(new String[]{"/bin/sh", "-i", "-l"}));
        sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            public Object authenticate(String username, String password) {
                return username != null && username.equals(password) ? username : null;
            }
        });
        sshd.start();
    }
}

