/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.channel;

import org.apache.sshd.client.channel.AbstractClientChannel;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.util.Buffer;

public class ChannelSession
extends AbstractClientChannel {
    private Thread streamPumper;

    public ChannelSession() {
        super("session");
    }

    public OpenFuture open() throws Exception {
        if (this.in == null || this.out == null || this.err == null) {
            throw new IllegalStateException("in, out and err streams should be set before openeing channel");
        }
        return this.internalOpen();
    }

    protected void doOpenShell() throws Exception {
        this.streamPumper = new Thread("ClientInputStreamPump"){

            public void run() {
                ChannelSession.this.pumpInputStream();
            }
        };
        this.streamPumper.setDaemon(true);
        this.streamPumper.start();
    }

    protected void doClose() {
        super.doClose();
        if (this.streamPumper != null) {
            this.streamPumper.interrupt();
            this.streamPumper = null;
        }
    }

    protected void pumpInputStream() {
        try {
            while (!this.closeFuture.isClosed()) {
                Buffer buffer = this.session.createBuffer(SshConstants.Message.SSH_MSG_CHANNEL_DATA);
                buffer.putInt(this.recipient);
                int wpos1 = buffer.wpos();
                buffer.putInt(0);
                int wpos2 = buffer.wpos();
                buffer.wpos(wpos2 + this.remoteWindow.getPacketSize());
                int len = this.in.read(buffer.array(), wpos2, this.remoteWindow.getPacketSize());
                if (len <= 0) continue;
                buffer.wpos(wpos1);
                buffer.putInt(len);
                buffer.wpos(wpos2 + len);
                this.remoteWindow.waitAndConsume(len);
                this.log.debug("Send SSH_MSG_CHANNEL_DATA on channel {}", (Object)this.id);
                this.session.writePacket(buffer);
            }
        }
        catch (Exception e) {
            this.close(false);
        }
    }
}

