/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.command;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.apache.sshd.server.CommandFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCommand
implements CommandFactory.Command,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(ScpCommand.class);
    private boolean optR;
    private boolean optT;
    private boolean optF;
    private boolean optV;
    private boolean optP;
    private File root;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private CommandFactory.ExitCallback callback;
    private IOException error;

    public ScpCommand(String[] args) {
        if (log.isDebugEnabled()) {
            log.debug("Executing command {}", Arrays.asList(args));
        }
        this.root = new File(".");
        for (int i = 1; i < args.length; ++i) {
            if (args[i].charAt(0) == '-') {
                block8: for (int j = 1; j < args[i].length(); ++j) {
                    switch (args[i].charAt(j)) {
                        case 'f': {
                            this.optF = true;
                            continue block8;
                        }
                        case 'p': {
                            this.optP = true;
                            continue block8;
                        }
                        case 'r': {
                            this.optR = true;
                            continue block8;
                        }
                        case 't': {
                            this.optT = true;
                            continue block8;
                        }
                        case 'v': {
                            this.optV = true;
                        }
                    }
                }
            } else if (i == args.length - 1) {
                this.root = new File(args[args.length - 1]);
            }
            if (this.optF || this.optT) continue;
            this.error = new IOException("Either -f or -t option should be set");
        }
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public void setExitCallback(CommandFactory.ExitCallback callback) {
        this.callback = callback;
    }

    public void start() throws IOException {
        if (this.error != null) {
            throw this.error;
        }
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block14: {
            try {
                if (this.optT && !this.optR) {
                    this.ack();
                    this.writeFile(this.readLine(), this.root);
                    break block14;
                }
                if (this.optT && this.optR) {
                    this.ack();
                    this.writeDir(this.readLine(), this.root);
                    break block14;
                }
                if (this.optF) {
                    if (!this.root.exists()) {
                        throw new IOException(this.root + ": no such file or directory");
                    }
                    if (this.root.isFile()) {
                        this.readFile(this.root);
                        break block14;
                    }
                    if (this.root.isDirectory()) {
                        if (!this.optR) {
                            throw new IOException(this.root + " not a regular file");
                        }
                        this.readDir(this.root);
                        break block14;
                    }
                    throw new IOException(this.root + ": unknown file type");
                }
                throw new IOException("Unsupported mode");
            }
            catch (IOException e) {
                try {
                    this.out.write(2);
                    this.out.write(e.getMessage().getBytes());
                    this.out.write(10);
                    this.out.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                log.info("Error in scp command", (Throwable)e);
            }
            finally {
                this.callback.onExit(0);
            }
        }
    }

    private void writeDir(String header, File path) throws IOException {
        File file;
        if (log.isDebugEnabled()) {
            log.debug("Writing dir {}", (Object)path);
        }
        if (!header.startsWith("D")) {
            throw new IOException("Expected a D message but got '" + header + "'");
        }
        String perms = header.substring(1, 5);
        int length = Integer.parseInt(header.substring(6, header.indexOf(32, 6)));
        String name = header.substring(header.indexOf(32, 6) + 1);
        if (length != 0) {
            throw new IOException("Expected 0 length for directory but got " + length);
        }
        if (path.exists() && path.isDirectory()) {
            file = new File(path, name);
        } else if (!path.exists() && path.getParentFile().exists() && path.getParentFile().isDirectory()) {
            file = path;
        } else {
            throw new IOException("Can not write to " + path);
        }
        if (!(file.exists() && file.isDirectory() || file.mkdir())) {
            throw new IOException("Could not create directory " + file);
        }
        this.ack();
        while (true) {
            if ((header = this.readLine()).startsWith("C")) {
                this.writeFile(header, file);
                continue;
            }
            if (!header.startsWith("D")) break;
            this.writeDir(header, file);
        }
        if (!header.equals("E")) {
            throw new IOException("Unexpected message: '" + header + "'");
        }
        this.ack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String header, File path) throws IOException {
        File file;
        if (log.isDebugEnabled()) {
            log.debug("Writing file {}", (Object)path);
        }
        if (!header.startsWith("C")) {
            throw new IOException("Expected a C message but got '" + header + "'");
        }
        String perms = header.substring(1, 5);
        int length = Integer.parseInt(header.substring(6, header.indexOf(32, 6)));
        String name = header.substring(header.indexOf(32, 6) + 1);
        if (path.exists() && path.isDirectory()) {
            file = new File(path, name);
        } else if (path.exists() && path.isFile()) {
            file = path;
        } else if (!path.exists() && path.getParentFile().exists() && path.getParentFile().isDirectory()) {
            file = path;
        } else {
            throw new IOException("Can not write to " + path);
        }
        FileOutputStream os = new FileOutputStream(file);
        try {
            this.ack();
            byte[] buffer = new byte[8192];
            while (length > 0) {
                int len = Math.min(length, buffer.length);
                if ((len = this.in.read(buffer, 0, len)) <= 0) {
                    throw new IOException("End of stream reached");
                }
                ((OutputStream)os).write(buffer, 0, len);
                length -= len;
            }
        }
        finally {
            ((OutputStream)os).close();
        }
        this.ack();
        this.readAck();
    }

    private String readLine() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int c;
        while ((c = this.in.read()) != 10) {
            if (c == -1) {
                throw new IOException("End of stream");
            }
            baos.write(c);
        }
        return baos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(File path) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Reading file {}", (Object)path);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("C");
        buf.append("0644");
        buf.append(" ");
        buf.append(path.length());
        buf.append(" ");
        buf.append(path.getName());
        buf.append("\n");
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        this.readAck();
        FileInputStream is = new FileInputStream(path);
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = ((InputStream)is).read(buffer, 0, buffer.length)) != -1) {
                this.out.write(buffer, 0, len);
            }
        }
        finally {
            ((InputStream)is).close();
        }
        this.ack();
        this.readAck();
    }

    private void readDir(File path) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Reading directory {}", (Object)path);
        }
        StringBuffer buf = new StringBuffer();
        buf.append("D");
        buf.append("0755");
        buf.append(" ");
        buf.append("0");
        buf.append(" ");
        buf.append(path.getName());
        buf.append("\n");
        this.out.write(buf.toString().getBytes());
        this.out.flush();
        this.readAck();
        for (File child : path.listFiles()) {
            if (child.isFile()) {
                this.readFile(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            this.readDir(child);
        }
        this.out.write("E\n".getBytes());
        this.out.flush();
        this.readAck();
    }

    private void ack() throws IOException {
        this.out.write(0);
        this.out.flush();
    }

    private void readAck() throws IOException {
        int c = this.in.read();
        switch (c) {
            case 0: {
                break;
            }
            case 1: {
                System.out.println("Received warning: " + this.readLine());
                break;
            }
            case 2: {
                throw new IOException("Received nack: " + this.readLine());
            }
        }
    }
}

