/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.util.Collections;
import java.util.List;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.kex.KeyExchange;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;

public abstract class AbstractKexFactoryManager
extends AbstractInnerCloseable
implements KexFactoryManager {
    private final KexFactoryManager delegate;
    private List<NamedFactory<KeyExchange>> keyExchangeFactories;
    private List<NamedFactory<Cipher>> cipherFactories;
    private List<NamedFactory<Compression>> compressionFactories;
    private List<NamedFactory<Mac>> macFactories;
    private List<NamedFactory<Signature>> signatureFactories;

    protected AbstractKexFactoryManager() {
        this(null);
    }

    protected AbstractKexFactoryManager(KexFactoryManager delegate) {
        this.delegate = delegate;
    }

    protected KexFactoryManager getDelegate() {
        return this.delegate;
    }

    @Override
    public List<NamedFactory<KeyExchange>> getKeyExchangeFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(KeyExchange.class, this.keyExchangeFactories, parent == null ? Collections.emptyList() : parent.getKeyExchangeFactories());
    }

    @Override
    public void setKeyExchangeFactories(List<NamedFactory<KeyExchange>> keyExchangeFactories) {
        this.keyExchangeFactories = keyExchangeFactories;
    }

    @Override
    public List<NamedFactory<Cipher>> getCipherFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(Cipher.class, this.cipherFactories, parent == null ? Collections.emptyList() : parent.getCipherFactories());
    }

    @Override
    public void setCipherFactories(List<NamedFactory<Cipher>> cipherFactories) {
        this.cipherFactories = cipherFactories;
    }

    @Override
    public List<NamedFactory<Compression>> getCompressionFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(Compression.class, this.compressionFactories, parent == null ? Collections.emptyList() : parent.getCompressionFactories());
    }

    @Override
    public void setCompressionFactories(List<NamedFactory<Compression>> compressionFactories) {
        this.compressionFactories = compressionFactories;
    }

    @Override
    public List<NamedFactory<Mac>> getMacFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(Mac.class, this.macFactories, parent == null ? Collections.emptyList() : parent.getMacFactories());
    }

    @Override
    public void setMacFactories(List<NamedFactory<Mac>> macFactories) {
        this.macFactories = macFactories;
    }

    public List<NamedFactory<Signature>> getSignatureFactories() {
        KexFactoryManager parent = this.getDelegate();
        return this.resolveEffectiveFactories(Signature.class, this.signatureFactories, parent == null ? Collections.emptyList() : parent.getSignatureFactories());
    }

    public void setSignatureFactories(List<NamedFactory<Signature>> signatureFactories) {
        this.signatureFactories = signatureFactories;
    }

    protected <V> List<NamedFactory<V>> resolveEffectiveFactories(Class<V> factoryType, List<NamedFactory<V>> local, List<NamedFactory<V>> inherited) {
        if (GenericUtils.isEmpty(local)) {
            return inherited;
        }
        return local;
    }

    protected <V> V resolveEffectiveProvider(Class<V> providerType, V local, V inherited) {
        if (local == null) {
            return inherited;
        }
        return local;
    }
}

