/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.channel.ClientChannelPendingMessagesQueue;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.forward.ForwardingFilter;
import org.apache.sshd.common.forward.LocalForwardingEntry;
import org.apache.sshd.common.forward.PortForwardingEventListener;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.forward.PortForwardingEventListenerManagerHolder;
import org.apache.sshd.common.forward.SocksProxy;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.forward.TcpipForwardingExceptionMarker;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoHandlerFactory;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionHolder;
import org.apache.sshd.common.util.EventListenerUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Invoker;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractInnerCloseable;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.slf4j.Logger;

public class DefaultForwardingFilter
extends AbstractInnerCloseable
implements ForwardingFilter,
SessionHolder<Session>,
PortForwardingEventListenerManager {
    public static final String FORWARD_REQUEST_TIMEOUT = "tcpip-forward-request-timeout";
    public static final long DEFAULT_FORWARD_REQUEST_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);
    public static final Set<ClientChannelEvent> STATIC_IO_MSG_RECEIVED_EVENTS = Collections.unmodifiableSet(EnumSet.of(ClientChannelEvent.OPENED, ClientChannelEvent.CLOSED));
    private final ConnectionService service;
    private final IoHandlerFactory socksProxyIoHandlerFactory = () -> new SocksProxy(this.getConnectionService());
    private final Session sessionInstance;
    private final Object localLock = new Object();
    private final Map<Integer, SshdSocketAddress> localToRemote = new TreeMap(Comparator.naturalOrder());
    private final Map<Integer, InetSocketAddress> boundLocals = new TreeMap(Comparator.naturalOrder());
    private final Object dynamicLock = new Object();
    private final Map<Integer, SshdSocketAddress> remoteToLocal = new TreeMap(Comparator.naturalOrder());
    private final Map<Integer, SocksProxy> dynamicLocal = new TreeMap(Comparator.naturalOrder());
    private final Map<Integer, InetSocketAddress> boundDynamic = new TreeMap(Comparator.naturalOrder());
    private final Set<LocalForwardingEntry> localForwards = new HashSet<LocalForwardingEntry>();
    private final IoHandlerFactory staticIoHandlerFactory = () -> new StaticIoHandler();
    private final Collection<PortForwardingEventListener> listeners = new CopyOnWriteArraySet<PortForwardingEventListener>();
    private final Collection<PortForwardingEventListenerManager> managersHolder = new CopyOnWriteArraySet<PortForwardingEventListenerManager>();
    private final PortForwardingEventListener listenerProxy;
    private IoAcceptor acceptor;

    public DefaultForwardingFilter(ConnectionService service) {
        this.service = Objects.requireNonNull(service, "No connection service");
        this.sessionInstance = (Session)Objects.requireNonNull(service.getSession(), "No session");
        this.listenerProxy = (PortForwardingEventListener)EventListenerUtils.proxyWrapper(PortForwardingEventListener.class, (ClassLoader)this.getClass().getClassLoader(), this.listeners);
    }

    @Override
    public PortForwardingEventListener getPortForwardingEventListenerProxy() {
        return this.listenerProxy;
    }

    @Override
    public void addPortForwardingEventListener(PortForwardingEventListener listener) {
        this.listeners.add(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public void removePortForwardingEventListener(PortForwardingEventListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(PortForwardingEventListener.validateListener(listener));
    }

    @Override
    public Collection<PortForwardingEventListenerManager> getRegisteredManagers() {
        return this.managersHolder.isEmpty() ? Collections.emptyList() : new ArrayList<PortForwardingEventListenerManager>(this.managersHolder);
    }

    @Override
    public boolean addPortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        return this.managersHolder.add(Objects.requireNonNull(manager, "No manager"));
    }

    @Override
    public boolean removePortForwardingEventListenerManager(PortForwardingEventListenerManager manager) {
        if (manager == null) {
            return false;
        }
        return this.managersHolder.remove(manager);
    }

    @Override
    public Session getSession() {
        return this.sessionInstance;
    }

    public final ConnectionService getConnectionService() {
        return this.service;
    }

    protected Collection<PortForwardingEventListener> getDefaultListeners() {
        ArrayList<PortForwardingEventListener> defaultListeners = new ArrayList<PortForwardingEventListener>();
        defaultListeners.add(this.getPortForwardingEventListenerProxy());
        Session session = this.getSession();
        PortForwardingEventListener l = session.getPortForwardingEventListenerProxy();
        if (l != null) {
            defaultListeners.add(l);
        }
        FactoryManager manager = session == null ? null : session.getFactoryManager();
        PortForwardingEventListener portForwardingEventListener = l = manager == null ? null : manager.getPortForwardingEventListenerProxy();
        if (l != null) {
            defaultListeners.add(l);
        }
        return defaultListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startLocalPortForwarding(SshdSocketAddress local, SshdSocketAddress remote) throws IOException {
        int port;
        Objects.requireNonNull(local, "Local address is null");
        ValidateUtils.checkTrue((local.getPort() >= 0 ? 1 : 0) != 0, (String)"Invalid local port: %s", (Object)local);
        Objects.requireNonNull(remote, "Remote address is null");
        if (this.isClosed()) {
            throw new IllegalStateException("TcpipForwarder is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closing");
        }
        InetSocketAddress bound = null;
        this.signalEstablishingExplicitTunnel(local, remote, true);
        try {
            bound = this.doBind(local, (Factory<? extends IoHandler>)this.staticIoHandlerFactory);
            port = bound.getPort();
            Object object = this.localLock;
            synchronized (object) {
                SshdSocketAddress prevRemote = this.localToRemote.get(port);
                if (prevRemote != null) {
                    throw new IOException("Multiple local port forwarding addressing on port=" + port + ": current=" + remote + ", previous=" + prevRemote);
                }
                InetSocketAddress prevBound = this.boundLocals.get(port);
                if (prevBound != null) {
                    throw new IOException("Multiple local port forwarding bindings on port=" + port + ": current=" + bound + ", previous=" + prevBound);
                }
                this.localToRemote.put(port, remote);
                this.boundLocals.put(port, bound);
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                this.unbindLocalForwarding(local, remote, bound);
            }
            catch (IOException | RuntimeException err) {
                e.addSuppressed(err);
            }
            this.signalEstablishedExplicitTunnel(local, remote, true, null, e);
            throw e;
        }
        try {
            SshdSocketAddress result = new SshdSocketAddress(bound.getHostString(), port);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startLocalPortForwarding(" + local + " -> " + remote + "): " + result);
            }
            this.signalEstablishedExplicitTunnel(local, remote, true, result, null);
            return result;
        }
        catch (IOException | RuntimeException e) {
            this.stopLocalPortForwarding(local);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopLocalPortForwarding(SshdSocketAddress local) throws IOException {
        InetSocketAddress bound;
        SshdSocketAddress remote;
        Objects.requireNonNull(local, "Local address is null");
        int port = local.getPort();
        Object object = this.localLock;
        synchronized (object) {
            remote = this.localToRemote.remove(port);
            bound = this.boundLocals.remove(port);
        }
        this.unbindLocalForwarding(local, remote, bound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindLocalForwarding(SshdSocketAddress local, SshdSocketAddress remote, InetSocketAddress bound) throws IOException {
        if (bound != null && this.acceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("unbindLocalForwarding({} => {}) unbind {}", new Object[]{local, remote, bound});
            }
            SshdSocketAddress boundAddress = new SshdSocketAddress(bound);
            try {
                this.signalTearingDownExplicitTunnel(boundAddress, true, remote);
            }
            finally {
                try {
                    this.acceptor.unbind((SocketAddress)bound);
                }
                catch (RuntimeException e) {
                    this.signalTornDownExplicitTunnel(boundAddress, true, remote, e);
                    throw e;
                }
            }
            this.signalTornDownExplicitTunnel(boundAddress, true, remote, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("unbindLocalForwarding({} => {}) no mapping({}) or acceptor({})", new Object[]{local, remote, bound, this.acceptor});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startRemotePortForwarding(SshdSocketAddress remote, SshdSocketAddress local) throws IOException {
        int port;
        Objects.requireNonNull(local, "Local address is null");
        Objects.requireNonNull(remote, "Remote address is null");
        String remoteHost = remote.getHostName();
        int remotePort = remote.getPort();
        Session session = this.getSession();
        Buffer buffer = session.createBuffer((byte)80, remoteHost.length() + 64);
        buffer.putString("tcpip-forward");
        buffer.putBoolean(true);
        buffer.putString(remoteHost);
        buffer.putInt((long)remotePort);
        long timeout = session.getLongProperty(FORWARD_REQUEST_TIMEOUT, DEFAULT_FORWARD_REQUEST_TIMEOUT);
        this.signalEstablishingExplicitTunnel(local, remote, false);
        try {
            Buffer result = session.request("tcpip-forward", buffer, timeout, TimeUnit.MILLISECONDS);
            if (result == null) {
                throw new SshException("Tcpip forwarding request denied by server");
            }
            port = remotePort == 0 ? result.getInt() : remote.getPort();
            Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
            synchronized (map) {
                SshdSocketAddress prev = this.remoteToLocal.get(port);
                if (prev != null) {
                    throw new IOException("Multiple remote port forwarding bindings on port=" + port + ": current=" + remote + ", previous=" + prev);
                }
                this.remoteToLocal.put(port, local);
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                this.stopRemotePortForwarding(remote);
            }
            catch (IOException | RuntimeException err) {
                e.addSuppressed(err);
            }
            this.signalEstablishedExplicitTunnel(local, remote, false, null, e);
            throw e;
        }
        try {
            SshdSocketAddress bound = new SshdSocketAddress(remoteHost, port);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startRemotePortForwarding(" + remote + " -> " + local + "): " + bound);
            }
            this.signalEstablishedExplicitTunnel(local, remote, false, bound, null);
            return bound;
        }
        catch (IOException | RuntimeException e) {
            this.stopRemotePortForwarding(remote);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopRemotePortForwarding(SshdSocketAddress remote) throws IOException {
        SshdSocketAddress bound;
        int port = remote.getPort();
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            bound = this.remoteToLocal.remove(port);
        }
        if (bound != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("stopRemotePortForwarding(" + remote + ") cancel forwarding to " + bound);
            }
            String remoteHost = remote.getHostName();
            Session session = this.getSession();
            Buffer buffer = session.createBuffer((byte)80, remoteHost.length() + 64);
            buffer.putString("cancel-tcpip-forward");
            buffer.putBoolean(false);
            buffer.putString(remoteHost);
            buffer.putInt((long)port);
            this.signalTearingDownExplicitTunnel(bound, false, remote);
            try {
                session.writePacket(buffer);
            }
            catch (IOException | RuntimeException e) {
                this.signalTornDownExplicitTunnel(bound, false, remote, e);
                throw e;
            }
            this.signalTornDownExplicitTunnel(bound, false, remote, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("stopRemotePortForwarding(" + remote + ") no binding found");
        }
    }

    protected void signalTearingDownExplicitTunnel(SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remote) throws IOException {
        try {
            this.invokePortEventListenerSignaller((Invoker<PortForwardingEventListener, Void>)((Invoker)l -> {
                this.signalTearingDownExplicitTunnel((PortForwardingEventListener)l, boundAddress, localForwarding, remote);
                return null;
            }));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal tearing down explicit tunnel for local=" + localForwarding + " on bound=" + boundAddress, t);
        }
    }

    protected void signalTearingDownExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remoteAddress) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tearingDownExplicitTunnel(this.getSession(), boundAddress, localForwarding, remoteAddress);
    }

    protected void signalTornDownExplicitTunnel(SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remoteAddress, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller((Invoker<PortForwardingEventListener, Void>)((Invoker)l -> {
                this.signalTornDownExplicitTunnel((PortForwardingEventListener)l, boundAddress, localForwarding, remoteAddress, reason);
                return null;
            }));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal torn down explicit tunnel local=" + localForwarding + " on bound=" + boundAddress, t);
        }
    }

    protected void signalTornDownExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress boundAddress, boolean localForwarding, SshdSocketAddress remoteAddress, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tornDownExplicitTunnel(this.getSession(), boundAddress, localForwarding, remoteAddress, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress startDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        int port;
        Objects.requireNonNull(local, "Local address is null");
        ValidateUtils.checkTrue((local.getPort() >= 0 ? 1 : 0) != 0, (String)"Invalid local port: %s", (Object)local);
        if (this.isClosed()) {
            throw new IllegalStateException("TcpipForwarder is closed");
        }
        if (this.isClosing()) {
            throw new IllegalStateException("TcpipForwarder is closing");
        }
        SocksProxy proxy = null;
        InetSocketAddress bound = null;
        this.signalEstablishingDynamicTunnel(local);
        try {
            bound = this.doBind(local, (Factory<? extends IoHandler>)this.socksProxyIoHandlerFactory);
            port = bound.getPort();
            Object object = this.dynamicLock;
            synchronized (object) {
                SocksProxy prevProxy = this.dynamicLocal.get(port);
                if (prevProxy != null) {
                    throw new IOException("Multiple dynamic port mappings found for port=" + port + ": current=" + proxy + ", previous=" + (Object)((Object)prevProxy));
                }
                InetSocketAddress prevBound = this.boundDynamic.get(port);
                if (prevBound != null) {
                    throw new IOException("Multiple dynamic port bindings found for port=" + port + ": current=" + bound + ", previous=" + prevBound);
                }
                proxy = new SocksProxy(this.service);
                this.dynamicLocal.put(port, proxy);
                this.boundDynamic.put(port, bound);
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                this.unbindDynamicForwarding(local, proxy, bound);
            }
            catch (IOException | RuntimeException err) {
                e.addSuppressed(err);
            }
            this.signalEstablishedDynamicTunnel(local, null, e);
            throw e;
        }
        try {
            SshdSocketAddress result = new SshdSocketAddress(bound.getHostString(), port);
            if (this.log.isDebugEnabled()) {
                this.log.debug("startDynamicPortForwarding(" + local + "): " + result);
            }
            this.signalEstablishedDynamicTunnel(local, result, null);
            return result;
        }
        catch (IOException | RuntimeException e) {
            this.stopDynamicPortForwarding(local);
            throw e;
        }
    }

    protected void signalEstablishedDynamicTunnel(SshdSocketAddress local, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller((Invoker<PortForwardingEventListener, Void>)((Invoker)l -> {
                this.signalEstablishedDynamicTunnel((PortForwardingEventListener)l, local, boundAddress, reason);
                return null;
            }));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal establishing dynamic tunnel for local=" + local + " on bound=" + boundAddress, t);
        }
    }

    protected void signalEstablishedDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress local, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishedDynamicTunnel(this.getSession(), local, boundAddress, reason);
    }

    protected void signalEstablishingDynamicTunnel(SshdSocketAddress local) throws IOException {
        try {
            this.invokePortEventListenerSignaller((Invoker<PortForwardingEventListener, Void>)((Invoker)l -> {
                this.signalEstablishingDynamicTunnel((PortForwardingEventListener)l, local);
                return null;
            }));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal establishing dynamic tunnel for local=" + local, t);
        }
    }

    protected void signalEstablishingDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress local) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishingDynamicTunnel(this.getSession(), local);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopDynamicPortForwarding(SshdSocketAddress local) throws IOException {
        InetSocketAddress bound;
        SocksProxy proxy;
        int port = local.getPort();
        Object object = this.dynamicLock;
        synchronized (object) {
            proxy = this.dynamicLocal.remove(port);
            bound = this.boundDynamic.remove(port);
        }
        this.unbindDynamicForwarding(local, proxy, bound);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void unbindDynamicForwarding(SshdSocketAddress local, SocksProxy proxy, InetSocketAddress bound) throws IOException {
        block24: {
            boolean debugEnabled = this.log.isDebugEnabled();
            if (bound == null && proxy == null) {
                if (!debugEnabled) return;
                this.log.debug("stopDynamicPortForwarding({}) no binding found", (Object)local);
                return;
            }
            try {
                this.signalTearingDownDynamicTunnel(local);
            }
            catch (Throwable throwable) {
                try {
                    block20: {
                        block21: {
                            try {
                                if (proxy != null) {
                                    if (debugEnabled) {
                                        this.log.debug("stopDynamicPortForwarding({}) close proxy={}", (Object)local, (Object)proxy);
                                    }
                                    proxy.close(true);
                                }
                                if (bound == null || this.acceptor == null) break block20;
                                if (!debugEnabled) break block21;
                            }
                            catch (Throwable throwable2) {
                                if (bound != null && this.acceptor != null) {
                                    if (debugEnabled) {
                                        this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                                    }
                                    this.acceptor.unbind((SocketAddress)bound);
                                    throw throwable2;
                                }
                                if (!debugEnabled) throw throwable2;
                                this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{local, this.acceptor, bound});
                                throw throwable2;
                            }
                            this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                        }
                        this.acceptor.unbind((SocketAddress)bound);
                        throw throwable;
                    }
                    if (!debugEnabled) throw throwable;
                    this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{local, this.acceptor, bound});
                    throw throwable;
                }
                catch (RuntimeException e) {
                    this.signalTornDownDynamicTunnel(local, e);
                    throw e;
                }
            }
            try {
                block22: {
                    block23: {
                        try {
                            if (proxy != null) {
                                if (debugEnabled) {
                                    this.log.debug("stopDynamicPortForwarding({}) close proxy={}", (Object)local, (Object)proxy);
                                }
                                proxy.close(true);
                            }
                            if (bound == null || this.acceptor == null) break block22;
                            if (!debugEnabled) break block23;
                        }
                        catch (Throwable throwable) {
                            if (bound != null && this.acceptor != null) {
                                if (debugEnabled) {
                                    this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                                }
                                this.acceptor.unbind((SocketAddress)bound);
                                throw throwable;
                            }
                            if (!debugEnabled) throw throwable;
                            this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{local, this.acceptor, bound});
                            throw throwable;
                        }
                        this.log.debug("stopDynamicPortForwarding({}) unbind address={}", (Object)local, (Object)bound);
                    }
                    this.acceptor.unbind((SocketAddress)bound);
                    break block24;
                }
                if (debugEnabled) {
                    this.log.debug("stopDynamicPortForwarding({}) no acceptor({}) or no binding({})", new Object[]{local, this.acceptor, bound});
                }
            }
            catch (RuntimeException e) {
                this.signalTornDownDynamicTunnel(local, e);
                throw e;
            }
        }
        this.signalTornDownDynamicTunnel(local, null);
    }

    protected void signalTearingDownDynamicTunnel(SshdSocketAddress address) throws IOException {
        try {
            this.invokePortEventListenerSignaller((Invoker<PortForwardingEventListener, Void>)((Invoker)l -> {
                this.signalTearingDownDynamicTunnel((PortForwardingEventListener)l, address);
                return null;
            }));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal tearing down dynamic tunnel for address=" + address, t);
        }
    }

    protected void signalTearingDownDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress address) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tearingDownDynamicTunnel(this.getSession(), address);
    }

    protected void signalTornDownDynamicTunnel(SshdSocketAddress address, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller((Invoker<PortForwardingEventListener, Void>)((Invoker)l -> {
                this.signalTornDownDynamicTunnel((PortForwardingEventListener)l, address, reason);
                return null;
            }));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal torn down dynamic tunnel for address=" + address, t);
        }
    }

    protected void signalTornDownDynamicTunnel(PortForwardingEventListener listener, SshdSocketAddress address, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.tornDownDynamicTunnel(this.getSession(), address, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress getForwardedPort(int remotePort) {
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.get(remotePort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SshdSocketAddress localPortForwardingRequested(SshdSocketAddress local) throws IOException {
        SshdSocketAddress result;
        Objects.requireNonNull(local, "Local address is null");
        ValidateUtils.checkTrue((local.getPort() >= 0 ? 1 : 0) != 0, (String)"Invalid local port: %s", (Object)local);
        Session session = this.getSession();
        FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
        TcpForwardingFilter filter = manager.getTcpForwardingFilter();
        try {
            if (filter == null || !filter.canListen(local, session)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("localPortForwardingRequested(" + session + ")[" + local + "][haveFilter=" + (filter != null) + "] rejected");
                }
                return null;
            }
        }
        catch (Error e) {
            this.log.warn("localPortForwardingRequested({})[{}] failed ({}) to consult forwarding filter: {}", new Object[]{session, local, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingRequested(" + this + ")[" + local + "] filter consultation failure details", (Throwable)e);
            }
            throw new RuntimeSshException((Throwable)e);
        }
        this.signalEstablishingExplicitTunnel(local, null, true);
        try {
            boolean added;
            InetSocketAddress bound = this.doBind(local, (Factory<? extends IoHandler>)this.staticIoHandlerFactory);
            result = new SshdSocketAddress(bound.getHostString(), bound.getPort());
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingRequested(" + local + "): " + result);
            }
            Set<LocalForwardingEntry> set = this.localForwards;
            synchronized (set) {
                added = this.localForwards.add(new LocalForwardingEntry(result.getHostName(), local.getHostName(), result.getPort()));
            }
            if (!added) {
                throw new IOException("Failed to add local port forwarding entry for " + local + " -> " + result);
            }
        }
        catch (IOException | RuntimeException e) {
            try {
                this.localPortForwardingCancelled(local);
            }
            catch (IOException | RuntimeException err) {
                e.addSuppressed(e);
            }
            this.signalEstablishedExplicitTunnel(local, null, true, null, e);
            throw e;
        }
        this.signalEstablishedExplicitTunnel(local, null, true, result, null);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void localPortForwardingCancelled(SshdSocketAddress local) throws IOException {
        LocalForwardingEntry entry;
        Set<LocalForwardingEntry> set = this.localForwards;
        synchronized (set) {
            entry = LocalForwardingEntry.findMatchingEntry(local.getHostName(), local.getPort(), this.localForwards);
            if (entry != null) {
                this.localForwards.remove((Object)entry);
            }
        }
        if (entry != null && this.acceptor != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("localPortForwardingCancelled(" + local + ") unbind " + (Object)((Object)entry));
            }
            this.signalTearingDownExplicitTunnel(entry, true, null);
            try {
                this.acceptor.unbind((SocketAddress)entry.toInetSocketAddress());
            }
            catch (RuntimeException e) {
                this.signalTornDownExplicitTunnel(entry, true, null, e);
                throw e;
            }
            this.signalTornDownExplicitTunnel(entry, true, null, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("localPortForwardingCancelled(" + local + ") no match/acceptor: " + (Object)((Object)entry));
        }
    }

    protected void signalEstablishingExplicitTunnel(SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding) throws IOException {
        try {
            this.invokePortEventListenerSignaller((Invoker<PortForwardingEventListener, Void>)((Invoker)l -> {
                this.signalEstablishingExplicitTunnel((PortForwardingEventListener)l, local, remote, localForwarding);
                return null;
            }));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal establishing explicit tunnel for local=" + local + ", remote=" + remote + ", localForwarding=" + localForwarding, t);
        }
    }

    protected void signalEstablishingExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishingExplicitTunnel(this.getSession(), local, remote, localForwarding);
    }

    protected void signalEstablishedExplicitTunnel(SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        try {
            this.invokePortEventListenerSignaller((Invoker<PortForwardingEventListener, Void>)((Invoker)l -> {
                this.signalEstablishedExplicitTunnel((PortForwardingEventListener)l, local, remote, localForwarding, boundAddress, reason);
                return null;
            }));
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            throw new IOException("Failed (" + t.getClass().getSimpleName() + ") to signal established explicit tunnel for local=" + local + ", remote=" + remote + ", localForwarding=" + localForwarding + ", bound=" + boundAddress, t);
        }
    }

    protected void signalEstablishedExplicitTunnel(PortForwardingEventListener listener, SshdSocketAddress local, SshdSocketAddress remote, boolean localForwarding, SshdSocketAddress boundAddress, Throwable reason) throws IOException {
        if (listener == null) {
            return;
        }
        listener.establishedExplicitTunnel(this.getSession(), local, remote, localForwarding, boundAddress, reason);
    }

    protected void invokePortEventListenerSignaller(Invoker<PortForwardingEventListener, Void> invoker) throws Throwable {
        Throwable e;
        Throwable err = null;
        try {
            this.invokePortEventListenerSignallerListeners(this.getDefaultListeners(), invoker);
        }
        catch (Throwable t) {
            e = GenericUtils.peelException((Throwable)t);
            err = GenericUtils.accumulateException(err, (Throwable)e);
        }
        try {
            this.invokePortEventListenerSignallerHolders(this.managersHolder, invoker);
        }
        catch (Throwable t) {
            e = GenericUtils.peelException((Throwable)t);
            err = GenericUtils.accumulateException((Throwable)err, (Throwable)e);
        }
        if (err != null) {
            throw err;
        }
    }

    protected void invokePortEventListenerSignallerListeners(Collection<? extends PortForwardingEventListener> listeners, Invoker<PortForwardingEventListener, Void> invoker) throws Throwable {
        if (GenericUtils.isEmpty(listeners)) {
            return;
        }
        Throwable err = null;
        for (PortForwardingEventListener portForwardingEventListener : listeners) {
            if (portForwardingEventListener == null) continue;
            try {
                invoker.invoke((Object)portForwardingEventListener);
            }
            catch (Throwable t) {
                Throwable e = GenericUtils.peelException((Throwable)t);
                err = GenericUtils.accumulateException(err, (Throwable)e);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    protected void invokePortEventListenerSignallerHolders(Collection<? extends PortForwardingEventListenerManager> holders, Invoker<PortForwardingEventListener, Void> invoker) throws Throwable {
        if (GenericUtils.isEmpty(holders)) {
            return;
        }
        Throwable err = null;
        for (PortForwardingEventListenerManager portForwardingEventListenerManager : holders) {
            Throwable e;
            try {
                PortForwardingEventListener listener = portForwardingEventListenerManager.getPortForwardingEventListenerProxy();
                if (listener != null) {
                    invoker.invoke((Object)listener);
                }
            }
            catch (Throwable t) {
                e = GenericUtils.peelException((Throwable)t);
                err = GenericUtils.accumulateException(err, (Throwable)e);
            }
            if (!(portForwardingEventListenerManager instanceof PortForwardingEventListenerManagerHolder)) continue;
            try {
                this.invokePortEventListenerSignallerHolders(((PortForwardingEventListenerManagerHolder)((Object)portForwardingEventListenerManager)).getRegisteredManagers(), invoker);
            }
            catch (Throwable t) {
                e = GenericUtils.peelException((Throwable)t);
                err = GenericUtils.accumulateException((Throwable)err, (Throwable)e);
            }
        }
        if (err != null) {
            throw err;
        }
    }

    protected synchronized Closeable getInnerCloseable() {
        return this.builder().parallel((Object)this.toString(), this.dynamicLocal.values()).close((Closeable)this.acceptor).build();
    }

    protected void preClose() {
        this.listeners.clear();
        this.managersHolder.clear();
        super.preClose();
    }

    private InetSocketAddress doBind(SshdSocketAddress address, Factory<? extends IoHandler> handlerFactory) throws IOException {
        Set after;
        if (this.acceptor == null) {
            Session session = this.getSession();
            FactoryManager manager = Objects.requireNonNull(session.getFactoryManager(), "No factory manager");
            IoServiceFactory factory = Objects.requireNonNull(manager.getIoServiceFactory(), "No I/O service factory");
            IoHandler handler = (IoHandler)handlerFactory.create();
            this.acceptor = factory.createAcceptor(handler);
        }
        Set before = this.acceptor.getBoundAddresses();
        try {
            InetSocketAddress bindAddress = address.toInetSocketAddress();
            this.acceptor.bind((SocketAddress)bindAddress);
            after = this.acceptor.getBoundAddresses();
            if (GenericUtils.size((Collection)after) > 0) {
                after.removeAll(before);
            }
            if (GenericUtils.isEmpty((Collection)after)) {
                throw new IOException("Error binding to " + address + "[" + bindAddress + "]: no local addresses bound");
            }
            if (after.size() > 1) {
                throw new IOException("Multiple local addresses have been bound for " + address + "[" + bindAddress + "]");
            }
            return (InetSocketAddress)GenericUtils.head((Iterable)after);
        }
        catch (IOException bindErr) {
            after = this.acceptor.getBoundAddresses();
            if (GenericUtils.isEmpty((Collection)after)) {
                this.close();
            }
            throw bindErr;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getSession() + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SshdSocketAddress getBoundLocalPortForward(int port) {
        ValidateUtils.checkTrue((port > 0 ? 1 : 0) != 0, (String)"Invalid local port: %d", (long)port);
        Integer portKey = port;
        Map<Integer, SshdSocketAddress> map = this.localToRemote;
        synchronized (map) {
            return this.localToRemote.get(portKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<Integer, SshdSocketAddress>> getLocalForwardsBindings() {
        Map<Integer, SshdSocketAddress> map = this.localToRemote;
        synchronized (map) {
            return this.localToRemote.isEmpty() ? Collections.emptyList() : (List)this.localToRemote.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry(e.getKey(), e.getValue())).collect(Collectors.toCollection(() -> new ArrayList(this.localToRemote.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableSet<Integer> getStartedLocalPortForwards() {
        Map<Integer, SshdSocketAddress> map = this.localToRemote;
        synchronized (map) {
            if (this.localToRemote.isEmpty()) {
                return Collections.emptyNavigableSet();
            }
            return GenericUtils.asSortedSet(this.localToRemote.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Map.Entry<Integer, SshdSocketAddress>> getRemoteForwardsBindings() {
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.isEmpty() ? Collections.emptyList() : (List)this.remoteToLocal.entrySet().stream().map(e -> new AbstractMap.SimpleImmutableEntry(e.getKey(), e.getValue())).collect(Collectors.toCollection(() -> new ArrayList(this.remoteToLocal.size())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SshdSocketAddress getBoundRemotePortForward(int port) {
        ValidateUtils.checkTrue((port > 0 ? 1 : 0) != 0, (String)"Invalid remote port: %d", (long)port);
        Integer portKey = port;
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            return this.remoteToLocal.get(portKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NavigableSet<Integer> getStartedRemotePortForwards() {
        Map<Integer, SshdSocketAddress> map = this.remoteToLocal;
        synchronized (map) {
            if (this.remoteToLocal.isEmpty()) {
                return Collections.emptyNavigableSet();
            }
            return GenericUtils.asSortedSet(this.remoteToLocal.keySet());
        }
    }

    static /* synthetic */ Logger access$000(DefaultForwardingFilter x0) {
        return x0.log;
    }

    static /* synthetic */ Logger access$100(DefaultForwardingFilter x0) {
        return x0.log;
    }

    class StaticIoHandler
    implements IoHandler {
        private final AtomicLong messagesCounter = new AtomicLong(0L);
        private final boolean debugEnabled = DefaultForwardingFilter.access$000(DefaultForwardingFilter.this).isDebugEnabled();
        private final boolean traceEnabled = DefaultForwardingFilter.access$100(DefaultForwardingFilter.this).isTraceEnabled();

        StaticIoHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sessionCreated(IoSession session) throws Exception {
            InetSocketAddress local = (InetSocketAddress)session.getLocalAddress();
            int localPort = local.getPort();
            SshdSocketAddress remote = (SshdSocketAddress)DefaultForwardingFilter.this.localToRemote.get(localPort);
            TcpipClientChannel.Type channelType = remote == null ? TcpipClientChannel.Type.Forwarded : TcpipClientChannel.Type.Direct;
            TcpipClientChannel channel = new TcpipClientChannel(channelType, session, remote);
            session.setAttribute(TcpipClientChannel.class, (Object)channel);
            if (channelType == TcpipClientChannel.Type.Forwarded) {
                SocketAddress accepted = session.getAcceptanceAddress();
                LocalForwardingEntry localEntry = null;
                if (accepted instanceof InetSocketAddress) {
                    Set set = DefaultForwardingFilter.this.localForwards;
                    synchronized (set) {
                        localEntry = LocalForwardingEntry.findMatchingEntry(((InetSocketAddress)accepted).getHostString(), localPort, DefaultForwardingFilter.this.localForwards);
                    }
                }
                if (localEntry != null) {
                    if (this.debugEnabled) {
                        DefaultForwardingFilter.this.log.debug("sessionCreated({})[local={}, remote={}, accepted={}] localEntry={}", new Object[]{session, local, remote, accepted, localEntry});
                    }
                    channel.updateLocalForwardingEntry(localEntry);
                } else {
                    DefaultForwardingFilter.this.log.warn("sessionCreated({})[local={}, remote={}] cannot locate original local entry for accepted={}", new Object[]{session, local, remote, accepted});
                }
            } else if (this.debugEnabled) {
                DefaultForwardingFilter.this.log.debug("sessionCreated({}) local={}, remote={}", new Object[]{session, local, remote});
            }
            DefaultForwardingFilter.this.service.registerChannel(channel);
            channel.open().addListener(future -> {
                Throwable t = future.getException();
                if (t != null) {
                    DefaultForwardingFilter.this.log.warn("Failed ({}) to open channel for session={}: {}", new Object[]{t.getClass().getSimpleName(), session, t.getMessage()});
                    if (this.debugEnabled) {
                        DefaultForwardingFilter.this.log.debug("sessionCreated(" + session + ") channel=" + channel + " open failure details", t);
                    }
                    DefaultForwardingFilter.this.service.unregisterChannel(channel);
                    channel.close(false);
                }
            });
        }

        public void sessionClosed(IoSession session) throws Exception {
            TcpipClientChannel channel = (TcpipClientChannel)session.removeAttribute(TcpipClientChannel.class);
            Throwable cause = (Throwable)session.removeAttribute(TcpipForwardingExceptionMarker.class);
            if (this.debugEnabled) {
                DefaultForwardingFilter.this.log.debug("sessionClosed({}) closing channel={} after {} messages - cause={}", new Object[]{session, channel, this.messagesCounter, cause == null ? null : cause.getClass().getSimpleName()});
            }
            if (channel == null) {
                return;
            }
            if (cause != null) {
                channel.close(true);
            } else {
                boolean immediately;
                OpenFuture openFuture = channel.getOpenFuture();
                Throwable err = openFuture.getException();
                ClientChannelPendingMessagesQueue queue = channel.getPendingMessagesQueue();
                OpenFuture completedFuture = queue.getCompletedFuture();
                if (err == null) {
                    err = completedFuture.getException();
                }
                boolean bl = immediately = err != null;
                if (immediately) {
                    channel.close(true);
                } else {
                    completedFuture.addListener(f -> {
                        Throwable thrown = f.getException();
                        channel.close(immediately || thrown != null);
                    });
                }
            }
        }

        public void messageReceived(IoSession session, Readable message) throws Exception {
            ClientChannelPendingMessagesQueue messagesQueue;
            OpenFuture future;
            TcpipClientChannel channel = (TcpipClientChannel)session.getAttribute(TcpipClientChannel.class);
            long totalMessages = this.messagesCounter.incrementAndGet();
            ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
            buffer.putBuffer(message);
            if (this.traceEnabled) {
                DefaultForwardingFilter.this.log.trace("messageReceived({}) channel={}, count={}, handle len={}", new Object[]{session, channel, totalMessages, message.available()});
            }
            Consumer<Throwable> errHandler = (future = (messagesQueue = channel.getPendingMessagesQueue()).getCompletedFuture()).isOpened() ? null : e -> {
                try {
                    this.exceptionCaught(session, (Throwable)e);
                }
                catch (Exception err) {
                    DefaultForwardingFilter.this.log.warn("messageReceived({}) failed ({}) to signal {}[{}] on channel={}: {}", new Object[]{session, err.getClass().getSimpleName(), e.getClass().getSimpleName(), e.getMessage(), channel, err.getMessage()});
                }
            };
            int pendCount = messagesQueue.handleIncomingMessage((Buffer)buffer, errHandler);
            if (this.traceEnabled) {
                DefaultForwardingFilter.this.log.trace("messageReceived({}) channel={} pend count={} after processing message", new Object[]{session, channel, pendCount});
            }
        }

        public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
            session.setAttribute(TcpipForwardingExceptionMarker.class, (Object)cause);
            if (this.debugEnabled) {
                DefaultForwardingFilter.this.log.debug("exceptionCaught({}) {}: {}", new Object[]{session, cause.getClass().getSimpleName(), cause.getMessage()});
            }
            if (this.traceEnabled) {
                DefaultForwardingFilter.this.log.trace("exceptionCaught(" + session + ") caught exception details", cause);
            }
            session.close(true);
        }
    }
}

