/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.nio.channels.Channel;
import java.nio.channels.UnsupportedAddressTypeException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.hostbased.HostBasedAuthenticationReporter;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordAuthenticationReporter;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.PublicKeyAuthenticationReporter;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.keys.ClientIdentity;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.DefaultClientIdentitiesWatcher;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientConnectionServiceFactory;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientUserAuthServiceFactory;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.client.session.forward.ExplicitPortForwardingTracker;
import org.apache.sshd.client.simple.AbstractSimpleClientSessionCreator;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.ExceptionUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.functors.UnaryEquator;
import org.apache.sshd.common.util.io.resource.PathResource;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;

public class SshClient
extends AbstractFactoryManager
implements ClientFactoryManager,
Closeable {
    public static final Factory<SshClient> DEFAULT_SSH_CLIENT_FACTORY = SshClient::new;
    public static final List<UserAuthFactory> DEFAULT_USER_AUTH_FACTORIES = Collections.unmodifiableList(Arrays.asList(UserAuthPublicKeyFactory.INSTANCE, UserAuthKeyboardInteractiveFactory.INSTANCE, UserAuthPasswordFactory.INSTANCE));
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ClientUserAuthServiceFactory.INSTANCE, ClientConnectionServiceFactory.INSTANCE));
    protected IoConnector connector;
    protected SessionFactory sessionFactory;
    protected List<UserAuthFactory> userAuthFactories;
    private ClientProxyConnector proxyConnector;
    private ServerKeyVerifier serverKeyVerifier;
    private HostConfigEntryResolver hostConfigEntryResolver;
    private ClientIdentityLoader clientIdentityLoader;
    private KeyIdentityProvider keyIdentityProvider;
    private PublicKeyAuthenticationReporter publicKeyAuthenticationReporter;
    private FilePasswordProvider filePasswordProvider;
    private PasswordIdentityProvider passwordIdentityProvider;
    private PasswordAuthenticationReporter passwordAuthenticationReporter;
    private HostBasedAuthenticationReporter hostBasedAuthenticationReporter;
    private UserInteraction userInteraction;
    private final List<Object> identities = new CopyOnWriteArrayList<Object>();
    private final AuthenticationIdentitiesProvider identitiesProvider;
    private final AtomicBoolean started = new AtomicBoolean(false);

    public SshClient() {
        this.identitiesProvider = AuthenticationIdentitiesProvider.wrapIdentities(this.identities);
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ClientProxyConnector getClientProxyConnector() {
        return this.proxyConnector;
    }

    @Override
    public void setClientProxyConnector(ClientProxyConnector proxyConnector) {
        this.proxyConnector = proxyConnector;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.serverKeyVerifier;
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = Objects.requireNonNull(serverKeyVerifier, "No server key verifier");
    }

    @Override
    public HostConfigEntryResolver getHostConfigEntryResolver() {
        return this.hostConfigEntryResolver;
    }

    @Override
    public void setHostConfigEntryResolver(HostConfigEntryResolver resolver) {
        this.hostConfigEntryResolver = Objects.requireNonNull(resolver, "No host configuration entry resolver");
    }

    public FilePasswordProvider getFilePasswordProvider() {
        return this.filePasswordProvider;
    }

    public void setFilePasswordProvider(FilePasswordProvider provider) {
        this.filePasswordProvider = Objects.requireNonNull(provider, "No file password provider");
    }

    public ClientIdentityLoader getClientIdentityLoader() {
        return this.clientIdentityLoader;
    }

    public void setClientIdentityLoader(ClientIdentityLoader loader) {
        this.clientIdentityLoader = Objects.requireNonNull(loader, "No client identity loader");
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public PasswordAuthenticationReporter getPasswordAuthenticationReporter() {
        return this.passwordAuthenticationReporter;
    }

    @Override
    public void setPasswordAuthenticationReporter(PasswordAuthenticationReporter reporter) {
        this.passwordAuthenticationReporter = reporter;
    }

    @Override
    public HostBasedAuthenticationReporter getHostBasedAuthenticationReporter() {
        return this.hostBasedAuthenticationReporter;
    }

    @Override
    public void setHostBasedAuthenticationReporter(HostBasedAuthenticationReporter reporter) {
        this.hostBasedAuthenticationReporter = reporter;
    }

    public List<UserAuthFactory> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    public void setUserAuthFactories(List<UserAuthFactory> userAuthFactories) {
        this.userAuthFactories = (List)ValidateUtils.checkNotNullAndNotEmpty(userAuthFactories, (String)"No user auth factories", (Object[])new Object[0]);
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        return this.passwordIdentityProvider;
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider provider) {
        this.passwordIdentityProvider = provider;
    }

    @Override
    public void addPasswordIdentity(String password) {
        ValidateUtils.checkTrue((password != null && !password.isEmpty() ? 1 : 0) != 0, (String)"No password provided");
        this.identities.add(password);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint((String)password));
        }
    }

    @Override
    public String removePasswordIdentity(String password) {
        if (GenericUtils.isEmpty((CharSequence)password)) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, (Comparator)AuthenticationIdentitiesProvider.PASSWORD_IDENTITY_COMPARATOR, (Object)password);
        if (index >= 0) {
            return (String)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair kp) {
        Objects.requireNonNull(kp, "No key-pair to add");
        Objects.requireNonNull(kp.getPublic(), "No public key");
        Objects.requireNonNull(kp.getPrivate(), "No private key");
        this.identities.add(kp);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPublicKeyIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint((PublicKey)kp.getPublic()));
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.findIdentityIndex(this.identities, (Comparator)AuthenticationIdentitiesProvider.KEYPAIR_IDENTITY_COMPARATOR, (Object)kp);
        if (index >= 0) {
            return (KeyPair)this.identities.remove(index);
        }
        return null;
    }

    public KeyIdentityProvider getKeyIdentityProvider() {
        return this.keyIdentityProvider;
    }

    public void setKeyIdentityProvider(KeyIdentityProvider keyIdentityProvider) {
        this.keyIdentityProvider = keyIdentityProvider;
    }

    @Override
    public PublicKeyAuthenticationReporter getPublicKeyAuthenticationReporter() {
        return this.publicKeyAuthenticationReporter;
    }

    @Override
    public void setPublicKeyAuthenticationReporter(PublicKeyAuthenticationReporter reporter) {
        this.publicKeyAuthenticationReporter = reporter;
    }

    @Override
    protected void checkConfig() {
        SshAgentFactory agentFactory;
        super.checkConfig();
        Objects.requireNonNull(this.getForwarderFactory(), "ForwarderFactory not set");
        Objects.requireNonNull(this.getServerKeyVerifier(), "ServerKeyVerifier not set");
        Objects.requireNonNull(this.getHostConfigEntryResolver(), "HostConfigEntryResolver not set");
        Objects.requireNonNull(this.getClientIdentityLoader(), "ClientIdentityLoader not set");
        Objects.requireNonNull(this.getFilePasswordProvider(), "FilePasswordProvider not set");
        KeyIdentityProvider defaultIdentities = this.getKeyIdentityProvider();
        if (defaultIdentities == null) {
            DefaultClientIdentitiesWatcher idsWatcher = new DefaultClientIdentitiesWatcher(this::getClientIdentityLoader, this::getFilePasswordProvider);
            this.setKeyIdentityProvider((KeyIdentityProvider)idsWatcher);
        }
        if ((agentFactory = this.getAgentFactory()) != null) {
            ArrayList forwarders = (ArrayList)ValidateUtils.checkNotNullAndNotEmpty(agentFactory.getChannelForwardingFactories(this), (String)"No agent channel forwarding factories for %s", (Object[])new Object[]{agentFactory});
            ArrayList factories = this.getChannelFactories();
            if (GenericUtils.isEmpty(factories)) {
                factories = forwarders;
            } else {
                ArrayList factories2 = new ArrayList(factories.size() + forwarders.size());
                factories2.addAll(factories);
                factories2.addAll(forwarders);
                factories = factories2;
            }
            this.setChannelFactories(factories);
        }
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
        if (GenericUtils.isEmpty(this.getUserAuthFactories())) {
            this.setUserAuthFactories(DEFAULT_USER_AUTH_FACTORIES);
        }
    }

    public boolean isStarted() {
        return this.started.get();
    }

    public void start() {
        if (this.isClosed()) {
            throw new IllegalStateException("Can not start the client again");
        }
        if (this.isStarted()) {
            return;
        }
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.setupSessionTimeout(this.sessionFactory);
        this.connector = this.createConnector();
        this.started.set(true);
    }

    public void stop() {
        if (!this.started.getAndSet(false)) {
            return;
        }
        try {
            Duration maxWait = (Duration)CoreModuleProperties.STOP_WAIT_TIME.getRequired((PropertyResolver)this);
            boolean successful = this.close(true).await(maxWait);
            if (!successful) {
                throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
            }
        }
        catch (IOException e) {
            this.warn("{} while stopping client: {}", e.getClass().getSimpleName(), e.getMessage(), e);
        }
        finally {
            this.clearAttributes();
        }
    }

    public void open() throws IOException {
        this.start();
    }

    protected Closeable getInnerCloseable() {
        String closeId = this.toString();
        return this.builder().run((Object)closeId, () -> this.removeSessionTimeout(this.sessionFactory)).sequential(new Closeable[]{this.connector, this.ioServiceFactory}).run((Object)closeId, () -> {
            this.connector = null;
            this.ioServiceFactory = null;
            if (this.shutdownExecutor && this.executor != null && !this.executor.isShutdown()) {
                try {
                    this.executor.shutdownNow();
                }
                finally {
                    this.executor = null;
                }
            }
        }).build();
    }

    @Override
    public ConnectFuture connect(String uriStr) throws IOException {
        Objects.requireNonNull(uriStr, "No uri address");
        URI uri = URI.create(uriStr.contains("//") ? uriStr : "ssh://" + uriStr);
        if (GenericUtils.isNotEmpty((CharSequence)uri.getScheme()) && !"ssh".equals(uri.getScheme())) {
            throw new IllegalArgumentException("Unsupported scheme for uri: " + uri);
        }
        String host = uri.getHost();
        int port = uri.getPort();
        String userInfo = uri.getUserInfo();
        return this.connect(userInfo, host, port);
    }

    @Override
    public ConnectFuture connect(String username, SocketAddress targetAddress, AttributeRepository context, SocketAddress localAddress) throws IOException {
        Objects.requireNonNull(targetAddress, "No target address");
        if (!(targetAddress instanceof InetSocketAddress)) {
            throw new UnsupportedAddressTypeException();
        }
        InetSocketAddress inetAddress = (InetSocketAddress)targetAddress;
        String host = ValidateUtils.checkNotNullAndNotEmpty((String)inetAddress.getHostString(), (String)"No host");
        int port = inetAddress.getPort();
        ValidateUtils.checkTrue((port > 0 ? 1 : 0) != 0, (String)"Invalid port: %d", (long)port);
        return this.connect(username, host, port, context, localAddress);
    }

    @Override
    public ConnectFuture connect(String username, String host, int port, AttributeRepository context, SocketAddress localAddress) throws IOException {
        HostConfigEntry entry = this.resolveHost(username, host, port, context, localAddress);
        return this.connect(entry, context, localAddress);
    }

    @Override
    public ConnectFuture connect(HostConfigEntry hostConfig, AttributeRepository context, SocketAddress localAddress) throws IOException {
        List<HostConfigEntry> jumps = this.parseProxyJumps(hostConfig.getProxyJump(), context);
        return this.doConnect(hostConfig, jumps, context, localAddress);
    }

    protected ConnectFuture doConnect(HostConfigEntry hostConfig, List<HostConfigEntry> jumps, AttributeRepository context, SocketAddress localAddress) throws IOException {
        Objects.requireNonNull(hostConfig, "No host configuration");
        String host = ValidateUtils.checkNotNullAndNotEmpty((String)hostConfig.getHostName(), (String)"No target host");
        int port = hostConfig.getPort();
        ValidateUtils.checkTrue((port > 0 ? 1 : 0) != 0, (String)"Invalid port: %d", (long)port);
        Collection hostIds = hostConfig.getIdentities();
        Collection idFiles = GenericUtils.stream((Iterable)hostIds).map(x$0 -> Paths.get(x$0, new String[0])).map(PathResource::new).collect(Collectors.toCollection(() -> new ArrayList(hostIds.size())));
        KeyIdentityProvider keys = this.preloadClientIdentities(idFiles);
        String username = hostConfig.getUsername();
        InetSocketAddress targetAddress = new InetSocketAddress(hostConfig.getHostName(), hostConfig.getPort());
        if (GenericUtils.isNotEmpty(jumps)) {
            DefaultConnectFuture connectFuture = new DefaultConnectFuture(username + "@" + targetAddress, null);
            HostConfigEntry jump = jumps.remove(0);
            ConnectFuture f1 = this.doConnect(jump, jumps, context, null);
            f1.addListener(f2 -> {
                if (f2.isConnected()) {
                    ClientSession proxySession = f2.getClientSession();
                    try {
                        AuthFuture auth = proxySession.auth();
                        auth.addListener(f3 -> {
                            if (f3.isSuccess()) {
                                try {
                                    SshdSocketAddress address = new SshdSocketAddress(hostConfig.getHostName(), hostConfig.getPort());
                                    ExplicitPortForwardingTracker tracker = proxySession.createLocalPortForwardingTracker(SshdSocketAddress.LOCALHOST_ADDRESS, address);
                                    SshdSocketAddress bound = tracker.getBoundAddress();
                                    ConnectFuture f4 = this.doConnect(hostConfig.getUsername(), bound.toInetSocketAddress(), context, localAddress, keys, !hostConfig.isIdentitiesOnly());
                                    f4.addListener(f5 -> {
                                        if (f5.isConnected()) {
                                            ClientSession clientSession = f5.getClientSession();
                                            clientSession.setAttribute(TARGET_SERVER, address);
                                            connectFuture.setSession(clientSession);
                                            proxySession.addCloseFutureListener(f6 -> clientSession.close(true));
                                            clientSession.addCloseFutureListener(f6 -> proxySession.close(true));
                                        } else {
                                            proxySession.close(true);
                                            connectFuture.setException(f5.getException());
                                        }
                                    });
                                }
                                catch (IOException e) {
                                    proxySession.close(true);
                                    connectFuture.setException(e);
                                }
                            } else {
                                proxySession.close(true);
                                connectFuture.setException(f3.getException());
                            }
                        });
                    }
                    catch (IOException e) {
                        proxySession.close(true);
                        connectFuture.setException(e);
                    }
                } else {
                    connectFuture.setException(f2.getException());
                }
            });
            return connectFuture;
        }
        return this.doConnect(hostConfig.getUsername(), new InetSocketAddress(host, port), context, localAddress, keys, !hostConfig.isIdentitiesOnly());
    }

    protected ConnectFuture doConnect(String username, SocketAddress targetAddress, AttributeRepository context, SocketAddress localAddress, KeyIdentityProvider identities, boolean useDefaultIdentities) throws IOException {
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        DefaultConnectFuture connectFuture = new DefaultConnectFuture(username + "@" + targetAddress, null);
        SshFutureListener<IoConnectFuture> listener = this.createConnectCompletionListener(connectFuture, username, targetAddress, identities, useDefaultIdentities);
        IoConnectFuture connectingFuture = this.connector.connect(targetAddress, context, localAddress);
        connectingFuture.addListener(listener);
        return connectFuture;
    }

    protected List<HostConfigEntry> parseProxyJumps(String proxyJump, AttributeRepository context) throws IOException {
        ArrayList<HostConfigEntry> jumps = new ArrayList<HostConfigEntry>();
        for (String jump : GenericUtils.split((String)proxyJump, (char)',')) {
            String j = jump.trim();
            URI uri = URI.create(j.contains("//") ? j : "ssh://" + j);
            if (GenericUtils.isNotEmpty((CharSequence)uri.getScheme()) && !"ssh".equals(uri.getScheme())) {
                throw new IllegalArgumentException("Unsupported scheme for proxy jump: " + jump);
            }
            String host = uri.getHost();
            int port = uri.getPort();
            String userInfo = uri.getUserInfo();
            HostConfigEntry entry = this.resolveHost(userInfo, host, port, context, null);
            jumps.add(entry);
        }
        return jumps;
    }

    protected HostConfigEntry resolveHost(String username, String host, int port, AttributeRepository context, SocketAddress localAddress) throws IOException {
        HostConfigEntryResolver resolver = this.getHostConfigEntryResolver();
        HostConfigEntry entry = resolver.resolveEffectiveHost(host, port, localAddress, username, null, context);
        if (entry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}@{}:{}) no overrides", new Object[]{username, host, port});
            }
            entry = SshdSocketAddress.isIPv6Address((String)host) ? new HostConfigEntry("", host, port, username, null) : new HostConfigEntry(host, host, port, username, null);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("connect({}@{}:{}) effective: {}", new Object[]{username, host, port, entry});
        }
        return entry;
    }

    protected KeyIdentityProvider preloadClientIdentities(Collection<? extends NamedResource> locations) throws IOException {
        return GenericUtils.isEmpty(locations) ? KeyIdentityProvider.EMPTY_KEYS_PROVIDER : ClientIdentityLoader.asKeyIdentityProvider((ClientIdentityLoader)Objects.requireNonNull(this.getClientIdentityLoader(), "No ClientIdentityLoader"), locations, (FilePasswordProvider)this.getFilePasswordProvider(), (boolean)((Boolean)CoreModuleProperties.IGNORE_INVALID_IDENTITIES.getRequired((PropertyResolver)this)));
    }

    protected SshFutureListener<IoConnectFuture> createConnectCompletionListener(final ConnectFuture connectFuture, final String username, final SocketAddress address, final KeyIdentityProvider identities, final boolean useDefaultIdentities) {
        return new SshFutureListener<IoConnectFuture>(){

            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                    return;
                }
                Throwable t = future.getException();
                if (t != null) {
                    if (SshClient.this.log.isDebugEnabled()) {
                        SshClient.this.log.debug("operationComplete({}@{}) failed ({}): {}", new Object[]{username, address, t.getClass().getSimpleName(), t.getMessage()});
                    }
                    connectFuture.setException(t);
                } else {
                    IoSession ioSession = future.getSession();
                    try {
                        SshClient.this.onConnectOperationComplete(ioSession, connectFuture, username, address, identities, useDefaultIdentities);
                    }
                    catch (IOException | RuntimeException | GeneralSecurityException e) {
                        SshClient.this.warn("operationComplete({}@{}) failed ({}) to signal completion of session={}: {}", username, address, e.getClass().getSimpleName(), ioSession, e.getMessage(), e);
                        connectFuture.setException(e);
                        ioSession.close(true);
                    }
                }
            }

            public String toString() {
                return "ConnectCompletionListener[" + username + "@" + address + "]";
            }
        };
    }

    protected void onConnectOperationComplete(IoSession ioSession, ConnectFuture connectFuture, String username, SocketAddress address, KeyIdentityProvider identities, boolean useDefaultIdentities) throws IOException, GeneralSecurityException {
        AbstractClientSession session = (AbstractClientSession)AbstractSession.getSession(ioSession);
        session.setUsername(username);
        session.setConnectAddress(address);
        if (useDefaultIdentities) {
            this.setupDefaultSessionIdentities(session, identities);
        } else {
            session.setKeyIdentityProvider(identities == null ? KeyIdentityProvider.EMPTY_KEYS_PROVIDER : identities);
        }
        connectFuture.setSession(session);
    }

    protected void setupDefaultSessionIdentities(ClientSession session, KeyIdentityProvider extraIdentities) throws IOException, GeneralSecurityException {
        PasswordIdentityProvider passClient;
        PasswordIdentityProvider passSession;
        KeyIdentityProvider kpEffective;
        KeyIdentityProvider kpClient;
        boolean debugEnabled = this.log.isDebugEnabled();
        KeyIdentityProvider kpSession = session.getKeyIdentityProvider();
        if (UnaryEquator.isSameReference((Object)kpSession, (Object)(kpClient = this.getKeyIdentityProvider())) && debugEnabled) {
            this.log.debug("setupDefaultSessionIdentities({}) key identity provider override in session listener", (Object)session);
        }
        if (!UnaryEquator.isSameReference((Object)kpSession, (Object)(kpEffective = KeyIdentityProvider.resolveKeyIdentityProvider((KeyIdentityProvider)extraIdentities, (KeyIdentityProvider)kpSession)))) {
            if (debugEnabled) {
                this.log.debug("setupDefaultSessionIdentities({}) key identity provider enhanced", (Object)session);
            }
            session.setKeyIdentityProvider(kpEffective);
        }
        if (!UnaryEquator.isSameReference((Object)(passSession = session.getPasswordIdentityProvider()), (Object)(passClient = this.getPasswordIdentityProvider())) && debugEnabled) {
            this.log.debug("setupDefaultSessionIdentities({}) password provider override", (Object)session);
        }
        AuthenticationIdentitiesProvider idsClient = this.getRegisteredIdentities();
        boolean traceEnabled = this.log.isTraceEnabled();
        Iterator iter = GenericUtils.iteratorOf(idsClient == null ? null : idsClient.loadIdentities((SessionContext)session));
        while (iter.hasNext()) {
            Object id = iter.next();
            if (id instanceof String) {
                if (traceEnabled) {
                    this.log.trace("setupDefaultSessionIdentities({}) add password fingerprint={}", (Object)session, (Object)KeyUtils.getFingerPrint((String)id.toString()));
                }
                session.addPasswordIdentity((String)id);
                continue;
            }
            if (id instanceof KeyPair) {
                KeyPair kp = (KeyPair)id;
                if (traceEnabled) {
                    this.log.trace("setupDefaultSessionIdentities({}) add identity type={}, fingerprint={}", new Object[]{session, KeyUtils.getKeyType((KeyPair)kp), KeyUtils.getFingerPrint((PublicKey)kp.getPublic())});
                }
                session.addPublicKeyIdentity(kp);
                continue;
            }
            if (!debugEnabled) continue;
            this.log.debug("setupDefaultSessionIdentities({}) ignored identity={}", (Object)session, id);
        }
    }

    protected IoConnector createConnector() {
        return this.getIoServiceFactory().createConnector((IoHandler)this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SimpleClient setUpDefaultSimpleClient() {
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        return SshClient.wrapAsSimpleClient(client);
    }

    public static SimpleClient wrapAsSimpleClient(final SshClient client) {
        Objects.requireNonNull(client, "No client instance");
        Channel channel = new Channel(){

            @Override
            public boolean isOpen() {
                return client.isOpen();
            }

            @Override
            public void close() throws IOException {
                Exception err = null;
                try {
                    client.close();
                }
                catch (Exception e) {
                    err = (Exception)ExceptionUtils.accumulateException(err, (Throwable)e);
                }
                try {
                    client.stop();
                }
                catch (Exception e) {
                    err = (Exception)ExceptionUtils.accumulateException((Throwable)err, (Throwable)e);
                }
                if (err != null) {
                    if (err instanceof IOException) {
                        throw (IOException)err;
                    }
                    throw new IOException(err);
                }
            }
        };
        return AbstractSimpleClientSessionCreator.wrap(client, channel);
    }

    public static SshClient setUpDefaultClient() {
        ClientBuilder builder = ClientBuilder.builder();
        return (SshClient)builder.build();
    }

    public static <C extends SshClient> C setKeyPairProvider(C client, boolean strict, boolean supportedOnly, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        return SshClient.setKeyPairProvider(client, PublicKeyEntry.getDefaultKeysFolderPath(), strict, supportedOnly, provider, options);
    }

    public static <C extends SshClient> C setKeyPairProvider(C client, Path dir, boolean strict, boolean supportedOnly, FilePasswordProvider provider, LinkOption ... options) throws IOException, GeneralSecurityException {
        KeyPairProvider kpp = ClientIdentity.loadDefaultKeyPairProvider((Path)dir, (boolean)strict, (boolean)supportedOnly, (FilePasswordProvider)provider, (LinkOption[])options);
        if (kpp != null) {
            client.setKeyIdentityProvider((KeyIdentityProvider)kpp);
        }
        return client;
    }
}

