/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.security;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import org.apache.commons.math3.util.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.storm.common.AbstractAutoCreds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoHDFS
extends AbstractAutoCreds {
    private static final Logger LOG = LoggerFactory.getLogger(AutoHDFS.class);
    public static final String HDFS_CREDENTIALS = "HDFS_CREDENTIALS";
    public static final String TOPOLOGY_HDFS_URI = "topology.hdfs.uri";
    private String hdfsKeyTab;
    private String hdfsPrincipal;

    @Override
    public void doPrepare(Map<String, Object> conf) {
        if (conf.containsKey("hdfs.keytab.file") && conf.containsKey("hdfs.kerberos.principal")) {
            this.hdfsKeyTab = (String)conf.get("hdfs.keytab.file");
            this.hdfsPrincipal = (String)conf.get("hdfs.kerberos.principal");
        }
    }

    @Override
    protected String getConfigKeyString() {
        return "hdfsCredentialsConfigKeys";
    }

    public void shutdown() {
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf, String configKey) {
        Configuration configuration = this.getHadoopConfiguration(conf, configKey);
        return this.getHadoopCredentials(conf, configuration);
    }

    @Override
    protected byte[] getHadoopCredentials(Map<String, Object> conf) {
        return this.getHadoopCredentials(conf, new Configuration());
    }

    private Configuration getHadoopConfiguration(Map<String, Object> topoConf, String configKey) {
        Configuration configuration = new Configuration();
        this.fillHadoopConfiguration(topoConf, configKey, configuration);
        return configuration;
    }

    private byte[] getHadoopCredentials(Map<String, Object> conf, final Configuration configuration) {
        try {
            if (UserGroupInformation.isSecurityEnabled()) {
                this.login(configuration);
                final String topologySubmitterUser = (String)conf.get("topology.submitter.principal");
                final URI nameNodeURI = conf.containsKey(TOPOLOGY_HDFS_URI) ? new URI(conf.get(TOPOLOGY_HDFS_URI).toString()) : FileSystem.getDefaultUri((Configuration)configuration);
                UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
                final UserGroupInformation proxyUser = UserGroupInformation.createProxyUser((String)topologySubmitterUser, (UserGroupInformation)ugi);
                Credentials creds = (Credentials)proxyUser.doAs((PrivilegedAction)new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            FileSystem fileSystem = FileSystem.get((URI)nameNodeURI, (Configuration)configuration);
                            Credentials credential = proxyUser.getCredentials();
                            if (configuration.get("hdfs.kerberos.principal") == null) {
                                configuration.set("hdfs.kerberos.principal", AutoHDFS.this.hdfsPrincipal);
                            }
                            fileSystem.addDelegationTokens(configuration.get("hdfs.kerberos.principal"), credential);
                            LOG.info("Delegation tokens acquired for user {}", (Object)topologySubmitterUser);
                            return credential;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bao);
                creds.write((DataOutput)out);
                out.flush();
                out.close();
                return bao.toByteArray();
            }
            throw new RuntimeException("Security is not enabled for HDFS");
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to get delegation tokens.", ex);
        }
    }

    @Override
    public void doRenew(Map<String, String> credentials, Map<String, Object> topologyConf) {
        for (Pair<String, Credentials> cred : this.getCredentials(credentials)) {
            try {
                Configuration configuration = this.getHadoopConfiguration(topologyConf, (String)cred.getFirst());
                Collection tokens = ((Credentials)cred.getSecond()).getAllTokens();
                if (tokens != null && !tokens.isEmpty()) {
                    for (Token token : tokens) {
                        this.login(configuration);
                        long expiration = token.renew(configuration);
                        LOG.info("HDFS delegation token renewed, new expiration time {}", (Object)expiration);
                    }
                    continue;
                }
                LOG.debug("No tokens found for credentials, skipping renewal.");
            }
            catch (Exception e) {
                LOG.warn("could not renew the credentials, one of the possible reason is tokens are beyond renewal period so attempting to get new tokens.", (Throwable)e);
                this.populateCredentials(credentials, topologyConf);
            }
        }
    }

    private void login(Configuration configuration) throws IOException {
        if (configuration.get("hdfs.keytab.file") == null) {
            configuration.set("hdfs.keytab.file", this.hdfsKeyTab);
        }
        if (configuration.get("hdfs.kerberos.principal") == null) {
            configuration.set("hdfs.kerberos.principal", this.hdfsPrincipal);
        }
        SecurityUtil.login((Configuration)configuration, (String)"hdfs.keytab.file", (String)"hdfs.kerberos.principal");
        LOG.info("Logged into hdfs with principal {}", (Object)configuration.get("hdfs.kerberos.principal"));
    }

    @Override
    protected String getCredentialKey(String configKey) {
        return HDFS_CREDENTIALS + configKey;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("topology.submitter.principal", args[0]);
        conf.put("hdfs.kerberos.principal", args[1]);
        conf.put("hdfs.keytab.file", args[2]);
        Configuration configuration = new Configuration();
        AutoHDFS autoHDFS = new AutoHDFS();
        autoHDFS.prepare(conf);
        HashMap<String, String> creds = new HashMap<String, String>();
        autoHDFS.populateCredentials(creds, conf);
        LOG.info("Got HDFS credentials", autoHDFS.getCredentials(creds));
        Subject s = new Subject();
        autoHDFS.populateSubject(s, creds);
        LOG.info("Got a Subject " + s);
        autoHDFS.renew(creds, conf);
        LOG.info("renewed credentials", autoHDFS.getCredentials(creds));
    }
}

