/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.misc.metric;

import com.esotericsoftware.kryo.io.Output;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.serialization.KryoValuesSerializer;
import org.apache.storm.task.IErrorReporter;
import org.apache.storm.task.TopologyContext;

public class HttpForwardingMetricsConsumer
implements IMetricsConsumer {
    private transient URL _url;
    private transient IErrorReporter _errorReporter;
    private transient KryoValuesSerializer _serializer;

    public void prepare(Map<String, Object> topoConf, Object registrationArgument, TopologyContext context, IErrorReporter errorReporter) {
        try {
            this._url = new URL((String)registrationArgument);
            this._errorReporter = errorReporter;
            this._serializer = new KryoValuesSerializer(topoConf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void handleDataPoints(IMetricsConsumer.TaskInfo taskInfo, Collection<IMetricsConsumer.DataPoint> dataPoints) {
        try {
            HttpURLConnection con = (HttpURLConnection)this._url.openConnection();
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            Output out = new Output(con.getOutputStream());
            this._serializer.serializeInto(Arrays.asList(taskInfo, dataPoints), out);
            out.flush();
            out.close();
            int n = con.getResponseCode();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanup() {
    }
}

