/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.misc.metric;

import com.esotericsoftware.kryo.io.Input;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.utils.Utils;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public abstract class HttpForwardingMetricsServer {
    private Map _conf;
    private Server _server = null;
    private int _port = -1;
    private String _url = null;
    ThreadLocal<KryoValuesDeserializer> _des = new ThreadLocal<KryoValuesDeserializer>(){

        @Override
        protected KryoValuesDeserializer initialValue() {
            return new KryoValuesDeserializer(HttpForwardingMetricsServer.this._conf);
        }
    };

    public HttpForwardingMetricsServer(Map<String, Object> conf) {
        this._conf = Utils.readStormConfig();
        if (conf != null) {
            this._conf.putAll(conf);
        }
    }

    public abstract void handle(IMetricsConsumer.TaskInfo var1, Collection<IMetricsConsumer.DataPoint> var2);

    public void serve(Integer port) {
        try {
            if (this._server != null) {
                throw new RuntimeException("The server is already running");
            }
            if (port == null || port <= 0) {
                ServerSocket s = new ServerSocket(0);
                port = s.getLocalPort();
                s.close();
            }
            this._server = new Server(port.intValue());
            this._port = port;
            this._url = "http://" + InetAddress.getLocalHost().getHostName() + ":" + this._port + "/";
            ServletContextHandler context = new ServletContextHandler(1);
            context.setContextPath("/");
            this._server.setHandler((Handler)context);
            context.addServlet(new ServletHolder((Servlet)new MetricsCollectionServlet()), "/*");
            this._server.start();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void serve() {
        this.serve(null);
    }

    public int getPort() {
        return this._port;
    }

    public String getUrl() {
        return this._url;
    }

    private class MetricsCollectionServlet
    extends HttpServlet {
        private MetricsCollectionServlet() {
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            Input in = new Input((InputStream)request.getInputStream());
            List metrics = HttpForwardingMetricsServer.this._des.get().deserializeFrom(in);
            HttpForwardingMetricsServer.this.handle((IMetricsConsumer.TaskInfo)metrics.get(0), (Collection)metrics.get(1));
            response.setStatus(200);
        }
    }
}

