/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.networktopography.DNSToSwitchMapping;
import org.apache.storm.utils.Utils;
import org.apache.storm.validation.ConfigValidation;
import org.apache.storm.validation.ConfigValidationAnnotations;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestConfigValidate {
    private static final Logger LOG = LoggerFactory.getLogger(TestConfigValidate.class);

    @Test
    public void validPacemakerAuthTest() throws InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("pacemaker.auth.method", "NONE");
        ConfigValidation.validateFields(conf);
        conf.put("pacemaker.auth.method", "DIGEST");
        ConfigValidation.validateFields(conf);
        conf.put("pacemaker.auth.method", "KERBEROS");
        ConfigValidation.validateFields(conf);
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidPacemakerAuthTest() throws InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        HashMap<String, String> conf = new HashMap<String, String>();
        conf.put("pacemaker.auth.method", "invalid");
        ConfigValidation.validateFields(conf);
    }

    @Test
    public void validConfigTest() throws InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        HashMap<String, Constable> conf = new HashMap<String, Constable>();
        conf.put("storm.messaging.netty.socket.backlog", Integer.valueOf(5));
        conf.put("storm.messaging.netty.min_wait_ms", Integer.valueOf(500));
        conf.put("storm.messaging.netty.authentication", Boolean.valueOf(true));
        ConfigValidation.validateFields(conf);
    }

    @Test(expected=IllegalArgumentException.class)
    public void invalidConfigTest() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("storm.messaging.netty.socket.backlog", 5);
        conf.put("storm.messaging.netty.min_wait_ms", 500);
        conf.put("storm.messaging.netty.authentication", "invalid");
        ConfigValidation.validateFields(conf);
    }

    @Test(expected=InvalidTopologyException.class)
    public void testValidateTopologyBlobStoreMap() throws InvalidTopologyException {
        HashMap topoConf = new HashMap();
        HashMap topologyMap = new HashMap();
        topologyMap.put("key1", new HashMap());
        topologyMap.put("key2", new HashMap());
        topoConf.put("topology.blobstore.map", topologyMap);
        HashSet<String> keySet = new HashSet<String>();
        keySet.add("key1");
        keySet.add("key2");
        Utils.validateTopologyBlobStoreMap(topoConf, keySet);
        keySet.remove("key2");
        Utils.validateTopologyBlobStoreMap(topoConf, keySet);
    }

    @Test
    public void defaultYamlTest() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        Map conf = Utils.readStormConfig();
        ConfigValidation.validateFields((Map)conf);
    }

    @Test
    public void testTopologyWorkersIsInteger() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        HashMap<String, Number> conf = new HashMap<String, Number>();
        conf.put("topology.workers", 42);
        ConfigValidation.validateFields(conf);
        conf.put("topology.workers", 3.14159);
        try {
            ConfigValidation.validateFields(conf);
            Assert.fail((String)"Expected Exception not Thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTopologyStatsSampleRateIsFloat() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        HashMap<String, Number> conf = new HashMap<String, Number>();
        conf.put("topology.stats.sample.rate", 0.5);
        ConfigValidation.validateFields(conf);
        conf.put("topology.stats.sample.rate", 10);
        ConfigValidation.validateFields(conf);
        conf.put("topology.stats.sample.rate", Double.MAX_VALUE);
        ConfigValidation.validateFields(conf);
    }

    @Test
    public void testWorkerChildoptsIsStringOrStringList() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        HashMap conf = new HashMap();
        LinkedList<Object> passCases = new LinkedList<Object>();
        LinkedList<Object> failCases = new LinkedList<Object>();
        passCases.add(null);
        passCases.add("some string");
        String[] stuff = new String[]{"some", "string", "list"};
        passCases.add(Arrays.asList(stuff));
        failCases.add(42);
        Integer[] wrongStuff = new Integer[]{1, 2, 3};
        failCases.add(Arrays.asList(wrongStuff));
        for (Object e : passCases) {
            conf.put("worker.childopts", e);
            ConfigValidation.validateFields(conf);
        }
        for (Object e : failCases) {
            try {
                conf.put("worker.childopts", e);
                ConfigValidation.validateFields(conf);
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        conf = new HashMap();
        for (Object e : passCases) {
            conf.put("topology.worker.childopts", e);
            ConfigValidation.validateFields(conf);
        }
        for (Object e : failCases) {
            try {
                conf.put("topology.worker.childopts", e);
                ConfigValidation.validateFields(conf);
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testValidity() {
        HashMap<String, Object> conf = new HashMap<String, Object>();
        conf.put("topology.debug", true);
        conf.put("q", "asasdasd");
        conf.put("aaa", new Integer("123"));
        conf.put("bbb", new Long("456"));
        ArrayList<Number> testList = new ArrayList<Number>();
        testList.add(1);
        testList.add(2);
        testList.add(new Integer("3"));
        testList.add(new Long("4"));
        conf.put("eee", testList);
        Utils.isValidConf(conf);
    }

    @Test
    public void testKryoRegValidator() {
        Object[] failCases;
        ConfigValidation.KryoRegValidator validator = new ConfigValidation.KryoRegValidator();
        for (Object value : failCases = new Object[]{ImmutableMap.of((Object)"f", (Object)"g"), ImmutableList.of((Object)1), Arrays.asList(ImmutableMap.of((Object)"a", (Object)1))}) {
            try {
                validator.validateField("test", value);
                Assert.fail((String)("Expected Exception not Thrown for value: " + value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        validator.validateField("test", Arrays.asList("a", "b", "c", ImmutableMap.of((Object)"d", (Object)"e"), ImmutableMap.of((Object)"f", (Object)"g")));
    }

    @Test
    public void testPowerOf2Validator() {
        Object[] passCases;
        Object[] failCases;
        ConfigValidation.PowerOf2Validator validator = new ConfigValidation.PowerOf2Validator();
        for (Object value : failCases = new Object[]{42.42, 42, -33, 2.3423423423E10, -32, -1, -1.0E-5, 0, 0, "Forty-two"}) {
            try {
                validator.validateField("test", value);
                Assert.fail((String)("Expected Exception not Thrown for value: " + value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (Object value : passCases = new Object[]{64, 4.294967296E9, 1, null}) {
            validator.validateField("test", value);
        }
    }

    @Test
    public void testPositiveNumberValidator() {
        Object[] failCasesIncludeZero;
        Object[] passCasesIncludeZero;
        Object[] failCases;
        Object[] passCases;
        ConfigValidation.PositiveNumberValidator validator = new ConfigValidation.PositiveNumberValidator();
        for (Object value : passCases = new Object[]{null, 1.0, 0.01, 1, Integer.MAX_VALUE, 42}) {
            validator.validateField("test", value);
        }
        for (Object value : failCases = new Object[]{-1.0, -1, -0.01, 0.0, 0, "43", "string"}) {
            try {
                validator.validateField("test", value);
                Assert.fail((String)("Expected Exception not Thrown for value: " + value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (Object value : passCasesIncludeZero = new Object[]{null, 1.0, 0.01, 0, Integer.MAX_VALUE, 0.0}) {
            ConfigValidation.PositiveNumberValidator.validateField((String)"test", (boolean)true, (Object)value);
        }
        for (Object value : failCasesIncludeZero = new Object[]{-1.0, -1, -0.01, "43", "string"}) {
            try {
                ConfigValidation.PositiveNumberValidator.validateField((String)"test", (boolean)true, (Object)value);
                Assert.fail((String)("Expected Exception not Thrown for value: " + value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testIntegerValidator() {
        Object[] failCases;
        Object[] passCases;
        ConfigValidation.IntegerValidator validator = new ConfigValidation.IntegerValidator();
        for (Object value : passCases = new Object[]{null, 1000, Integer.MAX_VALUE}) {
            validator.validateField("test", value);
        }
        for (Object value : failCases = new Object[]{1.34, new Long(Integer.MAX_VALUE) + 1L}) {
            try {
                validator.validateField("test", value);
                Assert.fail((String)("Expected Exception not Thrown for value: " + value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void NoDuplicateInListValidator() {
        ConfigValidation.NoDuplicateInListValidator validator = new ConfigValidation.NoDuplicateInListValidator();
        LinkedList<List<Object>> passCases = new LinkedList<List<Object>>();
        LinkedList<List<Object>> failCases = new LinkedList<List<Object>>();
        Object[] passCase1 = new Object[]{1000, 0, -1000};
        Object[] passCase2 = new Object[]{"one", "two", "three"};
        Object[] passCase3 = new Object[]{false, true};
        Object[] passCase4 = new Object[]{false, true, 1000, 0, -1000, "one", "two", "three"};
        Object[] passCase5 = new Object[]{1000.0, 0.0, -1000.0};
        passCases.add(Arrays.asList(passCase1));
        passCases.add(Arrays.asList(passCase2));
        passCases.add(Arrays.asList(passCase3));
        passCases.add(Arrays.asList(passCase4));
        passCases.add(Arrays.asList(passCase5));
        passCases.add(null);
        for (Object e : passCases) {
            validator.validateField("test", e);
        }
        Object[] failCase1 = new Object[]{1000, 0, 1000};
        Object[] objectArray = new Object[]{"one", "one", "two"};
        Object[] failCase3 = new Object[]{5.0, 5.0, 6};
        failCases.add(Arrays.asList(failCase1));
        failCases.add(Arrays.asList(objectArray));
        failCases.add(Arrays.asList(failCase3));
        for (Object e : failCases) {
            try {
                validator.validateField("test", e);
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testListEntryTypeValidator() {
        LinkedList<List<Object>> testCases1 = new LinkedList<List<Object>>();
        LinkedList<List<Object>> testCases2 = new LinkedList<List<Object>>();
        LinkedList<List<Object>> testCases3 = new LinkedList<List<Object>>();
        Object[] testCase1 = new Object[]{"one", "two", "three"};
        Object[] testCase2 = new Object[]{"three"};
        testCases1.add(Arrays.asList(testCase1));
        testCases1.add(Arrays.asList(testCase2));
        for (Object e : testCases1) {
            ConfigValidation.ListEntryTypeValidator.validateField((String)"test", String.class, e);
        }
        for (Object e : testCases1) {
            try {
                ConfigValidation.ListEntryTypeValidator.validateField((String)"test", Number.class, e);
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        Object[] testCase3 = new Object[]{1000, 0, 1000};
        Object[] objectArray = new Object[]{5};
        Object[] testCase5 = new Object[]{5.0, 5.0, 6};
        testCases2.add(Arrays.asList(testCase3));
        testCases2.add(Arrays.asList(objectArray));
        testCases2.add(Arrays.asList(testCase5));
        for (Object e : testCases2) {
            try {
                ConfigValidation.ListEntryTypeValidator.validateField((String)"test", String.class, e);
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        for (Object e : testCases2) {
            ConfigValidation.ListEntryTypeValidator.validateField((String)"test", Number.class, e);
        }
        Object[] testCase6 = new Object[]{1000, 0, 1000, "5"};
        Object[] objectArray2 = new Object[]{"4", "5", 5};
        testCases3.add(Arrays.asList(testCase6));
        testCases3.add(Arrays.asList(objectArray2));
        for (Object e : testCases3) {
            try {
                ConfigValidation.ListEntryTypeValidator.validateField((String)"test", String.class, e);
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        for (Object e : testCases1) {
            try {
                ConfigValidation.ListEntryTypeValidator.validateField((String)"test", Number.class, e);
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testMapEntryTypeAnnotation() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        TestConfig config = new TestConfig();
        LinkedList passCases = new LinkedList();
        LinkedList failCases = new LinkedList();
        HashMap<String, Integer> passCase1 = new HashMap<String, Integer>();
        passCase1.put("aaa", 5);
        passCase1.put("bbb", 6);
        passCase1.put("ccc", 7);
        passCases.add(passCase1);
        passCases.add(null);
        for (Object e : passCases) {
            config.put("test.map.config", e);
            ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
        }
        HashMap<Object, Integer> failCase1 = new HashMap<Object, Integer>();
        failCase1.put("aaa", 5);
        failCase1.put(5, 6);
        failCase1.put("ccc", 7);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("aaa", "str");
        hashMap.put("bbb", 6);
        hashMap.put("ccc", 7);
        failCases.add(failCase1);
        failCases.add(hashMap);
        for (Object e : failCases) {
            try {
                config.put("test.map.config", e);
                ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testMapEntryCustomAnnotation() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        TestConfig config = new TestConfig();
        LinkedList passCases = new LinkedList();
        LinkedList failCases = new LinkedList();
        HashMap<String, Integer> passCase1 = new HashMap<String, Integer>();
        passCase1.put("aaa", 5);
        passCase1.put("bbb", 100);
        passCase1.put("ccc", Integer.MAX_VALUE);
        passCases.add(passCase1);
        passCases.add(null);
        for (Object e : passCases) {
            config.put("test.map.config.2", e);
            ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
        }
        HashMap<Object, Integer> failCase1 = new HashMap<Object, Integer>();
        failCase1.put("aaa", 5);
        failCase1.put(5, 6);
        failCase1.put("ccc", 7);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("aaa", "str");
        hashMap.put("bbb", 6);
        hashMap.put("ccc", 7);
        HashMap<String, Integer> failCase3 = new HashMap<String, Integer>();
        failCase3.put("aaa", -1);
        failCase3.put("bbb", 6);
        failCase3.put("ccc", 7);
        HashMap<String, Number> failCase4 = new HashMap<String, Number>();
        failCase4.put("aaa", 1);
        failCase4.put("bbb", 6);
        failCase4.put("ccc", 7.4);
        failCases.add(failCase1);
        failCases.add(hashMap);
        failCases.add(failCase3);
        failCases.add(failCase4);
        for (Object e : failCases) {
            try {
                config.put("test.map.config.2", e);
                ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testListEntryTypeAnnotation() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        TestConfig config = new TestConfig();
        LinkedList<List<Object>> passCases = new LinkedList<List<Object>>();
        LinkedList<Object> failCases = new LinkedList<Object>();
        Object[] passCase1 = new Object[]{1, 5.0, -0.01, 0, Integer.MAX_VALUE, Double.MIN_VALUE};
        Object[] passCase2 = new Object[]{1};
        passCases.add(Arrays.asList(passCase1));
        passCases.add(Arrays.asList(passCase2));
        for (Object e : passCases) {
            config.put("test.map.config.3", e);
            ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
        }
        Object[] failCase1 = new Object[]{1, 5.0, -0.01, 0, "aaa"};
        Object[] objectArray = new Object[]{"aaa"};
        failCases.add(failCase1);
        failCases.add(objectArray);
        failCases.add(1);
        failCases.add("b");
        failCases.add(null);
        for (Object e : failCases) {
            try {
                config.put("test.map.config.3", e);
                ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void testListEntryCustomAnnotation() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        TestConfig config = new TestConfig();
        LinkedList<List<Object>> passCases = new LinkedList<List<Object>>();
        LinkedList<Object> failCases = new LinkedList<Object>();
        Object[] passCase1 = new Object[]{1, 5.0, 0.01, Double.MAX_VALUE};
        Object[] passCase2 = new Object[]{1};
        passCases.add(Arrays.asList(passCase1));
        passCases.add(Arrays.asList(passCase2));
        for (Object e : passCases) {
            config.put("test.map.config.4", e);
            ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
        }
        Object[] failCase1 = new Object[]{1, 5.0, -0.01, 3.0};
        Object[] objectArray = new Object[]{1, 5.0, -0.01, 1};
        Object[] failCase3 = new Object[]{"aaa", "bbb", "aaa"};
        Object[] failCase4 = new Object[]{1, 5.0, null, 1};
        Object[] failCase5 = new Object[]{1, 5.0, 0, 1};
        failCases.add(Arrays.asList(failCase1));
        failCases.add(Arrays.asList(objectArray));
        failCases.add(Arrays.asList(failCase3));
        failCases.add(Arrays.asList(failCase4));
        failCases.add(Arrays.asList(failCase5));
        failCases.add(1);
        failCases.add("b");
        for (Object e : failCases) {
            try {
                config.put("test.map.config.4", e);
                ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void TestAcceptedStrings() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        String[] failCases;
        String[] passCases;
        TestConfig config = new TestConfig();
        for (String value : passCases = new String[]{"aaa", "bbb", "ccc"}) {
            config.put("test.map.config.5", value);
            ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
        }
        for (String value : failCases = new String[]{"aa", "bb", "cc", "abc", "a", "b", "c", ""}) {
            try {
                config.put("test.map.config.5", value);
                ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
                Assert.fail((String)("Expected Exception not Thrown for value: " + value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test
    public void TestImpersonationAclUserEntryValidator() throws InvocationTargetException, NoSuchMethodException, NoSuchFieldException, InstantiationException, IllegalAccessException {
        TestConfig config = new TestConfig();
        LinkedList passCases = new LinkedList();
        LinkedList<Object> failCases = new LinkedList<Object>();
        HashMap passCase1 = new HashMap();
        HashMap<String, List<String>> passCase1_hostsAndGroups = new HashMap<String, List<String>>();
        String[] hosts = new String[]{"host.1", "host.2", "host.3"};
        passCase1_hostsAndGroups.put("hosts", Arrays.asList(hosts));
        String[] groups = new String[]{"group.1", "group.2", "group.3"};
        passCase1_hostsAndGroups.put("groups", Arrays.asList(groups));
        passCase1.put("jerry", passCase1_hostsAndGroups);
        passCases.add(passCase1);
        for (Object e : passCases) {
            config.put("test.map.config.6", e);
            ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
        }
        HashMap failCase1 = new HashMap();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        String[] failhosts = new String[]{"host.1", "host.2", "host.3"};
        hashMap.put("hosts", Arrays.asList(hosts));
        failCase1.put("jerry", hashMap);
        HashMap failCase2 = new HashMap();
        HashMap<String, List<String>> failCase2_hostsAndGroups = new HashMap<String, List<String>>();
        String[] failgroups = new String[]{"group.1", "group.2", "group.3"};
        failCase2_hostsAndGroups.put("groups", Arrays.asList(groups));
        failCase2.put("jerry", failCase2_hostsAndGroups);
        failCases.add(failCase1);
        failCases.add(failCase2);
        failCases.add("stuff");
        failCases.add(5);
        for (Object e : failCases) {
            try {
                config.put("test.map.config.6", e);
                ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void TestResourceAwareSchedulerUserPool() {
        TestConfig config = new TestConfig();
        LinkedList failCases = new LinkedList();
        HashMap passCase1 = new HashMap();
        passCase1.put("jerry", new HashMap());
        passCase1.put("bobby", new HashMap());
        passCase1.put("derek", new HashMap());
        ((Map)passCase1.get("jerry")).put("cpu", 10000);
        ((Map)passCase1.get("jerry")).put("memory", 20148);
        ((Map)passCase1.get("bobby")).put("cpu", 20000);
        ((Map)passCase1.get("bobby")).put("memory", 40148);
        ((Map)passCase1.get("derek")).put("cpu", 30000);
        ((Map)passCase1.get("derek")).put("memory", 60148);
        config.put("test.map.config.7", passCase1);
        ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
        HashMap failCase1 = new HashMap();
        failCase1.put("jerry", new HashMap());
        failCase1.put("bobby", new HashMap());
        failCase1.put("derek", new HashMap());
        ((Map)failCase1.get("jerry")).put("cpu", 10000);
        ((Map)failCase1.get("jerry")).put("memory", 20148);
        ((Map)failCase1.get("bobby")).put("cpu", 20000);
        ((Map)failCase1.get("bobby")).put("memory", 40148);
        ((Map)failCase1.get("derek")).put("cpu", 30000);
        HashMap failCase2 = new HashMap();
        failCase2.put("jerry", new HashMap());
        failCase2.put("bobby", new HashMap());
        failCase2.put("derek", new HashMap());
        ((Map)failCase2.get("bobby")).put("cpu", 20000);
        ((Map)failCase2.get("bobby")).put("memory", 40148);
        ((Map)failCase2.get("derek")).put("cpu", 30000);
        ((Map)failCase2.get("derek")).put("memory", 60148);
        failCases.add(failCase1);
        failCases.add(failCase2);
        for (Object e : failCases) {
            try {
                config.put("test.map.config.7", e);
                ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    @Test
    public void TestImplementsClassValidator() {
        TestConfig config = new TestConfig();
        LinkedList<String> passCases = new LinkedList<String>();
        LinkedList<String> failCases = new LinkedList<String>();
        passCases.add("org.apache.storm.networktopography.DefaultRackDNSToSwitchMapping");
        for (Object e : passCases) {
            config.put("test.map.config.8", e);
            ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
        }
        failCases.add("org.apache.storm.nimbus.NimbusInfo");
        failCases.add(null);
        for (Object e : failCases) {
            try {
                config.put("test.map.config.8", e);
                ConfigValidation.validateFields((Map)config, Arrays.asList(TestConfig.class));
                Assert.fail((String)("Expected Exception not Thrown for value: " + e));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    public class TestConfig
    extends HashMap<String, Object> {
        @ConfigValidationAnnotations.isMapEntryType(keyType=String.class, valueType=Integer.class)
        public static final String TEST_MAP_CONFIG = "test.map.config";
        @ConfigValidationAnnotations.isMapEntryCustom(keyValidatorClasses={ConfigValidation.StringValidator.class}, valueValidatorClasses={ConfigValidation.PositiveNumberValidator.class, ConfigValidation.IntegerValidator.class})
        public static final String TEST_MAP_CONFIG_2 = "test.map.config.2";
        @ConfigValidationAnnotations.isListEntryType(type=Number.class)
        @ConfigValidationAnnotations.NotNull
        public static final String TEST_MAP_CONFIG_3 = "test.map.config.3";
        @ConfigValidationAnnotations.isListEntryCustom(entryValidatorClasses={ConfigValidation.PositiveNumberValidator.class, ConfigValidation.NotNullValidator.class})
        @ConfigValidationAnnotations.isNoDuplicateInList
        public static final String TEST_MAP_CONFIG_4 = "test.map.config.4";
        @ConfigValidationAnnotations.isString(acceptedValues={"aaa", "bbb", "ccc"})
        public static final String TEST_MAP_CONFIG_5 = "test.map.config.5";
        @ConfigValidationAnnotations.isMapEntryCustom(keyValidatorClasses={ConfigValidation.StringValidator.class}, valueValidatorClasses={ConfigValidation.ImpersonationAclUserEntryValidator.class})
        public static final String TEST_MAP_CONFIG_6 = "test.map.config.6";
        @ConfigValidationAnnotations.isMapEntryCustom(keyValidatorClasses={ConfigValidation.StringValidator.class}, valueValidatorClasses={ConfigValidation.UserResourcePoolEntryValidator.class})
        public static final String TEST_MAP_CONFIG_7 = "test.map.config.7";
        @ConfigValidationAnnotations.isImplementationOfClass(implementsClass=DNSToSwitchMapping.class)
        @ConfigValidationAnnotations.NotNull
        public static final String TEST_MAP_CONFIG_8 = "test.map.config.8";
    }
}

