/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.cluster;

import org.apache.storm.callback.ZKStateChangedCallback;
import org.apache.storm.cluster.ClusterStateContext;
import org.apache.storm.cluster.ClusterUtils;
import org.apache.storm.cluster.IStateStorage;
import org.apache.storm.cluster.StormClusterStateImpl;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormClusterStateImplTest {
    private static final Logger LOG = LoggerFactory.getLogger(StormClusterStateImplTest.class);
    private final String[] pathlist = new String[]{"/assignments", "/storms", "/supervisors", "/workerbeats", "/errors", "/blobstore", "/nimbuses", "/logconfigs", "/backpressure"};
    private IStateStorage storage;
    private ClusterStateContext context;
    private StormClusterStateImpl state;

    @Before
    public void init() throws Exception {
        this.storage = (IStateStorage)Mockito.mock(IStateStorage.class);
        this.context = new ClusterStateContext();
        this.state = new StormClusterStateImpl(this.storage, null, this.context, false);
    }

    @Test
    public void registeredCallback() {
        ((IStateStorage)Mockito.verify((Object)this.storage)).register((ZKStateChangedCallback)Matchers.anyObject());
    }

    @Test
    public void createdZNodes() {
        for (String path : this.pathlist) {
            ((IStateStorage)Mockito.verify((Object)this.storage)).mkdirs(path, null);
        }
    }

    @Test
    public void removeBackpressureDoesNotThrowTest() {
        ((IStateStorage)Mockito.doThrow((Throwable)new RuntimeException((Throwable)new KeeperException.NoNodeException("foo"))).when((Object)this.storage)).delete_node(Matchers.anyString());
        try {
            this.state.removeBackpressure("bogus-topo-id");
            ((IStateStorage)Mockito.verify((Object)this.storage)).delete_node(ClusterUtils.backpressureStormRoot((String)"bogus-topo-id"));
        }
        catch (Exception e) {
            Assert.fail((String)("Exception thrown when it shouldn't have: " + e));
        }
    }

    @Test
    public void removeWorkerBackpressureDoesntAttemptForNonExistentZNodeTest() {
        Mockito.when((Object)this.storage.node_exists(Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)false);
        this.state.removeWorkerBackpressure("bogus-topo-id", "bogus-host", new Long(1234L));
        ((IStateStorage)Mockito.verify((Object)this.storage, (VerificationMode)Mockito.never())).delete_node(Matchers.anyString());
    }

    @Test
    public void removeWorkerBackpressureCleansForExistingZNodeTest() {
        Mockito.when((Object)this.storage.node_exists(Matchers.anyString(), Matchers.anyBoolean())).thenReturn((Object)true);
        this.state.removeWorkerBackpressure("bogus-topo-id", "bogus-host", new Long(1234L));
        ((IStateStorage)Mockito.verify((Object)this.storage)).delete_node(ClusterUtils.backpressurePath((String)"bogus-topo-id", (String)"bogus-host", (Long)new Long(1234L)));
    }
}

