/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.daemon.worker;

import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.storm.daemon.worker.LogConfigManager;
import org.apache.storm.generated.LogConfig;
import org.apache.storm.generated.LogLevel;
import org.apache.storm.generated.LogLevelAction;
import org.apache.storm.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConfigManagerTest {
    private static final Logger LOG = LoggerFactory.getLogger(LogConfigManagerTest.class);

    public static LogLevel ll() {
        return new LogLevel(LogLevelAction.UPDATE);
    }

    public static LogLevel ll(long epoc) {
        LogLevel ret = LogConfigManagerTest.ll();
        ret.set_reset_log_level_timeout_epoch(epoc);
        return ret;
    }

    public static LogLevel ll(String target, long epoc) {
        LogLevel ret = LogConfigManagerTest.ll();
        ret.set_target_log_level(target);
        ret.set_reset_log_level_timeout_epoch(epoc);
        return ret;
    }

    public static LogLevel ll(String target, String reset, long epoc) {
        LogLevel ret = LogConfigManagerTest.ll();
        ret.set_target_log_level(target);
        ret.set_reset_log_level(reset);
        ret.set_reset_log_level_timeout_epoch(epoc);
        return ret;
    }

    @Test
    public void testLogResetShouldNotTriggerForFutureTime() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            long theFuture = Time.currentTimeMillis() + 1000L;
            TreeMap<String, LogLevel> config = new TreeMap<String, LogLevel>();
            config.put("foo", LogConfigManagerTest.ll(theFuture));
            AtomicReference<TreeMap<String, LogLevel>> atomConf = new AtomicReference<TreeMap<String, LogLevel>>(config);
            LogConfigManagerUnderTest underTest = new LogConfigManagerUnderTest(atomConf);
            underTest.resetLogLevels();
            Assert.assertNotNull(atomConf.get());
        }
    }

    @Test
    public void testLogResetTriggersForPastTime() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            long past = Time.currentTimeMillis() - 1000L;
            TreeMap<String, LogLevel> config = new TreeMap<String, LogLevel>();
            config.put("foo", LogConfigManagerTest.ll("INFO", "WARN", past));
            AtomicReference<TreeMap<String, LogLevel>> atomConf = new AtomicReference<TreeMap<String, LogLevel>>(config);
            LogConfigManagerUnderTest underTest = new LogConfigManagerUnderTest(atomConf);
            underTest.resetLogLevels();
            Assert.assertEquals(new TreeMap(), atomConf.get());
        }
    }

    @Test
    public void testLogResetResetsDoesNothingForEmptyLogConfig() {
        TreeMap config = new TreeMap();
        AtomicReference<TreeMap<String, LogLevel>> atomConf = new AtomicReference<TreeMap<String, LogLevel>>(config);
        LogConfigManager underTest = (LogConfigManager)Mockito.spy((Object)((Object)new LogConfigManagerUnderTest(atomConf)));
        underTest.resetLogLevels();
        Assert.assertEquals(new TreeMap(), atomConf.get());
        ((LogConfigManager)Mockito.verify((Object)underTest, (VerificationMode)Mockito.never())).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.anyObject(), (String)Mockito.anyObject());
    }

    @Test
    public void testLogResetResetsRootLoggerIfSet() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            long past = Time.currentTimeMillis() - 1000L;
            TreeMap<String, LogLevel> config = new TreeMap<String, LogLevel>();
            config.put("", LogConfigManagerTest.ll("DEBUG", "WARN", past));
            AtomicReference<TreeMap<String, LogLevel>> atomConf = new AtomicReference<TreeMap<String, LogLevel>>(config);
            LogConfigManager underTest = (LogConfigManager)Mockito.spy((Object)((Object)new LogConfigManagerUnderTest(atomConf)));
            underTest.resetLogLevels();
            Assert.assertEquals(new TreeMap(), atomConf.get());
            ((LogConfigManager)Mockito.verify((Object)underTest)).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.eq((Object)""), (String)Mockito.eq((Object)"WARN"));
        }
    }

    @Test
    public void testLogResetsNamedLoggersWithPastTimeout() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            long past = Time.currentTimeMillis() - 1000L;
            TreeMap<String, LogLevel> config = new TreeMap<String, LogLevel>();
            config.put("my_debug_logger", LogConfigManagerTest.ll("DEBUG", "INFO", past));
            config.put("my_info_logger", LogConfigManagerTest.ll("INFO", "WARN", past));
            config.put("my_error_logger", LogConfigManagerTest.ll("ERROR", "INFO", past));
            AtomicReference<TreeMap<String, LogLevel>> atomConf = new AtomicReference<TreeMap<String, LogLevel>>(config);
            LogConfigManager underTest = (LogConfigManager)Mockito.spy((Object)((Object)new LogConfigManagerUnderTest(atomConf)));
            underTest.resetLogLevels();
            Assert.assertEquals(new TreeMap(), atomConf.get());
            ((LogConfigManager)Mockito.verify((Object)underTest)).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.eq((Object)"my_debug_logger"), (String)Mockito.eq((Object)"INFO"));
            ((LogConfigManager)Mockito.verify((Object)underTest)).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.eq((Object)"my_info_logger"), (String)Mockito.eq((Object)"WARN"));
            ((LogConfigManager)Mockito.verify((Object)underTest)).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.eq((Object)"my_error_logger"), (String)Mockito.eq((Object)"INFO"));
        }
    }

    @Test
    public void testProcessRootLogLevelToDebugSetsLoggerAndTimeout2() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            LogConfig mockConfig = new LogConfig();
            AtomicReference<Object> mockConfigAtom = new AtomicReference<Object>(null);
            long inThirtySeconds = Time.currentTimeMillis() + 30000L;
            mockConfig.put_to_named_logger_level("ROOT", LogConfigManagerTest.ll("DEBUG", inThirtySeconds));
            LogConfigManager underTest = (LogConfigManager)Mockito.spy((Object)((Object)new LogConfigManagerUnderTest(mockConfigAtom)));
            underTest.processLogConfigChange(mockConfig);
            LOG.info("Tests {}", mockConfigAtom.get());
            ((LogConfigManager)Mockito.verify((Object)underTest)).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.eq((Object)""), (String)Mockito.eq((Object)"DEBUG"));
            LogLevel rootResult = (LogLevel)((TreeMap)mockConfigAtom.get()).get("");
            Assert.assertNotNull((Object)rootResult);
            Assert.assertEquals((Object)LogLevelAction.UPDATE, (Object)rootResult.get_action());
            Assert.assertEquals((Object)"DEBUG", (Object)rootResult.get_target_log_level());
            Assert.assertEquals((Object)"INFO", (Object)rootResult.get_reset_log_level());
            Assert.assertEquals((long)inThirtySeconds, (long)rootResult.get_reset_log_level_timeout_epoch());
        }
    }

    @Test
    public void testProcessRootLogLevelToDebugSetsLoggerAndTimeout() {
        try (Time.SimulatedTime t = new Time.SimulatedTime();){
            LogConfig mockConfig = new LogConfig();
            AtomicReference<Object> mockConfigAtom = new AtomicReference<Object>(null);
            long inThirtySeconds = Time.currentTimeMillis() + 30000L;
            mockConfig.put_to_named_logger_level("ROOT", LogConfigManagerTest.ll("DEBUG", inThirtySeconds));
            mockConfig.put_to_named_logger_level("my_debug_logger", LogConfigManagerTest.ll("DEBUG", inThirtySeconds));
            mockConfig.put_to_named_logger_level("my_info_logger", LogConfigManagerTest.ll("INFO", inThirtySeconds));
            mockConfig.put_to_named_logger_level("my_error_logger", LogConfigManagerTest.ll("ERROR", inThirtySeconds));
            LOG.info("Tests {}", mockConfigAtom.get());
            LogConfigManager underTest = (LogConfigManager)Mockito.spy((Object)((Object)new LogConfigManagerUnderTest(mockConfigAtom)));
            underTest.processLogConfigChange(mockConfig);
            ((LogConfigManager)Mockito.verify((Object)underTest)).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.eq((Object)""), (String)Mockito.eq((Object)"DEBUG"));
            ((LogConfigManager)Mockito.verify((Object)underTest)).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.eq((Object)"my_debug_logger"), (String)Mockito.eq((Object)"DEBUG"));
            ((LogConfigManager)Mockito.verify((Object)underTest)).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.eq((Object)"my_info_logger"), (String)Mockito.eq((Object)"INFO"));
            ((LogConfigManager)Mockito.verify((Object)underTest)).setLoggerLevel((LoggerContext)Mockito.anyObject(), (String)Mockito.eq((Object)"my_error_logger"), (String)Mockito.eq((Object)"ERROR"));
        }
    }

    public static class LogConfigManagerUnderTest
    extends LogConfigManager {
        public LogConfigManagerUnderTest() {
        }

        public LogConfigManagerUnderTest(AtomicReference<TreeMap<String, LogLevel>> latestLogConfig) {
            super(latestLogConfig);
        }

        public void setLoggerLevel(LoggerContext logContext, String loggerName, String newLevelStr) {
        }
    }
}

