/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.grouping;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.grouping.PartialKeyGrouping;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class PartialKeyGroupingTest {
    @Test
    public void testChooseTasks() {
        PartialKeyGrouping pkg = new PartialKeyGrouping();
        pkg.prepare(null, null, (List)Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4, 5}));
        Values message = new Values(new Object[]{"key1"});
        List choice1 = pkg.chooseTasks(0, (List)message);
        Assert.assertThat((Object)choice1.size(), (Matcher)CoreMatchers.is((Object)1));
        List choice2 = pkg.chooseTasks(0, (List)message);
        Assert.assertThat((Object)choice2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)choice1)));
        List choice3 = pkg.chooseTasks(0, (List)message);
        Assert.assertThat((Object)choice3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)choice2)));
        Assert.assertThat((Object)choice3, (Matcher)CoreMatchers.is((Object)choice1));
    }

    @Test
    public void testChooseTasksFields() {
        PartialKeyGrouping pkg = new PartialKeyGrouping(new Fields(new String[]{"test"}));
        WorkerTopologyContext context = (WorkerTopologyContext)Mockito.mock(WorkerTopologyContext.class);
        Mockito.when((Object)context.getComponentOutputFields((GlobalStreamId)Mockito.any(GlobalStreamId.class))).thenReturn((Object)new Fields(new String[]{"test"}));
        pkg.prepare(context, null, (List)Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4, 5}));
        Values message = new Values(new Object[]{"key1"});
        List choice1 = pkg.chooseTasks(0, (List)message);
        Assert.assertThat((Object)choice1.size(), (Matcher)CoreMatchers.is((Object)1));
        List choice2 = pkg.chooseTasks(0, (List)message);
        Assert.assertThat((Object)choice2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)choice1)));
        List choice3 = pkg.chooseTasks(0, (List)message);
        Assert.assertThat((Object)choice3, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)choice2)));
        Assert.assertThat((Object)choice3, (Matcher)CoreMatchers.is((Object)choice1));
    }
}

