/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.filter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.metric.filter.FilterByMetricName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FilterByMetricNameTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testWhitelist() {
        ArrayList whitelistPattern = Lists.newArrayList((Object[])new String[]{"^metric\\.", "test\\.hello\\.[0-9]+"});
        FilterByMetricName sut = new FilterByMetricName((List)whitelistPattern, null);
        HashMap testMetricNamesAndExpected = Maps.newHashMap();
        testMetricNamesAndExpected.put("storm.metric.hello", false);
        testMetricNamesAndExpected.put("test.hello.world", false);
        testMetricNamesAndExpected.put("test.hello.123", true);
        testMetricNamesAndExpected.put("test.metric.world", false);
        testMetricNamesAndExpected.put("metric.world", true);
        this.assertTests(sut, testMetricNamesAndExpected);
    }

    @Test
    public void testBlacklist() {
        ArrayList blacklistPattern = Lists.newArrayList((Object[])new String[]{"^__", "test\\."});
        FilterByMetricName sut = new FilterByMetricName(null, (List)blacklistPattern);
        HashMap testMetricNamesAndExpected = Maps.newHashMap();
        testMetricNamesAndExpected.put("__storm.metric.hello", false);
        testMetricNamesAndExpected.put("storm.metric.__hello", true);
        testMetricNamesAndExpected.put("test.hello.world", false);
        testMetricNamesAndExpected.put("storm.test.123", false);
        testMetricNamesAndExpected.put("metric.world", true);
        this.assertTests(sut, testMetricNamesAndExpected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBothWhitelistAndBlacklistAreSpecified() {
        ArrayList whitelistPattern = Lists.newArrayList((Object[])new String[]{"^metric\\.", "test\\.hello\\.[0-9]+"});
        ArrayList blacklistPattern = Lists.newArrayList((Object[])new String[]{"^__", "test\\."});
        new FilterByMetricName((List)whitelistPattern, (List)blacklistPattern);
    }

    @Test
    public void testNoneIsSpecified() {
        FilterByMetricName sut = new FilterByMetricName(null, null);
        HashMap testMetricNamesAndExpected = Maps.newHashMap();
        testMetricNamesAndExpected.put("__storm.metric.hello", true);
        testMetricNamesAndExpected.put("storm.metric.__hello", true);
        testMetricNamesAndExpected.put("test.hello.world", true);
        testMetricNamesAndExpected.put("storm.test.123", true);
        testMetricNamesAndExpected.put("metric.world", true);
        this.assertTests(sut, testMetricNamesAndExpected);
    }

    private void assertTests(FilterByMetricName sut, Map<String, Boolean> testMetricNamesAndExpected) {
        for (Map.Entry<String, Boolean> testEntry : testMetricNamesAndExpected.entrySet()) {
            Assert.assertEquals((String)("actual filter result is not same: " + testEntry.getKey()), (Object)testEntry.getValue(), (Object)sut.apply(new IMetricsConsumer.DataPoint(testEntry.getKey(), (Object)1)));
        }
    }
}

