/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metric.util;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.metric.api.IMetricsConsumer;
import org.apache.storm.metric.util.DataPointExpander;
import org.junit.Assert;
import org.junit.Test;

public class DataPointExpanderTest {
    @Test
    public void testExpandDataPointWithExpandDisabled() {
        DataPointExpander populator = new DataPointExpander(false, ".");
        Map<String, Object> value = this.getDummyMetricMapValue();
        IMetricsConsumer.DataPoint point = new IMetricsConsumer.DataPoint("test", value);
        Collection expandedDataPoints = populator.expandDataPoint(point);
        Assert.assertEquals((long)1L, (long)expandedDataPoints.size());
        Assert.assertEquals((Object)point, expandedDataPoints.iterator().next());
    }

    @Test
    public void testExpandDataPointsWithExpandDisabled() {
        DataPointExpander populator = new DataPointExpander(false, ".");
        Map<String, Object> value = this.getDummyMetricMapValue();
        IMetricsConsumer.DataPoint point = new IMetricsConsumer.DataPoint("test", value);
        Collection expandedDataPoints = populator.expandDataPoints(Collections.singletonList(point));
        Assert.assertEquals((long)1L, (long)expandedDataPoints.size());
        Assert.assertEquals((Object)point, expandedDataPoints.iterator().next());
    }

    @Test
    public void testExpandDataPointWithVariousKindOfMetrics() {
        DataPointExpander populator = new DataPointExpander(true, ".");
        IMetricsConsumer.DataPoint point = new IMetricsConsumer.DataPoint("point", this.getDummyMetricMapValue());
        Collection expandedDataPoints = populator.expandDataPoints(Collections.singletonList(point));
        Assert.assertEquals((long)4L, (long)expandedDataPoints.size());
        Assert.assertTrue((boolean)expandedDataPoints.contains(new IMetricsConsumer.DataPoint("point.a", (Object)1.0)));
        Assert.assertTrue((boolean)expandedDataPoints.contains(new IMetricsConsumer.DataPoint("point.b", (Object)2.5)));
        Assert.assertTrue((boolean)expandedDataPoints.contains(new IMetricsConsumer.DataPoint("point.c", null)));
        Assert.assertTrue((boolean)expandedDataPoints.contains(new IMetricsConsumer.DataPoint("point.d", (Object)"hello")));
    }

    @Test
    public void testExpandDataPointsWithVariousKindOfMetrics() {
        DataPointExpander populator = new DataPointExpander(true, ":");
        IMetricsConsumer.DataPoint point1 = new IMetricsConsumer.DataPoint("point1", (Object)2.5);
        IMetricsConsumer.DataPoint point2 = new IMetricsConsumer.DataPoint("point2", this.getDummyMetricMapValue());
        Collection expandedDataPoints = populator.expandDataPoints((Collection)Lists.newArrayList((Object[])new IMetricsConsumer.DataPoint[]{point1, point2}));
        Assert.assertEquals((long)5L, (long)expandedDataPoints.size());
        Assert.assertTrue((boolean)expandedDataPoints.contains(new IMetricsConsumer.DataPoint("point1", (Object)2.5)));
        Assert.assertTrue((boolean)expandedDataPoints.contains(new IMetricsConsumer.DataPoint("point2:a", (Object)1.0)));
        Assert.assertTrue((boolean)expandedDataPoints.contains(new IMetricsConsumer.DataPoint("point2:b", (Object)2.5)));
        Assert.assertTrue((boolean)expandedDataPoints.contains(new IMetricsConsumer.DataPoint("point2:c", null)));
        Assert.assertTrue((boolean)expandedDataPoints.contains(new IMetricsConsumer.DataPoint("point2:d", (Object)"hello")));
    }

    @Test
    public void testExpandDataPointWithNullValueMetric() {
        DataPointExpander populator = new DataPointExpander(true, ".");
        IMetricsConsumer.DataPoint point = new IMetricsConsumer.DataPoint("point", null);
        Collection expandedDataPoints = populator.expandDataPoint(point);
        Assert.assertEquals((long)0L, (long)expandedDataPoints.size());
    }

    private Map<String, Object> getDummyMetricMapValue() {
        HashMap<String, Object> value = new HashMap<String, Object>();
        value.put("a", 1.0);
        value.put("b", 2.5);
        value.put("c", null);
        value.put("d", "hello");
        return value;
    }
}

