/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import com.google.common.collect.ImmutableSet;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.state.State;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BoltDeclarer;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.IRichSpout;
import org.apache.storm.topology.IStatefulBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.TopologyBuilder;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.topology.base.BaseStatefulBolt;
import org.apache.storm.tuple.Tuple;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TopologyBuilderTest {
    private final TopologyBuilder builder = new TopologyBuilder();

    @Test(expected=IllegalArgumentException.class)
    public void testSetRichBolt() {
        this.builder.setBolt("bolt", (IRichBolt)Mockito.mock(IRichBolt.class), (Number)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetBasicBolt() {
        this.builder.setBolt("bolt", (IBasicBolt)Mockito.mock(IBasicBolt.class), (Number)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetSpout() {
        this.builder.setSpout("spout", (IRichSpout)Mockito.mock(IRichSpout.class), (Number)0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddWorkerHook() {
        this.builder.addWorkerHook(null);
    }

    @Test
    public void testStatefulTopology() {
        this.builder.setSpout("spout1", this.makeDummySpout());
        this.builder.setSpout("spout2", this.makeDummySpout());
        ((BoltDeclarer)this.builder.setBolt("bolt1", this.makeDummyStatefulBolt(), (Number)1).shuffleGrouping("spout1")).shuffleGrouping("spout2");
        this.builder.setBolt("bolt2", this.makeDummyStatefulBolt(), (Number)1).shuffleGrouping("spout1");
        ((BoltDeclarer)this.builder.setBolt("bolt3", this.makeDummyStatefulBolt(), (Number)1).shuffleGrouping("bolt1")).shuffleGrouping("bolt2");
        StormTopology topology = this.builder.createTopology();
        Assert.assertNotNull((Object)topology);
        Set spouts = topology.get_spouts().keySet();
        Assert.assertEquals((Object)ImmutableSet.of((Object)"spout1", (Object)"spout2", (Object)"$checkpointspout"), spouts);
        Assert.assertEquals((Object)ImmutableSet.of((Object)new GlobalStreamId("spout1", "default"), (Object)new GlobalStreamId("spout2", "default"), (Object)new GlobalStreamId("$checkpointspout", "$checkpoint")), ((Bolt)topology.get_bolts().get("bolt1")).get_common().get_inputs().keySet());
        Assert.assertEquals((Object)ImmutableSet.of((Object)new GlobalStreamId("spout1", "default"), (Object)new GlobalStreamId("$checkpointspout", "$checkpoint")), ((Bolt)topology.get_bolts().get("bolt2")).get_common().get_inputs().keySet());
        Assert.assertEquals((Object)ImmutableSet.of((Object)new GlobalStreamId("bolt1", "default"), (Object)new GlobalStreamId("bolt1", "$checkpoint"), (Object)new GlobalStreamId("bolt2", "default"), (Object)new GlobalStreamId("bolt2", "$checkpoint")), ((Bolt)topology.get_bolts().get("bolt3")).get_common().get_inputs().keySet());
    }

    private IRichSpout makeDummySpout() {
        return new BaseRichSpout(){

            public void declareOutputFields(OutputFieldsDeclarer declarer) {
            }

            public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
            }

            public void nextTuple() {
            }

            private void writeObject(ObjectOutputStream stream) {
            }
        };
    }

    private IStatefulBolt makeDummyStatefulBolt() {
        return new BaseStatefulBolt(){

            public void execute(Tuple input) {
            }

            public void initState(State state) {
            }

            private void writeObject(ObjectOutputStream stream) {
            }
        };
    }
}

