/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.curator.ensemble.exhibitor.ExhibitorEnsembleProvider;
import org.apache.curator.ensemble.fixed.FixedEnsembleProvider;
import org.apache.curator.framework.AuthInfo;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.storm.utils.CuratorUtils;
import org.apache.storm.utils.StormBoundedExponentialBackoffRetry;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.ZookeeperAuthInfo;
import org.junit.Assert;
import org.junit.Test;

public class CuratorUtilsTest {
    @Test
    public void newCuratorUsesExponentialBackoffTest() throws InterruptedException {
        int expectedInterval = 2400;
        int expectedRetries = 10;
        int expectedCeiling = 3000;
        Map config = Utils.readDefaultConfig();
        config.put("storm.zookeeper.retry.interval", 2400);
        config.put("storm.zookeeper.retry.times", 10);
        config.put("storm.zookeeper.retry.intervalceiling.millis", 3000);
        CuratorFramework curator = CuratorUtils.newCurator((Map)config, Arrays.asList("bogus_server"), (Object)42, (String)"");
        StormBoundedExponentialBackoffRetry policy = (StormBoundedExponentialBackoffRetry)curator.getZookeeperClient().getRetryPolicy();
        Assert.assertEquals((long)policy.getBaseSleepTimeMs(), (long)2400L);
        Assert.assertEquals((long)policy.getN(), (long)10L);
        Assert.assertEquals((long)policy.getSleepTimeMs(10, 0L), (long)3000L);
    }

    @Test
    public void givenExhibitorServersBuilderUsesExhibitorProviderTest() {
        CuratorFrameworkFactory.Builder builder = this.setupBuilder(true);
        Assert.assertEquals((Object)builder.getEnsembleProvider().getConnectionString(), (Object)"");
        Assert.assertEquals(builder.getEnsembleProvider().getClass(), ExhibitorEnsembleProvider.class);
    }

    @Test
    public void givenNoExhibitorServersBuilderUsesFixedProviderTest() {
        CuratorFrameworkFactory.Builder builder = this.setupBuilder(false);
        Assert.assertEquals((Object)builder.getEnsembleProvider().getConnectionString(), (Object)"zk_connection_string");
        Assert.assertEquals(builder.getEnsembleProvider().getClass(), FixedEnsembleProvider.class);
    }

    @Test
    public void givenSchemeAndPayloadBuilderUsesAuthTest() {
        CuratorFrameworkFactory.Builder builder = this.setupBuilder(false, true);
        List authInfos = builder.getAuthInfos();
        AuthInfo authInfo = (AuthInfo)authInfos.get(0);
        Assert.assertEquals((Object)authInfo.getScheme(), (Object)"scheme");
        Assert.assertArrayEquals((byte[])authInfo.getAuth(), (byte[])"abc".getBytes());
    }

    private CuratorFrameworkFactory.Builder setupBuilder(boolean withExhibitor) {
        return this.setupBuilder(withExhibitor, false);
    }

    private CuratorFrameworkFactory.Builder setupBuilder(boolean withExhibitor, boolean withAuth) {
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
        HashMap<String, Object> conf = new HashMap<String, Object>();
        if (withExhibitor) {
            conf.put("storm.exhibitor.servers", "foo");
            conf.put("storm.exhibitor.port", 0);
            conf.put("storm.exhibitor.poll.uripath", "/exhibitor");
            conf.put("storm.exhibitor.poll.millis", 0);
            conf.put("storm.exhibitor.retry.interval", 0);
            conf.put("storm.exhibitor.retry.intervalceiling.millis", 0);
            conf.put("storm.exhibitor.retry.times", 0);
        }
        conf.put("storm.zookeeper.connection.timeout", 0);
        conf.put("storm.zookeeper.session.timeout", 0);
        conf.put("storm.zookeeper.retry.interval", 0);
        conf.put("storm.zookeeper.retry.intervalceiling.millis", 0);
        conf.put("storm.zookeeper.retry.times", 0);
        String zkStr = new String("zk_connection_string");
        ZookeeperAuthInfo auth = null;
        if (withAuth) {
            auth = new ZookeeperAuthInfo("scheme", "abc".getBytes());
        }
        CuratorUtils.testSetupBuilder((CuratorFrameworkFactory.Builder)builder, (String)zkStr, conf, auth);
        return builder;
    }
}

