/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import junit.framework.TestCase;
import org.apache.storm.utils.StormBoundedExponentialBackoffRetry;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormBoundedExponentialBackoffRetryTest
extends TestCase {
    private static final Logger LOG = LoggerFactory.getLogger(StormBoundedExponentialBackoffRetryTest.class);

    @Test
    public void testExponentialSleepLargeRetries() throws Exception {
        int baseSleepMs = 10;
        int maxSleepMs = 1000;
        int maxRetries = 900;
        this.validateSleepTimes(baseSleepMs, maxSleepMs, maxRetries);
    }

    @Test
    public void testExponentialSleep() throws Exception {
        int baseSleepMs = 10;
        int maxSleepMs = 100;
        int maxRetries = 40;
        this.validateSleepTimes(baseSleepMs, maxSleepMs, maxRetries);
    }

    @Test
    public void testExponentialSleepSmallMaxRetries() throws Exception {
        int baseSleepMs = 1000;
        int maxSleepMs = 5000;
        int maxRetries = 10;
        this.validateSleepTimes(baseSleepMs, maxSleepMs, maxRetries);
    }

    @Test
    public void testExponentialSleepZeroMaxTries() throws Exception {
        int baseSleepMs = 10;
        int maxSleepMs = 100;
        int maxRetries = 0;
        this.validateSleepTimes(baseSleepMs, maxSleepMs, maxRetries);
    }

    @Test
    public void testExponentialSleepSmallMaxTries() throws Exception {
        int baseSleepMs = 10;
        int maxSleepMs = 100;
        int maxRetries = 10;
        this.validateSleepTimes(baseSleepMs, maxSleepMs, maxRetries);
    }

    private void validateSleepTimes(int baseSleepMs, int maxSleepMs, int maxRetries) {
        StormBoundedExponentialBackoffRetry retryPolicy = new StormBoundedExponentialBackoffRetry(baseSleepMs, maxSleepMs, maxRetries);
        long prevSleepMs = 0L;
        LOG.info("The baseSleepMs [" + baseSleepMs + "] the maxSleepMs [" + maxSleepMs + "] the maxRetries [" + maxRetries + "]");
        for (int retryCount = 0; retryCount <= maxRetries; ++retryCount) {
            long currSleepMs = retryPolicy.getSleepTimeMs(retryCount, 0L);
            LOG.info("For retryCount [" + retryCount + "] the previousSleepMs [" + prevSleepMs + "] the currentSleepMs [" + currSleepMs + "]");
            StormBoundedExponentialBackoffRetryTest.assertTrue((String)("For retryCount [" + retryCount + "] the previousSleepMs [" + prevSleepMs + "] is not less than currentSleepMs [" + currSleepMs + "]"), (prevSleepMs < currSleepMs || currSleepMs == (long)maxSleepMs ? 1 : 0) != 0);
            StormBoundedExponentialBackoffRetryTest.assertTrue((String)("For retryCount [" + retryCount + "] the currentSleepMs [" + currSleepMs + "] is less than baseSleepMs [" + baseSleepMs + "]."), ((long)baseSleepMs <= currSleepMs || currSleepMs == (long)maxSleepMs ? 1 : 0) != 0);
            StormBoundedExponentialBackoffRetryTest.assertTrue((String)("For retryCount [" + retryCount + "] the currentSleepMs [" + currSleepMs + "] is greater than maxSleepMs [" + maxSleepMs + "]"), ((long)maxSleepMs >= currSleepMs ? 1 : 0) != 0);
            prevSleepMs = currSleepMs;
        }
        int badRetryCount = maxRetries + 10;
        long currSleepMs = retryPolicy.getSleepTimeMs(badRetryCount, 0L);
        LOG.info("For badRetryCount [" + badRetryCount + "] the previousSleepMs [" + prevSleepMs + "] the currentSleepMs [" + currSleepMs + "]");
        StormBoundedExponentialBackoffRetryTest.assertTrue((String)("For the badRetryCount [" + badRetryCount + "] that's greater than maxRetries [" + maxRetries + "]the currentSleepMs [" + currSleepMs + "] is greater than maxSleepMs [" + maxSleepMs + "]"), ((long)maxSleepMs >= currSleepMs ? 1 : 0) != 0);
    }
}

