/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.storm.topology.base.BaseWindowedBolt;
import org.apache.storm.windowing.CountEvictionPolicy;
import org.apache.storm.windowing.CountTriggerPolicy;
import org.apache.storm.windowing.DefaultEvictionContext;
import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.EvictionContext;
import org.apache.storm.windowing.EvictionPolicy;
import org.apache.storm.windowing.TimeEvictionPolicy;
import org.apache.storm.windowing.TimeTriggerPolicy;
import org.apache.storm.windowing.TriggerPolicy;
import org.apache.storm.windowing.WaterMarkEvent;
import org.apache.storm.windowing.WatermarkCountEvictionPolicy;
import org.apache.storm.windowing.WatermarkCountTriggerPolicy;
import org.apache.storm.windowing.WatermarkTimeEvictionPolicy;
import org.apache.storm.windowing.WatermarkTimeTriggerPolicy;
import org.apache.storm.windowing.WindowLifecycleListener;
import org.apache.storm.windowing.WindowManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WindowManagerTest {
    private WindowManager<Integer> windowManager;
    private Listener listener;

    @Before
    public void setUp() {
        this.listener = new Listener();
        this.windowManager = new WindowManager((WindowLifecycleListener)this.listener);
    }

    @After
    public void tearDown() {
        this.windowManager.shutdown();
    }

    @Test
    public void testCountBasedWindow() throws Exception {
        CountEvictionPolicy evictionPolicy = new CountEvictionPolicy(5);
        CountTriggerPolicy triggerPolicy = new CountTriggerPolicy(2, this.windowManager, (EvictionPolicy)evictionPolicy);
        triggerPolicy.start();
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        this.windowManager.add((Object)1);
        this.windowManager.add((Object)2);
        Assert.assertTrue((boolean)this.listener.onExpiryEvents.isEmpty());
        Assert.assertEquals(this.seq(1, 2), this.listener.onActivationEvents);
        Assert.assertEquals(this.seq(1, 2), this.listener.onActivationNewEvents);
        Assert.assertTrue((boolean)this.listener.onActivationExpiredEvents.isEmpty());
        this.windowManager.add((Object)3);
        this.windowManager.add((Object)4);
        Assert.assertTrue((boolean)this.listener.onExpiryEvents.isEmpty());
        Assert.assertEquals(this.seq(1, 4), this.listener.onActivationEvents);
        Assert.assertEquals(this.seq(3, 4), this.listener.onActivationNewEvents);
        Assert.assertTrue((boolean)this.listener.onActivationExpiredEvents.isEmpty());
        this.windowManager.add((Object)5);
        this.windowManager.add((Object)6);
        Assert.assertEquals(this.seq(1), this.listener.onExpiryEvents);
        Assert.assertEquals(this.seq(2, 6), this.listener.onActivationEvents);
        Assert.assertEquals(this.seq(5, 6), this.listener.onActivationNewEvents);
        Assert.assertEquals(this.seq(1), this.listener.onActivationExpiredEvents);
        this.listener.clear();
        this.windowManager.add((Object)7);
        Assert.assertTrue((boolean)this.listener.onExpiryEvents.isEmpty());
        this.windowManager.add((Object)8);
        Assert.assertEquals(this.seq(2, 3), this.listener.onExpiryEvents);
        Assert.assertEquals(this.seq(4, 8), this.listener.onActivationEvents);
        Assert.assertEquals(this.seq(7, 8), this.listener.onActivationNewEvents);
        Assert.assertEquals(this.seq(2, 3), this.listener.onActivationExpiredEvents);
    }

    @Test
    public void testExpireThreshold() throws Exception {
        int threshold = 100;
        int windowLength = 5;
        this.windowManager.setEvictionPolicy((EvictionPolicy)new CountEvictionPolicy(5));
        TimeTriggerPolicy triggerPolicy = new TimeTriggerPolicy((long)new BaseWindowedBolt.Duration((int)1, (TimeUnit)TimeUnit.HOURS).value, this.windowManager);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        for (int i : this.seq(1, 5)) {
            this.windowManager.add((Object)i);
        }
        Assert.assertTrue((boolean)this.listener.onExpiryEvents.isEmpty());
        for (int i : this.seq(6, 10)) {
            this.windowManager.add((Object)i);
        }
        for (int i : this.seq(11, threshold)) {
            this.windowManager.add((Object)i);
        }
        Assert.assertEquals(this.seq(1, threshold - windowLength), this.listener.onExpiryEvents);
    }

    @Test
    public void testTimeBasedWindow() throws Exception {
        TimeEvictionPolicy evictionPolicy = new TimeEvictionPolicy(new BaseWindowedBolt.Duration((int)1, (TimeUnit)TimeUnit.SECONDS).value);
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        TimeTriggerPolicy triggerPolicy = new TimeTriggerPolicy((long)new BaseWindowedBolt.Duration((int)1, (TimeUnit)TimeUnit.DAYS).value, this.windowManager, (EvictionPolicy)evictionPolicy);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        long now = System.currentTimeMillis();
        for (int i : this.seq(1, 50)) {
            this.windowManager.add((Object)i, now - 1000L);
        }
        for (int i : this.seq(51, 100)) {
            this.windowManager.add((Object)i, now);
        }
        Assert.assertEquals((long)50L, (long)this.listener.onExpiryEvents.size());
        for (int i : this.seq(101, 200)) {
            this.windowManager.add((Object)i, now - 1000L);
        }
        evictionPolicy.setContext((EvictionContext)new DefaultEvictionContext(Long.valueOf(now + 100L)));
        this.windowManager.onTrigger();
        Assert.assertEquals((long)100L, (long)this.listener.onExpiryEvents.size());
        Assert.assertEquals(this.seq(101, 200), this.listener.onExpiryEvents);
        List<Integer> activationsEvents = this.seq(51, 100);
        Assert.assertEquals(this.seq(51, 100), this.listener.onActivationEvents);
        Assert.assertEquals(this.seq(51, 100), this.listener.onActivationNewEvents);
        List<Integer> expiredList = this.seq(1, 50);
        expiredList.addAll(this.seq(101, 200));
        Assert.assertEquals(expiredList, this.listener.onActivationExpiredEvents);
        this.listener.clear();
        List<Integer> newEvents = this.seq(201, 300);
        for (int i : newEvents) {
            this.windowManager.add((Object)i, now);
        }
        activationsEvents.addAll(newEvents);
        evictionPolicy.setContext((EvictionContext)new DefaultEvictionContext(Long.valueOf(now + 200L)));
        this.windowManager.onTrigger();
        Assert.assertTrue((boolean)this.listener.onExpiryEvents.isEmpty());
        Assert.assertEquals(activationsEvents, this.listener.onActivationEvents);
        Assert.assertEquals(newEvents, this.listener.onActivationNewEvents);
    }

    @Test
    public void testTimeBasedWindowExpiry() throws Exception {
        TimeEvictionPolicy evictionPolicy = new TimeEvictionPolicy(new BaseWindowedBolt.Duration((int)100, (TimeUnit)TimeUnit.MILLISECONDS).value);
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        TimeTriggerPolicy triggerPolicy = new TimeTriggerPolicy((long)new BaseWindowedBolt.Duration((int)1, (TimeUnit)TimeUnit.DAYS).value, this.windowManager);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        long now = System.currentTimeMillis();
        for (int i : this.seq(1, 10)) {
            this.windowManager.add((Object)i);
        }
        evictionPolicy.setContext((EvictionContext)new DefaultEvictionContext(Long.valueOf(now + 60L)));
        this.windowManager.onTrigger();
        Assert.assertEquals(this.seq(1, 10), this.listener.onActivationEvents);
        Assert.assertTrue((boolean)this.listener.onActivationExpiredEvents.isEmpty());
        this.listener.clear();
        evictionPolicy.setContext((EvictionContext)new DefaultEvictionContext(Long.valueOf(now + 120L)));
        this.windowManager.onTrigger();
        Assert.assertEquals(this.seq(1, 10), this.listener.onExpiryEvents);
        Assert.assertTrue((boolean)this.listener.onActivationEvents.isEmpty());
        this.listener.clear();
        evictionPolicy.setContext((EvictionContext)new DefaultEvictionContext(Long.valueOf(now + 180L)));
        this.windowManager.onTrigger();
        Assert.assertTrue((boolean)this.listener.onActivationExpiredEvents.isEmpty());
        Assert.assertTrue((boolean)this.listener.onActivationEvents.isEmpty());
    }

    @Test
    public void testTumblingWindow() throws Exception {
        CountEvictionPolicy evictionPolicy = new CountEvictionPolicy(3);
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        CountTriggerPolicy triggerPolicy = new CountTriggerPolicy(3, this.windowManager, (EvictionPolicy)evictionPolicy);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        this.windowManager.add((Object)1);
        this.windowManager.add((Object)2);
        Assert.assertTrue((boolean)this.listener.onExpiryEvents.isEmpty());
        this.windowManager.add((Object)3);
        Assert.assertTrue((boolean)this.listener.onExpiryEvents.isEmpty());
        Assert.assertEquals(this.seq(1, 3), this.listener.onActivationEvents);
        Assert.assertTrue((boolean)this.listener.onActivationExpiredEvents.isEmpty());
        Assert.assertEquals(this.seq(1, 3), this.listener.onActivationNewEvents);
        this.listener.clear();
        this.windowManager.add((Object)4);
        this.windowManager.add((Object)5);
        this.windowManager.add((Object)6);
        Assert.assertEquals(this.seq(1, 3), this.listener.onExpiryEvents);
        Assert.assertEquals(this.seq(4, 6), this.listener.onActivationEvents);
        Assert.assertEquals(this.seq(1, 3), this.listener.onActivationExpiredEvents);
        Assert.assertEquals(this.seq(4, 6), this.listener.onActivationNewEvents);
    }

    @Test
    public void testEventTimeBasedWindow() throws Exception {
        WatermarkTimeEvictionPolicy evictionPolicy = new WatermarkTimeEvictionPolicy(20);
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        WatermarkTimeTriggerPolicy triggerPolicy = new WatermarkTimeTriggerPolicy(10L, this.windowManager, (EvictionPolicy)evictionPolicy, this.windowManager);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        this.windowManager.add((Object)1, 603L);
        this.windowManager.add((Object)2, 605L);
        this.windowManager.add((Object)3, 607L);
        this.windowManager.add((Event)new WaterMarkEvent(609L));
        Assert.assertEquals(Collections.emptyList(), this.listener.allOnActivationEvents);
        this.windowManager.add((Object)4, 618L);
        this.windowManager.add((Object)5, 626L);
        this.windowManager.add((Object)6, 636L);
        this.windowManager.add((Event)new WaterMarkEvent(631L));
        Assert.assertEquals((long)3L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(1, 3), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(1, 4), this.listener.allOnActivationEvents.get(1));
        Assert.assertEquals(this.seq(4, 5), this.listener.allOnActivationEvents.get(2));
        Assert.assertEquals(Collections.emptyList(), this.listener.allOnActivationExpiredEvents.get(0));
        Assert.assertEquals(Collections.emptyList(), this.listener.allOnActivationExpiredEvents.get(1));
        Assert.assertEquals(this.seq(1, 3), this.listener.allOnActivationExpiredEvents.get(2));
        Assert.assertEquals(this.seq(1, 3), this.listener.allOnActivationNewEvents.get(0));
        Assert.assertEquals(this.seq(4, 4), this.listener.allOnActivationNewEvents.get(1));
        Assert.assertEquals(this.seq(5, 5), this.listener.allOnActivationNewEvents.get(2));
        Assert.assertEquals(this.seq(1, 3), this.listener.allOnExpiryEvents.get(0));
        this.windowManager.add((Object)7, 825L);
        this.windowManager.add((Object)8, 826L);
        this.windowManager.add((Object)9, 827L);
        this.windowManager.add((Object)10, 839L);
        this.listener.clear();
        this.windowManager.add((Event)new WaterMarkEvent(834L));
        Assert.assertEquals((long)3L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(5, 6), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(6, 6), this.listener.allOnActivationEvents.get(1));
        Assert.assertEquals(this.seq(7, 9), this.listener.allOnActivationEvents.get(2));
        Assert.assertEquals(this.seq(4, 4), this.listener.allOnActivationExpiredEvents.get(0));
        Assert.assertEquals(this.seq(5, 5), this.listener.allOnActivationExpiredEvents.get(1));
        Assert.assertEquals(Collections.emptyList(), this.listener.allOnActivationExpiredEvents.get(2));
        Assert.assertEquals(this.seq(6, 6), this.listener.allOnActivationNewEvents.get(0));
        Assert.assertEquals(Collections.emptyList(), this.listener.allOnActivationNewEvents.get(1));
        Assert.assertEquals(this.seq(7, 9), this.listener.allOnActivationNewEvents.get(2));
        Assert.assertEquals(this.seq(4, 4), this.listener.allOnExpiryEvents.get(0));
        Assert.assertEquals(this.seq(5, 5), this.listener.allOnExpiryEvents.get(1));
        Assert.assertEquals(this.seq(6, 6), this.listener.allOnExpiryEvents.get(2));
    }

    @Test
    public void testCountBasedWindowWithEventTs() throws Exception {
        WatermarkCountEvictionPolicy evictionPolicy = new WatermarkCountEvictionPolicy(3);
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        WatermarkTimeTriggerPolicy triggerPolicy = new WatermarkTimeTriggerPolicy(10L, this.windowManager, (EvictionPolicy)evictionPolicy, this.windowManager);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        this.windowManager.add((Object)1, 603L);
        this.windowManager.add((Object)2, 605L);
        this.windowManager.add((Object)3, 607L);
        this.windowManager.add((Object)4, 618L);
        this.windowManager.add((Object)5, 626L);
        this.windowManager.add((Object)6, 636L);
        this.windowManager.add((Event)new WaterMarkEvent(631L));
        Assert.assertEquals((long)3L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(1, 3), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(2, 4), this.listener.allOnActivationEvents.get(1));
        Assert.assertEquals(this.seq(3, 5), this.listener.allOnActivationEvents.get(2));
        this.windowManager.add((Object)7, 665L);
        this.windowManager.add((Object)8, 666L);
        this.windowManager.add((Object)9, 667L);
        this.windowManager.add((Object)10, 679L);
        this.listener.clear();
        this.windowManager.add((Event)new WaterMarkEvent(674L));
        Assert.assertEquals((long)4L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(4, 6), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(4, 6), this.listener.allOnActivationEvents.get(1));
        Assert.assertEquals(this.seq(4, 6), this.listener.allOnActivationEvents.get(2));
        Assert.assertEquals(this.seq(7, 9), this.listener.allOnActivationEvents.get(3));
    }

    @Test
    public void testCountBasedTriggerWithEventTs() throws Exception {
        WatermarkTimeEvictionPolicy evictionPolicy = new WatermarkTimeEvictionPolicy(20);
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        WatermarkCountTriggerPolicy triggerPolicy = new WatermarkCountTriggerPolicy(3, this.windowManager, (EvictionPolicy)evictionPolicy, this.windowManager);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        this.windowManager.add((Object)1, 603L);
        this.windowManager.add((Object)2, 605L);
        this.windowManager.add((Object)3, 607L);
        this.windowManager.add((Object)4, 618L);
        this.windowManager.add((Object)5, 625L);
        this.windowManager.add((Object)6, 626L);
        this.windowManager.add((Object)7, 629L);
        this.windowManager.add((Object)8, 636L);
        this.windowManager.add((Event)new WaterMarkEvent(631L));
        Assert.assertEquals((long)2L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(1, 3), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(3, 6), this.listener.allOnActivationEvents.get(1));
        this.windowManager.add((Object)9, 665L);
        this.windowManager.add((Object)10, 666L);
        this.windowManager.add((Object)11, 667L);
        this.windowManager.add((Object)12, 669L);
        this.windowManager.add((Object)12, 679L);
        this.listener.clear();
        this.windowManager.add((Event)new WaterMarkEvent(674L));
        Assert.assertEquals((long)2L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(9), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(9, 12), this.listener.allOnActivationEvents.get(1));
    }

    @Test
    public void testCountBasedTumblingWithSameEventTs() throws Exception {
        WatermarkCountEvictionPolicy evictionPolicy = new WatermarkCountEvictionPolicy(2);
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        WatermarkCountTriggerPolicy triggerPolicy = new WatermarkCountTriggerPolicy(2, this.windowManager, (EvictionPolicy)evictionPolicy, this.windowManager);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        this.windowManager.add((Object)1, 10L);
        this.windowManager.add((Object)2, 10L);
        this.windowManager.add((Object)3, 11L);
        this.windowManager.add((Object)4, 12L);
        this.windowManager.add((Object)5, 12L);
        this.windowManager.add((Object)6, 12L);
        this.windowManager.add((Object)7, 12L);
        this.windowManager.add((Object)8, 13L);
        this.windowManager.add((Object)9, 14L);
        this.windowManager.add((Object)10, 15L);
        this.windowManager.add((Event)new WaterMarkEvent(20L));
        Assert.assertEquals((long)5L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(1, 2), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(3, 4), this.listener.allOnActivationEvents.get(1));
        Assert.assertEquals(this.seq(5, 6), this.listener.allOnActivationEvents.get(2));
        Assert.assertEquals(this.seq(7, 8), this.listener.allOnActivationEvents.get(3));
        Assert.assertEquals(this.seq(9, 10), this.listener.allOnActivationEvents.get(4));
    }

    @Test
    public void testCountBasedSlidingWithSameEventTs() throws Exception {
        WatermarkCountEvictionPolicy evictionPolicy = new WatermarkCountEvictionPolicy(5);
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        WatermarkCountTriggerPolicy triggerPolicy = new WatermarkCountTriggerPolicy(2, this.windowManager, (EvictionPolicy)evictionPolicy, this.windowManager);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        this.windowManager.add((Object)1, 10L);
        this.windowManager.add((Object)2, 10L);
        this.windowManager.add((Object)3, 11L);
        this.windowManager.add((Object)4, 12L);
        this.windowManager.add((Object)5, 12L);
        this.windowManager.add((Object)6, 12L);
        this.windowManager.add((Object)7, 12L);
        this.windowManager.add((Object)8, 13L);
        this.windowManager.add((Object)9, 14L);
        this.windowManager.add((Object)10, 15L);
        this.windowManager.add((Event)new WaterMarkEvent(20L));
        Assert.assertEquals((long)5L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(1, 2), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(1, 4), this.listener.allOnActivationEvents.get(1));
        Assert.assertEquals(this.seq(2, 6), this.listener.allOnActivationEvents.get(2));
        Assert.assertEquals(this.seq(4, 8), this.listener.allOnActivationEvents.get(3));
        Assert.assertEquals(this.seq(6, 10), this.listener.allOnActivationEvents.get(4));
    }

    @Test
    public void testEventTimeLag() throws Exception {
        WatermarkTimeEvictionPolicy evictionPolicy = new WatermarkTimeEvictionPolicy(20, 5);
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        WatermarkTimeTriggerPolicy triggerPolicy = new WatermarkTimeTriggerPolicy(10L, this.windowManager, (EvictionPolicy)evictionPolicy, this.windowManager);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        this.windowManager.add((Object)1, 603L);
        this.windowManager.add((Object)2, 605L);
        this.windowManager.add((Object)3, 607L);
        this.windowManager.add((Object)4, 618L);
        this.windowManager.add((Object)5, 626L);
        this.windowManager.add((Object)6, 632L);
        this.windowManager.add((Object)7, 629L);
        this.windowManager.add((Object)8, 636L);
        this.windowManager.add((Event)new WaterMarkEvent(631L));
        Assert.assertEquals((long)3L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(1, 3), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(1, 4), this.listener.allOnActivationEvents.get(1));
        Assert.assertEquals(Arrays.asList(4, 5, 7), this.listener.allOnActivationEvents.get(2));
    }

    @Test
    public void testScanStop() throws Exception {
        final HashSet eventsScanned = new HashSet();
        WatermarkTimeEvictionPolicy<Integer> evictionPolicy = new WatermarkTimeEvictionPolicy<Integer>(20, 5){

            public EvictionPolicy.Action evict(Event<Integer> event) {
                eventsScanned.add(event.get());
                return super.evict(event);
            }
        };
        this.windowManager.setEvictionPolicy((EvictionPolicy)evictionPolicy);
        WatermarkTimeTriggerPolicy triggerPolicy = new WatermarkTimeTriggerPolicy(10L, this.windowManager, (EvictionPolicy)evictionPolicy, this.windowManager);
        triggerPolicy.start();
        this.windowManager.setTriggerPolicy((TriggerPolicy)triggerPolicy);
        this.windowManager.add((Object)1, 603L);
        this.windowManager.add((Object)2, 605L);
        this.windowManager.add((Object)3, 607L);
        this.windowManager.add((Object)4, 618L);
        this.windowManager.add((Object)5, 626L);
        this.windowManager.add((Object)6, 629L);
        this.windowManager.add((Object)7, 636L);
        this.windowManager.add((Object)8, 637L);
        this.windowManager.add((Object)9, 638L);
        this.windowManager.add((Object)10, 639L);
        this.windowManager.add((Event)new WaterMarkEvent(631L));
        Assert.assertEquals((long)3L, (long)this.listener.allOnActivationEvents.size());
        Assert.assertEquals(this.seq(1, 3), this.listener.allOnActivationEvents.get(0));
        Assert.assertEquals(this.seq(1, 4), this.listener.allOnActivationEvents.get(1));
        Assert.assertEquals(Arrays.asList(4, 5, 6), this.listener.allOnActivationEvents.get(2));
        Assert.assertEquals(new HashSet<Integer>(this.seq(1, 7)), eventsScanned);
    }

    private List<Integer> seq(int start) {
        return this.seq(start, start);
    }

    private List<Integer> seq(int start, int stop) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        for (int i = start; i <= stop; ++i) {
            ints.add(i);
        }
        return ints;
    }

    private static class Listener
    implements WindowLifecycleListener<Integer> {
        List<Integer> onExpiryEvents = Collections.emptyList();
        List<Integer> onActivationEvents = Collections.emptyList();
        List<Integer> onActivationNewEvents = Collections.emptyList();
        List<Integer> onActivationExpiredEvents = Collections.emptyList();
        List<List<Integer>> allOnExpiryEvents = new ArrayList<List<Integer>>();
        List<List<Integer>> allOnActivationEvents = new ArrayList<List<Integer>>();
        List<List<Integer>> allOnActivationNewEvents = new ArrayList<List<Integer>>();
        List<List<Integer>> allOnActivationExpiredEvents = new ArrayList<List<Integer>>();

        private Listener() {
        }

        public void onExpiry(List<Integer> events) {
            this.onExpiryEvents = events;
            this.allOnExpiryEvents.add(events);
        }

        public void onActivation(List<Integer> events, List<Integer> newEvents, List<Integer> expired, Long timestamp) {
            this.onActivationEvents = events;
            this.allOnActivationEvents.add(events);
            this.onActivationNewEvents = newEvents;
            this.allOnActivationNewEvents.add(newEvents);
            this.onActivationExpiredEvents = expired;
            this.allOnActivationExpiredEvents.add(expired);
        }

        void clear() {
            this.onExpiryEvents = Collections.emptyList();
            this.onActivationEvents = Collections.emptyList();
            this.onActivationNewEvents = Collections.emptyList();
            this.onActivationExpiredEvents = Collections.emptyList();
            this.allOnExpiryEvents.clear();
            this.allOnActivationEvents.clear();
            this.allOnActivationNewEvents.clear();
            this.allOnActivationExpiredEvents.clear();
        }
    }
}

