/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.trident.mapper;

import org.apache.storm.hbase.common.ColumnList;
import org.apache.storm.hbase.common.Utils;
import org.apache.storm.hbase.trident.mapper.TridentHBaseMapper;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.Fields;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTridentHBaseMapper
implements TridentHBaseMapper {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTridentHBaseMapper.class);
    private String rowKeyField;
    private byte[] columnFamily;
    private Fields columnFields;
    private Fields counterFields;

    public SimpleTridentHBaseMapper withRowKeyField(String rowKeyField) {
        this.rowKeyField = rowKeyField;
        return this;
    }

    public SimpleTridentHBaseMapper withColumnFields(Fields columnFields) {
        this.columnFields = columnFields;
        return this;
    }

    public SimpleTridentHBaseMapper withCounterFields(Fields counterFields) {
        this.counterFields = counterFields;
        return this;
    }

    public SimpleTridentHBaseMapper withColumnFamily(String columnFamily) {
        this.columnFamily = columnFamily.getBytes();
        return this;
    }

    @Override
    public byte[] rowKey(TridentTuple tuple) {
        Object objVal = tuple.getValueByField(this.rowKeyField);
        return Utils.toBytes(objVal);
    }

    @Override
    public ColumnList columns(TridentTuple tuple) {
        ColumnList cols = new ColumnList();
        if (this.columnFields != null) {
            for (String field : this.columnFields) {
                cols.addColumn(this.columnFamily, field.getBytes(), Utils.toBytes(tuple.getValueByField(field)));
            }
        }
        if (this.counterFields != null) {
            for (String field : this.counterFields) {
                cols.addCounter(this.columnFamily, field.getBytes(), Utils.toLong(tuple.getValueByField(field)));
            }
        }
        return cols;
    }
}

