/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.redis.common.container;

import java.io.Closeable;
import java.io.IOException;
import org.apache.storm.redis.common.container.JedisCommandsInstanceContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisCommands;
import redis.clients.jedis.JedisPool;

public class JedisContainer
implements JedisCommandsInstanceContainer {
    private static final Logger LOG = LoggerFactory.getLogger(JedisContainer.class);
    private JedisPool jedisPool;

    public JedisContainer(JedisPool jedisPool) {
        this.jedisPool = jedisPool;
    }

    @Override
    public JedisCommands getInstance() {
        return this.jedisPool.getResource();
    }

    @Override
    public void returnInstance(JedisCommands jedisCommands) {
        if (jedisCommands == null) {
            return;
        }
        try {
            ((Closeable)jedisCommands).close();
        }
        catch (IOException e) {
            LOG.error("Failed to close (return) instance to pool");
        }
    }

    @Override
    public void close() {
        this.jedisPool.close();
    }
}

