/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.util.fs;

import com.opensymphony.xwork2.util.fs.DefaultFileManager;
import com.opensymphony.xwork2.util.fs.FileRevision;
import com.opensymphony.xwork2.util.fs.Revision;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossFileManager
extends DefaultFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(JBossFileManager.class);
    private static final String JBOSS5_VFS = "vfs";
    private static final String JBOSS5_VFSZIP = "vfszip";
    private static final String JBOSS5_VFSMEMORY = "vfsmemory";
    private static final String JBOSS5_VFSFILE = "vfsfile";
    private static final String VFS_JBOSS7 = "org.jboss.vfs.VirtualFile";
    private static final String VFS_JBOSS5 = "org.jboss.virtual.VirtualFile";

    public boolean support() {
        boolean supports;
        boolean bl = supports = this.isJBoss7() || this.isJBoss5();
        if (supports && LOG.isDebugEnabled()) {
            LOG.debug("JBoss server detected, Struts 2 will use [#0] to support file system operations!", new String[]{JBossFileManager.class.getSimpleName()});
        }
        return supports;
    }

    private boolean isJBoss5() {
        try {
            Class.forName(VFS_JBOSS5);
            return true;
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot load [#0] class, not a JBoss 5!", new String[]{VFS_JBOSS7});
            }
            return false;
        }
    }

    private boolean isJBoss7() {
        try {
            Class.forName(VFS_JBOSS7);
            return true;
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot load [#0] class, not a JBoss 7!", new String[]{VFS_JBOSS7});
            }
            return false;
        }
    }

    public void monitorFile(URL fileUrl) {
        if (this.isJBossUrl(fileUrl)) {
            String fileName = fileUrl.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating revision for URL: " + fileName, new String[0]);
            }
            Revision revision = FileRevision.build((URL)this.normalizeToFileProtocol(fileUrl));
            files.put(fileName, revision);
        } else {
            super.monitorFile(fileUrl);
        }
    }

    public URL normalizeToFileProtocol(URL url) {
        if (this.isJBossUrl(url)) {
            try {
                return this.getJBossPhysicalUrl(url);
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage(), (Throwable)e, new String[0]);
                }
                return null;
            }
        }
        return super.normalizeToFileProtocol(url);
    }

    public Collection<? extends URL> getAllPhysicalUrls(URL url) throws IOException {
        if (this.isJBossUrl(url)) {
            return this.getAllJBossPhysicalUrls(url);
        }
        return super.getAllPhysicalUrls(url);
    }

    protected boolean isJBossUrl(URL fileUrl) {
        String protocol = fileUrl.getProtocol();
        return JBOSS5_VFSZIP.equals(protocol) || JBOSS5_VFSMEMORY.equals(protocol) || JBOSS5_VFS.equals(protocol) || "true".equals(System.getProperty("jboss.vfs.forceVfsJar")) && JBOSS5_VFSFILE.equals(protocol);
    }

    protected URL getJBossPhysicalUrl(URL url) throws IOException {
        Object content = url.openConnection().getContent();
        try {
            String s = content.getClass().toString();
            if (s.startsWith("class org.jboss.vfs.VirtualFile")) {
                File physicalFile = this.readJBossPhysicalFile(content);
                return physicalFile.toURI().toURL();
            }
            if (s.startsWith("class org.jboss.virtual.VirtualFile")) {
                String fileName = url.toExternalForm();
                return new URL("file", null, fileName.substring(fileName.indexOf(":") + 1));
            }
        }
        catch (Exception e) {
            LOG.warn("Error calling getPhysicalFile() on JBoss VirtualFile.", (Throwable)e, new String[0]);
        }
        return url;
    }

    private File readJBossPhysicalFile(Object content) throws Exception {
        Method method = content.getClass().getDeclaredMethod("getPhysicalFile", new Class[0]);
        return (File)method.invoke(content, new Object[0]);
    }

    private List<URL> getAllJBossPhysicalUrls(URL url) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Object content = url.openConnection().getContent();
        try {
            if (content.getClass().toString().startsWith("class org.jboss.vfs.VirtualFile")) {
                File physicalFile = this.readJBossPhysicalFile(content);
                this.readFile(urls, physicalFile);
                this.readFile(urls, physicalFile.getParentFile());
            } else {
                urls.add(url);
            }
        }
        catch (Exception e) {
            LOG.warn("Error calling getPhysicalFile() on JBoss VirtualFile!", (Throwable)e, new String[0]);
        }
        return urls;
    }

    private void readFile(List<URL> urls, File physicalFile) throws MalformedURLException {
        File[] files = physicalFile.listFiles();
        if (physicalFile.isDirectory() && files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    this.addIfAbsent(urls, file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.readFile(urls, file);
            }
        }
    }

    private void addIfAbsent(List<URL> urls, URL fileUrl) {
        if (!urls.contains(fileUrl)) {
            urls.add(fileUrl);
        }
    }
}

