/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import org.apache.struts2.views.xslt.AbstractAdapterNode;
import org.apache.struts2.views.xslt.AdapterFactory;
import org.apache.struts2.views.xslt.AdapterNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class ProxyNodeAdapter
extends AbstractAdapterNode {
    private Logger log = LoggerFactory.getLogger(this.getClass());

    public ProxyNodeAdapter(AdapterFactory factory, AdapterNode parent, Node value) {
        this.setContext(factory, parent, "document", value);
        this.log.debug("proxied node is: " + value, new String[0]);
        this.log.debug("node class is: " + value.getClass(), new String[0]);
        this.log.debug("node type is: " + value.getNodeType(), new String[0]);
        this.log.debug("node name is: " + value.getNodeName(), new String[0]);
    }

    protected Node node() {
        return (Node)this.getPropertyValue();
    }

    protected Node wrap(Node node) {
        return this.getAdapterFactory().proxyNode(this, node);
    }

    protected NamedNodeMap wrap(NamedNodeMap nnm) {
        return this.getAdapterFactory().proxyNamedNodeMap(this, nnm);
    }

    public String getNodeName() {
        this.log.trace("getNodeName", new String[0]);
        return this.node().getNodeName();
    }

    public String getNodeValue() throws DOMException {
        this.log.trace("getNodeValue", new String[0]);
        return this.node().getNodeValue();
    }

    public short getNodeType() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("getNodeType: " + this.getNodeName() + ": " + this.node().getNodeType(), new String[0]);
        }
        return this.node().getNodeType();
    }

    public NamedNodeMap getAttributes() {
        NamedNodeMap nnm = this.wrap(this.node().getAttributes());
        if (this.log.isTraceEnabled()) {
            this.log.trace("getAttributes: " + nnm, new String[0]);
        }
        return nnm;
    }

    public boolean hasChildNodes() {
        this.log.trace("hasChildNodes", new String[0]);
        return this.node().hasChildNodes();
    }

    public boolean isSupported(String s, String s1) {
        this.log.trace("isSupported", new String[0]);
        return this.node().isSupported(s, s1);
    }

    public String getNamespaceURI() {
        this.log.trace("getNamespaceURI", new String[0]);
        return this.node().getNamespaceURI();
    }

    public String getPrefix() {
        this.log.trace("getPrefix", new String[0]);
        return this.node().getPrefix();
    }

    public String getLocalName() {
        this.log.trace("getLocalName", new String[0]);
        return this.node().getLocalName();
    }

    public boolean hasAttributes() {
        this.log.trace("hasAttributes", new String[0]);
        return this.node().hasAttributes();
    }

    public String toString() {
        return "ProxyNode for: " + this.node();
    }
}

