/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.config.entities.ActionConfig;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.StrutsException;
import org.apache.struts2.components.Form;
import org.apache.struts2.components.UrlProvider;
import org.apache.struts2.components.UrlRenderer;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.apache.struts2.views.util.UrlHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletUrlRenderer
implements UrlRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(ServletUrlRenderer.class);
    private ActionMapper actionMapper;
    private UrlHelper urlHelper;

    @Override
    @Inject
    public void setActionMapper(ActionMapper mapper) {
        this.actionMapper = mapper;
    }

    @Inject
    public void setUrlHelper(UrlHelper urlHelper) {
        this.urlHelper = urlHelper;
    }

    @Override
    public void renderUrl(Writer writer, UrlProvider urlComponent) {
        String result;
        String scheme = urlComponent.getHttpServletRequest().getScheme();
        if (urlComponent.getScheme() != null) {
            scheme = urlComponent.getScheme();
        }
        ActionInvocation ai = (ActionInvocation)ActionContext.getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
        if (urlComponent.getValue() == null && urlComponent.getAction() != null) {
            result = urlComponent.determineActionURL(urlComponent.getAction(), urlComponent.getNamespace(), urlComponent.getMethod(), urlComponent.getHttpServletRequest(), urlComponent.getHttpServletResponse(), urlComponent.getParameters(), scheme, urlComponent.isIncludeContext(), urlComponent.isEncode(), urlComponent.isForceAddSchemeHostAndPort(), urlComponent.isEscapeAmp());
        } else if (urlComponent.getValue() == null && urlComponent.getAction() == null && ai != null) {
            String action = ai.getProxy().getActionName();
            String namespace = ai.getProxy().getNamespace();
            String method = urlComponent.getMethod() != null || !ai.getProxy().isMethodSpecified() ? urlComponent.getMethod() : ai.getProxy().getMethod();
            result = urlComponent.determineActionURL(action, namespace, method, urlComponent.getHttpServletRequest(), urlComponent.getHttpServletResponse(), urlComponent.getParameters(), scheme, urlComponent.isIncludeContext(), urlComponent.isEncode(), urlComponent.isForceAddSchemeHostAndPort(), urlComponent.isEscapeAmp());
        } else {
            String _value = urlComponent.getValue();
            if (_value != null && _value.indexOf("?") > 0) {
                _value = _value.substring(0, _value.indexOf("?"));
            }
            result = this.urlHelper.buildUrl(_value, urlComponent.getHttpServletRequest(), urlComponent.getHttpServletResponse(), urlComponent.getParameters(), scheme, urlComponent.isIncludeContext(), urlComponent.isEncode(), urlComponent.isForceAddSchemeHostAndPort(), urlComponent.isEscapeAmp());
        }
        String anchor = urlComponent.getAnchor();
        if (StringUtils.isNotEmpty((CharSequence)anchor)) {
            result = result + '#' + urlComponent.findString(anchor);
        }
        if (urlComponent.isPutInContext()) {
            String var = urlComponent.getVar();
            if (StringUtils.isNotEmpty((CharSequence)var)) {
                urlComponent.putInContext(result);
                urlComponent.getHttpServletRequest().setAttribute(var, (Object)result);
            } else {
                try {
                    writer.write(result);
                }
                catch (IOException e) {
                    throw new StrutsException("IOError: " + e.getMessage(), e);
                }
            }
        } else {
            try {
                writer.write(result);
            }
            catch (IOException e) {
                throw new StrutsException("IOError: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void renderFormUrl(Form formComponent) {
        String action;
        String namespace = formComponent.determineNamespace(formComponent.namespace, formComponent.getStack(), formComponent.request);
        if (formComponent.action != null) {
            action = formComponent.findString(formComponent.action);
        } else {
            ActionInvocation ai = (ActionInvocation)formComponent.getStack().getContext().get("com.opensymphony.xwork2.ActionContext.actionInvocation");
            if (ai != null) {
                action = ai.getProxy().getActionName();
                namespace = ai.getProxy().getNamespace();
            } else {
                String uri = formComponent.request.getRequestURI();
                action = uri.substring(uri.lastIndexOf(47));
            }
        }
        Map<String, Object> actionParams = null;
        if (action != null && action.indexOf("?") > 0) {
            String queryString = action.substring(action.indexOf("?") + 1);
            actionParams = this.urlHelper.parseQueryString(queryString, false);
            action = action.substring(0, action.indexOf("?"));
        }
        ActionMapping nameMapping = this.actionMapper.getMappingFromActionName(action);
        String actionName = nameMapping.getName();
        String actionMethod = nameMapping.getMethod();
        ActionConfig actionConfig = formComponent.configuration.getRuntimeConfiguration().getActionConfig(namespace, actionName);
        if (actionConfig != null) {
            ActionMapping mapping = new ActionMapping(actionName, namespace, actionMethod, formComponent.parameters);
            String result = this.urlHelper.buildUrl(formComponent.actionMapper.getUriFromActionMapping(mapping), formComponent.request, formComponent.response, actionParams, null, formComponent.includeContext, true, false, false);
            formComponent.addParameter("action", result);
            formComponent.addParameter("actionName", actionName);
            try {
                Class clazz = formComponent.objectFactory.getClassInstance(actionConfig.getClassName());
                formComponent.addParameter("actionClass", clazz);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            formComponent.addParameter("namespace", namespace);
            if (formComponent.name == null) {
                formComponent.addParameter("name", actionName);
            }
            if (formComponent.getId() == null && actionName != null) {
                formComponent.addParameter("id", formComponent.escape(actionName));
            }
        } else if (action != null) {
            if (namespace != null && LOG.isWarnEnabled()) {
                LOG.warn("No configuration found for the specified action: '" + actionName + "' in namespace: '" + namespace + "'. Form action defaulting to 'action' attribute's literal value.", new String[0]);
            }
            String result = this.urlHelper.buildUrl(action, formComponent.request, formComponent.response, null, null, formComponent.includeContext, true);
            formComponent.addParameter("action", result);
            int slash = result.lastIndexOf(47);
            if (slash != -1) {
                formComponent.addParameter("namespace", result.substring(0, slash));
            } else {
                formComponent.addParameter("namespace", "");
            }
            String id = formComponent.getId();
            if (id == null) {
                slash = result.lastIndexOf(47);
                int dot = result.indexOf(46, slash);
                id = dot != -1 ? result.substring(slash + 1, dot) : result.substring(slash + 1);
                formComponent.addParameter("id", formComponent.escape(id));
            }
        }
        formComponent.evaluateClientSideJsEnablement(actionName, namespace, actionMethod);
    }

    @Override
    public void beforeRenderUrl(UrlProvider urlComponent) {
        block11: {
            if (urlComponent.getValue() != null) {
                urlComponent.setValue(urlComponent.findString(urlComponent.getValue()));
            }
            try {
                String includeParams;
                String string = includeParams = urlComponent.getUrlIncludeParams() != null ? urlComponent.getUrlIncludeParams().toLowerCase() : "get";
                if (urlComponent.getIncludeParams() != null) {
                    includeParams = urlComponent.findString(urlComponent.getIncludeParams());
                }
                if ("none".equalsIgnoreCase(includeParams)) {
                    this.mergeRequestParameters(urlComponent.getValue(), urlComponent.getParameters(), Collections.<String, Object>emptyMap());
                } else if ("all".equalsIgnoreCase(includeParams)) {
                    this.mergeRequestParameters(urlComponent.getValue(), urlComponent.getParameters(), urlComponent.getHttpServletRequest().getParameterMap());
                    this.includeGetParameters(urlComponent);
                    this.includeExtraParameters(urlComponent);
                } else if ("get".equalsIgnoreCase(includeParams) || includeParams == null && urlComponent.getValue() == null && urlComponent.getAction() == null) {
                    this.includeGetParameters(urlComponent);
                    this.includeExtraParameters(urlComponent);
                } else if (includeParams != null && LOG.isWarnEnabled()) {
                    LOG.warn("Unknown value for includeParams parameter to URL tag: " + includeParams, new String[0]);
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block11;
                LOG.warn("Unable to put request parameters (" + urlComponent.getHttpServletRequest().getQueryString() + ") into parameter map.", (Throwable)e, new String[0]);
            }
        }
    }

    private void includeExtraParameters(UrlProvider urlComponent) {
        if (urlComponent.getExtraParameterProvider() != null) {
            this.mergeRequestParameters(urlComponent.getValue(), urlComponent.getParameters(), urlComponent.getExtraParameterProvider().getExtraParameters());
        }
    }

    private void includeGetParameters(UrlProvider urlComponent) {
        String query = this.extractQueryString(urlComponent);
        this.mergeRequestParameters(urlComponent.getValue(), urlComponent.getParameters(), this.urlHelper.parseQueryString(query, false));
    }

    private String extractQueryString(UrlProvider urlComponent) {
        int idx;
        String query = urlComponent.getHttpServletRequest().getQueryString();
        if (query == null) {
            query = (String)urlComponent.getHttpServletRequest().getAttribute("javax.servlet.forward.query_string");
        }
        if (query != null && (idx = query.lastIndexOf(35)) != -1) {
            query = query.substring(0, idx);
        }
        return query;
    }

    protected void mergeRequestParameters(String value, Map<String, Object> parameters, Map<String, Object> contextParameters) {
        Map<String, Object> mergedParams = new LinkedHashMap<String, Object>(contextParameters);
        if (value != null && value.trim().length() > 0 && value.indexOf("?") > 0) {
            String queryString = value.substring(value.indexOf("?") + 1);
            mergedParams = this.urlHelper.parseQueryString(queryString, false);
            for (Map.Entry<String, Object> entry : contextParameters.entrySet()) {
                if (mergedParams.containsKey(entry.getKey())) continue;
                mergedParams.put(entry.getKey(), entry.getValue());
            }
        }
        for (Map.Entry entry : mergedParams.entrySet()) {
            if (parameters.containsKey(entry.getKey())) continue;
            parameters.put((String)entry.getKey(), entry.getValue());
        }
    }
}

