/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.util.fs;

import com.opensymphony.xwork2.util.fs.DefaultFileManager;
import com.opensymphony.xwork2.util.fs.FileRevision;
import com.opensymphony.xwork2.util.fs.JarEntryRevision;
import com.opensymphony.xwork2.util.fs.Revision;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossFileManager
extends DefaultFileManager {
    private static final Logger LOG = LoggerFactory.getLogger(JBossFileManager.class);
    private static final String JBOSS5_VFS = "vfs";
    private static final String JBOSS5_VFSZIP = "vfszip";
    private static final String JBOSS5_VFSMEMORY = "vfsmemory";
    private static final String JBOSS5_VFSFILE = "vfsfile";
    private static final String VFS_JBOSS7 = "org.jboss.vfs.VirtualFile";
    private static final String VFS_JBOSS5 = "org.jboss.virtual.VirtualFile";

    public boolean support() {
        boolean supports;
        boolean bl = supports = this.isJBoss7() || this.isJBoss5();
        if (supports && LOG.isDebugEnabled()) {
            LOG.debug("JBoss server detected, Struts 2 will use [#0] to support file system operations!", new String[]{JBossFileManager.class.getSimpleName()});
        }
        return supports;
    }

    private boolean isJBoss5() {
        try {
            Class.forName(VFS_JBOSS5);
            return true;
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot load [#0] class, not a JBoss 5!", new String[]{VFS_JBOSS5});
            }
            return false;
        }
    }

    private boolean isJBoss7() {
        try {
            Class.forName(VFS_JBOSS7);
            return true;
        }
        catch (ClassNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cannot load [#0] class, not a JBoss 7!", new String[]{VFS_JBOSS7});
            }
            return false;
        }
    }

    public void monitorFile(URL fileUrl) {
        if (this.isJBossUrl(fileUrl)) {
            String fileName = fileUrl.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating revision for URL: " + fileName, new String[0]);
            }
            URL normalizedUrl = this.normalizeToFileProtocol(fileUrl);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Normalized URL for [#0] is [#1]", new String[]{fileName, normalizedUrl.toString()});
            }
            Revision revision = "file".equals(normalizedUrl.getProtocol()) ? FileRevision.build((URL)normalizedUrl) : ("jar".equals(normalizedUrl.getProtocol()) ? JarEntryRevision.build((URL)normalizedUrl) : Revision.build((URL)normalizedUrl));
            files.put(fileName, revision);
        } else {
            super.monitorFile(fileUrl);
        }
    }

    public URL normalizeToFileProtocol(URL url) {
        if (this.isJBossUrl(url)) {
            try {
                return this.getJBossPhysicalUrl(url);
            }
            catch (IOException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(e.getMessage(), (Throwable)e, new String[0]);
                }
                return null;
            }
        }
        return super.normalizeToFileProtocol(url);
    }

    public Collection<? extends URL> getAllPhysicalUrls(URL url) throws IOException {
        if (this.isJBossUrl(url)) {
            return this.getAllJBossPhysicalUrls(url);
        }
        return super.getAllPhysicalUrls(url);
    }

    protected boolean isJBossUrl(URL fileUrl) {
        String protocol = fileUrl.getProtocol();
        return JBOSS5_VFSZIP.equals(protocol) || JBOSS5_VFSMEMORY.equals(protocol) || JBOSS5_VFS.equals(protocol) || "true".equals(System.getProperty("jboss.vfs.forceVfsJar")) && JBOSS5_VFSFILE.equals(protocol);
    }

    protected URL getJBossPhysicalUrl(URL url) throws IOException {
        Object content = url.openConnection().getContent();
        String classContent = content.getClass().toString();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading physical URL for [#0]", new String[]{url.toString()});
        }
        if (classContent.startsWith("class org.jboss.vfs.VirtualFile")) {
            File physicalFile = this.readJBossPhysicalFile(content);
            return physicalFile.toURI().toURL();
        }
        if (classContent.startsWith("class org.jboss.virtual.VirtualFile")) {
            return this.readJBoss5Url(content);
        }
        return url;
    }

    private List<URL> getAllJBossPhysicalUrls(URL url) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Object content = url.openConnection().getContent();
        String classContent = content.getClass().toString();
        if (classContent.startsWith("class org.jboss.vfs.VirtualFile")) {
            File physicalFile = this.readJBossPhysicalFile(content);
            if (physicalFile != null) {
                this.readFile(urls, physicalFile);
                this.readFile(urls, physicalFile.getParentFile());
            }
        } else if (classContent.startsWith("class org.jboss.virtual.VirtualFile")) {
            URL physicalUrl = this.readJBoss5Url(content);
            if (physicalUrl != null) {
                urls.add(physicalUrl);
            }
        } else {
            urls.add(url);
        }
        return urls;
    }

    private File readJBossPhysicalFile(Object content) {
        try {
            Method method = content.getClass().getDeclaredMethod("getPhysicalFile", new Class[0]);
            return (File)method.invoke(content, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Provided class content [#0] is not a JBoss VirtualFile, getPhysicalFile() method not found!", (Throwable)e, new String[]{content.getClass().getSimpleName()});
        }
        catch (InvocationTargetException e) {
            LOG.error("Cannot invoke getPhysicalFile() method!", (Throwable)e, new String[0]);
        }
        catch (IllegalAccessException e) {
            LOG.error("Cannot access getPhysicalFile() method!", (Throwable)e, new String[0]);
        }
        return null;
    }

    private URL readJBoss5Url(Object content) {
        try {
            Method method = content.getClass().getDeclaredMethod("getHandler", new Class[0]);
            method.setAccessible(true);
            Object handler = method.invoke(content, new Object[0]);
            method = handler.getClass().getMethod("getRealURL", new Class[0]);
            return (URL)method.invoke(handler, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error("Provided class content [#0] is not a JBoss VirtualFile, getHandler() or getRealURL() method not found!", (Throwable)e, new String[]{content.getClass().getSimpleName()});
        }
        catch (InvocationTargetException e) {
            LOG.error("Cannot invoke getHandler() or getRealURL() method!", (Throwable)e, new String[0]);
        }
        catch (IllegalAccessException e) {
            LOG.error("Cannot access getHandler() or getRealURL() method!", (Throwable)e, new String[0]);
        }
        return null;
    }

    private void readFile(List<URL> urls, File physicalFile) throws MalformedURLException {
        File[] files = physicalFile.listFiles();
        if (physicalFile.isDirectory() && files != null) {
            for (File file : files) {
                if (file.isFile()) {
                    this.addIfAbsent(urls, file.toURI().toURL());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.readFile(urls, file);
            }
        }
    }

    private void addIfAbsent(List<URL> urls, URL fileUrl) {
        if (!urls.contains(fileUrl)) {
            urls.add(fileUrl);
        }
    }
}

