/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.config;

import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.UnknownHandlerManager;
import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.conversion.ObjectTypeDeterminer;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.ContainerBuilder;
import com.opensymphony.xwork2.inject.Context;
import com.opensymphony.xwork2.inject.Factory;
import com.opensymphony.xwork2.inject.Scope;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.PatternMatcher;
import com.opensymphony.xwork2.util.ValueStackFactory;
import com.opensymphony.xwork2.util.location.LocatableProperties;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionContextFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionProvider;
import com.opensymphony.xwork2.validator.ActionValidatorManager;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.struts2.components.UrlRenderer;
import org.apache.struts2.dispatcher.StaticContentLoader;
import org.apache.struts2.dispatcher.mapper.ActionMapper;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;
import org.apache.struts2.views.freemarker.FreemarkerManager;
import org.apache.struts2.views.util.UrlHelper;
import org.apache.struts2.views.velocity.VelocityManager;

public class BeanSelectionProvider
implements ConfigurationProvider {
    public static final String DEFAULT_BEAN_NAME = "struts";
    private static final Logger LOG = LoggerFactory.getLogger(BeanSelectionProvider.class);

    public void destroy() {
    }

    public void loadPackages() throws ConfigurationException {
    }

    public void init(Configuration configuration) throws ConfigurationException {
    }

    public boolean needsReload() {
        return false;
    }

    public void register(ContainerBuilder builder, LocatableProperties props) {
        this.alias(ObjectFactory.class, "struts.objectFactory", builder, (Properties)props);
        this.alias(XWorkConverter.class, "struts.xworkConverter", builder, (Properties)props);
        this.alias(TextProvider.class, "struts.xworkTextProvider", builder, (Properties)props, Scope.DEFAULT);
        this.alias(ActionProxyFactory.class, "struts.actionProxyFactory", builder, (Properties)props);
        this.alias(ObjectTypeDeterminer.class, "struts.objectTypeDeterminer", builder, (Properties)props);
        this.alias(ActionMapper.class, "struts.mapper.class", builder, (Properties)props);
        this.alias(MultiPartRequest.class, "struts.multipart.parser", builder, (Properties)props, Scope.DEFAULT);
        this.alias(FreemarkerManager.class, "struts.freemarker.manager.classname", builder, (Properties)props);
        this.alias(VelocityManager.class, "struts.velocity.manager.classname", builder, (Properties)props);
        this.alias(UrlRenderer.class, "struts.urlRenderer", builder, (Properties)props);
        this.alias(ActionValidatorManager.class, "struts.actionValidatorManager", builder, (Properties)props);
        this.alias(ValueStackFactory.class, "struts.valueStackFactory", builder, (Properties)props);
        this.alias(ReflectionProvider.class, "struts.reflectionProvider", builder, (Properties)props);
        this.alias(ReflectionContextFactory.class, "struts.reflectionContextFactory", builder, (Properties)props);
        this.alias(PatternMatcher.class, "struts.patternMatcher", builder, (Properties)props);
        this.alias(StaticContentLoader.class, "struts.staticContentLoader", builder, (Properties)props);
        this.alias(UnknownHandlerManager.class, "struts.unknownHandlerManager", builder, (Properties)props);
        this.alias(UrlHelper.class, "struts.view.urlHelper", builder, (Properties)props);
        if ("true".equalsIgnoreCase(props.getProperty("struts.devMode"))) {
            props.setProperty("struts.i18n.reload", "true");
            props.setProperty("struts.configuration.xml.reload", "true");
            props.setProperty("struts.freemarker.templatesCache", "false");
            props.setProperty("struts.freemarker.templatesCache.updateDelay", "0");
            props.setProperty("devMode", "true");
        } else {
            props.setProperty("devMode", "false");
        }
        this.convertIfExist(props, "struts.ognl.logMissingProperties", "logMissingProperties");
        this.convertIfExist(props, "struts.ognl.enableExpressionCache", "enableOGNLExpressionCache");
        this.convertIfExist(props, "struts.ognl.allowStaticMethodAccess", "allowStaticMethodAccess");
        LocalizedTextUtil.addDefaultResourceBundle((String)"org/apache/struts2/struts-messages");
        this.loadCustomResourceBundles(props);
    }

    private void convertIfExist(LocatableProperties props, String fromKey, String toKey) {
        if (props.containsKey((Object)fromKey)) {
            props.setProperty(toKey, props.getProperty(fromKey));
        }
    }

    private void loadCustomResourceBundles(LocatableProperties props) {
        String bundles = props.getProperty("struts.custom.i18n.resources");
        if (bundles != null && bundles.length() > 0) {
            StringTokenizer customBundles = new StringTokenizer(bundles, ", ");
            while (customBundles.hasMoreTokens()) {
                String name = customBundles.nextToken();
                try {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Loading global messages from " + name, new String[0]);
                    }
                    LocalizedTextUtil.addDefaultResourceBundle((String)name);
                }
                catch (Exception e) {
                    LOG.error("Could not find messages file " + name + ".properties. Skipping", new String[0]);
                }
            }
        }
    }

    void alias(Class type, String key, ContainerBuilder builder, Properties props) {
        this.alias(type, key, builder, props, Scope.SINGLETON);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void alias(Class type, String key, ContainerBuilder builder, Properties props, Scope scope) {
        if (!builder.contains(type)) {
            String foundName = props.getProperty(key, DEFAULT_BEAN_NAME);
            if (builder.contains(type, foundName)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Choosing bean (#1) for (#2)", new String[]{foundName, type.getName()});
                }
                builder.alias(type, foundName, "default");
                return;
            } else {
                try {
                    Class cls = ClassLoaderUtil.loadClass((String)foundName, this.getClass());
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Choosing bean (#1) for (#2)", new String[]{cls.getName(), type.getName()});
                    }
                    builder.factory(type, cls, scope);
                    return;
                }
                catch (ClassNotFoundException ex) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Choosing bean (#1) for (#2) to be loaded from the ObjectFactory", new String[]{foundName, type.getName()});
                    }
                    if (DEFAULT_BEAN_NAME.equals(foundName)) return;
                    if (ObjectFactory.class == type) throw new ConfigurationException("Cannot locate the chosen ObjectFactory implementation: " + foundName);
                    builder.factory(type, (Factory)new ObjectFactoryDelegateFactory(foundName, type), scope);
                    return;
                }
            }
        } else {
            if (!LOG.isWarnEnabled()) return;
            LOG.warn("Unable to alias bean type (#1), default mapping already assigned.", new String[]{type.getName()});
        }
    }

    static class ObjectFactoryDelegateFactory
    implements Factory {
        String name;
        Class type;

        ObjectFactoryDelegateFactory(String name, Class type) {
            this.name = name;
            this.type = type;
        }

        public Object create(Context context) throws Exception {
            ObjectFactory objFactory = (ObjectFactory)context.getContainer().getInstance(ObjectFactory.class);
            try {
                return objFactory.buildBean(this.name, null, true);
            }
            catch (ClassNotFoundException ex) {
                throw new ConfigurationException("Unable to load bean " + this.type.getName() + " (" + this.name + ")");
            }
        }
    }
}

