/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;

public class ApplicationMap
extends AbstractMap
implements Serializable {
    private static final long serialVersionUID = 9136809763083228202L;
    private ServletContext context;
    private Set<Object> entries;

    public ApplicationMap(ServletContext ctx) {
        this.context = ctx;
    }

    public void clear() {
        this.entries = null;
        Enumeration e = this.context.getAttributeNames();
        while (e.hasMoreElements()) {
            this.context.removeAttribute(e.nextElement().toString());
        }
    }

    public Set entrySet() {
        if (this.entries == null) {
            Object value;
            String key;
            this.entries = new HashSet<Object>();
            Enumeration enumeration = this.context.getAttributeNames();
            while (enumeration.hasMoreElements()) {
                key = enumeration.nextElement().toString();
                value = this.context.getAttribute(key);
                this.entries.add(new Map.Entry(){

                    public boolean equals(Object obj) {
                        if (!(obj instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry entry = (Map.Entry)obj;
                        return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    public int hashCode() {
                        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                    }

                    public Object getKey() {
                        return key;
                    }

                    public Object getValue() {
                        return value;
                    }

                    public Object setValue(Object obj) {
                        ApplicationMap.this.context.setAttribute(key, obj);
                        return value;
                    }
                });
            }
            enumeration = this.context.getInitParameterNames();
            while (enumeration.hasMoreElements()) {
                key = enumeration.nextElement().toString();
                value = this.context.getInitParameter(key);
                this.entries.add(new Map.Entry(){

                    public boolean equals(Object obj) {
                        if (!(obj instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry entry = (Map.Entry)obj;
                        return (key == null ? entry.getKey() == null : key.equals(entry.getKey())) && (value == null ? entry.getValue() == null : value.equals(entry.getValue()));
                    }

                    public int hashCode() {
                        return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                    }

                    public Object getKey() {
                        return key;
                    }

                    public Object getValue() {
                        return value;
                    }

                    public Object setValue(Object obj) {
                        ApplicationMap.this.context.setAttribute(key, obj);
                        return value;
                    }
                });
            }
        }
        return this.entries;
    }

    public Object get(Object key) {
        String keyString = key.toString();
        Object value = this.context.getAttribute(keyString);
        return value == null ? this.context.getInitParameter(keyString) : value;
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.get(key);
        this.entries = null;
        this.context.setAttribute(key.toString(), value);
        return oldValue;
    }

    public Object remove(Object key) {
        this.entries = null;
        Object value = this.get(key);
        this.context.removeAttribute(key.toString());
        return value;
    }
}

