/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.conversion.impl;

import com.opensymphony.xwork2.FileManager;
import com.opensymphony.xwork2.FileManagerFactory;
import com.opensymphony.xwork2.conversion.ConversionFileProcessor;
import com.opensymphony.xwork2.conversion.TypeConverter;
import com.opensymphony.xwork2.conversion.TypeConverterCreator;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultConversionFileProcessor
implements ConversionFileProcessor {
    private static final Logger LOG = LogManager.getLogger(DefaultConversionFileProcessor.class);
    private FileManager fileManager;
    private TypeConverterCreator converterCreator;

    @Inject
    public void setFileManagerFactory(FileManagerFactory factory) {
        this.fileManager = factory.getFileManager();
    }

    @Inject
    public void setTypeConverterCreator(TypeConverterCreator converterCreator) {
        this.converterCreator = converterCreator;
    }

    @Override
    public void process(Map<String, Object> mapping, Class clazz, String converterFilename) {
        try {
            InputStream is = this.fileManager.loadFile(ClassLoaderUtil.getResource(converterFilename, clazz));
            if (is != null) {
                Map.Entry<Object, Object> entry;
                String key;
                LOG.debug("Processing conversion file [{}] for class [{}]", new Object[]{converterFilename, clazz});
                Properties prop = new Properties();
                prop.load(is);
                Iterator<Map.Entry<Object, Object>> i$ = prop.entrySet().iterator();
                while (i$.hasNext() && !mapping.containsKey(key = (String)(entry = i$.next()).getKey())) {
                    if (key.startsWith("KeyProperty_") || key.startsWith("CreateIfNull_")) {
                        LOG.debug("\t{}:{} [treated as String]", new Object[]{key, entry.getValue()});
                        mapping.put(key, entry.getValue());
                        continue;
                    }
                    if (!(key.startsWith("Element_") || key.startsWith("Key_") || key.startsWith("Collection_"))) {
                        TypeConverter _typeConverter = this.converterCreator.createTypeConverter((String)entry.getValue());
                        LOG.debug("\t{}:{} [treated as TypeConverter {}]", new Object[]{key, entry.getValue(), _typeConverter});
                        mapping.put(key, _typeConverter);
                        continue;
                    }
                    if (key.startsWith("Key_")) {
                        Class<TypeConverter> converterClass = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                        if (converterClass.isAssignableFrom(TypeConverter.class)) {
                            TypeConverter _typeConverter = this.converterCreator.createTypeConverter((String)entry.getValue());
                            LOG.debug("\t{}:{} [treated as TypeConverter {}]", new Object[]{key, entry.getValue(), _typeConverter});
                            mapping.put(key, _typeConverter);
                            continue;
                        }
                        LOG.debug("\t{}:{} [treated as Class {}]", new Object[]{key, entry.getValue(), converterClass});
                        mapping.put(key, converterClass);
                        continue;
                    }
                    Class<?> _c = Thread.currentThread().getContextClassLoader().loadClass((String)entry.getValue());
                    LOG.debug("\t{}:{} [treated as Class {}]", new Object[]{key, entry.getValue(), _c});
                    mapping.put(key, _c);
                }
            }
        }
        catch (Exception ex) {
            LOG.error("Problem loading properties for {}", new Object[]{clazz.getName(), ex});
        }
    }
}

