/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.TextProvider;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.ErrorMessageBuilder;
import com.opensymphony.xwork2.ognl.OgnlTypeConverterWrapper;
import com.opensymphony.xwork2.ognl.OgnlUtil;
import com.opensymphony.xwork2.ognl.SecurityMemberAccess;
import com.opensymphony.xwork2.ognl.accessor.CompoundRootAccessor;
import com.opensymphony.xwork2.util.ClearableValueStack;
import com.opensymphony.xwork2.util.CompoundRoot;
import com.opensymphony.xwork2.util.MemberAccessValueStack;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import ognl.ClassResolver;
import ognl.MemberAccess;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.PropertyAccessor;
import ognl.TypeConverter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OgnlValueStack
implements Serializable,
ValueStack,
ClearableValueStack,
MemberAccessValueStack {
    public static final String THROW_EXCEPTION_ON_FAILURE = OgnlValueStack.class.getName() + ".throwExceptionOnFailure";
    private static final long serialVersionUID = 370737852934925530L;
    private static final String MAP_IDENTIFIER_KEY = "com.opensymphony.xwork2.util.OgnlValueStack.MAP_IDENTIFIER_KEY";
    private static final Logger LOG = LogManager.getLogger(OgnlValueStack.class);
    CompoundRoot root;
    transient Map<String, Object> context;
    Class defaultType;
    Map<Object, Object> overrides;
    transient OgnlUtil ognlUtil;
    transient SecurityMemberAccess securityMemberAccess;
    private transient XWorkConverter converter;
    private boolean devMode;
    private boolean logMissingProperties;

    protected OgnlValueStack(XWorkConverter xworkConverter, CompoundRootAccessor accessor, TextProvider prov, boolean allowStaticAccess) {
        this.setRoot(xworkConverter, accessor, new CompoundRoot(), allowStaticAccess);
        this.push(prov);
    }

    protected OgnlValueStack(ValueStack vs, XWorkConverter xworkConverter, CompoundRootAccessor accessor, boolean allowStaticAccess) {
        this.setRoot(xworkConverter, accessor, new CompoundRoot(vs.getRoot()), allowStaticAccess);
    }

    @Inject
    public void setOgnlUtil(OgnlUtil ognlUtil) {
        this.ognlUtil = ognlUtil;
        this.securityMemberAccess.setExcludedClasses(ognlUtil.getExcludedClasses());
        this.securityMemberAccess.setExcludedPackageNamePatterns(ognlUtil.getExcludedPackageNamePatterns());
    }

    protected void setRoot(XWorkConverter xworkConverter, CompoundRootAccessor accessor, CompoundRoot compoundRoot, boolean allowStaticMethodAccess) {
        this.root = compoundRoot;
        this.securityMemberAccess = new SecurityMemberAccess(allowStaticMethodAccess);
        this.context = Ognl.createDefaultContext((Object)this.root, (ClassResolver)accessor, (TypeConverter)new OgnlTypeConverterWrapper(xworkConverter), (MemberAccess)this.securityMemberAccess);
        this.context.put("com.opensymphony.xwork2.util.ValueStack.ValueStack", this);
        Ognl.setClassResolver(this.context, (ClassResolver)accessor);
        ((OgnlContext)this.context).setTraceEvaluations(false);
        ((OgnlContext)this.context).setKeepLastEvaluation(false);
    }

    @Inject(value="devMode")
    public void setDevMode(String mode) {
        this.devMode = BooleanUtils.toBoolean((String)mode);
    }

    @Inject(value="logMissingProperties", required=false)
    public void setLogMissingProperties(String logMissingProperties) {
        this.logMissingProperties = BooleanUtils.toBoolean((String)logMissingProperties);
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public void setDefaultType(Class defaultType) {
        this.defaultType = defaultType;
    }

    @Override
    public void setExprOverrides(Map<Object, Object> overrides) {
        if (this.overrides == null) {
            this.overrides = overrides;
        } else {
            this.overrides.putAll(overrides);
        }
    }

    @Override
    public Map<Object, Object> getExprOverrides() {
        return this.overrides;
    }

    @Override
    public CompoundRoot getRoot() {
        return this.root;
    }

    @Override
    public void setParameter(String expr, Object value) {
        this.setValue(expr, value, this.devMode, false);
    }

    @Override
    public void setValue(String expr, Object value) {
        this.setValue(expr, value, this.devMode);
    }

    @Override
    public void setValue(String expr, Object value, boolean throwExceptionOnFailure) {
        this.setValue(expr, value, throwExceptionOnFailure, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(String expr, Object value, boolean throwExceptionOnFailure, boolean evalExpression) {
        Map<String, Object> context = this.getContext();
        try {
            this.trySetValue(expr, value, throwExceptionOnFailure, context, evalExpression);
        }
        catch (OgnlException e) {
            this.handleOgnlException(expr, value, throwExceptionOnFailure, e);
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(expr, value, throwExceptionOnFailure, re);
        }
        finally {
            this.cleanUpContext(context);
        }
    }

    private void trySetValue(String expr, Object value, boolean throwExceptionOnFailure, Map<String, Object> context, boolean evalExpression) throws OgnlException {
        context.put("conversion.property.fullName", expr);
        context.put("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp", throwExceptionOnFailure ? Boolean.TRUE : Boolean.FALSE);
        this.ognlUtil.setValue(expr, context, this.root, value, evalExpression);
    }

    private void cleanUpContext(Map<String, Object> context) {
        ReflectionContextState.clear(context);
        context.remove("conversion.property.fullName");
        context.remove("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp");
    }

    private void handleRuntimeException(String expr, Object value, boolean throwExceptionOnFailure, RuntimeException re) {
        if (throwExceptionOnFailure) {
            String message = ErrorMessageBuilder.create().errorSettingExpressionWithValue(expr, value).build();
            throw new XWorkException(message, re);
        }
        LOG.warn("Error setting value [{}] with expression [{}]", new Object[]{value, expr, re});
    }

    private void handleOgnlException(String expr, Object value, boolean throwExceptionOnFailure, OgnlException e) {
        boolean shouldLog = this.shouldLogMissingPropertyWarning(e);
        String msg = null;
        if (throwExceptionOnFailure || shouldLog) {
            msg = ErrorMessageBuilder.create().errorSettingExpressionWithValue(expr, value).build();
        }
        if (shouldLog) {
            LOG.warn(msg, (Throwable)e);
        }
        if (throwExceptionOnFailure) {
            throw new XWorkException(msg, e);
        }
    }

    @Override
    public String findString(String expr) {
        return (String)this.findValue(expr, String.class);
    }

    @Override
    public String findString(String expr, boolean throwExceptionOnFailure) {
        return (String)this.findValue(expr, String.class, throwExceptionOnFailure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findValue(String expr, boolean throwExceptionOnFailure) {
        try {
            this.setupExceptionOnFailure(throwExceptionOnFailure);
            Object object = this.tryFindValueWhenExpressionIsNotNull(expr);
            return object;
        }
        catch (OgnlException e) {
            Object object = this.handleOgnlException(expr, throwExceptionOnFailure, e);
            return object;
        }
        catch (Exception e) {
            Object object = this.handleOtherException(expr, throwExceptionOnFailure, e);
            return object;
        }
        finally {
            ReflectionContextState.clear(this.context);
        }
    }

    private void setupExceptionOnFailure(boolean throwExceptionOnFailure) {
        if (throwExceptionOnFailure) {
            this.context.put(THROW_EXCEPTION_ON_FAILURE, true);
        }
    }

    private Object tryFindValueWhenExpressionIsNotNull(String expr) throws OgnlException {
        if (expr == null) {
            return null;
        }
        return this.tryFindValue(expr);
    }

    private Object handleOtherException(String expr, boolean throwExceptionOnFailure, Exception e) {
        this.logLookupFailure(expr, e);
        if (throwExceptionOnFailure) {
            throw new XWorkException(e);
        }
        return this.findInContext(expr);
    }

    private Object tryFindValue(String expr) throws OgnlException {
        Object value;
        expr = this.lookupForOverrides(expr);
        if (this.defaultType != null) {
            value = this.findValue(expr, this.defaultType);
        } else {
            value = this.getValueUsingOgnl(expr);
            if (value == null) {
                value = this.findInContext(expr);
            }
        }
        return value;
    }

    private String lookupForOverrides(String expr) {
        if (this.overrides != null && this.overrides.containsKey(expr)) {
            expr = (String)this.overrides.get(expr);
        }
        return expr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValueUsingOgnl(String expr) throws OgnlException {
        try {
            Object object = this.ognlUtil.getValue(expr, this.context, this.root);
            return object;
        }
        finally {
            this.context.remove(THROW_EXCEPTION_ON_FAILURE);
        }
    }

    @Override
    public Object findValue(String expr) {
        return this.findValue(expr, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object findValue(String expr, Class asType, boolean throwExceptionOnFailure) {
        try {
            this.setupExceptionOnFailure(throwExceptionOnFailure);
            Object object = this.tryFindValueWhenExpressionIsNotNull(expr, asType);
            return object;
        }
        catch (OgnlException e) {
            Object value = this.handleOgnlException(expr, throwExceptionOnFailure, e);
            Object object = this.converter.convertValue(this.getContext(), value, asType);
            return object;
        }
        catch (Exception e) {
            Object value = this.handleOtherException(expr, throwExceptionOnFailure, e);
            Object object = this.converter.convertValue(this.getContext(), value, asType);
            return object;
        }
        finally {
            ReflectionContextState.clear(this.context);
        }
    }

    private Object tryFindValueWhenExpressionIsNotNull(String expr, Class asType) throws OgnlException {
        if (expr == null) {
            return null;
        }
        return this.tryFindValue(expr, asType);
    }

    private Object handleOgnlException(String expr, boolean throwExceptionOnFailure, OgnlException e) {
        Object ret = this.findInContext(expr);
        if (ret == null) {
            if (this.shouldLogMissingPropertyWarning(e)) {
                LOG.warn("Could not find property [{}]!", new Object[]{expr, e});
            }
            if (throwExceptionOnFailure) {
                throw new XWorkException(e);
            }
        }
        return ret;
    }

    private boolean shouldLogMissingPropertyWarning(OgnlException e) {
        return (e instanceof NoSuchPropertyException || e instanceof MethodFailedException) && this.devMode && this.logMissingProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object tryFindValue(String expr, Class asType) throws OgnlException {
        Object value = null;
        try {
            expr = this.lookupForOverrides(expr);
            value = this.getValue(expr, asType);
            if (value == null) {
                value = this.findInContext(expr);
                Object object = this.converter.convertValue(this.getContext(), value, asType);
                return object;
            }
        }
        finally {
            this.context.remove(THROW_EXCEPTION_ON_FAILURE);
        }
        return value;
    }

    private Object getValue(String expr, Class asType) throws OgnlException {
        return this.ognlUtil.getValue(expr, this.context, this.root, asType);
    }

    private Object findInContext(String name) {
        return this.getContext().get(name);
    }

    @Override
    public Object findValue(String expr, Class asType) {
        return this.findValue(expr, asType, false);
    }

    private void logLookupFailure(String expr, Exception e) {
        if (this.devMode && LOG.isWarnEnabled()) {
            LOG.warn("Caught an exception while evaluating expression '{}' against value stack", new Object[]{expr, e});
            LOG.warn("NOTE: Previous warning message was issued due to devMode set to true.");
        } else {
            LOG.debug("Caught an exception while evaluating expression '{}' against value stack", new Object[]{expr, e});
        }
    }

    @Override
    public Object peek() {
        return this.root.peek();
    }

    @Override
    public Object pop() {
        return this.root.pop();
    }

    @Override
    public void push(Object o) {
        this.root.push(o);
    }

    @Override
    public void set(String key, Object o) {
        Map setMap = this.retrieveSetMap();
        setMap.put(key, o);
    }

    private Map retrieveSetMap() {
        HashMap<String, String> setMap;
        Object topObj = this.peek();
        if (this.shouldUseOldMap(topObj)) {
            setMap = (HashMap<String, String>)topObj;
        } else {
            setMap = new HashMap<String, String>();
            setMap.put(MAP_IDENTIFIER_KEY, "");
            this.push(setMap);
        }
        return setMap;
    }

    private boolean shouldUseOldMap(Object topObj) {
        return topObj instanceof Map && ((Map)topObj).get(MAP_IDENTIFIER_KEY) != null;
    }

    @Override
    public int size() {
        return this.root.size();
    }

    private Object readResolve() {
        ActionContext ac = ActionContext.getContext();
        Container cont = ac.getContainer();
        XWorkConverter xworkConverter = cont.getInstance(XWorkConverter.class);
        CompoundRootAccessor accessor = (CompoundRootAccessor)cont.getInstance(PropertyAccessor.class, CompoundRoot.class.getName());
        TextProvider prov = cont.getInstance(TextProvider.class, "system");
        boolean allow = BooleanUtils.toBoolean((String)cont.getInstance(String.class, "allowStaticMethodAccess"));
        OgnlValueStack aStack = new OgnlValueStack(xworkConverter, accessor, prov, allow);
        aStack.setOgnlUtil(cont.getInstance(OgnlUtil.class));
        aStack.setRoot(xworkConverter, accessor, this.root, allow);
        return aStack;
    }

    @Override
    public void clearContextValues() {
        ((OgnlContext)this.context).getValues().clear();
    }

    @Override
    public void setAcceptProperties(Set<Pattern> acceptedProperties) {
        this.securityMemberAccess.setAcceptProperties(acceptedProperties);
    }

    @Override
    public void setExcludeProperties(Set<Pattern> excludeProperties) {
        this.securityMemberAccess.setExcludeProperties(excludeProperties);
    }

    @Inject
    public void setXWorkConverter(XWorkConverter converter) {
        this.converter = converter;
    }
}

