/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.ognl.accessor;

import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.ognl.OgnlValueStack;
import com.opensymphony.xwork2.util.CompoundRoot;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import ognl.ClassResolver;
import ognl.MethodAccessor;
import ognl.MethodFailedException;
import ognl.NoSuchPropertyException;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.PropertyAccessor;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CompoundRootAccessor
implements PropertyAccessor,
MethodAccessor,
ClassResolver {
    private static final Logger LOG = LogManager.getLogger(CompoundRootAccessor.class);
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];
    private static Map<MethodCall, Boolean> invalidMethods = new ConcurrentHashMap<MethodCall, Boolean>();
    private boolean devMode = false;

    public String getSourceAccessor(OgnlContext context, Object target, Object index) {
        return null;
    }

    public String getSourceSetter(OgnlContext context, Object target, Object index) {
        return null;
    }

    @Inject(value="devMode")
    public void setDevMode(String mode) {
        this.devMode = BooleanUtils.toBoolean((String)mode);
    }

    public void setProperty(Map context, Object target, Object name, Object value) throws OgnlException {
        CompoundRoot root = (CompoundRoot)target;
        OgnlContext ognlContext = (OgnlContext)context;
        for (Object o : root) {
            if (o == null) continue;
            try {
                if (OgnlRuntime.hasSetProperty((OgnlContext)ognlContext, o, (Object)name)) {
                    OgnlRuntime.setProperty((OgnlContext)ognlContext, o, (Object)name, (Object)value);
                    return;
                }
                if (!(o instanceof Map)) continue;
                Map map = (Map)o;
                try {
                    map.put(name, value);
                    return;
                }
                catch (UnsupportedOperationException e) {
                }
            }
            catch (IntrospectionException e) {}
        }
        boolean reportError = BooleanUtils.toBoolean((Boolean)((Boolean)context.get("com.opensymphony.xwork2.util.ValueStack.ReportErrorsOnNoProp")));
        if (reportError || this.devMode) {
            String msg = String.format("No object in the CompoundRoot has a publicly accessible property named '%s' (no setter could be found).", name);
            if (reportError) {
                throw new XWorkException(msg);
            }
            LOG.warn(msg);
        }
    }

    public Object getProperty(Map context, Object target, Object name) throws OgnlException {
        CompoundRoot root = (CompoundRoot)target;
        OgnlContext ognlContext = (OgnlContext)context;
        if (name instanceof Integer) {
            Integer index = (Integer)name;
            return root.cutStack(index);
        }
        if (name instanceof String) {
            if ("top".equals(name)) {
                if (root.size() > 0) {
                    return root.get(0);
                }
                return null;
            }
            for (Object o : root) {
                if (o == null) continue;
                try {
                    if (!OgnlRuntime.hasGetProperty((OgnlContext)ognlContext, o, (Object)name) && (!(o instanceof Map) || !((Map)o).containsKey(name))) continue;
                    return OgnlRuntime.getProperty((OgnlContext)ognlContext, o, (Object)name);
                }
                catch (OgnlException e) {
                    if (e.getReason() == null) continue;
                    String msg = "Caught an Ognl exception while getting property " + name;
                    throw new XWorkException(msg, e);
                }
                catch (IntrospectionException e) {
                }
            }
            if (context.containsKey(OgnlValueStack.THROW_EXCEPTION_ON_FAILURE)) {
                throw new NoSuchPropertyException(target, name);
            }
            return null;
        }
        return null;
    }

    public Object callMethod(Map context, Object target, String name, Object[] objects) throws MethodFailedException {
        CompoundRoot root = (CompoundRoot)target;
        if ("describe".equals(name)) {
            Object v = objects != null && objects.length == 1 ? objects[0] : root.get(0);
            if (v instanceof Collection || v instanceof Map || v.getClass().isArray()) {
                return v.toString();
            }
            try {
                Map descriptors = OgnlRuntime.getPropertyDescriptors(v.getClass());
                int maxSize = 0;
                for (String pdName : descriptors.keySet()) {
                    if (pdName.length() <= maxSize) continue;
                    maxSize = pdName.length();
                }
                TreeSet<String> set = new TreeSet<String>();
                StringBuffer sb = new StringBuffer();
                for (PropertyDescriptor propertyDescriptor : descriptors.values()) {
                    sb.append(propertyDescriptor.getName()).append(": ");
                    int padding = maxSize - propertyDescriptor.getName().length();
                    for (int i = 0; i < padding; ++i) {
                        sb.append(" ");
                    }
                    sb.append(propertyDescriptor.getPropertyType().getName());
                    set.add(sb.toString());
                    sb = new StringBuffer();
                }
                sb = new StringBuffer();
                for (Object object : set) {
                    String s = (String)object;
                    sb.append(s).append("\n");
                }
                return sb.toString();
            }
            catch (IntrospectionException | OgnlException e) {
                LOG.debug("Got exception in callMethod", e);
                return null;
            }
        }
        for (Object o : root) {
            if (o == null) continue;
            Class<?> clazz = o.getClass();
            Class[] argTypes = this.getArgTypes(objects);
            MethodCall mc = null;
            if (argTypes != null) {
                mc = new MethodCall(clazz, name, argTypes);
            }
            if (argTypes != null && invalidMethods.containsKey(mc)) continue;
            try {
                Object value = OgnlRuntime.callMethod((OgnlContext)((OgnlContext)context), o, (String)name, (Object[])objects);
                if (value == null) continue;
                return value;
            }
            catch (OgnlException e) {
                Throwable throwable = e.getReason();
                if (!context.containsKey(OgnlValueStack.THROW_EXCEPTION_ON_FAILURE) && mc != null && throwable != null && throwable.getClass() == NoSuchMethodException.class) {
                    invalidMethods.put(mc, Boolean.TRUE);
                    continue;
                }
                if (throwable == null) continue;
                throw new MethodFailedException(o, name, e.getReason());
            }
        }
        return null;
    }

    public Object callStaticMethod(Map transientVars, Class aClass, String s, Object[] objects) throws MethodFailedException {
        return null;
    }

    public Class classForName(String className, Map context) throws ClassNotFoundException {
        Object root = Ognl.getRoot((Map)context);
        try {
            if (root instanceof CompoundRoot && className.startsWith("vs")) {
                CompoundRoot compoundRoot = (CompoundRoot)root;
                if ("vs".equals(className)) {
                    return compoundRoot.peek().getClass();
                }
                int index = Integer.parseInt(className.substring(2));
                return compoundRoot.get(index - 1).getClass();
            }
        }
        catch (Exception e) {
            LOG.debug("Got exception when tried to get class for name [{}]", new Object[]{className, e});
        }
        return Thread.currentThread().getContextClassLoader().loadClass(className);
    }

    private Class[] getArgTypes(Object[] args) {
        if (args == null) {
            return EMPTY_CLASS_ARRAY;
        }
        Class[] classes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            classes[i] = arg != null ? arg.getClass() : Object.class;
        }
        return classes;
    }

    static class MethodCall {
        Class clazz;
        String name;
        Class[] args;
        int hash;

        public MethodCall(Class clazz, String name, Class[] args) {
            this.clazz = clazz;
            this.name = name;
            this.args = args;
            this.hash = clazz.hashCode() + name.hashCode();
            for (Class arg : args) {
                this.hash += arg.hashCode();
            }
        }

        public boolean equals(Object obj) {
            MethodCall mc = (MethodCall)obj;
            return mc.clazz.equals(this.clazz) && mc.name.equals(this.name) && Arrays.equals(mc.args, this.args);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

