/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.classloader;

import com.opensymphony.xwork2.util.classloader.AbstractResourceStore;
import java.io.File;
import java.io.FileInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FileResourceStore
extends AbstractResourceStore {
    private static final Logger LOG = LogManager.getLogger(FileResourceStore.class);

    public FileResourceStore(File file) {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(String pResourceName) {
        byte[] byArray;
        FileInputStream fis = null;
        try {
            File file = this.getFile(pResourceName);
            byte[] data = new byte[(int)file.length()];
            fis = new FileInputStream(file);
            fis.read(data);
            byArray = data;
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                LOG.debug("Unable to read file [{}]", new Object[]{pResourceName, e});
                byArray2 = null;
            }
            catch (Throwable throwable) {
                this.closeQuietly(fis);
                throw throwable;
            }
            this.closeQuietly(fis);
            return byArray2;
        }
        this.closeQuietly(fis);
        return byArray;
    }

    private File getFile(String pResourceName) {
        String fileName = pResourceName.replace('/', File.separatorChar);
        return new File(this.file, fileName);
    }
}

