/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.classloader;

import com.opensymphony.xwork2.util.classloader.AbstractResourceStore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JarResourceStore
extends AbstractResourceStore {
    private static final Logger LOG = LogManager.getLogger(JarResourceStore.class);

    public JarResourceStore(File file) {
        super(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] read(String pResourceName) {
        byte[] byArray;
        InputStream in = null;
        try {
            ZipFile jarFile = new ZipFile(this.file);
            ZipEntry entry = jarFile.getEntry(pResourceName);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            in = jarFile.getInputStream(entry);
            JarResourceStore.copy(in, out);
            byArray = out.toByteArray();
        }
        catch (Exception e) {
            byte[] byArray2;
            try {
                LOG.debug("Unable to read file [{}] from [{}]", new Object[]{pResourceName, this.file.getName(), e});
                byArray2 = null;
            }
            catch (Throwable throwable) {
                this.closeQuietly(in);
                throw throwable;
            }
            this.closeQuietly(in);
            return byArray2;
        }
        this.closeQuietly(in);
        return byArray;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }
}

