/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.components.template;

import com.opensymphony.xwork2.inject.Inject;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.components.template.BaseTemplateEngine;
import org.apache.struts2.components.template.Template;
import org.apache.struts2.components.template.TemplateRenderingContext;
import org.apache.struts2.views.velocity.VelocityManager;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class VelocityTemplateEngine
extends BaseTemplateEngine {
    private static final Logger LOG = LogManager.getLogger(VelocityTemplateEngine.class);
    private VelocityManager velocityManager;

    @Inject
    public void setVelocityManager(VelocityManager mgr) {
        this.velocityManager = mgr;
    }

    @Override
    public void renderTemplate(TemplateRenderingContext templateContext) throws Exception {
        Map<String, Object> actionContext = templateContext.getStack().getContext();
        ServletContext servletContext = (ServletContext)actionContext.get("com.opensymphony.xwork2.dispatcher.ServletContext");
        HttpServletRequest req = (HttpServletRequest)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletRequest");
        HttpServletResponse res = (HttpServletResponse)actionContext.get("com.opensymphony.xwork2.dispatcher.HttpServletResponse");
        this.velocityManager.init(servletContext);
        VelocityEngine velocityEngine = this.velocityManager.getVelocityEngine();
        List<Template> templates = templateContext.getTemplate().getPossibleTemplates(this);
        org.apache.velocity.Template template = null;
        String templateName = null;
        IOException exception = null;
        for (Template t : templates) {
            templateName = this.getFinalTemplateName(t);
            try {
                template = velocityEngine.getTemplate(templateName);
                break;
            }
            catch (IOException e) {
                if (exception != null) continue;
                exception = e;
            }
        }
        if (template == null) {
            LOG.error("Could not load template {}", new Object[]{templateContext.getTemplate()});
            if (exception != null) {
                throw exception;
            }
            return;
        }
        LOG.debug("Rendering template {}", new Object[]{templateName});
        Context context = this.velocityManager.createContext(templateContext.getStack(), req, res);
        Writer outputWriter = templateContext.getWriter();
        context.put("tag", (Object)templateContext.getTag());
        context.put("parameters", (Object)templateContext.getParameters());
        template.merge(context, outputWriter);
    }

    @Override
    protected String getSuffix() {
        return "vm";
    }
}

