/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.dispatcher.multipart;

import com.opensymphony.xwork2.LocaleProvider;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.dispatcher.multipart.MultiPartRequest;

public class JakartaMultiPartRequest
implements MultiPartRequest {
    static final Logger LOG = LogManager.getLogger(JakartaMultiPartRequest.class);
    protected Map<String, List<FileItem>> files = new HashMap<String, List<FileItem>>();
    protected Map<String, List<String>> params = new HashMap<String, List<String>>();
    protected List<String> errors = new ArrayList<String>();
    protected long maxSize;
    private Locale defaultLocale = Locale.ENGLISH;

    @Inject(value="struts.multipart.maxSize")
    public void setMaxSize(String maxSize) {
        this.maxSize = Long.parseLong(maxSize);
    }

    @Inject
    public void setLocaleProvider(LocaleProvider provider) {
        this.defaultLocale = provider.getLocale();
    }

    @Override
    public void parse(HttpServletRequest request, String saveDir) throws IOException {
        block4: {
            try {
                this.setLocale(request);
                this.processUpload(request, saveDir);
            }
            catch (FileUploadBase.SizeLimitExceededException e) {
                LOG.warn("Request exceeded size limit!", (Throwable)e);
                String errorMessage = this.buildErrorMessage(e, new Object[]{e.getPermittedSize(), e.getActualSize()});
                if (!this.errors.contains(errorMessage)) {
                    this.errors.add(errorMessage);
                }
            }
            catch (Exception e) {
                LOG.warn("Unable to parse request", (Throwable)e);
                String errorMessage = this.buildErrorMessage(e, new Object[0]);
                if (this.errors.contains(errorMessage)) break block4;
                this.errors.add(errorMessage);
            }
        }
    }

    protected void setLocale(HttpServletRequest request) {
        if (this.defaultLocale == null) {
            this.defaultLocale = request.getLocale();
        }
    }

    protected String buildErrorMessage(Throwable e, Object[] args) {
        String errorKey = "struts.messages.upload.error." + e.getClass().getSimpleName();
        LOG.debug("Preparing error message for key: [{}]", new Object[]{errorKey});
        return LocalizedTextUtil.findText(this.getClass(), errorKey, this.defaultLocale, e.getMessage(), args);
    }

    protected void processUpload(HttpServletRequest request, String saveDir) throws FileUploadException, UnsupportedEncodingException {
        for (FileItem item : this.parseRequest(request, saveDir)) {
            LOG.debug("Found file item: [{}]", new Object[]{item.getFieldName()});
            if (item.isFormField()) {
                this.processNormalFormField(item, request.getCharacterEncoding());
                continue;
            }
            this.processFileField(item);
        }
    }

    protected void processFileField(FileItem item) {
        LOG.debug("Item is a file upload");
        if (item.getName() == null || item.getName().trim().length() < 1) {
            LOG.debug("No file has been uploaded for the field: {}", new Object[]{item.getFieldName()});
            return;
        }
        List<FileItem> values = this.files.get(item.getFieldName()) != null ? this.files.get(item.getFieldName()) : new ArrayList<FileItem>();
        values.add(item);
        this.files.put(item.getFieldName(), values);
    }

    protected void processNormalFormField(FileItem item, String charset) throws UnsupportedEncodingException {
        LOG.debug("Item is a normal form field");
        List<Object> values = this.params.get(item.getFieldName()) != null ? this.params.get(item.getFieldName()) : new ArrayList();
        if (charset != null) {
            values.add(item.getString(charset));
        } else {
            values.add(item.getString());
        }
        this.params.put(item.getFieldName(), values);
        item.delete();
    }

    protected List<FileItem> parseRequest(HttpServletRequest servletRequest, String saveDir) throws FileUploadException {
        DiskFileItemFactory fac = this.createDiskFileItemFactory(saveDir);
        ServletFileUpload upload = this.createServletFileUpload(fac);
        return upload.parseRequest(this.createRequestContext(servletRequest));
    }

    protected ServletFileUpload createServletFileUpload(DiskFileItemFactory fac) {
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
        upload.setSizeMax(this.maxSize);
        return upload;
    }

    protected DiskFileItemFactory createDiskFileItemFactory(String saveDir) {
        DiskFileItemFactory fac = new DiskFileItemFactory();
        fac.setSizeThreshold(0);
        if (saveDir != null) {
            fac.setRepository(new File(saveDir));
        }
        return fac;
    }

    @Override
    public Enumeration<String> getFileParameterNames() {
        return Collections.enumeration(this.files.keySet());
    }

    @Override
    public String[] getContentType(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> contentTypes = new ArrayList<String>(items.size());
        for (FileItem fileItem : items) {
            contentTypes.add(fileItem.getContentType());
        }
        return contentTypes.toArray(new String[contentTypes.size()]);
    }

    @Override
    public File[] getFile(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<File> fileList = new ArrayList<File>(items.size());
        for (FileItem fileItem : items) {
            File storeLocation = ((DiskFileItem)fileItem).getStoreLocation();
            if (fileItem.isInMemory() && storeLocation != null && !storeLocation.exists()) {
                try {
                    storeLocation.createNewFile();
                }
                catch (IOException e) {
                    LOG.error("Cannot write uploaded empty file to disk: {}", new Object[]{storeLocation.getAbsolutePath(), e});
                }
            }
            fileList.add(storeLocation);
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    @Override
    public String[] getFileNames(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (FileItem fileItem : items) {
            fileNames.add(this.getCanonicalName(fileItem.getName()));
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public String[] getFilesystemName(String fieldName) {
        List<FileItem> items = this.files.get(fieldName);
        if (items == null) {
            return null;
        }
        ArrayList<String> fileNames = new ArrayList<String>(items.size());
        for (FileItem fileItem : items) {
            fileNames.add(((DiskFileItem)fileItem).getStoreLocation().getName());
        }
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public String getParameter(String name) {
        List<String> v = this.params.get(name);
        if (v != null && v.size() > 0) {
            return v.get(0);
        }
        return null;
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    @Override
    public String[] getParameterValues(String name) {
        List<String> v = this.params.get(name);
        if (v != null && v.size() > 0) {
            return v.toArray(new String[v.size()]);
        }
        return null;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    private String getCanonicalName(String filename) {
        int forwardSlash = filename.lastIndexOf("/");
        int backwardSlash = filename.lastIndexOf("\\");
        if (forwardSlash != -1 && forwardSlash > backwardSlash) {
            filename = filename.substring(forwardSlash + 1, filename.length());
        } else if (backwardSlash != -1 && backwardSlash >= forwardSlash) {
            filename = filename.substring(backwardSlash + 1, filename.length());
        }
        return filename;
    }

    protected RequestContext createRequestContext(final HttpServletRequest req) {
        return new RequestContext(){

            public String getCharacterEncoding() {
                return req.getCharacterEncoding();
            }

            public String getContentType() {
                return req.getContentType();
            }

            public int getContentLength() {
                return req.getContentLength();
            }

            public InputStream getInputStream() throws IOException {
                ServletInputStream in = req.getInputStream();
                if (in == null) {
                    throw new IOException("Missing content in the request");
                }
                return req.getInputStream();
            }
        };
    }

    @Override
    public void cleanUp() {
        Set<String> names = this.files.keySet();
        for (String name : names) {
            List<FileItem> items = this.files.get(name);
            for (FileItem item : items) {
                if (LOG.isDebugEnabled()) {
                    String msg = LocalizedTextUtil.findText(this.getClass(), "struts.messages.removing.file", Locale.ENGLISH, "no.message.found", new Object[]{name, item});
                    LOG.debug(msg);
                }
                if (item.isInMemory()) continue;
                item.delete();
            }
        }
    }
}

