/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.factory;

import com.opensymphony.xwork2.ActionProxy;
import com.opensymphony.xwork2.ActionProxyFactory;
import com.opensymphony.xwork2.DefaultActionProxyFactory;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PrefixBasedActionProxyFactory
extends DefaultActionProxyFactory {
    private static final Logger LOG = LogManager.getLogger(PrefixBasedActionProxyFactory.class);
    private Map<String, ActionProxyFactory> actionProxyFactories = new HashMap<String, ActionProxyFactory>();
    private ActionProxyFactory defaultFactory;

    @Override
    @Inject
    public void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="struts.actionProxyFactory")
    public void setActionProxyFactory(ActionProxyFactory factory) {
        this.defaultFactory = factory;
    }

    @Inject(value="struts.mapper.prefixMapping")
    public void setPrefixBasedActionProxyFactories(String list) {
        if (list != null) {
            String[] factories;
            for (String factory : factories = list.split(",")) {
                String[] thisFactory = factory.split(":");
                if (thisFactory.length != 2) continue;
                String factoryPrefix = thisFactory[0].trim();
                String factoryName = thisFactory[1].trim();
                ActionProxyFactory obj = this.container.getInstance(ActionProxyFactory.class, factoryName);
                if (obj != null) {
                    this.actionProxyFactories.put(factoryPrefix, obj);
                    continue;
                }
                LOG.warn("Invalid PrefixBasedActionProxyFactory config entry: [{}]", new Object[]{factory});
            }
        }
    }

    @Override
    public ActionProxy createActionProxy(String namespace, String actionName, String methodName, Map<String, Object> extraContext, boolean executeResult, boolean cleanupContext) {
        String uri = namespace + (namespace.endsWith("/") ? actionName : "/" + actionName);
        int lastIndex = uri.lastIndexOf(47);
        while (lastIndex > -1) {
            String key = uri.substring(0, lastIndex);
            ActionProxyFactory actionProxyFactory = this.actionProxyFactories.get(key);
            if (actionProxyFactory != null) {
                LOG.debug("Using ActionProxyFactory [{}] for prefix [{}]", new Object[]{actionProxyFactory, key});
                return actionProxyFactory.createActionProxy(namespace, actionName, methodName, extraContext, executeResult, cleanupContext);
            }
            LOG.debug("No ActionProxyFactory defined for [{}]", new Object[]{key});
            lastIndex = uri.lastIndexOf(47, lastIndex - 1);
        }
        LOG.debug("Cannot find any matching ActionProxyFactory, falling back to [{}]", new Object[]{this.defaultFactory});
        return this.defaultFactory.createActionProxy(namespace, actionName, methodName, extraContext, executeResult, cleanupContext);
    }
}

